/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.handlers;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.external.ImageHelper;
import org.jpedal.utils.LogWriter;

public class StandardImageIO
implements ImageHelper {
    public StandardImageIO() {
        ImageIO.setUseCache(false);
    }

    @Override
    public void write(BufferedImage image, String type, String file_name) throws IOException {
        ExternalHandlers.ImageLib.write(image, type, file_name, GenericColorSpace.fasterPNG);
    }

    @Override
    public BufferedImage read(String file_name) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(file_name));
        }
        catch (IOException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        catch (Error err) {
            LogWriter.writeLog("Error: " + err.getMessage());
            throw new RuntimeException("Error " + err + " loading " + file_name + " with ImageIO");
        }
        return image;
    }

    @Override
    public synchronized BufferedImage read(byte[] data) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ImageIO.setUseCache(false);
        return ImageIO.read(bis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Raster readRasterFromJPeg(byte[] data) throws IOException {
        Raster ras = null;
        ImageReader iir = null;
        ImageInputStream iin = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(data);){
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG");
            while (iterator.hasNext() && !(iir = iterator.next()).canReadRaster()) {
            }
            if (iir == null) {
                Raster raster = null;
                return raster;
            }
            ImageIO.setUseCache(false);
            iin = ImageIO.createImageInputStream(in);
            iir.setInput(iin, true);
            ras = iir.readRaster(0, null);
        }
        catch (Exception e) {
            LogWriter.writeLog("Unable to find jars on classpath " + e);
        }
        finally {
            if (iin != null) {
                iin.flush();
                iin.close();
            }
            if (iir != null) {
                iir.dispose();
            }
        }
        return ras;
    }
}

