/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.Graphics2D;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.io.Serializable;
import org.jpedal.color.PatternColorSpace;
import org.jpedal.color.PatternDisplay;
import org.jpedal.color.PdfPaint;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.Matrix;

public class PatternPaint
implements PdfPaint,
Serializable {
    private final int[][] imageArr;
    private final float[][] mm;
    private final float xStep;
    private final float yStep;

    @Override
    public void setScaling(double cropH, float scaling) {
    }

    @Override
    public boolean isPattern() {
        return false;
    }

    @Override
    public boolean isTexture() {
        return true;
    }

    @Override
    public int getRGB() {
        return 0;
    }

    @Override
    public int getTransparency() {
        return 255;
    }

    public PatternPaint(PdfObject patternObj, byte[] streamData, PatternColorSpace colorSpace, ObjectStore objectStore) {
        float[] inputs = patternObj.getFloatArray(1145198201);
        this.mm = inputs != null ? (Object)new float[][]{{inputs[0], inputs[1], 0.0f}, {inputs[2], inputs[3], 0.0f}, {inputs[4], inputs[5], 1.0f}} : (float[][])new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
        float[] rawBBox = patternObj.getFloatArray(303185736);
        GeneralPath rawPath = new GeneralPath();
        rawPath.moveTo(rawBBox[0], rawBBox[1]);
        rawPath.lineTo(rawBBox[2], rawBBox[1]);
        rawPath.lineTo(rawBBox[2], rawBBox[3]);
        rawPath.lineTo(rawBBox[0], rawBBox[3]);
        rawPath.lineTo(rawBBox[0], rawBBox[1]);
        rawPath.closePath();
        Rectangle2D rectBBox = rawPath.getBounds2D();
        int iw = (int)Math.round(rectBBox.getWidth());
        int ih = (int)Math.round(rectBBox.getHeight());
        if (rectBBox.getWidth() > 3000.0 || rectBBox.getHeight() > 3000.0) {
            iw = 3000;
            ih = 3000;
        }
        float[][] sn = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {(float)(-rectBBox.getX()), (float)(-rectBBox.getY()), 1.0f}};
        BufferedImage image = new BufferedImage(iw, ih, 2);
        PatternDisplay glyphDisplay = colorSpace.decodePatternContent(patternObj, sn, streamData, objectStore);
        Graphics2D g2 = image.createGraphics();
        glyphDisplay.setG2(g2);
        glyphDisplay.paint(null, null, null);
        float rawXStep = patternObj.getFloatNumber(591672680);
        float rawYStep = patternObj.getFloatNumber(591672681);
        this.xStep = rawXStep;
        this.yStep = rawYStep;
        this.imageArr = new int[ih][iw];
        int[] imageData = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int p = 0;
        for (int i = 0; i < ih; ++i) {
            for (int j = 0; j < iw; ++j) {
                this.imageArr[i][j] = imageData[p++];
            }
        }
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        return new PatternTileContext(this.imageArr, xform, this.mm);
    }

    @Override
    public void setGlyphMatrix(float[][] gtm) {
    }

    private static int calculatePixels(int[][] imagePixels, int iw, int ih, float xStep, float yStep, float xx, float yy) {
        float x_ = xx % xStep;
        float y_ = yy % yStep;
        if (yy < 0.0f) {
            y_ = yStep + y_;
        }
        if (xx < 0.0f) {
            x_ = xStep + x_;
        }
        int bx = (int)x_;
        int by = (int)y_;
        if (bx > -1 && by > -1 && bx < iw && by < ih) {
            return imagePixels[by][bx];
        }
        return 0;
    }

    @Override
    public void setGS(GraphicsState gs) {
    }

    private class PatternTileContext
    implements PaintContext {
        private final int[][] imagePixels;
        private final float[][] toUserSpace;
        private final float[][] fromPatternToUserSpace;

        PatternTileContext(int[][] imageArr, AffineTransform xform, float[][] mmm) {
            this.imagePixels = imageArr;
            float[][] xformMatrix = Matrix.fromAffine(xform);
            this.toUserSpace = Matrix.inverse(xformMatrix);
            this.fromPatternToUserSpace = Matrix.inverse(mmm);
        }

        @Override
        public Raster getRaster(int x, int y, int w, int h) {
            BufferedImage img = new BufferedImage(w, h, 2);
            int[] pixels = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
            int iw = this.imagePixels[0].length;
            int ih = this.imagePixels.length;
            int p = 0;
            for (int i = 0; i < h; ++i) {
                for (int j = 0; j < w; ++j) {
                    float[] src = new float[]{x + j, y + i};
                    src = Matrix.transformPoint(this.toUserSpace, src[0], src[1]);
                    src = Matrix.transformPoint(this.fromPatternToUserSpace, src[0], src[1]);
                    float xx = src[0];
                    float yy = src[1];
                    pixels[p++] = PatternPaint.calculatePixels(this.imagePixels, iw, ih, PatternPaint.this.xStep, PatternPaint.this.yStep, xx, yy);
                }
            }
            return img.getRaster();
        }

        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            return ColorModel.getRGBdefault();
        }
    }
}

