/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.FileInputStream;
import java.util.Map;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.FastColorSpaceCMYK;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.GraphicsState;
import org.jpedal.utils.LogWriter;

public class GenericColorSpace {
    boolean isConverted;
    float[] rawValues;
    Map<String, byte[]> patterns;
    private int size;
    float c = -1.0f;
    float y = -1.0f;
    float m = -1.0f;
    float k = -1.0f;
    float[] W;
    float[] G;
    float[] Ma;
    float[] R;
    private static final ColorSpace rgbCS;
    public static final String cb = "<color ";
    public static final String ce = "</color>";
    private int value = 1785221209;
    private static ColorConvertOp CSToRGB;
    ColorSpace cs;
    int type;
    PdfPaint currentColor = new PdfColor(0, 0, 0);
    private static ColorModel rgbModel;
    private static ICC_Profile ICCProfileForRGB;
    public static boolean fasterPNG;
    private static final int[] bands4;
    private int rawCSType;
    private byte[] IndexedColorMap;
    int componentCount = 3;
    GraphicsState gs;

    private static void initCMYKColorspace() {
        if (ICCProfileForRGB == null) {
            rgbModel = new ComponentColorModel(rgbCS, new int[]{8, 8, 8}, false, false, 1, 0);
        } else {
            int compCount = rgbCS.getNumComponents();
            int[] values = new int[compCount];
            for (int i = 0; i < compCount; ++i) {
                values[i] = 8;
            }
            rgbModel = new ComponentColorModel(rgbCS, values, false, false, 1, 0);
        }
        FastColorSpaceCMYK cmykCS = new FastColorSpaceCMYK();
        CSToRGB = new ColorConvertOp(cmykCS, rgbCS, ColorSpaces.hints);
    }

    public int getIndexSize() {
        return this.size;
    }

    public PdfPaint getColor() {
        return this.currentColor;
    }

    public ColorSpace getColorSpace() {
        return this.cs;
    }

    GenericColorSpace() {
        this.cs = rgbCS;
    }

    private static BufferedImage cleanupImage(BufferedImage image, int pX, int pY) {
        try {
            int imageType = image.getType();
            if (GenericColorSpace.getSampling(image.getWidth(), image.getHeight(), pX, pY) <= 1 || imageType == 0) {
                return image;
            }
            if (imageType == 5) {
                return GenericColorSpace.cleanupBGRImage(image, pX, pY);
            }
            Raster ras = GenericColorSpace.cleanupRaster(image.getData(), pX, pY, image.getColorModel().getNumColorComponents());
            image = new BufferedImage(ras.getWidth(), ras.getHeight(), image.getType());
            image.setData(ras);
            return image;
        }
        catch (Error err) {
            LogWriter.writeLog("[PDF] Error in cleanupImage " + err);
            return image;
        }
    }

    private static int getSampling(int w, int h, int pX, int pY) {
        int sampling = 1;
        int newW = w;
        if (pX > 0 && pY > 0) {
            int scaleY;
            int smallestH = pY << 2;
            int smallestW = pX << 2;
            for (int newH = h; newW > smallestW && newH > smallestH; newW >>= 1, newH >>= 1) {
                sampling <<= 1;
            }
            int scaleX = w / pX;
            if (scaleX < 1) {
                scaleX = 1;
            }
            if ((scaleY = h / pY) < 1) {
                scaleY = 1;
            }
            if ((sampling = scaleX) > scaleY) {
                sampling = scaleY;
            }
        }
        return sampling;
    }

    static Raster cleanupRaster(Raster ras, int pX, int pY, int comp) {
        String avoidCleanupRaster = System.getProperty("org.jpedal.avoidCleanupRaster");
        if (avoidCleanupRaster != null && avoidCleanupRaster.toLowerCase().contains("true")) {
            return ras;
        }
        byte[] buffer = null;
        int[] intBuffer = null;
        DataBuffer data = ras.getDataBuffer();
        int type = data instanceof DataBufferInt ? 1 : 0;
        if (type == 1) {
            intBuffer = ((DataBufferInt)data).getData();
        } else {
            int layerCount = ras.getNumBands();
            buffer = layerCount == comp ? ((DataBufferByte)data).getData() : GenericColorSpace.cleanupCOmponents(ras, comp);
        }
        int sampling = 1;
        int w = ras.getWidth();
        int h = ras.getHeight();
        int newW = w;
        if (pX > 0 && pY > 0) {
            int scaleY;
            int smallestH = pY << 2;
            int smallestW = pX << 2;
            for (int newH = h; newW > smallestW && newH > smallestH; newW >>= 1, newH >>= 1) {
                sampling <<= 1;
            }
            int scaleX = w / pX;
            if (scaleX < 1) {
                scaleX = 1;
            }
            if ((scaleY = h / pY) < 1) {
                scaleY = 1;
            }
            if ((sampling = scaleX) > scaleY) {
                sampling = scaleY;
            }
        }
        if (sampling > 1) {
            ras = GenericColorSpace.reduceImageSize(ras, comp, buffer, intBuffer, type, sampling, w, h);
        }
        return ras;
    }

    private static Raster reduceImageSize(Raster ras, int comp, byte[] buffer, int[] intBuffer, int type, int sampling, int w, int h) {
        int newW = w / sampling;
        int newH = h / sampling;
        int origLineLength = w;
        try {
            byte[] newData = new byte[newW * newH * comp];
            if (type == 0) {
                origLineLength = w * comp;
            }
            GenericColorSpace.downsample(comp, buffer, intBuffer, type, sampling, w, h, newW, newH, origLineLength, newData);
            int[] bands = new int[comp];
            for (int jj2 = 0; jj2 < comp; ++jj2) {
                bands[jj2] = jj2;
            }
            ras = Raster.createInterleavedRaster(new DataBufferByte(newData, newData.length), newW, newH, newW * comp, comp, bands, null);
        }
        catch (Exception e) {
            LogWriter.writeLog("Problem with Image " + e);
        }
        return ras;
    }

    private static void downsample(int comp, byte[] buffer, int[] intBuffer, int type, int sampling, int w, int h, int newW, int newH, int origLineLength, byte[] newData) {
        for (int y = 0; y < newH; ++y) {
            for (int x = 0; x < newW; ++x) {
                int wCount = sampling;
                int hCount = sampling;
                int wGapLeft = w - x;
                int hGapLeft = h - y;
                if (wCount > wGapLeft) {
                    wCount = wGapLeft;
                }
                if (hCount > hGapLeft) {
                    hCount = hGapLeft;
                }
                for (int jj = 0; jj < comp; ++jj) {
                    int byteTotal = 0;
                    int count = 0;
                    for (int yy = 0; yy < hCount; ++yy) {
                        for (int xx = 0; xx < wCount; ++xx) {
                            byteTotal = type == 0 ? (byteTotal += buffer[(yy + y * sampling) * origLineLength + (x * sampling * comp + xx * comp + jj)] & 0xFF) : (byteTotal += intBuffer[(yy + y * sampling) * origLineLength + x * sampling + xx] >> 8 * (2 - jj) & 0xFF);
                            ++count;
                        }
                    }
                    if (count <= 0) continue;
                    newData[jj + x * comp + newW * y * comp] = (byte)(byteTotal / count);
                }
            }
        }
    }

    private static byte[] cleanupCOmponents(Raster ras, int comp) {
        byte[] rawBuffer = ((DataBufferByte)ras.getDataBuffer()).getData();
        int size = rawBuffer.length;
        int realSize = size * comp;
        int j = 0;
        int i = 0;
        byte[] buffer = new byte[realSize];
        do {
            for (int a = 0; a < comp; ++a) {
                buffer[j] = rawBuffer[i];
                ++j;
            }
        } while (++i < size);
        return buffer;
    }

    private static BufferedImage cleanupBGRImage(BufferedImage img, int pX, int pY) {
        String avoidCleanupRaster = System.getProperty("org.jpedal.avoidCleanupRaster");
        if (avoidCleanupRaster != null && avoidCleanupRaster.toLowerCase().contains("true")) {
            return img;
        }
        Raster ras = img.getData();
        int comp = img.getColorModel().getNumColorComponents();
        byte[] buffer = null;
        int[] intBuffer = null;
        DataBuffer data = ras.getDataBuffer();
        int type = data instanceof DataBufferInt ? 1 : 0;
        if (type == 1) {
            intBuffer = ((DataBufferInt)data).getData();
        } else {
            int layerCount = ras.getNumBands();
            if (layerCount == comp) {
                buffer = ((DataBufferByte)data).getData();
            } else if (layerCount == 1) {
                buffer = GenericColorSpace.getBytes(ras, comp);
            }
        }
        int w = ras.getWidth();
        int h = ras.getHeight();
        int sampling = GenericColorSpace.getSampling(w, h, pX, pY);
        if (sampling > 1) {
            img = GenericColorSpace.downSampleData(img, (WritableRaster)ras, comp, buffer, intBuffer, type, sampling, w, h);
        }
        return img;
    }

    private static BufferedImage downSampleData(BufferedImage img, WritableRaster ras, int comp, byte[] buffer, int[] intBuffer, int type, int sampling, int w, int h) {
        int newW = w / sampling;
        int newH = h / sampling;
        int origLineLength = w;
        try {
            int[] newData = new int[comp];
            if (type == 0) {
                origLineLength = w * comp;
            }
            for (int y = 0; y < newH; ++y) {
                for (int x = 0; x < newW; ++x) {
                    int wCount = sampling;
                    int hCount = sampling;
                    int wGapLeft = w - x;
                    int hGapLeft = h - y;
                    if (wCount > wGapLeft) {
                        wCount = wGapLeft;
                    }
                    if (hCount > hGapLeft) {
                        hCount = hGapLeft;
                    }
                    GenericColorSpace.downsampleComponents(comp, buffer, intBuffer, type, sampling, x, y, origLineLength, newData, wCount, hCount);
                    ras.setPixels(x, y, 1, 1, newData);
                }
            }
            img = new BufferedImage(newW, newH, img.getType());
            img.setData(ras);
        }
        catch (Exception e) {
            LogWriter.writeLog("Problem with Image " + e);
        }
        return img;
    }

    private static void downsampleComponents(int comp, byte[] buffer, int[] intBuffer, int type, int sampling, int x, int y, int origLineLength, int[] newData, int wCount, int hCount) {
        block4: for (int jj = 0; jj < comp; ++jj) {
            int byteTotal = 0;
            int count = 0;
            for (int yy = 0; yy < hCount; ++yy) {
                for (int xx = 0; xx < wCount; ++xx) {
                    byteTotal = type == 0 ? (byteTotal += buffer[(yy + y * sampling) * origLineLength + (x * sampling * comp + xx * comp + jj)] & 0xFF) : (byteTotal += intBuffer[(yy + y * sampling) * origLineLength + x * sampling + xx] >> 8 * (2 - jj) & 0xFF);
                    ++count;
                }
            }
            if (count <= 0) continue;
            switch (jj) {
                case 0: {
                    newData[2] = byteTotal / count;
                    continue block4;
                }
                case 2: {
                    newData[0] = byteTotal / count;
                    continue block4;
                }
                default: {
                    newData[jj] = byteTotal / count;
                }
            }
        }
    }

    private static byte[] getBytes(Raster ras, int comp) {
        byte[] buffer = GenericColorSpace.cleanupCOmponents(ras, comp);
        return buffer;
    }

    public void setIndex(byte[] IndexedColorMap, int size) {
        this.IndexedColorMap = IndexedColorMap;
        this.size = size;
    }

    int getIndexedColorComponent(int count) {
        int vv = 255;
        if (count < this.IndexedColorMap.length) {
            vv = this.IndexedColorMap[count] & 0xFF;
        }
        return vv;
    }

    public byte[] getIndexedMap() {
        if (this.IndexedColorMap == null) {
            return null;
        }
        int size = this.IndexedColorMap.length;
        byte[] copy = new byte[size];
        System.arraycopy(this.IndexedColorMap, 0, copy, 0, size);
        return copy;
    }

    public void setColor(String[] number_values) {
        int items = number_values.length;
        float[] colValues = new float[items];
        for (int ii = 0; ii < items; ++ii) {
            colValues[ii] = Float.parseFloat(number_values[ii]);
        }
        this.setColor(colValues);
    }

    public void setColor(int[] number_values) {
        int items = number_values.length;
        float[] colValues = new float[items];
        for (int ii = 0; ii < items; ++ii) {
            colValues[ii] = (float)number_values[ii] / 255.0f;
        }
        this.setColor(colValues);
    }

    public void setColor(float[] value) {
        if (LogWriter.isRunningFromIDE) {
            throw new RuntimeException(" called setColor(float[] in Generic for " + this);
        }
    }

    public BufferedImage JPEGToRGBImage(byte[] data, int w, int h, int pX, int pY) {
        BufferedImage image;
        try {
            image = DefaultImageHelper.read(data);
            if (image != null && !fasterPNG && this.value != 1568372915) {
                image = GenericColorSpace.cleanupImage(image, pX, pY);
                image = ColorSpaceConvertor.convertToRGB(image);
            }
        }
        catch (Exception ee) {
            image = null;
            LogWriter.writeLog("Problem reading JPEG: " + ee);
        }
        return image;
    }

    public byte[] dataToRGBByteArray(byte[] data, int w, int h) {
        return data;
    }

    float[] flattenIndexedValue(float[] number_values) {
        int ptr = (int)(number_values[0] * (float)this.componentCount);
        byte[] cmap = this.getIndexedMap();
        number_values = new float[this.componentCount];
        for (int i = 0; i < this.componentCount; ++i) {
            number_values[i] = (float)(cmap[ptr + i] & 0xFF) / 255.0f;
        }
        return number_values;
    }

    int[] flattenIndexedValue(int[] number_values) {
        int ptr = number_values[0] * this.componentCount;
        byte[] cmap = this.getIndexedMap();
        number_values = new int[this.componentCount];
        for (int i = 0; i < this.componentCount; ++i) {
            number_values[i] = cmap[ptr + i] & 0xFF;
        }
        return number_values;
    }

    public BufferedImage dataToRGB(byte[] data, int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 1);
        Raster raster = ColorSpaceConvertor.createInterleavedRaster(data, w, h);
        image.setData(raster);
        return image;
    }

    public int getID() {
        return this.value;
    }

    final void setCIEValues(float[] W, float[] R, float[] Ma, float[] G2) {
        this.cs = ColorSpace.getInstance(1001);
        this.G = G2;
        this.Ma = Ma;
        this.W = W;
        this.R = R;
    }

    byte[] convert4Index(byte[] data) {
        int compCount = 4;
        if (this.value == 1498837125) {
            int len = data.length;
            byte[] rgb = new byte[len * 3 / 4];
            int j2 = 0;
            for (int ii = 0; ii < len; ii += 4) {
                int[] vals = new int[4];
                for (int j = 0; j < 4; ++j) {
                    vals[j] = data[ii + j] & 0xFF;
                }
                this.setColor(vals);
                int foreground = this.currentColor.getRGB();
                rgb[j2] = (byte)(foreground >> 16 & 0xFF);
                rgb[j2 + 1] = (byte)(foreground >> 8 & 0xFF);
                rgb[j2 + 2] = (byte)(foreground & 0xFF);
                j2 += 3;
                if (len - 4 - ii >= 4) continue;
                ii = len;
            }
            return rgb;
        }
        try {
            int width = data.length / 4;
            boolean height = true;
            DataBufferByte db = new DataBufferByte(data, data.length);
            WritableRaster raster = Raster.createInterleavedRaster(db, width, 1, width * 4, 4, bands4, null);
            if (CSToRGB == null) {
                GenericColorSpace.initCMYKColorspace();
                CSToRGB = new ColorConvertOp(this.cs, rgbCS, ColorSpaces.hints);
            }
            WritableRaster rgbRaster = rgbModel.createCompatibleWritableRaster(width, 1);
            CSToRGB.filter(raster, rgbRaster);
            DataBuffer convertedData = rgbRaster.getDataBuffer();
            int size = width * 1 * 3;
            data = new byte[size];
            for (int ii = 0; ii < size; ++ii) {
                data[ii] = (byte)convertedData.getElem(ii);
            }
        }
        catch (Exception ee) {
            LogWriter.writeLog("Exception  " + ee + " converting colorspace");
        }
        return data;
    }

    public byte[] convertIndexToRGB(byte[] index) {
        return index;
    }

    public String getXMLColorToken() {
        String colorToken;
        if (this.c == -1.0f) {
            if (this.currentColor instanceof Color) {
                Color col = new Color(this.currentColor.getRGB());
                float c = (float)(255 - col.getRed()) / 255.0f;
                float m = (float)(255 - col.getGreen()) / 255.0f;
                float y = (float)(255 - col.getBlue()) / 255.0f;
                float k = c;
                if (k < m) {
                    k = m;
                }
                if (k < y) {
                    k = y;
                }
                colorToken = "<color C='" + c + "' M='" + m + "' Y='" + y + "' K='" + k + "' >";
            } else {
                colorToken = "<color type='shading'>";
            }
        } else {
            colorToken = "<color C='" + this.c + "' M='" + this.m + "' Y='" + this.y + "' K='" + this.k + "' >";
        }
        return colorToken;
    }

    public void setPattern(Map<String, byte[]> patterns) {
        this.patterns = patterns;
    }

    public void setColor(PdfPaint col) {
        this.currentColor = col;
    }

    public int getColorComponentCount() {
        return this.componentCount;
    }

    public void setGS(GraphicsState currentGraphicsState) {
        this.gs = currentGraphicsState;
    }

    public float[] getRawValues() {
        return this.rawValues;
    }

    public boolean isIndexConverted() {
        return this.isConverted;
    }

    public static ColorSpace getColorSpaceInstance() {
        ColorSpace rgbCS = ColorSpace.getInstance(1000);
        String profile = System.getProperty("org.jpedal.RGBprofile");
        if (profile != null) {
            try {
                rgbCS = new ICC_ColorSpace(ICC_Profile.getInstance(new FileInputStream(profile)));
                System.out.println("use " + profile);
            }
            catch (Exception e) {
                LogWriter.writeLog("[PDF] Problem " + e.getMessage() + " with ICC data ");
            }
        }
        return rgbCS;
    }

    int getType() {
        return this.type;
    }

    void setType(int rawValue) {
        this.value = rawValue;
        this.rawCSType = rawValue;
    }

    void setRawColorSpace(int rawType) {
        this.rawCSType = rawType;
    }

    public int getRawColorSpacePDFType() {
        return this.rawCSType;
    }

    public void invalidateCaching(int color) {
    }

    static {
        block3: {
            bands4 = new int[]{0, 1, 2, 3};
            String fasterPNG = System.getProperty("org.jpedal.fasterPNG");
            GenericColorSpace.fasterPNG = fasterPNG != null && fasterPNG.equalsIgnoreCase("true");
            String profile = System.getProperty("org.jpedal.RGBprofile");
            if (profile != null) {
                try {
                    ICCProfileForRGB = ICC_Profile.getInstance(new FileInputStream(profile));
                }
                catch (Exception e) {
                    LogWriter.writeLog("[PDF] Problem " + e.getMessage() + " with ICC data ");
                    if (ICCProfileForRGB != null) break block3;
                    throw new RuntimeException("Problem wth RGB profile " + profile + ' ' + e.getMessage());
                }
            }
        }
        rgbCS = ICCProfileForRGB != null ? new ICC_ColorSpace(ICCProfileForRGB) : ColorSpace.getInstance(1000);
    }
}

