/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import com.idrsolutions.image.jpeg2000.EnumeratedSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;

public class CMYKtoRGB {
    public static BufferedImage convert(Raster ras, int w, int h) {
        byte[] rasData = ((DataBufferByte)ras.getDataBuffer()).getData();
        return CMYKtoRGB.decode(rasData, w, h);
    }

    public static BufferedImage convert(byte[] cmyk, int w, int h) {
        return CMYKtoRGB.decode(cmyk, w, h);
    }

    private static BufferedImage decode(byte[] rasData, int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 1);
        int[] imageData = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int dim = w * h;
        int p = 0;
        EnumeratedSpace em = new EnumeratedSpace();
        for (int i = 0; i < dim; ++i) {
            int c = rasData[p++] & 0xFF;
            int m = rasData[p++] & 0xFF;
            int y = rasData[p++] & 0xFF;
            int k = rasData[p++] & 0xFF;
            imageData[i] = em.getRGB(c, m, y, k);
        }
        return image;
    }
}

