/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import com.idrsolutions.image.Decoder;
import com.idrsolutions.image.ImageFormat;
import com.idrsolutions.image.bmp.BmpDecoder;
import com.idrsolutions.image.bmp.BmpEncoder;
import com.idrsolutions.image.jpeg.JpegDecoder;
import com.idrsolutions.image.jpeg2000.EnumeratedSpace;
import com.idrsolutions.image.jpeg2000.Jpeg2000Decoder;
import com.idrsolutions.image.jpeg2000.Jpeg2000Encoder;
import com.idrsolutions.image.png.PngDecoder;
import com.idrsolutions.image.png.PngEncoder;
import com.idrsolutions.image.png.options.PngCompressionFormat;
import com.idrsolutions.image.scale.QualityScaler;
import com.idrsolutions.image.tiff.TiffDecoder;
import com.idrsolutions.image.tiff.TiffEncoder;
import com.idrsolutions.image.utility.ImageTypeFinder;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;
import org.jpedal.color.CMYKtoRGB;
import org.jpedal.images.ImageLibrary;
import org.jpedal.jbig2.io.JBIG2;
import org.jpedal.utils.LogWriter;

public class JDeliHelper
implements ImageLibrary {
    private static Object JDeli = null;
    private final EnumeratedSpace cmyk = new EnumeratedSpace();

    @Override
    public BufferedImage convert(byte[] buffer, int w, int h) {
        return CMYKtoRGB.convert(buffer, w, h);
    }

    @Override
    public BufferedImage convert(Raster ras, int w, int h) {
        return CMYKtoRGB.convert(ras, w, h);
    }

    @Override
    public byte[] JBIGDecode(byte[] data, byte[] globalData) throws Exception {
        return JBIG2.JBIGDecode(data, globalData);
    }

    @Override
    public void processJPEG(int dim, byte[] data, int[] maskArray, int[] output) {
        int p = 0;
        for (int i = 0; i < dim; ++i) {
            boolean isMask;
            int c = data[p++] & 0xFF;
            int m = data[p++] & 0xFF;
            int y = data[p++] & 0xFF;
            int k = data[p++] & 0xFF;
            boolean bl = isMask = c >= maskArray[0] && c <= maskArray[1] && m >= maskArray[2] && m <= maskArray[3] && y >= maskArray[4] && y <= maskArray[5] && k >= maskArray[4] && k <= maskArray[5];
            if (isMask) continue;
            output[i] = 0xFF000000 | this.cmyk.getRGB(c, m, y, k);
        }
    }

    @Override
    public BufferedImage JPEG2000ToRGBImage(byte[] data) throws Exception {
        Jpeg2000Decoder decoder = new Jpeg2000Decoder();
        return decoder.read(data);
    }

    @Override
    public int convertCMYKtoRGB(int cc, int mm, int yy, int kk) {
        return EnumeratedSpace.getStaticRGB(cc, mm, yy, kk);
    }

    @Override
    public byte[] convertCMYK2RGB(int w, int h, int pixelCount, byte[] data) {
        byte[] output = new byte[w * h * 3];
        EnumeratedSpace.convertCMYKToRGB(data, output);
        return output;
    }

    @Override
    public byte[] getBytesFromJPEG(byte[] data) throws Exception {
        return Jpeg2000Decoder.readComponentsAsConvertedBytes(data);
    }

    @Override
    public byte[] getUnconvertedBytesFromJPEG2000(byte[] data) throws Exception {
        return Jpeg2000Decoder.readComponentsAsUnConvertedBytes(data);
    }

    @Override
    public byte[] getUnconvertedBytesFromJPEG(byte[] data, int adobeColorTransform) throws Exception {
        JpegDecoder decoder = new JpegDecoder();
        return decoder.readAsUnconvertedBytes(data, adobeColorTransform);
    }

    @Override
    public BufferedImage getTiffImage(int tiffImageToLoad, String file) {
        BufferedImage image = null;
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            TiffDecoder decoder = new TiffDecoder();
            decoder.read(raf);
            image = decoder.read(tiffImageToLoad + 1);
            raf.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return image;
    }

    @Override
    public int getTiffPageCount(String file) {
        int pageCount = 0;
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            TiffDecoder decoder = new TiffDecoder();
            decoder.read(raf);
            pageCount = decoder.getPageCount();
            raf.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return pageCount;
    }

    @Override
    public void write(BufferedImage image, String type, String file_name, boolean fasterPNG) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(file_name)));
        if (image.getData().getMinX() != 0 || image.getData().getMinY() != 0) {
            ImageIO.write((RenderedImage)image, type, bos);
        } else if (type.equalsIgnoreCase("png")) {
            PngEncoder encoder = new PngEncoder();
            encoder.getEncoderOptions().setCompressionFormat(PngCompressionFormat.ZLIB_BETTER_SPEED);
            encoder.write(image, bos);
        } else if (type.equalsIgnoreCase("tif") || type.equalsIgnoreCase("tiff")) {
            TiffEncoder encoder = new TiffEncoder();
            encoder.setCompressed(true);
            encoder.write(image, bos);
        } else if (type.equalsIgnoreCase("jpx")) {
            Jpeg2000Encoder encoder = new Jpeg2000Encoder();
            encoder.write(image, bos);
        } else if (type.equalsIgnoreCase("bmp")) {
            BmpEncoder encoder = new BmpEncoder();
            encoder.write(image, bos);
        } else {
            if (fasterPNG) {
                BufferedImage indexedImage = new BufferedImage(image.getWidth(), image.getHeight(), 13);
                Graphics2D g = indexedImage.createGraphics();
                g.drawImage((Image)image, 0, 0, null);
                image = indexedImage;
            }
            ImageIO.write((RenderedImage)image, type, bos);
        }
        bos.flush();
        bos.close();
    }

    public static BufferedImage getScaledImage(BufferedImage srcImage, int dstWidth, int dstHeight) {
        return QualityScaler.getScaledImage(srcImage, dstWidth, dstHeight);
    }

    @Override
    public BufferedImage read(File f) throws Exception {
        if (JDeli == null) {
            return JDeliHelper.readCoreFormats(f);
        }
        Method method = JDeli.getClass().getMethod("read", File.class);
        return (BufferedImage)method.invoke(null, f);
    }

    private static BufferedImage readCoreFormats(File imageFile) throws Exception {
        byte[] data = JDeliHelper.getTestBytes(imageFile);
        ImageFormat type = ImageTypeFinder.getImageType(data);
        Decoder dec = JDeliHelper.getCoreDecoder(type);
        if (dec != null) {
            return dec.read(imageFile);
        }
        return null;
    }

    private static Decoder getCoreDecoder(ImageFormat type) {
        switch (type) {
            case BMP_IMAGE: {
                return new BmpDecoder();
            }
            case JPEG_IMAGE: {
                return new JpegDecoder();
            }
            case JPEG2000_IMAGE: {
                return new Jpeg2000Decoder();
            }
            case PNG_IMAGE: {
                return new PngDecoder();
            }
            case TIFF_IMAGE: {
                return new TiffDecoder();
            }
        }
        return null;
    }

    private static byte[] getTestBytes(File imageFile) throws IOException {
        byte[] test;
        try (FileInputStream fis = new FileInputStream(imageFile);){
            test = new byte[Math.min(140, (int)imageFile.length())];
            fis.read(test);
        }
        return test;
    }

    static {
        ClassLoader loader = JDeliHelper.class.getClassLoader();
        String jdeliClassPath = "com/idrsolutions/image/JDeli.class";
        if (loader.getResource("com/idrsolutions/image/JDeli.class") != null) {
            try {
                JDeli = loader.loadClass("com.idrsolutions.image.JDeliSupport").newInstance();
            }
            catch (Exception ex) {
                LogWriter.writeLog("[PDF] Unable to instance JDeli " + ex);
            }
        }
    }
}

