/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.BitReader;
import com.idrsolutions.pdf.color.shading.ShadingFactory;
import com.idrsolutions.pdf.color.shading.ShadingUtils;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.Matrix;

class FreeFormShadeContext
implements PaintContext {
    private final GenericColorSpace shadingColorSpace;
    private final float[] background;
    private float[][] toUserSpace = Matrix.getIdentity();
    private final float[][] toShadeSpace;
    private final float[] decodeArr;
    private final PDFFunction[] function;
    private final int nComp;
    private final List<float[]> triCoords;
    private final List<Color> triColors;
    private final int triCount;
    private int[] lumPixels;
    private float lumX;
    private float lumY;
    private float lumW;
    private float lumH;
    private int lumIW;

    FreeFormShadeContext(GenericColorSpace shadingColorSpace, float[] background, PdfObject shadingObject, float[][] mm, PDFFunction[] function) {
        this.shadingColorSpace = shadingColorSpace;
        int bitsPerComponent = shadingObject.getInt(-1344207655);
        int bitsPerFlag = shadingObject.getInt(1500422077);
        int bitsPerCoordinate = shadingObject.getInt(-335950113);
        this.decodeArr = shadingObject.getFloatArray(859785322);
        this.function = function;
        this.background = background;
        this.nComp = (this.decodeArr.length - 4) / 2;
        float[][] caller = mm != null ? mm : Matrix.getIdentity();
        Object shadeMatrix = Matrix.getIdentity();
        float[] inputs = shadingObject.getFloatArray(1145198201);
        if (inputs != null) {
            shadeMatrix = new float[][]{{inputs[0], inputs[1], 0.0f}, {inputs[2], inputs[3], 0.0f}, {inputs[4], inputs[5], 1.0f}};
        }
        float[][] shader = Matrix.concatenate(caller, shadeMatrix);
        this.toShadeSpace = Matrix.inverse(shader);
        boolean hasSmallBits = bitsPerFlag < 8 || bitsPerComponent < 8 || bitsPerCoordinate < 8;
        BitReader reader = new BitReader(shadingObject.getDecodedStream(), hasSmallBits);
        double bitCoordScaling = 1.0 / (double)((1L << bitsPerCoordinate) - 1L);
        double bitCompScaling = 1.0 / (double)((1L << bitsPerComponent) - 1L);
        ArrayList<Point2D> trianglesPoints = new ArrayList<Point2D>();
        this.triColors = new ArrayList<Color>();
        while (reader.getPointer() < reader.getTotalBitLen()) {
            int flag = reader.getPositive(bitsPerFlag);
            Point2D p = FreeFormShadeContext.getPointCoords(reader, bitCoordScaling, bitsPerCoordinate, this.decodeArr);
            Color c = this.getPointColor(reader, bitCompScaling, bitsPerComponent);
            switch (flag) {
                case 0: {
                    break;
                }
                case 1: {
                    Point2D[] temp = new Point2D[]{(Point2D)trianglesPoints.get(trianglesPoints.size() - 2), (Point2D)trianglesPoints.get(trianglesPoints.size() - 1)};
                    trianglesPoints.addAll(Arrays.asList(temp));
                    Color[] tc = new Color[]{this.triColors.get(this.triColors.size() - 2), this.triColors.get(this.triColors.size() - 1)};
                    this.triColors.addAll(Arrays.asList(tc));
                    break;
                }
                case 2: {
                    Point2D[] ff = new Point2D[]{(Point2D)trianglesPoints.get(trianglesPoints.size() - 3), (Point2D)trianglesPoints.get(trianglesPoints.size() - 1)};
                    trianglesPoints.addAll(Arrays.asList(ff));
                    Color[] fc = new Color[]{this.triColors.get(this.triColors.size() - 3), this.triColors.get(this.triColors.size() - 1)};
                    this.triColors.addAll(Arrays.asList(fc));
                }
            }
            trianglesPoints.add(p);
            this.triColors.add(c);
        }
        this.triCoords = new ArrayList<float[]>();
        for (Point2D trianglesPoint : trianglesPoints) {
            float[] xy = new float[]{(float)trianglesPoint.getX(), (float)trianglesPoint.getY()};
            this.triCoords.add(xy);
        }
        this.triCount = this.triCoords.size() / 3;
    }

    public void updateXForm(float[][] xFormMatrix, float[][] gm) {
        float[][] xm = xFormMatrix;
        if (gm != null) {
            xm = Matrix.concatenate(xm, Matrix.inverse(gm));
        }
        this.toUserSpace = Matrix.inverse(xm);
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    private static Point2D getPointCoords(BitReader reader, double bitScaling, int bps, float[] decode) {
        long x_ = reader.readBitsAsLong(bps);
        long y_ = reader.readBitsAsLong(bps);
        double x = (double)x_ * bitScaling * (double)(decode[1] - decode[0]) + (double)decode[0];
        double y = (double)y_ * bitScaling * (double)(decode[3] - decode[2]) + (double)decode[2];
        return new Point2D.Double(x, y);
    }

    private Color getPointColor(BitReader reader, double bitScaling, int bps) {
        float[] components = new float[this.nComp];
        int i = 0;
        int j = 4;
        while (i < this.nComp) {
            long ci = reader.readBitsAsLong(bps);
            components[i] = (float)((double)ci * bitScaling * (double)(this.decodeArr[j + 1] - this.decodeArr[j]) + (double)this.decodeArr[j]);
            ++i;
            j += 2;
        }
        return this.calculateColor(components);
    }

    @Override
    public Raster getRaster(int startX, int startY, int w, int h) {
        WritableRaster raster = new BufferedImage(w, h, 2).getRaster();
        int[] data = ((DataBufferInt)raster.getDataBuffer()).getData();
        if (this.background != null) {
            ShadingUtils.setBackgroundColor(w, h, data, this.shadingColorSpace, this.background);
        }
        int lum = 0;
        boolean hasLum = false;
        for (int i = 0; i < h; ++i) {
            block1: for (int j = 0; j < w; ++j) {
                float y1;
                float x1;
                float[] src = new float[]{startX + j, startY + i};
                src = Matrix.transformPoint(this.toUserSpace, src[0], src[1]);
                if (this.lumPixels != null) {
                    int xLoc;
                    int yLoc;
                    int loc;
                    x1 = src[0];
                    y1 = src[1];
                    float xend = this.lumX + this.lumW;
                    float yend = this.lumY + this.lumH;
                    if (x1 >= this.lumX && x1 <= xend && y1 >= this.lumY && y1 <= yend && (loc = (yLoc = (int)(y1 - this.lumY)) * this.lumIW + (xLoc = (int)(x1 - this.lumX))) < this.lumPixels.length) {
                        hasLum = true;
                        lum = this.lumPixels[loc];
                    }
                }
                src = Matrix.transformPoint(this.toShadeSpace, src[0], src[1]);
                float x = src[0];
                float y = src[1];
                for (int t = 0; t < this.triCount; ++t) {
                    int pix;
                    float y3;
                    int p = t * 3;
                    float[] temp = this.triCoords.get(p);
                    x1 = temp[0];
                    y1 = temp[1];
                    temp = this.triCoords.get(p + 1);
                    float x2 = temp[0];
                    float y2 = temp[1];
                    float x3 = (temp = this.triCoords.get(p + 2))[0];
                    if (!FreeFormShadeContext.isInTriangle(x, y, x1, y1, x2, y2, x3, y3 = temp[1])) continue;
                    Color c1 = this.triColors.get(p);
                    Color c2 = this.triColors.get(p + 1);
                    Color c3 = this.triColors.get(p + 2);
                    float a = FreeFormShadeContext.areaTriangle(x1, y1, x2, y2, x3, y3);
                    float a1 = FreeFormShadeContext.areaTriangle(x, y, x1, y1, x2, y2);
                    float a2 = FreeFormShadeContext.areaTriangle(x, y, x1, y1, x3, y3);
                    float a3 = FreeFormShadeContext.areaTriangle(x, y, x2, y2, x3, y3);
                    int r = (int)(a1 / a * (float)c3.getRed() + a2 / a * (float)c2.getRed() + a3 / a * (float)c1.getRed());
                    int g = (int)(a1 / a * (float)c3.getGreen() + a2 / a * (float)c2.getGreen() + a3 / a * (float)c1.getGreen());
                    int b = (int)(a1 / a * (float)c3.getBlue() + a2 / a * (float)c2.getBlue() + a3 / a * (float)c1.getBlue());
                    data[i * w + j] = pix = 0xFF000000 | r << 16 | g << 8 | b;
                    if (!hasLum) continue block1;
                    r = lum >> 16 & 0xFF;
                    g = lum >> 8 & 0xFF;
                    b = lum & 0xFF;
                    int yy = r * 77 + g * 152 + b * 28;
                    int resA = pix >> 24 & 0xFF;
                    resA = resA * yy >> 16;
                    data[i * w + j] = resA << 24 | pix & 0xFFFFFF;
                    continue block1;
                }
            }
        }
        return raster;
    }

    public void setLuminosityMask(BufferedImage image, float x, float y, float w, float h) {
        this.lumPixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        this.lumX = x;
        this.lumY = y;
        this.lumIW = image.getWidth();
        this.lumW = w;
        this.lumH = h;
    }

    private Color calculateColor(float[] val) {
        Color col;
        if (this.function != null) {
            float[] colValues = ShadingFactory.applyFunctions(this.function, val);
            this.shadingColorSpace.setColor(colValues);
            col = new Color(this.shadingColorSpace.getColor().getRGB());
        } else {
            this.shadingColorSpace.setColor(val);
            col = new Color(this.shadingColorSpace.getColor().getRGB());
        }
        return col;
    }

    private static float areaTriangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        return Math.abs((x1 - x3) * (y2 - y1) - (x1 - x2) * (y3 - y1));
    }

    private static boolean isInTriangle(float x, float y, float x1, float y1, float x2, float y2, float x3, float y3) {
        float dX = x - x3;
        float dY = y - y3;
        float dX21 = x3 - x2;
        float dY12 = y2 - y3;
        float D2 = dY12 * (x1 - x3) + dX21 * (y1 - y3);
        float s = dY12 * dX + dX21 * dY;
        float t = (y3 - y1) * dX + (x1 - x3) * dY;
        if (D2 < 0.0f) {
            return s <= 0.0f && t <= 0.0f && s + t >= D2;
        }
        return s >= 0.0f && t >= 0.0f && s + t <= D2;
    }
}

