/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.utility;

public class SupportedFormats {
    private static final String[][] supportedEncoders;
    private static final String[][] supportedDecoders;

    public static String[][] getSupportedImageEncoders() {
        return supportedEncoders;
    }

    public static String[][] getSupportedImageDecoders() {
        return supportedDecoders;
    }

    public static boolean hasEncoderSupportForImageFormat(String format) {
        boolean formatFound = false;
        if (format != null && !format.isEmpty()) {
            String[][] stringArray = supportedEncoders;
            int n = stringArray.length;
            block0: for (int i = 0; i < n; ++i) {
                String[] supportedAlternative;
                for (String supported : supportedAlternative = stringArray[i]) {
                    if (!supported.equalsIgnoreCase(format)) continue;
                    formatFound = true;
                    continue block0;
                }
            }
        }
        return formatFound;
    }

    public static boolean hasDecoderSupportForImageFormat(String format) {
        boolean formatFound = false;
        if (format != null && !format.isEmpty()) {
            String[][] stringArray = supportedDecoders;
            int n = stringArray.length;
            block0: for (int i = 0; i < n; ++i) {
                String[] supportedAlternative;
                for (String supported : supportedAlternative = stringArray[i]) {
                    if (!supported.equalsIgnoreCase(format)) continue;
                    formatFound = true;
                    continue block0;
                }
            }
        }
        return formatFound;
    }

    static {
        boolean iSJDeliPresent;
        ClassLoader loader = SupportedFormats.class.getClassLoader();
        String jdeliClassPath = "com/idrsolutions/image/JDeli.class";
        boolean bl = iSJDeliPresent = loader.getResource("com/idrsolutions/image/JDeli.class") != null;
        if (iSJDeliPresent) {
            supportedDecoders = new String[][]{{"bmp"}, {"dcm"}, {"gif"}, {"jpx", "jp2"}, {"jpeg", "jpg"}, {"png"}, {"psd"}, {"sgi", "rgb"}, {"tif", "tiff"}, {"webp"}, {"wmf"}};
            supportedEncoders = new String[][]{{"bmp"}, {"jpeg", "jpg"}, {"jpx"}, {"png"}, {"tif", "tiff"}};
        } else {
            supportedDecoders = new String[][]{{"bmp"}, {"jpx", "jp2"}, {"jpeg", "jpg"}, {"png"}, {"tif", "tiff"}};
            supportedEncoders = new String[][]{{"bmp"}, {"jpeg", "jpg"}, {"jpx"}, {"png"}, {"tif", "tiff"}};
        }
    }
}

