/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.utility;

class BitWriter {
    private int buffer;
    private int bitC;
    private int bp;
    private byte[] data = new byte[16];

    BitWriter() {
    }

    private void putBit(int bit) {
        this.buffer = this.buffer << 1 | bit & 1;
        ++this.bitC;
        if (this.bitC == 8) {
            this.bitC = 0;
            this.stuff(this.buffer);
        }
    }

    public void putNBit(int v, int nb) {
        for (int i = nb; i > 0; --i) {
            this.putBit(v >> i - 1);
        }
    }

    private void putU8(int b) {
        if (this.bitC == 0) {
            this.stuff(b);
        } else {
            for (int j = 7; j >= 0; --j) {
                this.putBit(b >> j);
            }
        }
    }

    public void putU16(int value) {
        this.putU8(value >> 8 & 0xFF);
        this.putU8(value & 0xFF);
    }

    public void putU32(int value) {
        this.putU8(value >> 24 & 0xFF);
        this.putU8(value >> 16 & 0xFF);
        this.putU8(value >> 8 & 0xFF);
        this.putU8(value & 0xFF);
    }

    private void stuff(int v) {
        if (this.bp >= this.data.length) {
            byte[] temp = new byte[this.data.length << 1];
            System.arraycopy(this.data, 0, temp, 0, this.bp);
            this.data = temp;
        }
        this.data[this.bp++] = (byte)v;
    }

    public byte[] getBytes() {
        if (this.bitC > 0) {
            this.stuff(this.buffer <<= 8 - this.bitC);
            this.bitC = 0;
        }
        byte[] result = new byte[this.bp];
        System.arraycopy(this.data, 0, result, 0, this.bp);
        return result;
    }
}

