/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.utility;

public class BitReader {
    private int p;
    private final byte[] data;
    private int bs;
    private int b;

    public BitReader(byte[] data) {
        this.data = data;
    }

    public byte readBit() {
        if (this.bs < 1) {
            this.b = this.b << 8 | this.data[this.p++] & 0xFF;
            this.bs += 8;
        }
        --this.bs;
        return (byte)(this.b >>> this.bs & 1);
    }

    public int readU8() {
        if (this.bs < 8) {
            this.b = this.b << 8 | this.data[this.p++] & 0xFF;
            this.bs += 8;
        }
        this.bs -= 8;
        return this.b >>> this.bs & 0xFF;
    }

    public int readU16() {
        return this.readU8() << 8 | this.readU8();
    }

    public int readU32() {
        return this.readU16() << 16 | this.readU16();
    }

    public int readBits(int n) {
        while (this.bs < n) {
            this.b = this.b << 8 | this.data[this.p++] & 0xFF;
            this.bs += 8;
        }
        this.bs -= n;
        return this.b >>> this.bs & (1 << n) - 1;
    }

    public int nextBits(int n) {
        int oldP = this.p;
        int oldBS = this.bs;
        int oldB = this.b;
        int v = this.readBits(n);
        this.p = oldP;
        this.bs = oldBS;
        this.b = oldB;
        return v;
    }

    public static int ae() {
        return 0;
    }

    public int ue() {
        int leadZeros = -1;
        byte x = 0;
        while (x == 0) {
            x = this.readBit();
            ++leadZeros;
        }
        if (leadZeros > -1) {
            return (1 << leadZeros) - 1 + this.readBits(leadZeros);
        }
        return 0;
    }

    public int se() {
        int v = this.ue();
        if (v == 0) {
            return 0;
        }
        return (v & 1) == 0 ? -v / 2 : (v + 1) / 2;
    }

    public static boolean moreRbspData() {
        return false;
    }

    public static boolean moreRbspTrailingData() {
        return false;
    }

    public boolean byteAligned() {
        return this.bs == 0;
    }

    public boolean moreDataInByteStream() {
        return this.p < this.data.length;
    }
}

