/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.scale;

import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.JDeliImageSupport;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;

public class QualityThumbnail
extends JDeliImage {
    public static BufferedImage getScaledImage(BufferedImage sourceImage, int expectedWidth, int expectedHeight) {
        JDeliImageSupport.optimiseImage(sourceImage);
        int sw = sourceImage.getWidth();
        int sh = sourceImage.getHeight();
        ColorModel cm = sourceImage.getColorModel();
        int nComp = cm.getNumComponents();
        if (expectedWidth == sw && expectedHeight == sh) {
            return sourceImage;
        }
        if (expectedWidth > sw || expectedHeight > sw || cm instanceof IndexColorModel || sourceImage.getType() == 0) {
            return QualityThumbnail.getCubicScaled(sourceImage, expectedWidth, expectedHeight);
        }
        int[] pixels = QualityThumbnail.getPixels(sourceImage);
        pixels = QualityThumbnail.getLancsozPixels(pixels, sw, sh, expectedWidth, expectedHeight, nComp);
        return QualityThumbnail.getImageFromPixels(pixels, expectedWidth, expectedHeight, sourceImage.getType());
    }

    private static BufferedImage getImageFromPixels(int[] pixels, int dw, int dh, int type) {
        BufferedImage thumb = new BufferedImage(dw, dh, type);
        int dim = dw * dh;
        int p = 0;
        switch (type) {
            case 10: {
                byte[] data = ((DataBufferByte)thumb.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < dim; ++i) {
                    data[i] = (byte)pixels[i];
                }
                break;
            }
            case 5: {
                byte[] data = ((DataBufferByte)thumb.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < dim; ++i) {
                    int t = pixels[i];
                    data[p++] = (byte)(t & 0xFF);
                    data[p++] = (byte)(t >> 8 & 0xFF);
                    data[p++] = (byte)(t >> 16);
                }
                break;
            }
            case 6: 
            case 7: {
                byte[] data = ((DataBufferByte)thumb.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < dim; ++i) {
                    int t = pixels[i];
                    data[p++] = (byte)(t >> 24);
                    data[p++] = (byte)(t & 0xFF);
                    data[p++] = (byte)(t >> 8 & 0xFF);
                    data[p++] = (byte)(t >> 16 & 0xFF);
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                int[] results = ((DataBufferInt)thumb.getRaster().getDataBuffer()).getData();
                System.arraycopy(pixels, 0, results, 0, dim);
            }
        }
        return thumb;
    }

    private static int[] getPixels(BufferedImage source) {
        int iw = source.getWidth();
        int ih = source.getHeight();
        int dim = iw * ih;
        int[] results = new int[dim];
        int p = 0;
        switch (source.getType()) {
            case 10: {
                byte[] data = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < dim; ++i) {
                    results[i] = data[i] & 0xFF;
                }
                break;
            }
            case 5: {
                byte[] data = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < dim; ++i) {
                    int b = data[p++] & 0xFF;
                    int g = data[p++] & 0xFF;
                    int r = data[p++] & 0xFF;
                    results[i] = r << 16 | g << 8 | b;
                }
                break;
            }
            case 6: 
            case 7: {
                byte[] data = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < dim; ++i) {
                    int a = data[p++] & 0xFF;
                    int b = data[p++] & 0xFF;
                    int g = data[p++] & 0xFF;
                    int r = data[p++] & 0xFF;
                    results[i] = a << 24 | r << 16 | g << 8 | b;
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return ((DataBufferInt)source.getRaster().getDataBuffer()).getData();
            }
        }
        return results;
    }

    private static int[] getLancsozPixels(int[] pixels, int sw, int sh, int dw, int dh, int nComp) {
        int[] output;
        switch (nComp) {
            case 1: {
                output = QualityThumbnail.set1Comp(pixels, sw, sh, dw, dh);
                break;
            }
            case 3: {
                output = QualityThumbnail.set3Comp(pixels, sw, sh, dw, dh);
                break;
            }
            case 4: {
                output = QualityThumbnail.set4Comp(pixels, sw, sh, dw, dh);
                break;
            }
            default: {
                output = new int[dw * dh];
            }
        }
        return output;
    }

    private static int[] set4Comp(int[] pixels, int sw, int sh, int dw, int dh) {
        double scaleX = (double)dw * 1.0 / (double)sw;
        double scaleY = (double)dh * 1.0 / (double)sh;
        WeightsBox wBox = QualityThumbnail.generateWeightsBox(Math.min(scaleX, scaleY));
        float sumW = wBox.sum;
        int sw2m = (sw << 1) - 1;
        int sh2m = (sh << 1) - 1;
        int[] output = new int[dw * dh];
        int pos = 0;
        for (int dy = 0; dy < dh; ++dy) {
            int bsy = (int)((double)dy / scaleY);
            for (int dx = 0; dx < dw; ++dx) {
                float dr = 0.0f;
                float db = 0.0f;
                float dg = 0.0f;
                float da = 0.0f;
                int bsx = (int)((double)dx / scaleX);
                for (Weight weight : wBox.weights) {
                    int rgb = QualityThumbnail.getLP(pixels, bsx + weight.x, bsy + weight.y, sw, sh, sw2m, sh2m);
                    da += (float)(rgb >>> 24) * weight.g;
                    dr += (float)(rgb >> 16 & 0xFF) * weight.g;
                    dg += (float)(rgb >> 8 & 0xFF) * weight.g;
                    db += (float)(rgb & 0xFF) * weight.g;
                }
                output[pos++] = QualityThumbnail.getLC(da, sumW) << 24 | QualityThumbnail.getLC(dr, sumW) << 16 | QualityThumbnail.getLC(dg, sumW) << 8 | QualityThumbnail.getLC(db, sumW);
            }
        }
        return output;
    }

    private static int[] set3Comp(int[] pixels, int sw, int sh, int dw, int dh) {
        int[] output = new int[dw * dh];
        double scaleX = (double)dw * 1.0 / (double)sw;
        double scaleY = (double)dh * 1.0 / (double)sh;
        WeightsBox wBox = QualityThumbnail.generateWeightsBox(Math.min(scaleX, scaleY));
        float sumW = wBox.sum;
        int sw2m = (sw << 1) - 1;
        int sh2m = (sh << 1) - 1;
        int pos = 0;
        for (int dy = 0; dy < dh; ++dy) {
            int bsy = (int)((double)dy / scaleY);
            for (int dx = 0; dx < dw; ++dx) {
                float dr = 0.0f;
                float db = 0.0f;
                float dg = 0.0f;
                int bsx = (int)((double)dx / scaleX);
                for (Weight weight : wBox.weights) {
                    int rgb = QualityThumbnail.getLP(pixels, bsx + weight.x, bsy + weight.y, sw, sh, sw2m, sh2m);
                    dr += (float)(rgb >> 16) * weight.g;
                    dg += (float)(rgb >> 8 & 0xFF) * weight.g;
                    db += (float)(rgb & 0xFF) * weight.g;
                }
                output[pos++] = QualityThumbnail.getLC(dr, sumW) << 16 | QualityThumbnail.getLC(dg, sumW) << 8 | QualityThumbnail.getLC(db, sumW);
            }
        }
        return output;
    }

    private static int[] set1Comp(int[] pixels, int sw, int sh, int dw, int dh) {
        double scaleX = (double)dw * 1.0 / (double)sw;
        double scaleY = (double)dh * 1.0 / (double)sh;
        WeightsBox wBox = QualityThumbnail.generateWeightsBox(Math.min(scaleX, scaleY));
        float sumW = wBox.sum;
        int sw2m = (sw << 1) - 1;
        int sh2m = (sh << 1) - 1;
        int[] output = new int[dw * dh];
        int pos = 0;
        for (int dy = 0; dy < dh; ++dy) {
            int bsy = (int)((double)dy / scaleY);
            for (int dx = 0; dx < dw; ++dx) {
                float db = 0.0f;
                int bsx = (int)((double)dx / scaleX);
                for (Weight weight : wBox.weights) {
                    int rgb = QualityThumbnail.getLP(pixels, bsx + weight.x, bsy + weight.y, sw, sh, sw2m, sh2m);
                    db += (float)(rgb & 0xFF) * weight.g;
                }
                output[pos++] = QualityThumbnail.getLC(db, sumW);
            }
        }
        return output;
    }

    private static BufferedImage getCubicScaled(BufferedImage image, int width, int height) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        double scaleX = (double)width / (double)imageWidth;
        double scaleY = (double)height / (double)imageHeight;
        AffineTransform scaleTransform = AffineTransform.getScaleInstance(scaleX, scaleY);
        AffineTransformOp scaleOP = new AffineTransformOp(scaleTransform, 3);
        return scaleOP.filter(image, new BufferedImage(width, height, image.getType()));
    }

    private static double filterLancsoz(double x) {
        if (x == 0.0) {
            return 1.0;
        }
        if (Math.abs(x) >= 3.0) {
            return 0.0;
        }
        double piX = Math.PI * x;
        return Math.sin(piX) / Math.PI / x * (Math.sin(piX / 3.0) / Math.PI / x * 3.0);
    }

    private static int getLP(int[] image, int x, int y, int w, int h, int w2, int h2) {
        if (x < 0) {
            x = -x;
        }
        if (y < 0) {
            y = -y;
        }
        if (x >= w) {
            x = w2 - x;
        }
        if (y >= h) {
            y = h2 - y;
        }
        return image[y * w + x];
    }

    private static int getLC(float val, float sumw) {
        if (sumw != 0.0f) {
            val /= sumw;
        }
        return val < 0.0f ? 0 : (val > 255.0f ? 255 : (int)val);
    }

    private static WeightsBox generateWeightsBox(double scale) {
        double bdx0 = 0.5;
        double bdy0 = 0.5;
        int ss = (int)(-2.5 / scale);
        int se = (int)(3.5 / scale);
        float sumw = 0.0f;
        int gap = se - ss;
        ArrayList<Weight> weightList = new ArrayList<Weight>(gap * gap);
        for (int sy = ss; sy <= se; ++sy) {
            double y1 = ((double)sy + 0.5) * scale - 0.5;
            double y2 = y1 * y1;
            for (int sx = ss; sx <= se; ++sx) {
                double xl = ((double)sx + 0.5) * scale - 0.5;
                float w = (float)QualityThumbnail.filterLancsoz(Math.sqrt(xl * xl + y2));
                if (w == 0.0f) continue;
                weightList.add(new Weight(sx, sy, w));
                sumw += w;
            }
        }
        return new WeightsBox(sumw, weightList.toArray(new Weight[0]));
    }

    static class WeightsBox {
        final float sum;
        final Weight[] weights;

        WeightsBox(float sum, Weight[] weights) {
            this.sum = sum;
            this.weights = weights;
        }
    }

    static class Weight {
        final int x;
        final int y;
        final float g;

        Weight(int x, int y, float w) {
            this.x = x;
            this.y = y;
            this.g = w;
        }
    }
}

