/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000.data;

import com.idrsolutions.image.jpeg2000.data.CodeBlock;
import com.idrsolutions.image.jpeg2000.data.EntropyEncoder;
import com.idrsolutions.image.jpeg2000.data.Info;
import com.idrsolutions.image.jpeg2000.data.TileBand;
import java.util.Arrays;

public class Tier1Encoder {
    private final int cbw;
    private final int cbh;
    private final EntropyEncoder encoder;
    private final CodeBlock cb;
    private int maxMag;
    private final int mb;
    private final int[] magnArr;
    private final byte[] signArr;
    private final byte[] aArr;
    private final byte[] a_Arr;
    private final byte[] nArr;
    private final byte[] vArr;
    private int dd;
    private int h0;
    private int h1;
    private int v0;
    private int v1;
    private int sh0;
    private int sh1;
    private int sv0;
    private int sv1;
    private boolean pnh;
    private int znh;
    private static final byte[] CXLLHH = new byte[]{0, 1, 1, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final byte[] CXHL = new byte[]{0, 1, 1, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final byte[] CXHH = new byte[]{0, 3, 3, 6, 3, 6, 6, 8, 3, 6, 6, 8, 6, 8, 8, 8, 1, 4, 4, 7, 4, 7, 7, 8, 4, 7, 7, 8, 7, 8, 8, 8, 1, 4, 4, 7, 4, 7, 7, 8, 4, 7, 7, 8, 7, 8, 8, 8, 2, 5, 5, 7, 5, 7, 7, 8, 5, 7, 7, 8, 7, 8, 8, 8, 1, 4, 4, 7, 4, 7, 7, 8, 4, 7, 7, 8, 7, 8, 8, 8, 2, 5, 5, 7, 5, 7, 7, 8, 5, 7, 7, 8, 7, 8, 8, 8, 2, 5, 5, 7, 5, 7, 7, 8, 5, 7, 7, 8, 7, 8, 8, 8, 2, 5, 5, 7, 5, 7, 7, 8, 5, 7, 7, 8, 7, 8, 8, 8, 1, 4, 4, 7, 4, 7, 7, 8, 4, 7, 7, 8, 7, 8, 8, 8, 2, 5, 5, 7, 5, 7, 7, 8, 5, 7, 7, 8, 7, 8, 8, 8, 2, 5, 5, 7, 5, 7, 7, 8, 5, 7, 7, 8, 7, 8, 8, 8, 2, 5, 5, 7, 5, 7, 7, 8, 5, 7, 7, 8, 7, 8, 8, 8, 2, 5, 5, 7, 5, 7, 7, 8, 5, 7, 7, 8, 7, 8, 8, 8, 2, 5, 5, 7, 5, 7, 7, 8, 5, 7, 7, 8, 7, 8, 8, 8, 2, 5, 5, 7, 5, 7, 7, 8, 5, 7, 7, 8, 7, 8, 8, 8, 2, 5, 5, 7, 5, 7, 7, 8, 5, 7, 7, 8, 7, 8, 8, 8};
    private static final int[] CXSIGN = new int[]{9, 10, 10, 0, 12, 13, 11, 0, 12, 11, 13};
    private final byte[] zeroTable;

    public Tier1Encoder(Info info, TileBand tb, CodeBlock cb) {
        this.encoder = info.entropy;
        this.encoder.init();
        this.mb = info.qcd.guardBits + tb.eb - 1;
        this.cb = cb;
        this.cbw = cb.tbx1_ - cb.tbx0_;
        this.cbh = cb.tby1_ - cb.tby0_;
        Arrays.fill(info.signArray, (byte)0);
        Arrays.fill(info.curFlagArray, (byte)0);
        Arrays.fill(info.a_Array, (byte)0);
        Arrays.fill(info.nbrArray, (byte)0);
        this.magnArr = info.magnArray;
        this.signArr = info.signArray;
        this.aArr = info.curFlagArray;
        this.a_Arr = info.a_Array;
        this.nArr = info.nbrArray;
        this.vArr = info.bitsDecArray;
        int pos = 0;
        int tbw = tb.x1 - tb.x0;
        float[] subbandData = tb.floats;
        for (int y = cb.tby0_; y < cb.tby1_; ++y) {
            for (int x = cb.tbx0_; x < cb.tbx1_; ++x) {
                int mn = (int)subbandData[y * tbw + x];
                if (mn < 0) {
                    this.signArr[pos] = 1;
                    mn = -mn;
                }
                this.maxMag = mn > this.maxMag ? mn : this.maxMag;
                this.magnArr[pos] = mn;
                ++pos;
            }
        }
        switch (tb.type) {
            case 3: {
                this.zeroTable = CXHH;
                break;
            }
            case 2: {
                this.zeroTable = CXHL;
                break;
            }
            default: {
                this.zeroTable = CXLLHH;
            }
        }
    }

    public void encode() {
        int nBP = 0;
        for (int t = this.maxMag; t > 0; t >>= 1) {
            ++nBP;
        }
        this.cb.zeroBitPlanes = this.mb - nBP;
        int p = nBP - 1;
        int nPasses = 0;
        this.updateV(p);
        while (true) {
            ++nPasses;
            this.cup();
            if (p <= 0) break;
            Arrays.fill(this.nArr, (byte)0);
            this.updateV(--p);
            nPasses += 2;
            this.spp();
            this.mrp();
        }
        this.cb.block.data = this.encoder.getEncodedData();
        this.cb.block.nCodingPass = (byte)nPasses;
    }

    private void updateV(int p) {
        int len = this.vArr.length;
        for (int i = 0; i < len; ++i) {
            this.vArr[i] = (byte)(this.magnArr[i] >> p & 1);
        }
    }

    private void callCXD(int cx, int d) {
        this.encoder.encode(cx, d);
    }

    private void cup() {
        int nextBit = 0;
        int h = this.cbh;
        int w = this.cbw;
        int w2 = this.cbw * 2;
        int w3 = this.cbw * 3;
        while (nextBit < h) {
            int i0 = nextBit;
            nextBit = Math.min(i0 + 4, h);
            boolean has4 = i0 + 3 < h;
            for (int j = 0; j < w; ++j) {
                int i1 = 0;
                int mn = i0 * w + j;
                int mn3 = mn + w3;
                if (this.aArr[mn] == 0 && this.nArr[mn] == 0 && has4 && this.canRLC(i0, j, mn, mn3)) {
                    byte r0 = this.vArr[mn];
                    byte r1 = this.vArr[mn + w];
                    byte r2 = this.vArr[mn + w2];
                    byte r3 = this.vArr[mn3];
                    int v = r0 << 3 | r1 << 2 | r2 << 1 | r3;
                    if (v == 0) {
                        this.callCXD(17, 0);
                        continue;
                    }
                    i1 = this.getI1(i0, j, mn, i0, i1, v);
                }
                for (int i = i0 + i1; i < nextBit; ++i) {
                    mn = i * w + j;
                    if (this.aArr[mn] != 0 || this.nArr[mn] != 0) continue;
                    this.updateNeighbours(i, j, mn);
                    byte d = this.vArr[mn];
                    this.callCXD(this.zeroTable[this.znh], d);
                    if (d != 1) continue;
                    this.signCoding(mn);
                    this.aArr[mn] = 1;
                }
            }
        }
    }

    private int getI1(int i, int j, int mn, int i0, int i1, int v) {
        this.callCXD(17, 1);
        while (i1 < 4 && (v >> 3 - i1 & 1) != 1) {
            ++i1;
        }
        int d = i1 >> 1 & 1;
        this.callCXD(18, d);
        d = i1 & 1;
        this.callCXD(18, d);
        if (i1 != 0) {
            i = i0 + i1;
            mn += i1 * this.cbw;
        }
        if ((d = this.vArr[mn]) == 1) {
            this.updateNeighbours(i, j, mn);
            this.signCoding(mn);
            this.aArr[mn] = 1;
        }
        return ++i1;
    }

    private boolean canRLC(int i, int j, int mn, int mn3) {
        this.updateNeighbours(i, j, mn);
        if (this.pnh) {
            return false;
        }
        this.updateNeighbours(i + 3, j, mn3);
        return this.aArr[mn3] == 0 && !this.pnh;
    }

    private void spp() {
        for (int i0 = 0; i0 < this.cbh; i0 += 4) {
            for (int j = 0; j < this.cbw; ++j) {
                int i;
                int mn = i0 * this.cbw + j;
                for (int i1 = 0; i1 < 4 && (i = i0 + i1) < this.cbh; ++i1) {
                    this.updateNeighbours(i, j, mn);
                    if (this.pnh && this.aArr[mn] == 0) {
                        byte cxLabel = this.zeroTable[this.znh];
                        byte d = this.vArr[mn];
                        this.callCXD(cxLabel, d);
                        this.nArr[mn] = 1;
                        if (d == 1) {
                            this.signCoding(mn);
                            this.aArr[mn] = 1;
                        }
                    }
                    mn += this.cbw;
                }
            }
        }
    }

    private void mrp() {
        for (int i0 = 0; i0 < this.cbh; i0 += 4) {
            for (int j = 0; j < this.cbw; ++j) {
                int i;
                int mn = i0 * this.cbw + j;
                for (int i1 = 0; i1 < 4 && (i = i0 + i1) < this.cbh; ++i1) {
                    if (this.aArr[mn] == 1 && this.nArr[mn] == 0) {
                        int cxLabel;
                        byte d = this.vArr[mn];
                        if (this.a_Arr[mn] == 1) {
                            cxLabel = 16;
                        } else {
                            this.updateNeighbours(i, j, mn);
                            cxLabel = this.pnh ? 15 : 14;
                        }
                        this.callCXD(cxLabel, d);
                        this.a_Arr[mn] = 1;
                    }
                    mn += this.cbw;
                }
            }
        }
    }

    private void signCoding(int mn) {
        int h = this.h0 * (1 - 2 * this.sh0) + this.h1 * (1 - 2 * this.sh1);
        h = h < 0 ? 2 : (h > 1 ? 1 : h);
        int v = this.v0 * (1 - 2 * this.sv0) + this.v1 * (1 - 2 * this.sv1);
        v = v < 0 ? 2 : (v > 1 ? 1 : v);
        int hv = h << 2 | v;
        byte xorB = h == 2 || hv == 2 ? (byte)1 : 0;
        int cxLabel = CXSIGN[hv];
        int d = xorB ^ this.signArr[mn];
        this.callCXD(cxLabel, d);
    }

    private void updateNeighbours(int m, int n, int mn) {
        int i;
        boolean right;
        this.dd = 0;
        this.h0 = 0;
        this.h1 = 0;
        this.v0 = 0;
        this.v1 = 0;
        this.sh0 = 0;
        this.sh1 = 0;
        this.sv0 = 0;
        this.sv1 = 0;
        boolean left = n > 0;
        boolean bl = right = n + 1 < this.cbw;
        if (m > 0) {
            i = mn - this.cbw;
            if (left) {
                this.dd = this.aArr[i - 1] << 3;
            }
            if (right) {
                this.dd |= this.aArr[i + 1] << 2;
            }
            this.sv0 = this.signArr[i];
            this.v0 = this.aArr[i];
        }
        if (m + 1 < this.cbh) {
            i = mn + this.cbw;
            if (left) {
                this.dd |= this.aArr[i - 1] << 1;
            }
            if (right) {
                this.dd |= this.aArr[i + 1];
            }
            this.sv1 = this.signArr[i];
            this.v1 = this.aArr[i];
        }
        if (left) {
            this.h0 = this.aArr[mn - 1];
            this.sh0 = this.signArr[mn - 1];
        }
        if (right) {
            this.h1 = this.aArr[mn + 1];
            this.sh1 = this.signArr[mn + 1];
        }
        this.znh = this.h0 << 7 | this.h1 << 6 | this.v0 << 5 | this.v1 << 4 | this.dd;
        this.pnh = this.znh > 0;
    }
}

