/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg.data;

import com.idrsolutions.image.jpeg.JpegDecoder;
import com.idrsolutions.image.jpeg.data.Component;
import com.idrsolutions.image.jpeg.data.Frame;
import com.idrsolutions.image.jpeg.data.HTree;
import java.util.List;

public class JpegScanner {
    private static final int DCFIRST = 0;
    private static final int DCSUCCESSIVE = 1;
    private static final int ACFIRST = 2;
    private static final int ACSUCCESSIVE = 3;
    private static final int BASELINE = 4;
    private final byte[] data;
    private int bitPos;
    private int bitBuffer;
    private int eobrun;
    private int mcusX;
    private int offset;
    private int successive;
    private int sStart;
    private int sEnd;
    private int stateAC;
    private int stateNextAC;

    public JpegScanner(byte[] data) {
        this.data = data;
    }

    public int decodeScan(int off, Frame frame, List<Component> components, int resetInterval, int sStart, int sEnd, int sPrev, int successive) {
        this.mcusX = frame.mcusX;
        this.offset = off;
        this.successive = successive;
        this.sStart = sStart;
        this.sEnd = sEnd;
        int componentsLength = components.size();
        int decodeFn = JpegScanner.getDecodeFn(frame, sStart, sPrev);
        int mcu = 0;
        int mcuExpected = componentsLength == 1 ? components.get((int)0).blocksX * components.get((int)0).blocksY : this.mcusX * frame.mcusY;
        while (mcu < mcuExpected) {
            int nc = resetInterval != 0 ? Math.min(mcuExpected - mcu, resetInterval) : mcuExpected;
            for (int i = 0; i < componentsLength; ++i) {
                components.get((int)i).pred = 0;
            }
            this.eobrun = 0;
            mcu = componentsLength == 1 ? this.setSingleComponent(components, decodeFn, mcu, nc) : this.setMultiComponent(components, componentsLength, decodeFn, mcu, nc);
            if (this.offset + 2 >= this.data.length) break;
            this.bitPos = 0;
            int[] markAndOff = new int[]{0, this.offset};
            JpegScanner.findNextFileMarker(this.data, markAndOff);
            int marker = markAndOff[0];
            this.offset = markAndOff[1];
            if (marker <= 65280) {
                return this.offset;
            }
            if (marker < 65488 || marker > 65495) break;
            this.offset += 2;
        }
        return this.offset;
    }

    private static void findNextFileMarker(byte[] data, int[] markAndOff) {
        int pos = markAndOff[1];
        int currentMarker = (data[pos] & 0xFF) << 8 | data[pos + 1] & 0xFF;
        if (currentMarker >= 65472 && currentMarker <= 65534) {
            markAndOff[0] = currentMarker;
            return;
        }
        int newMarker = (data[pos] & 0xFF) << 8 | data[pos + 1] & 0xFF;
        while (newMarker < 65472 || newMarker > 65534) {
            if (++pos >= data.length - 1) {
                markAndOff[1] = pos;
                return;
            }
            newMarker = (data[pos] & 0xFF) << 8 | data[pos + 1] & 0xFF;
        }
        markAndOff[0] = newMarker;
        markAndOff[1] = pos;
    }

    private static int getDecodeFn(Frame frame, int sStart, int sPrev) {
        int decodeFn = frame.progressive ? (sStart == 0 ? (sPrev == 0 ? 0 : 1) : (sPrev == 0 ? 2 : 3)) : 4;
        return decodeFn;
    }

    private int setSingleComponent(List<Component> components, int decodeFn, int mcu, int nc) {
        Component component = components.get(0);
        for (int n = 0; n < nc; ++n) {
            this.decodeBlock(component, decodeFn, mcu);
            ++mcu;
        }
        return mcu;
    }

    private int setMultiComponent(List<Component> components, int componentsLength, int decodeFn, int mcu, int nc) {
        for (int n = 0; n < nc; ++n) {
            for (int i = 0; i < componentsLength; ++i) {
                Component component = components.get(i);
                int h = component.h;
                int v = component.v;
                for (int j = 0; j < v; ++j) {
                    for (int k = 0; k < h; ++k) {
                        this.decodeMcu(component, decodeFn, mcu, j, k);
                    }
                }
            }
            ++mcu;
        }
        return mcu;
    }

    private int findHuffmanValue(HTree tree) {
        HTree t = tree;
        do {
            t = t.nodes[this.readBit()];
        } while (!t.isEnd);
        return t.value;
    }

    private int readBit() {
        if (this.bitPos > 0) {
            --this.bitPos;
            return this.bitBuffer >> this.bitPos & 1;
        }
        this.bitBuffer = this.data[this.offset++] & 0xFF;
        if (this.bitBuffer == 255) {
            ++this.offset;
        }
        this.bitPos = 7;
        return this.bitBuffer >>> 7;
    }

    private int getNext(int length) {
        int n = 0;
        while (length > 0) {
            n = n << 1 | this.readBit();
            --length;
        }
        return n;
    }

    private int getNextFull(int length) {
        if (length == 1) {
            return this.readBit() == 1 ? 1 : -1;
        }
        int n = this.getNext(length);
        if (n >= 1 << length - 1) {
            return n;
        }
        return n + (-1 << length) + 1;
    }

    private void decodeMcu(Component component, int decodeFn, int mcu, int row, int col) {
        int mcuRow = mcu / this.mcusX;
        int mcuCol = mcu % this.mcusX;
        int blockRow = mcuRow * component.v + row;
        int blockCol = mcuCol * component.h + col;
        int offsetD = JpegScanner.getCodeBlockOffset(component, blockRow, blockCol);
        this.decodeOrdering(component, offsetD, decodeFn);
    }

    private void decodeBlock(Component component, int decodeFn, int mcu) {
        int blockRow = mcu / component.blocksX;
        int blockCol = mcu % component.blocksX;
        int offsetD = JpegScanner.getCodeBlockOffset(component, blockRow, blockCol);
        this.decodeOrdering(component, offsetD, decodeFn);
    }

    private void decodeOrdering(Component component, int offset, int decodeFn) {
        switch (decodeFn) {
            case 0: {
                int e = this.findHuffmanValue(component.huffmanTableDC);
                int diff = e == 0 ? 0 : this.getNextFull(e) << this.successive;
                component.codeBlock[offset] = (short)(component.pred += diff);
                break;
            }
            case 1: {
                int n = offset;
                component.codeBlock[n] = (short)(component.codeBlock[n] | this.readBit() << this.successive);
                break;
            }
            case 2: {
                if (this.eobrun > 0) {
                    --this.eobrun;
                    break;
                }
                this.handleACFirst(component, offset);
                break;
            }
            case 3: {
                this.handleACSuccessive(component, offset);
                break;
            }
            case 4: {
                this.handleBaseline(component, offset);
            }
        }
    }

    private void handleACSuccessive(Component component, int offset1) {
        int a = this.sStart;
        int b = this.sEnd;
        int c = 0;
        block6: while (a <= b) {
            byte z = JpegDecoder.ZIGZAGORDER[a];
            switch (this.stateAC) {
                case 0: {
                    int f = this.findHuffmanValue(component.huffmanTableAC);
                    int d = f & 0xF;
                    c = f >> 4;
                    if (d == 0) {
                        if (c < 15) {
                            this.eobrun = this.getNext(c) + (1 << c);
                            this.stateAC = 4;
                            continue block6;
                        }
                        c = 16;
                        this.stateAC = 1;
                        continue block6;
                    }
                    if (d != 1) {
                        // empty if block
                    }
                    this.stateNextAC = this.getNextFull(d);
                    this.stateAC = c != 0 ? 2 : 3;
                    continue block6;
                }
                case 1: 
                case 2: {
                    if (component.codeBlock[offset1 + z] != 0) {
                        int n = offset1 + z;
                        component.codeBlock[n] = (short)(component.codeBlock[n] + (this.readBit() << this.successive));
                        break;
                    }
                    if (--c != 0) break;
                    this.stateAC = this.stateAC == 2 ? 3 : 0;
                    break;
                }
                case 3: {
                    if (component.codeBlock[offset1 + z] != 0) {
                        int n = offset1 + z;
                        component.codeBlock[n] = (short)(component.codeBlock[n] + (this.readBit() << this.successive));
                        break;
                    }
                    component.codeBlock[offset1 + z] = (short)(this.stateNextAC << this.successive);
                    this.stateAC = 0;
                    break;
                }
                case 4: {
                    if (component.codeBlock[offset1 + z] == 0) break;
                    int n = offset1 + z;
                    component.codeBlock[n] = (short)(component.codeBlock[n] + (this.readBit() << this.successive));
                }
            }
            ++a;
        }
        if (this.stateAC == 4) {
            --this.eobrun;
            if (this.eobrun == 0) {
                this.stateAC = 0;
            }
        }
    }

    private void handleBaseline(Component component, int offset1) {
        int a = 1;
        int e = this.findHuffmanValue(component.huffmanTableDC);
        int diff = e == 0 ? 0 : this.getNextFull(e);
        component.codeBlock[offset1] = (short)(component.pred += diff);
        while (a < 64) {
            int f = this.findHuffmanValue(component.huffmanTableAC);
            int d = f & 0xF;
            int c = f >> 4;
            if (d == 0) {
                if (c < 15) break;
                a += 16;
                continue;
            }
            byte z = JpegDecoder.ZIGZAGORDER[a += c];
            component.codeBlock[offset1 + z] = (short)this.getNextFull(d);
            ++a;
        }
    }

    private void handleACFirst(Component component, int offset1) {
        int a = this.sStart;
        int b = this.sEnd;
        while (a <= b) {
            int f = this.findHuffmanValue(component.huffmanTableAC);
            int d = f & 0xF;
            int c = f >> 4;
            if (d == 0) {
                if (c < 15) {
                    this.eobrun = this.getNext(c) + (1 << c) - 1;
                    break;
                }
                a += 16;
                continue;
            }
            byte z = JpegDecoder.ZIGZAGORDER[a += c];
            component.codeBlock[offset1 + z] = (short)(this.getNextFull(d) * (1 << this.successive));
            ++a;
        }
    }

    public static int getCodeBlockOffset(Component component, int row, int col) {
        return 64 * ((component.blocksX + 1) * row + col);
    }
}

