/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.ico;

import com.idrsolutions.image.Decoder;
import com.idrsolutions.image.ImageFormat;
import com.idrsolutions.image.JDeliImageSupport;
import com.idrsolutions.image.bmp.BmpDecoder;
import com.idrsolutions.image.png.PngDecoder;
import com.idrsolutions.image.utility.DataByteLittle;
import com.idrsolutions.image.utility.DataFileLittle;
import com.idrsolutions.image.utility.DataReader;
import com.idrsolutions.image.utility.IcoInfo;
import com.idrsolutions.image.utility.ImageTypeFinder;
import com.idrsolutions.image.utility.WriterByteLittle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class IcoDecoder
implements Decoder {
    @Override
    public BufferedImage read(byte[] icoData) throws Exception {
        DataByteLittle reader = new DataByteLittle(icoData);
        List<IcoInfo> infos = IcoDecoder.grabIcoInfos(reader);
        BufferedImage img = IcoDecoder.grabImage(infos.get(0), reader);
        reader.close();
        return JDeliImageSupport.optimiseImage(img);
    }

    @Override
    public BufferedImage read(File icoFile) throws Exception {
        DataFileLittle reader = new DataFileLittle(icoFile);
        List<IcoInfo> infos = IcoDecoder.grabIcoInfos(reader);
        BufferedImage img = IcoDecoder.grabImage(infos.get(0), reader);
        reader.close();
        return JDeliImageSupport.optimiseImage(img);
    }

    private static List<IcoInfo> grabIcoInfos(DataReader reader) throws IOException {
        boolean valid;
        int reserved = reader.getU16();
        int type = reader.getU16();
        boolean bl = valid = reserved == 0 && (type == 1 || type == 2);
        if (!valid) {
            throw new IOException("Not a valid ICO image");
        }
        int imageCount = reader.getU16();
        ArrayList<IcoInfo> infoList = new ArrayList<IcoInfo>();
        for (int i = 0; i < imageCount; ++i) {
            IcoInfo info = new IcoInfo();
            info.iw = reader.getU8();
            info.ih = reader.getU8();
            info.nPalColor = reader.getU8();
            reader.skip(1);
            info.colorPlanes = reader.getU16();
            info.bpp = reader.getU16();
            info.dataLen = reader.getU32();
            info.offset = reader.getU32();
            infoList.add(info);
        }
        return infoList;
    }

    private static BufferedImage grabImage(IcoInfo info, DataReader reader) throws Exception {
        reader.moveTo(info.offset);
        byte[] imgData = new byte[info.dataLen];
        ImageFormat type = ImageTypeFinder.getImageType(imgData);
        if (type == ImageFormat.PNG_IMAGE) {
            PngDecoder decoder = new PngDecoder();
            return decoder.read(imgData);
        }
        BmpDecoder decoder = new BmpDecoder();
        byte[] bmpData = new byte[imgData.length + 14];
        WriterByteLittle buffer = new WriterByteLittle(bmpData);
        buffer.putU8(66);
        buffer.putU8(77);
        buffer.putU32(bmpData.length);
        buffer.putU32(0);
        buffer.putU32(54);
        int position = buffer.getPosition();
        buffer.write(imgData);
        buffer.seek(position);
        buffer.putU32(40);
        buffer.putU32(info.iw == 0 ? 256 : info.iw);
        buffer.putU32(info.ih == 0 ? 256 : info.ih);
        buffer.putU16(info.colorPlanes);
        buffer.putU16(info.bpp);
        if (info.nPalColor != 0) {
            position = buffer.getPosition() + 16;
            buffer.seek(position);
            buffer.putU32(info.nPalColor);
        }
        return decoder.read(bmpData);
    }

    static {
        String imageLib2ClassPath = "com/idrsolutions/image/JDeliImageSupport.class";
        ClassLoader loader = IcoDecoder.class.getClassLoader();
        if (loader.getResource("com/idrsolutions/image/JDeliImageSupport.class") != null) {
            try {
                loader.loadClass("com.idrsolutions.image.JDeliImageSupport").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                System.out.println("Unable to instance JDeli " + ex);
            }
        }
    }
}

