/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heif.data;

import com.idrsolutions.image.heif.data.D;
import com.idrsolutions.image.heif.data.Pps;
import com.idrsolutions.image.heif.data.PredWeightTable;
import com.idrsolutions.image.heif.data.RefPicListMod;
import com.idrsolutions.image.heif.data.Sps;
import com.idrsolutions.image.heif.data.StRefPic;
import com.idrsolutions.image.utility.BitReader;

class Ssh {
    private final byte first_slice_segment_in_pic_flag;
    private byte no_output_of_prior_pics_flag;
    private final int slice_pic_parameter_set_id;
    private byte dependent_slice_segment_flag;
    private int slice_segment_address;
    int slice_type;
    int num_ref_idx_l0_active_minus1;
    int num_ref_idx_l1_active_minus1;
    private byte pic_output_flag;
    private int colour_plane_id;
    private int slice_pic_order_cnt_lsb;
    private byte short_term_ref_pic_set_sps_flag;
    private int short_term_ref_pic_set_idx;
    private int num_long_term_sps;
    private int num_long_term_pics;
    private int[] lt_idx_sps;
    private int[] poc_lsb_lt;
    private byte[] used_by_curr_pic_lt_flag;
    private byte[] delta_poc_msb_present_flag;
    private int[] delta_poc_msb_cycle_lt;
    private byte slice_temporal_mvp_enabled_flag;
    byte slice_sao_luma_flag;
    byte slice_sao_chroma_flag;
    private byte num_ref_idx_active_override_flag;
    private byte mvd_l1_zero_flag;
    private byte cabac_init_flag;
    private byte collocated_from_l0_flag;
    private int collocated_ref_idx;
    private PredWeightTable predWeightTable;
    private int five_minus_max_num_merge_cand;
    private byte use_integer_mv_flag;
    private int slice_qp_delta;
    private int slice_cb_qp_offset;
    private int slice_cr_qp_offset;
    int cu_chroma_qp_offset_enabled_flag;
    private int slice_act_y_qp_offset;
    private int slice_act_cb_qp_offset;
    private int slice_act_cr_qp_offset;
    private RefPicListMod refPicListMod;
    private StRefPic st_ref_pic_set;
    private byte deblocking_filter_override_flag;
    private byte slice_deblocking_filter_disabled_flag;
    private int slice_beta_offset_div2;
    private int slice_tc_offset_div2;
    private byte slice_loop_filter_across_slices_enabled_flag;
    private int num_entry_point_offsets;
    private int offset_len_minus1;
    private int slice_segment_header_extension_length;
    private int[] slice_segment_header_extension_data_byte;

    public Ssh(BitReader reader, int nalUnitType, int nuh_layer_id, Pps pps, Sps sps, D d) {
        int i;
        int len;
        this.first_slice_segment_in_pic_flag = reader.readBit();
        if (nalUnitType >= 16 && nalUnitType <= 23) {
            this.no_output_of_prior_pics_flag = reader.readBit();
        }
        this.slice_pic_parameter_set_id = reader.ue();
        if (this.first_slice_segment_in_pic_flag == 0) {
            if (pps.dependent_slice_segments_enabled_flag != 0) {
                this.dependent_slice_segment_flag = reader.readBit();
            }
            len = (int)Math.ceil(Math.log(d.picSizeInCtbsY));
            this.slice_segment_address = reader.readBits(len);
        }
        if (this.dependent_slice_segment_flag == 0) {
            for (i = 0; i < pps.num_extra_slice_header_bits; ++i) {
                reader.readBit();
            }
            this.slice_type = reader.ue();
            if (pps.output_flag_present_flag != 0) {
                this.pic_output_flag = reader.readBit();
            }
            if (sps.separate_colour_plane_flag == 1) {
                this.colour_plane_id = reader.readBits(2);
            }
            if (nalUnitType != 19 && nalUnitType != 20) {
                this.slice_pic_order_cnt_lsb = reader.readBits(sps.log2_max_pic_order_cnt_lsb_minus4 + 4);
                this.short_term_ref_pic_set_sps_flag = reader.readBit();
                if (this.short_term_ref_pic_set_sps_flag == 0) {
                    this.st_ref_pic_set = new StRefPic(reader, this.slice_type, sps.num_short_term_ref_pic_sets, d);
                } else if (sps.num_short_term_ref_pic_sets > 1) {
                    len = (int)Math.ceil(Math.log(sps.num_short_term_ref_pic_sets));
                    this.short_term_ref_pic_set_idx = reader.readBits(len);
                }
                if (sps.long_term_ref_pics_present_flag != 0) {
                    if (sps.num_long_term_ref_pics_sps > 0) {
                        this.num_long_term_sps = reader.ue();
                    }
                    this.num_long_term_pics = reader.ue();
                    int ii = this.num_long_term_sps + this.num_long_term_pics;
                    this.lt_idx_sps = new int[ii];
                    this.poc_lsb_lt = new int[ii];
                    this.used_by_curr_pic_lt_flag = new byte[ii];
                    this.delta_poc_msb_present_flag = new byte[ii];
                    this.delta_poc_msb_cycle_lt = new int[ii];
                    for (int i2 = 0; i2 < ii; ++i2) {
                        if (i2 < this.num_long_term_sps) {
                            if (sps.num_long_term_ref_pics_sps > 1) {
                                int len2 = (int)Math.ceil(Math.log(sps.num_long_term_ref_pics_sps));
                                this.lt_idx_sps[i2] = reader.readBits(len2);
                            }
                        } else {
                            this.poc_lsb_lt[i2] = reader.readBits(sps.log2_max_pic_order_cnt_lsb_minus4 + 4);
                            this.used_by_curr_pic_lt_flag[i2] = reader.readBit();
                        }
                        this.delta_poc_msb_present_flag[i2] = reader.readBit();
                        if (this.delta_poc_msb_present_flag[i2] == 0) continue;
                        this.delta_poc_msb_cycle_lt[i2] = reader.ue();
                    }
                }
                if (sps.sps_temporal_mvp_enabled_flag != 0) {
                    this.slice_temporal_mvp_enabled_flag = reader.readBit();
                }
            }
            if (sps.sample_adaptive_offset_enabled_flag != 0) {
                this.slice_sao_luma_flag = reader.readBit();
                if (d.chromaArrayType != 0) {
                    this.slice_sao_chroma_flag = reader.readBit();
                }
            }
            if (this.slice_type == 0 || this.slice_type == 1) {
                this.num_ref_idx_active_override_flag = reader.readBit();
                if (this.num_ref_idx_active_override_flag != 0) {
                    this.num_ref_idx_l0_active_minus1 = reader.ue();
                    if (this.slice_type == 0) {
                        this.num_ref_idx_l1_active_minus1 = reader.ue();
                    }
                }
                if (pps.lists_modification_present_flag != 0 && d.numPicTotalCurr > 1) {
                    this.refPicListMod = new RefPicListMod(reader, this.slice_type, this.num_ref_idx_l0_active_minus1, this.num_ref_idx_l1_active_minus1, d);
                }
                if (this.slice_type == 0) {
                    this.mvd_l1_zero_flag = reader.readBit();
                }
                if (pps.cabac_init_present_flag != 0) {
                    this.cabac_init_flag = reader.readBit();
                }
                if (this.slice_temporal_mvp_enabled_flag != 0) {
                    if (this.slice_type == 0) {
                        this.collocated_from_l0_flag = reader.readBit();
                    }
                    if (this.collocated_from_l0_flag != 0 ? this.num_ref_idx_l0_active_minus1 > 0 : this.num_ref_idx_l1_active_minus1 > 0) {
                        this.collocated_ref_idx = reader.ue();
                    }
                }
                if (pps.weighted_pred_flag != 0 && this.slice_type == 1 || pps.weighted_bipred_flag != 0 && this.slice_type == 0) {
                    this.predWeightTable = new PredWeightTable(reader, nuh_layer_id, sps, this, d);
                }
                this.five_minus_max_num_merge_cand = reader.ue();
                if (sps.motion_vector_resolution_control_idc == 2) {
                    this.use_integer_mv_flag = reader.readBit();
                }
            }
            this.slice_qp_delta = reader.se();
            if (pps.pps_slice_chroma_qp_offsets_present_flag != 0) {
                this.slice_cb_qp_offset = reader.se();
                this.slice_cr_qp_offset = reader.se();
            }
            if (pps.pps_slice_act_qp_offsets_present_flag != 0) {
                this.slice_act_y_qp_offset = reader.se();
                this.slice_act_cb_qp_offset = reader.se();
                this.slice_act_cr_qp_offset = reader.se();
            }
            if (pps.chroma_qp_offset_list_enabled_flag != 0) {
                this.cu_chroma_qp_offset_enabled_flag = reader.readBit();
            }
            if (pps.deblocking_filter_override_enabled_flag != 0) {
                this.deblocking_filter_override_flag = reader.readBit();
            }
            if (this.deblocking_filter_override_flag != 0) {
                this.slice_deblocking_filter_disabled_flag = reader.readBit();
                if (this.slice_deblocking_filter_disabled_flag == 0) {
                    this.slice_beta_offset_div2 = reader.se();
                    this.slice_tc_offset_div2 = reader.se();
                }
            }
            if (pps.pps_loop_filter_across_slices_enabled_flag != 0 && (this.slice_sao_luma_flag != 0 || this.slice_sao_chroma_flag != 0 || this.slice_deblocking_filter_disabled_flag == 0)) {
                this.slice_loop_filter_across_slices_enabled_flag = reader.readBit();
            }
        }
        if (pps.tiles_enabled_flag != 0 || pps.entropy_coding_sync_enabled_flag != 0) {
            this.num_entry_point_offsets = reader.ue();
            if (this.num_entry_point_offsets > 0) {
                this.offset_len_minus1 = reader.ue();
                for (i = 0; i < this.num_entry_point_offsets; ++i) {
                }
            }
        }
        if (pps.slice_segment_header_extension_present_flag != 0) {
            this.slice_segment_header_extension_length = reader.ue();
            this.slice_segment_header_extension_data_byte = new int[this.slice_segment_header_extension_length];
            for (i = 0; i < this.slice_segment_header_extension_length; ++i) {
                this.slice_segment_header_extension_data_byte[i] = reader.readU8();
            }
        }
    }
}

