/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heif.data;

import com.idrsolutions.image.heif.data.D;
import com.idrsolutions.image.heif.data.ProfileTierLevel;
import com.idrsolutions.image.heif.data.RbspTrailingBits;
import com.idrsolutions.image.heif.data.ScalingListData;
import com.idrsolutions.image.heif.data.StRefPic;
import com.idrsolutions.image.heif.data.Vui;
import com.idrsolutions.image.utility.BitReader;

class Sps {
    private final int sps_video_parameter_set_id;
    final int sps_max_sub_layers_minus1;
    private final byte sps_temporal_id_nesting_flag;
    private final ProfileTierLevel profileTilerLevel;
    private final int sps_seq_parameter_set_id;
    private final int chroma_format_idc;
    byte separate_colour_plane_flag;
    final int pic_width_in_luma_samples;
    final int pic_height_in_luma_samples;
    private final byte conformance_window_flag;
    private int conf_win_left_offset;
    private int conf_win_right_offset;
    private int conf_win_top_offset;
    private int conf_win_bottom_offset;
    private final int bit_depth_luma_minus8;
    private final int bit_depth_chroma_minus8;
    final int log2_max_pic_order_cnt_lsb_minus4;
    private final byte sps_sub_layer_ordering_info_present_flag;
    private final int[] sps_max_dec_pic_buffering_minus1;
    private final int[] sps_max_num_reorder_pics;
    private final int[] sps_max_latency_increase_plus1;
    private final int log2_min_luma_coding_block_size_minus3;
    private final int log2_diff_max_min_luma_coding_block_size;
    private final int log2_min_luma_transform_block_size_minus2;
    private final int log2_diff_max_min_luma_transform_block_size;
    private final int max_transform_hierarchy_depth_inter;
    private final int max_transform_hierarchy_depth_intra;
    private final byte scaling_list_enabled_flag;
    private byte sps_scaling_list_data_present_flag;
    private ScalingListData scalingListData;
    private final byte amp_enabled_flag;
    final byte sample_adaptive_offset_enabled_flag;
    private final byte pcm_enabled_flag;
    private int pcm_sample_bit_depth_luma_minus1;
    private int pcm_sample_bit_depth_chroma_minus1;
    private int log2_min_pcm_luma_coding_block_size_minus3;
    private int log2_diff_max_min_pcm_luma_coding_block_size;
    private byte pcm_loop_filter_disabled_flag;
    final int num_short_term_ref_pic_sets;
    final byte long_term_ref_pics_present_flag;
    int num_long_term_ref_pics_sps;
    private int[] lt_ref_pic_poc_lsb_sps;
    private byte[] used_by_curr_pic_lt_sps_flag;
    final byte sps_temporal_mvp_enabled_flag;
    private final byte strong_intra_smoothing_enabled_flag;
    private final byte vui_parameters_present_flag;
    private final byte sps_extension_present_flag;
    private byte sps_range_extension_flag;
    private byte sps_multilayer_extension_flag;
    private byte sps_3d_extension_flag;
    private byte sps_scc_extension_flag;
    private int sps_extension_4bits;
    private byte sps_extension_data_flag;
    private final RbspTrailingBits rbspTrailingBits;
    private Vui vui;
    private final StRefPic[] stRefPicSet;
    private byte transform_skip_rotation_enabled_flag;
    private byte transform_skip_context_enabled_flag;
    private byte implicit_rdpcm_enabled_flag;
    private byte explicit_rdpcm_enabled_flag;
    private byte extended_precision_processing_flag;
    private byte intra_smoothing_disabled_flag;
    private byte high_precision_offsets_enabled_flag;
    private byte persistent_rice_adaptation_enabled_flag;
    private byte cabac_bypass_alignment_enabled_flag;
    private byte sps_curr_pic_ref_enabled_flag;
    private byte palette_mode_enabled_flag;
    private int palette_max_size;
    private int delta_palette_max_predictor_size;
    private byte sps_palette_predictor_initializer_present_flag;
    private int sps_num_palette_predictor_initializer_minus1;
    private int[][] sps_palette_predictor_initializers;
    int motion_vector_resolution_control_idc;
    private byte ntra_boundary_filtering_disabled_flag;

    public Sps(BitReader reader, D d) {
        int i;
        this.sps_video_parameter_set_id = reader.readBits(4);
        this.sps_max_sub_layers_minus1 = reader.readBits(3);
        this.sps_temporal_id_nesting_flag = reader.readBit();
        this.profileTilerLevel = new ProfileTierLevel(reader, 1, this.sps_max_sub_layers_minus1);
        this.sps_seq_parameter_set_id = reader.ue();
        this.chroma_format_idc = reader.ue();
        if (this.chroma_format_idc == 3) {
            this.separate_colour_plane_flag = reader.readBit();
        }
        d.chromaArrayType = this.separate_colour_plane_flag == 0 ? this.chroma_format_idc : 0;
        this.pic_width_in_luma_samples = reader.ue();
        this.pic_height_in_luma_samples = reader.ue();
        this.conformance_window_flag = reader.readBit();
        if (this.conformance_window_flag != 0) {
            this.conf_win_left_offset = reader.ue();
            this.conf_win_right_offset = reader.ue();
            this.conf_win_top_offset = reader.ue();
            this.conf_win_bottom_offset = reader.ue();
        }
        this.bit_depth_luma_minus8 = reader.ue();
        d.bitDepthY = this.bit_depth_luma_minus8 + 8;
        d.qpBdOffsetY = 6 * this.bit_depth_luma_minus8;
        this.bit_depth_chroma_minus8 = reader.ue();
        d.bitDepthC = this.bit_depth_chroma_minus8 + 8;
        d.qpBdOffsetC = 6 * this.bit_depth_chroma_minus8;
        this.log2_max_pic_order_cnt_lsb_minus4 = reader.ue();
        d.maxPicOrderCntLsb = (int)Math.pow(2.0, this.log2_max_pic_order_cnt_lsb_minus4 + 4);
        this.sps_sub_layer_ordering_info_present_flag = reader.readBit();
        int start = this.sps_sub_layer_ordering_info_present_flag != 0 ? 0 : this.sps_max_sub_layers_minus1;
        int len = this.sps_max_sub_layers_minus1 + start + 1;
        this.sps_max_dec_pic_buffering_minus1 = new int[len];
        this.sps_max_num_reorder_pics = new int[len];
        this.sps_max_latency_increase_plus1 = new int[len];
        for (i = start; i <= this.sps_max_sub_layers_minus1; ++i) {
            this.sps_max_dec_pic_buffering_minus1[i] = reader.ue();
            this.sps_max_num_reorder_pics[i] = reader.ue();
            this.sps_max_latency_increase_plus1[i] = reader.ue();
        }
        this.log2_min_luma_coding_block_size_minus3 = reader.ue();
        this.log2_diff_max_min_luma_coding_block_size = reader.ue();
        this.log2_min_luma_transform_block_size_minus2 = reader.ue();
        this.log2_diff_max_min_luma_transform_block_size = reader.ue();
        d.minCbLog2SizeY = this.log2_min_luma_coding_block_size_minus3 + 3;
        d.ctbLog2SizeY = d.minCbLog2SizeY + this.log2_diff_max_min_luma_coding_block_size;
        d.minCbSizeY = 1 << d.minCbLog2SizeY;
        d.ctbSizeY = 1 << d.ctbLog2SizeY;
        d.picWidthInMinCbsY = this.pic_width_in_luma_samples / d.minCbSizeY;
        d.picWidthInCtbsY = (int)Math.ceil((double)this.pic_width_in_luma_samples * 1.0 / (double)d.ctbSizeY);
        d.picHeightInMinCbsY = this.pic_height_in_luma_samples / d.minCbSizeY;
        d.picHeightInCtbsY = (int)Math.ceil((double)this.pic_height_in_luma_samples * 1.0 / (double)d.ctbSizeY);
        d.picSizeInMinCbsY = d.picWidthInMinCbsY * d.picHeightInMinCbsY;
        d.picSizeInCtbsY = d.picWidthInCtbsY * d.picHeightInCtbsY;
        d.picSizeInSamplesY = this.pic_width_in_luma_samples * this.pic_height_in_luma_samples;
        d.subWidthC = Sps.getSubWidthC(this.chroma_format_idc);
        d.subHeightC = Sps.getSubHeightC(this.chroma_format_idc);
        d.picWidthInSamplesC = this.pic_width_in_luma_samples / d.subWidthC;
        d.picHeightInSamplesC = this.pic_height_in_luma_samples / d.subHeightC;
        if (this.chroma_format_idc == 0 || this.separate_colour_plane_flag == 1) {
            d.ctbWidthC = 0;
            d.ctbHeightC = 0;
        } else {
            d.ctbWidthC = d.ctbSizeY / d.subWidthC;
            d.ctbHeightC = d.ctbSizeY / d.subHeightC;
        }
        d.minTbLog2SizeY = this.log2_min_luma_transform_block_size_minus2 + 2;
        d.maxTbLog2SizeY = d.minTbLog2SizeY + this.log2_diff_max_min_luma_transform_block_size;
        this.max_transform_hierarchy_depth_inter = reader.ue();
        this.max_transform_hierarchy_depth_intra = reader.ue();
        this.scaling_list_enabled_flag = reader.readBit();
        if (this.scaling_list_enabled_flag != 0) {
            this.sps_scaling_list_data_present_flag = reader.readBit();
            if (this.sps_scaling_list_data_present_flag != 0) {
                this.scalingListData = new ScalingListData(reader);
            }
        }
        this.amp_enabled_flag = reader.readBit();
        this.sample_adaptive_offset_enabled_flag = reader.readBit();
        this.pcm_enabled_flag = reader.readBit();
        if (this.pcm_enabled_flag != 0) {
            this.pcm_sample_bit_depth_luma_minus1 = reader.readBits(4);
            this.pcm_sample_bit_depth_chroma_minus1 = reader.readBits(4);
            this.log2_min_pcm_luma_coding_block_size_minus3 = reader.ue();
            this.log2_diff_max_min_pcm_luma_coding_block_size = reader.ue();
            this.pcm_loop_filter_disabled_flag = reader.readBit();
        }
        d.pcmBitDepthY = this.pcm_sample_bit_depth_luma_minus1 + 1;
        d.pcmBitDepthC = this.pcm_sample_bit_depth_chroma_minus1 + 1;
        this.num_short_term_ref_pic_sets = reader.ue();
        this.stRefPicSet = new StRefPic[this.num_short_term_ref_pic_sets];
        for (i = 0; i < this.num_short_term_ref_pic_sets; ++i) {
            this.stRefPicSet[i] = new StRefPic(reader, i, this.num_short_term_ref_pic_sets, d);
        }
        this.long_term_ref_pics_present_flag = reader.readBit();
        if (this.long_term_ref_pics_present_flag != 0) {
            this.num_long_term_ref_pics_sps = reader.ue();
            this.lt_ref_pic_poc_lsb_sps = new int[this.num_long_term_ref_pics_sps];
            this.used_by_curr_pic_lt_sps_flag = new byte[this.num_long_term_ref_pics_sps];
            for (i = 0; i < this.num_long_term_ref_pics_sps; ++i) {
                this.lt_ref_pic_poc_lsb_sps[i] = reader.readBits(this.log2_max_pic_order_cnt_lsb_minus4 + 4);
                this.used_by_curr_pic_lt_sps_flag[i] = reader.readBit();
            }
        }
        this.sps_temporal_mvp_enabled_flag = reader.readBit();
        this.strong_intra_smoothing_enabled_flag = reader.readBit();
        this.vui_parameters_present_flag = reader.readBit();
        if (this.vui_parameters_present_flag != 0) {
            this.vui = new Vui(reader, this);
        }
        this.sps_extension_present_flag = reader.readBit();
        if (this.sps_extension_present_flag != 0) {
            this.sps_range_extension_flag = reader.readBit();
            this.sps_multilayer_extension_flag = reader.readBit();
            this.sps_3d_extension_flag = reader.readBit();
            this.sps_scc_extension_flag = reader.readBit();
            this.sps_extension_4bits = reader.readBits(4);
        }
        if (this.sps_range_extension_flag != 0) {
            this.updateSpsRange(reader, d);
        }
        if (this.sps_multilayer_extension_flag != 0) {
            // empty if block
        }
        if (this.sps_3d_extension_flag != 0) {
            // empty if block
        }
        if (this.sps_scc_extension_flag != 0) {
            this.updateSpsScc(reader);
        }
        if (this.sps_extension_4bits != 0) {
            while (BitReader.moreRbspData()) {
                this.sps_extension_data_flag = reader.readBit();
            }
        }
        this.rbspTrailingBits = new RbspTrailingBits(reader);
    }

    private void updateSpsRange(BitReader reader, D d) {
        this.transform_skip_rotation_enabled_flag = reader.readBit();
        this.transform_skip_context_enabled_flag = reader.readBit();
        this.implicit_rdpcm_enabled_flag = reader.readBit();
        this.explicit_rdpcm_enabled_flag = reader.readBit();
        this.extended_precision_processing_flag = reader.readBit();
        d.coeffMinY = -(1 << (this.extended_precision_processing_flag != 0 ? Math.max(15, d.bitDepthY + 6) : 15));
        d.coeffMinC = -(1 << (this.extended_precision_processing_flag != 0 ? Math.max(15, d.bitDepthC + 6) : 15));
        d.coeffMaxY = (1 << (this.extended_precision_processing_flag != 0 ? Math.max(15, d.bitDepthY + 6) : 15)) - 1;
        d.coeffMaxC = (1 << (this.extended_precision_processing_flag != 0 ? Math.max(15, d.bitDepthC + 6) : 15)) - 1;
        this.intra_smoothing_disabled_flag = reader.readBit();
        this.high_precision_offsets_enabled_flag = reader.readBit();
        d.wpOffsetBdShiftY = this.high_precision_offsets_enabled_flag != 0 ? 0 : d.bitDepthY - 8;
        d.wpOffsetBdShiftC = this.high_precision_offsets_enabled_flag != 0 ? 0 : d.bitDepthC - 8;
        d.wpOffsetHalfRangeY = 1 << (this.high_precision_offsets_enabled_flag != 0 ? d.bitDepthY - 1 : 7);
        d.wpOffsetHalfRangeC = 1 << (this.high_precision_offsets_enabled_flag != 0 ? d.bitDepthC - 1 : 7);
        this.persistent_rice_adaptation_enabled_flag = reader.readBit();
        this.cabac_bypass_alignment_enabled_flag = reader.readBit();
    }

    private void updateSpsScc(BitReader reader) {
        this.sps_curr_pic_ref_enabled_flag = reader.readBit();
        this.palette_mode_enabled_flag = reader.readBit();
        if (this.palette_mode_enabled_flag != 0) {
            this.palette_max_size = reader.ue();
            this.delta_palette_max_predictor_size = reader.ue();
            this.sps_palette_predictor_initializer_present_flag = reader.readBit();
            if (this.sps_palette_predictor_initializer_present_flag != 0) {
                this.sps_num_palette_predictor_initializer_minus1 = reader.ue();
                int nComp = this.chroma_format_idc == 0 ? 1 : 3;
                for (int comp = 0; comp < nComp; ++comp) {
                    for (int i = 0; i <= this.sps_num_palette_predictor_initializer_minus1; ++i) {
                        this.sps_palette_predictor_initializers[comp][i] = reader.ue();
                    }
                }
            }
        }
        this.motion_vector_resolution_control_idc = reader.readBits(2);
        this.ntra_boundary_filtering_disabled_flag = reader.readBit();
    }

    private static int getSubWidthC(int chroma_format_idc) {
        switch (chroma_format_idc) {
            case 1: 
            case 2: {
                return 2;
            }
        }
        return 1;
    }

    private static int getSubHeightC(int chroma_format_idc) {
        if (chroma_format_idc == 1) {
            return 2;
        }
        return 1;
    }
}

