/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heif.data;

import com.idrsolutions.image.heif.data.D;
import com.idrsolutions.image.heif.data.Pps;
import com.idrsolutions.image.heif.data.Sps;
import com.idrsolutions.image.heif.data.Ssh;
import com.idrsolutions.image.utility.BitReader;

class QuadTree {
    public QuadTree(BitReader reader, Pps pps, Sps sps, Ssh ssh, int x0, int y0, int log2CbSize, int cqtDepth, D d) {
        if (x0 + (1 << log2CbSize) > sps.pic_width_in_luma_samples || y0 + (1 << log2CbSize) > sps.pic_height_in_luma_samples || log2CbSize > d.minCbLog2SizeY) {
            // empty if block
        }
        if (pps.cu_qp_delta_enabled_flag != 0 && log2CbSize >= d.log2MinCuQpDeltaSize) {
            d.isCuQpDeltaCoded = 0;
            d.cuQpDeltaVal = 0;
        }
        if (ssh.cu_chroma_qp_offset_enabled_flag != 0 && log2CbSize >= d.log2MinCuChromaQpOffsetSize) {
            d.isCuChromaQpOffsetCoded = 0;
        }
    }
}

