/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heif.data;

import com.idrsolutions.image.heif.data.D;
import com.idrsolutions.image.heif.data.Sps;
import com.idrsolutions.image.heif.data.Ssh;
import com.idrsolutions.image.utility.BitReader;
import java.util.Objects;

class PredWeightTable {
    private final int luma_log2_weight_denom;
    private int delta_chroma_log2_weight_denom;
    private final byte[] luma_weight_l0_flag;
    private byte[] chroma_weight_l0_flag;
    private byte[] chroma_weight_l1_flag;
    private final int[] delta_luma_weight_l0;
    private final int[] luma_offset_l0;
    private int[] luma_offset_l1;
    private byte[] luma_weight_l1_flag;
    private final int[][] delta_chroma_weight_l0;
    private final int[][] delta_chroma_offset_l0;
    private int[][] delta_chroma_weight_l1;
    private int[][] delta_chroma_offset_l1;
    private int[] delta_luma_weight_l1;

    public PredWeightTable(BitReader reader, int nuh_layer_id, Sps sps, Ssh ssh, D d) {
        int j;
        int i;
        this.luma_log2_weight_denom = reader.ue();
        if (d.chromaArrayType != 0) {
            this.delta_chroma_log2_weight_denom = reader.se();
        }
        this.luma_weight_l0_flag = new byte[ssh.num_ref_idx_l0_active_minus1 + 1];
        for (i = 0; i < ssh.num_ref_idx_l0_active_minus1; ++i) {
            if (d.pic_layer_id(d.refPicList0[i]) == nuh_layer_id && d.picOrderCnt(d.refPicList0[i]) == d.picOrderCnt(d.currPic)) continue;
            this.luma_weight_l0_flag[i] = reader.readBit();
        }
        if (d.chromaArrayType != 0) {
            this.chroma_weight_l0_flag = new byte[ssh.num_ref_idx_l0_active_minus1 + 1];
            for (i = 0; i <= ssh.num_ref_idx_l0_active_minus1; ++i) {
                if (d.pic_layer_id(d.refPicList0[i]) == nuh_layer_id && d.picOrderCnt(d.refPicList0[i]) == d.picOrderCnt(d.currPic)) continue;
                this.chroma_weight_l0_flag[i] = reader.readBit();
            }
        }
        this.delta_luma_weight_l0 = new int[ssh.num_ref_idx_l0_active_minus1 + 1];
        this.delta_chroma_weight_l0 = new int[ssh.num_ref_idx_l0_active_minus1 + 1][2];
        this.delta_chroma_offset_l0 = new int[ssh.num_ref_idx_l0_active_minus1 + 1][2];
        this.luma_offset_l0 = new int[ssh.num_ref_idx_l0_active_minus1 + 1];
        for (i = 0; i <= ssh.num_ref_idx_l0_active_minus1; ++i) {
            if (this.luma_weight_l0_flag[i] != 0) {
                this.delta_luma_weight_l0[i] = reader.se();
                this.luma_offset_l0[i] = reader.se();
            }
            if (Objects.requireNonNull(this.chroma_weight_l0_flag)[i] == 0) continue;
            for (j = 0; j < 2; ++j) {
                this.delta_chroma_weight_l0[i][j] = reader.se();
                this.delta_chroma_offset_l0[i][j] = reader.se();
            }
        }
        if (ssh.slice_type == 0) {
            this.luma_weight_l1_flag = new byte[ssh.num_ref_idx_l1_active_minus1 + 1];
            for (i = 0; i <= ssh.num_ref_idx_l1_active_minus1; ++i) {
                if (d.pic_layer_id(d.refPicList0[i]) == nuh_layer_id && d.picOrderCnt(d.refPicList1[i]) == d.picOrderCnt(d.currPic)) continue;
                this.luma_weight_l1_flag[i] = reader.readBit();
            }
            if (d.chromaArrayType != 0) {
                this.chroma_weight_l1_flag = new byte[ssh.num_ref_idx_l1_active_minus1 + 1];
                for (i = 0; i <= ssh.num_ref_idx_l1_active_minus1; ++i) {
                    if (d.pic_layer_id(d.refPicList0[i]) == nuh_layer_id && d.picOrderCnt(d.refPicList1[i]) == d.picOrderCnt(d.currPic)) continue;
                    this.chroma_weight_l1_flag[i] = reader.readBit();
                }
            }
            this.delta_chroma_weight_l1 = new int[ssh.num_ref_idx_l1_active_minus1 + 1][2];
            this.delta_chroma_offset_l1 = new int[ssh.num_ref_idx_l1_active_minus1 + 1][2];
            this.delta_luma_weight_l1 = new int[ssh.num_ref_idx_l1_active_minus1 + 1];
            this.luma_offset_l1 = new int[ssh.num_ref_idx_l1_active_minus1 + 1];
            for (i = 0; i <= ssh.num_ref_idx_l1_active_minus1; ++i) {
                if (Objects.requireNonNull(this.luma_weight_l1_flag)[i] != 0) {
                    this.delta_luma_weight_l1[i] = reader.se();
                    this.luma_offset_l1[i] = reader.se();
                }
                if (Objects.requireNonNull(this.chroma_weight_l1_flag)[i] == 0) continue;
                for (j = 0; j < 2; ++j) {
                    this.delta_chroma_weight_l1[i][j] = reader.se();
                    this.delta_chroma_offset_l1[i][j] = reader.se();
                }
            }
        }
    }
}

