/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heif.data;

import com.idrsolutions.image.heif.data.SubLayerHrd;
import com.idrsolutions.image.utility.BitReader;

class Hrd {
    private byte nal_hrd_parameters_present_flag;
    private byte vcl_hrd_parameters_present_flag;
    private byte sub_pic_hrd_params_present_flag;
    private int tick_divisor_minus2;
    private int du_cpb_removal_delay_increment_length_minus1;
    private byte sub_pic_cpb_params_in_pic_timing_sei_flag;
    private int dpb_output_delay_du_length_minus1;
    private int bit_rate_scale;
    private int cpb_size_scale;
    private int cpb_size_du_scale;
    private int initial_cpb_removal_delay_length_minus1;
    private int au_cpb_removal_delay_length_minus1;
    private int dpb_output_delay_length_minus1;
    private final byte[] fixed_pic_rate_general_flag;
    private final byte[] fixed_pic_rate_within_cvs_flag;
    private final byte[] elemental_duration_in_tc_minus1;
    private final byte[] low_delay_hrd_flag;
    private final int[] cpb_cnt_minus1;
    private final SubLayerHrd[] sub_layer_hrd_parameters;

    public Hrd(BitReader reader, byte commonInfPresentFlag, int maxNumSubLayersMinus1) {
        if (commonInfPresentFlag != 0) {
            this.nal_hrd_parameters_present_flag = reader.readBit();
            this.vcl_hrd_parameters_present_flag = reader.readBit();
            if (this.nal_hrd_parameters_present_flag != 0 || this.vcl_hrd_parameters_present_flag != 0) {
                this.sub_pic_hrd_params_present_flag = reader.readBit();
                if (this.sub_pic_hrd_params_present_flag != 0) {
                    this.tick_divisor_minus2 = reader.readU8();
                    this.du_cpb_removal_delay_increment_length_minus1 = reader.readBits(5);
                    this.sub_pic_cpb_params_in_pic_timing_sei_flag = reader.readBit();
                    this.dpb_output_delay_du_length_minus1 = reader.readBits(5);
                }
                this.bit_rate_scale = reader.readBits(4);
                this.cpb_size_scale = reader.readBits(4);
                if (this.sub_pic_hrd_params_present_flag != 0) {
                    this.cpb_size_du_scale = reader.readBits(4);
                }
                this.initial_cpb_removal_delay_length_minus1 = reader.readBits(5);
                this.au_cpb_removal_delay_length_minus1 = reader.readBits(5);
                this.dpb_output_delay_length_minus1 = reader.readBits(5);
            }
        }
        this.fixed_pic_rate_general_flag = new byte[maxNumSubLayersMinus1];
        this.fixed_pic_rate_within_cvs_flag = new byte[maxNumSubLayersMinus1];
        this.elemental_duration_in_tc_minus1 = new byte[maxNumSubLayersMinus1];
        this.low_delay_hrd_flag = new byte[maxNumSubLayersMinus1];
        this.cpb_cnt_minus1 = new int[maxNumSubLayersMinus1];
        this.sub_layer_hrd_parameters = new SubLayerHrd[maxNumSubLayersMinus1];
        for (int i = 0; i <= maxNumSubLayersMinus1; ++i) {
            this.fixed_pic_rate_general_flag[i] = reader.readBit();
            if (this.fixed_pic_rate_general_flag[i] == 0) {
                this.fixed_pic_rate_within_cvs_flag[i] = reader.readBit();
            }
            if (this.fixed_pic_rate_within_cvs_flag[i] != 0) {
                this.elemental_duration_in_tc_minus1[i] = reader.readBit();
            } else {
                this.low_delay_hrd_flag[i] = reader.readBit();
            }
            if (this.low_delay_hrd_flag[i] == 0) {
                this.cpb_cnt_minus1[i] = reader.ue();
            }
            if (this.nal_hrd_parameters_present_flag != 0) {
                this.sub_layer_hrd_parameters[i] = new SubLayerHrd(reader, i, this.cpb_cnt_minus1[i], this.sub_pic_hrd_params_present_flag);
            }
            if (this.vcl_hrd_parameters_present_flag == 0) continue;
            this.sub_layer_hrd_parameters[i] = new SubLayerHrd(reader, i, this.cpb_cnt_minus1[i], this.sub_pic_hrd_params_present_flag);
        }
    }
}

