/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heif.data;

import com.idrsolutions.image.heif.data.Pps;
import com.idrsolutions.image.heif.data.Sps;

class D {
    public int bitDepthY;
    public int bitDepthC;
    public int qpBdOffsetY;
    public int qpBdOffsetC;
    public int maxPicOrderCntLsb;
    public int ctbSizeY;
    public int ctbWidthC;
    public int ctbHeightC;
    public int picWidthInCtbsY;
    public int picHeightInCtbsY;
    public int picSizeInCtbsY;
    public int pcmBitDepthY;
    public int pcmBitDepthC;
    public int minCbLog2SizeY;
    public int ctbLog2SizeY;
    public int minCbSizeY;
    public int minTbLog2SizeY;
    public int maxTbLog2SizeY;
    public int picWidthInMinCbsY;
    public int picHeightInMinCbsY;
    public int picSizeInMinCbsY;
    public int picSizeInSamplesY;
    public int subWidthC;
    public int subHeightC;
    public int picWidthInSamplesC;
    public int picHeightInSamplesC;
    public int log2MinCuQpDeltaSize;
    public int log2ParMrgLevel;
    public int log2MaxTransformSkipSize;
    public int log2MinCuChromaQpOffsetSize;
    public int coeffMinY;
    public int coeffMinC;
    public int coeffMaxY;
    public int coeffMaxC;
    public int wpOffsetBdShiftY;
    public int wpOffsetBdShiftC;
    public int wpOffsetHalfRangeY;
    public int wpOffsetHalfRangeC;
    public int refRpsIdx;
    public int[] numDeltaPocs;
    private int[][] minTbAddrZs;
    public int[] ctbAddrRsToTs;
    public int[] ctbAddrTsToRs;
    public int[] tileId;
    private int[][] diagScan;
    private int[][] horScan;
    private int[][] verScan;
    private int[][] travScan;
    private int[] colWidth;
    private int[] rowHeight;
    private int[] colBd;
    private int[] rowBd;
    public int[] refPicList0;
    public int[] refPicList1;
    public int currPic;
    public int numPicTotalCurr;
    public int[] numNegativePics;
    public int[] numPositivePics;
    public int[] usedByCurrPicS0;
    public int[] usedByCurrPicS1;
    public int[] deltaPocS0;
    public int[] deltaPocS1;
    public int[][][] saoTypeIdx;
    public int[][][] saoEoClass;
    public int[] vpsMaxLatencyPictures;
    public int[] SpsMaxLatencyPictures;
    public int ppsActQpOffsetY;
    public int ppsActQpOffsetCb;
    public int ppsActQpOffsetCr;
    private static final int[] TB0 = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
    private static final int[] TB1 = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 16, 17, 16, 17, 18};
    private static final int[] TB2 = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 18};
    private static final int[] TB3 = new int[]{17, 18, 18, 17, 18, 21, 19, 20, 21, 20, 19, 21, 24, 22, 22, 24};
    private static final int[] TB4 = new int[]{18, 18, 18, 18, 18, 20, 20, 20, 20, 20, 20, 20, 24, 24, 24, 24};
    private static final int[] TB5 = new int[]{24, 22, 22, 24, 25, 25, 27, 30, 27, 25, 25, 29, 31, 35, 35, 31};
    private static final int[] TB6 = new int[]{24, 24, 24, 24, 25, 25, 25, 25, 25, 25, 25, 28, 28, 28, 28, 28};
    private static final int[] TB7 = new int[]{29, 36, 41, 44, 41, 36, 47, 54, 54, 47, 65, 70, 65, 88, 88, 115};
    private static final int[] TB8 = new int[]{28, 33, 33, 33, 33, 33, 41, 41, 41, 41, 54, 54, 54, 71, 71, 91};
    private final int[][][] scalingList = new int[4][6][64];
    public int[][][][] scalingFactor;
    public int ctbAddrInRs;
    public int sliceAddrRs;
    int ctbAddrInTs;
    int chromaArrayType;
    public int isCuQpDeltaCoded;
    int cuQpDeltaVal;
    int isCuChromaQpOffsetCoded;
    public int currentPaletteSize;
    public int[][] currentPaletteEntries;

    D() {
    }

    public void initScalingList() {
        for (int m = 0; m <= 5; ++m) {
            System.arraycopy(TB0, 0, this.scalingList[0][m], 0, 16);
        }
        for (int x = 1; x <= 3; ++x) {
            int m;
            for (m = 0; m <= 2; ++m) {
                System.arraycopy(TB1, 0, this.scalingList[x][m], 0, 16);
                System.arraycopy(TB3, 0, this.scalingList[x][m], 16, 16);
                System.arraycopy(TB5, 0, this.scalingList[x][m], 32, 16);
                System.arraycopy(TB7, 0, this.scalingList[x][m], 48, 16);
            }
            for (m = 3; m <= 5; ++m) {
                System.arraycopy(TB2, 0, this.scalingList[x][m], 0, 16);
                System.arraycopy(TB4, 0, this.scalingList[x][m], 16, 16);
                System.arraycopy(TB6, 0, this.scalingList[x][m], 32, 16);
                System.arraycopy(TB8, 0, this.scalingList[x][m], 48, 16);
            }
        }
    }

    private boolean zScanOrderBlockAvailability(int xCurr, int yCurr, int xNbY, int yNbY, Sps sps) {
        int minBlockAddrCurr = this.minTbAddrZs[xCurr >> this.minTbLog2SizeY][yCurr >> this.minTbLog2SizeY];
        int minBlockAddrN = xNbY < 0 || yNbY < 0 || xNbY >= sps.pic_width_in_luma_samples || yNbY >= sps.pic_height_in_luma_samples ? -1 : this.minTbAddrZs[xNbY >> this.minTbLog2SizeY][yNbY >> this.minTbLog2SizeY];
        return minBlockAddrN >= 0 && minBlockAddrN <= minBlockAddrCurr;
    }

    public boolean predictionBlockAvailability(int xCb, int yCb, int nCbS, int xPb, int yPb, int nPbW, int nPbH, int partIdx, int xNbY, int yNbY, Sps sps) {
        boolean sameCb;
        boolean bl = sameCb = xCb <= xNbY && yCb <= yNbY && xCb + nCbS > xNbY && yCb + nCbS > yNbY;
        boolean availableN = !sameCb ? this.zScanOrderBlockAvailability(xPb, yPb, xNbY, yNbY, sps) : nPbW << 1 != nCbS || nPbH << 1 != nCbS || partIdx != 1 || yCb + nPbH > yNbY || xCb + nPbW <= xNbY;
        return availableN;
    }

    public void codeTreeBlockRasterTileScan(Pps pps, Sps sps) {
        int j;
        int i;
        this.initColWidth(pps);
        this.initRowHeight(pps);
        this.initColRowBd(pps);
        int tileX = 0;
        int tileY = 0;
        this.ctbAddrRsToTs = new int[this.picSizeInCtbsY];
        this.ctbAddrTsToRs = new int[this.picSizeInCtbsY];
        this.tileId = new int[this.picSizeInCtbsY];
        int ctbAddrRs = 0;
        while (ctbAddrRs < this.picSizeInCtbsY) {
            int tbX = ctbAddrRs % this.picWidthInCtbsY;
            int tbY = ctbAddrRs / this.picWidthInCtbsY;
            for (i = 0; i <= pps.nTile_columns_minus1; ++i) {
                if (tbX < this.colBd[i]) continue;
                tileX = i;
            }
            for (j = 0; j <= pps.nTile_rows_minus1; ++j) {
                if (tbY < this.rowBd[j]) continue;
                tileY = j;
            }
            this.ctbAddrRsToTs[ctbAddrRs] = 0;
            for (i = 0; i < tileX; ++i) {
                int n = ctbAddrRs;
                this.ctbAddrRsToTs[n] = this.ctbAddrRsToTs[n] + this.rowHeight[tileY] * this.colWidth[i];
            }
            for (j = 0; j < tileY; ++j) {
                int n = ctbAddrRs;
                this.ctbAddrRsToTs[n] = this.ctbAddrRsToTs[n] + this.picWidthInCtbsY * this.rowHeight[j];
            }
            int n = ctbAddrRs++;
            this.ctbAddrRsToTs[n] = this.ctbAddrRsToTs[n] + ((tbY - this.rowBd[tileY]) * this.colWidth[tileX] + tbX - this.colBd[tileX]);
        }
        for (ctbAddrRs = 0; ctbAddrRs < this.picSizeInCtbsY; ++ctbAddrRs) {
            this.ctbAddrTsToRs[this.ctbAddrRsToTs[ctbAddrRs]] = ctbAddrRs;
        }
        int tileIdx = 0;
        for (j = 0; j <= pps.nTile_rows_minus1; ++j) {
            i = 0;
            while (i <= pps.nTile_columns_minus1) {
                for (int y = this.rowBd[j]; y < this.rowBd[j + 1]; ++y) {
                    for (int x = this.colBd[i]; x < this.colBd[i + 1]; ++x) {
                        this.tileId[this.ctbAddrRsToTs[y * this.picWidthInCtbsY + x]] = tileIdx;
                    }
                }
                ++i;
                ++tileIdx;
            }
        }
    }

    private void initColWidth(Pps pps) {
        int ii = pps.nTile_columns_minus1 + 1;
        this.colWidth = new int[ii];
        if (pps.uniform_spacing_flag != 0) {
            for (int i = 0; i < ii; ++i) {
                this.colWidth[i] = (i + 1) * this.picWidthInCtbsY / ii - i * this.picWidthInCtbsY / ii;
            }
        } else {
            this.colWidth[pps.nTile_columns_minus1] = this.picWidthInCtbsY;
            for (int i = 0; i < pps.nTile_columns_minus1; ++i) {
                this.colWidth[i] = pps.column_width_minus1[i] + 1;
                int n = pps.nTile_columns_minus1;
                this.colWidth[n] = this.colWidth[n] - this.colWidth[i];
            }
        }
    }

    private void initRowHeight(Pps pps) {
        int jj = pps.nTile_rows_minus1 + 1;
        this.rowHeight = new int[jj];
        if (pps.uniform_spacing_flag != 0) {
            for (int j = 0; j < jj; ++j) {
                this.rowHeight[j] = (j + 1) * this.picHeightInCtbsY / jj - j * this.picHeightInCtbsY / jj;
            }
        } else {
            this.rowHeight[pps.nTile_rows_minus1] = this.picHeightInCtbsY;
            for (int j = 0; j < pps.nTile_rows_minus1; ++j) {
                this.rowHeight[j] = pps.row_height_minus1[j] + 1;
                int n = pps.nTile_rows_minus1;
                this.rowHeight[n] = this.rowHeight[n] - this.rowHeight[j];
            }
        }
    }

    private void initColRowBd(Pps pps) {
        int ii = pps.nTile_columns_minus1 + 1;
        int jj = pps.nTile_rows_minus1 + 1;
        this.colBd = new int[ii];
        this.colBd[0] = 0;
        for (int i = 0; i < ii; ++i) {
            this.colBd[i + 1] = this.colBd[i] + this.colWidth[i];
        }
        this.rowBd = new int[jj];
        this.rowBd[0] = 0;
        for (int j = 0; j < jj; ++j) {
            this.rowBd[j + 1] = this.rowBd[j] + this.rowHeight[j];
        }
    }

    public void initZScan() {
        int xx = this.picWidthInCtbsY << this.ctbLog2SizeY - this.minTbLog2SizeY;
        int yy = this.picHeightInCtbsY << this.ctbLog2SizeY - this.minTbLog2SizeY;
        this.minTbAddrZs = new int[xx][yy];
        for (int y = 0; y < yy; ++y) {
            for (int x = 0; x < xx; ++x) {
                int tbX = x << this.minTbLog2SizeY >> this.ctbLog2SizeY;
                int tbY = y << this.minTbLog2SizeY >> this.ctbLog2SizeY;
                int ctbAddrRs = this.picWidthInCtbsY * tbY + tbX;
                this.minTbAddrZs[x][y] = this.ctbAddrRsToTs[ctbAddrRs] << (this.ctbLog2SizeY - this.minTbLog2SizeY) * 2;
                int ii = this.ctbLog2SizeY - this.minTbLog2SizeY;
                int p = 0;
                for (int i = 0; i < ii; ++i) {
                    int m = 1 << i;
                    int m1 = (m & x) != 0 ? m * m : 0;
                    int m2 = (m & y) != 0 ? 2 * m * m : 0;
                    p += m1 + m2;
                }
                int[] nArray = this.minTbAddrZs[x];
                int n = y;
                nArray[n] = nArray[n] + p;
            }
        }
    }

    private void initDiagScan(int blkSize) {
        int i = 0;
        int x = 0;
        int y = 0;
        boolean stopLoop = false;
        int bb = blkSize * blkSize;
        this.diagScan = new int[bb][2];
        while (!stopLoop) {
            while (y >= 0) {
                if (x < blkSize && y < blkSize) {
                    this.diagScan[i][0] = x;
                    this.diagScan[i][1] = y;
                    ++i;
                }
                --y;
                ++x;
            }
            y = x;
            x = 0;
            if (i < bb) continue;
            stopLoop = true;
        }
    }

    private void initHorScan(int blkSize) {
        int i = 0;
        int bb = blkSize * blkSize;
        this.horScan = new int[bb][2];
        for (int y = 0; y < blkSize; ++y) {
            int x = 0;
            while (x < blkSize) {
                this.horScan[i][0] = x++;
                this.horScan[i][1] = y;
                ++i;
            }
        }
    }

    private void initVerScan(int blkSize) {
        int i = 0;
        int bb = blkSize * blkSize;
        this.verScan = new int[bb][2];
        for (int y = 0; y < blkSize; ++y) {
            int x = 0;
            while (x < blkSize) {
                this.verScan[i][0] = x++;
                this.verScan[i][1] = y;
                ++i;
            }
        }
    }

    private void initTravScan(int blkSize) {
        int i = 0;
        int bb = blkSize * blkSize;
        this.travScan = new int[bb][2];
        for (int y = 0; y < blkSize; ++y) {
            int x;
            if (y % 2 == 0) {
                x = 0;
                while (x < blkSize) {
                    this.travScan[i][0] = x++;
                    this.travScan[i][1] = y;
                    ++i;
                }
                continue;
            }
            x = blkSize - 1;
            while (x >= 0) {
                this.travScan[i][0] = x--;
                this.travScan[i][1] = y;
                ++i;
            }
        }
    }

    public int pic_layer_id(int v) {
        return 1;
    }

    public int picOrderCnt(int v) {
        return 1;
    }

    public static void main(String[] args) {
        D d = new D();
        d.initHorScan(8);
        d.initVerScan(8);
        d.initTravScan(8);
        d.initDiagScan(8);
        int p = 0;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                System.out.print(d.diagScan[p][0] + "," + d.diagScan[p][1] + ' ');
                ++p;
            }
            System.out.println();
        }
        System.out.println("stop");
    }
}

