/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heif.box;

import com.idrsolutions.image.heif.box.Box;
import com.idrsolutions.image.heif.box.FTYP;
import com.idrsolutions.image.heif.box.FullBox;
import com.idrsolutions.image.heif.box.HDLR;
import com.idrsolutions.image.heif.box.HVCC;
import com.idrsolutions.image.heif.box.HeifFile;
import com.idrsolutions.image.heif.box.IINF;
import com.idrsolutions.image.heif.box.ILOC;
import com.idrsolutions.image.heif.box.INFE;
import com.idrsolutions.image.heif.box.IPCO;
import com.idrsolutions.image.heif.box.IPMA;
import com.idrsolutions.image.heif.box.IPRP;
import com.idrsolutions.image.heif.box.ISPE;
import com.idrsolutions.image.heif.box.MDAT;
import com.idrsolutions.image.heif.box.META;
import com.idrsolutions.image.heif.box.PITM;
import com.idrsolutions.image.utility.DataReader;
import java.io.IOException;

public class BoxReader {
    public static void readBoxes(DataReader reader, HeifFile hFile) throws IOException {
        while (reader.getPosition() < reader.getLength()) {
            int pos = reader.getPosition();
            Box box = BoxReader.readBox(reader);
            System.out.println(box + " at position: " + pos);
            switch (box.type) {
                case 1718909296: {
                    hFile.ftyp = BoxReader.readFTYP(reader, box.size);
                    break;
                }
                case 1835365473: {
                    hFile.meta = BoxReader.readMETA(reader, box.size);
                    break;
                }
                case 1835295092: {
                    if (hFile.mdat != null) break;
                    hFile.mdat = BoxReader.readMDAT(reader, box.size);
                }
            }
            reader.moveTo(pos + box.size);
        }
    }

    private static Box readBox(DataReader reader) throws IOException {
        Box box = new Box();
        box.size = reader.getU32();
        box.type = reader.getU32();
        if (box.size == 1) {
            box.size = (int)((long)reader.getU32() * 1L << 32 | (long)reader.getU32());
        }
        return box;
    }

    private static FullBox readFullBox(DataReader reader) throws IOException {
        FullBox box = new FullBox();
        box.version = reader.getU8();
        box.flags = reader.getU24();
        return box;
    }

    private static MDAT readMDAT(DataReader reader, int size) {
        MDAT box = new MDAT();
        box.offset = reader.getPosition();
        box.length = size - 8;
        return box;
    }

    private static String getTypeString(int v) {
        char[] c = new char[]{(char)(v >> 24), (char)(v >> 16 & 0xFF), (char)(v >> 8 & 0xFF), (char)(v & 0xFF)};
        return new String(c);
    }

    private static FTYP readFTYP(DataReader reader, int size) throws IOException {
        FTYP ftyp = new FTYP();
        ftyp.major = reader.getU32();
        ftyp.minor = reader.getU32();
        int temp = (size - 16) / 4;
        ftyp.compatibleBrands = new int[temp];
        for (int i = 0; i < temp; ++i) {
            ftyp.compatibleBrands[i] = reader.getU32();
            System.out.println('\t' + BoxReader.getTypeString(ftyp.compatibleBrands[i]));
        }
        return ftyp;
    }

    private static META readMETA(DataReader reader, int size) throws IOException {
        int metaEnd = reader.getPosition() + size - 8;
        META meta = new META();
        BoxReader.readFullBox(reader);
        while (reader.getPosition() < metaEnd) {
            int pos = reader.getPosition();
            Box box = BoxReader.readBox(reader);
            System.out.println("\t" + box);
            switch (box.type) {
                case 1751411826: {
                    meta.handler = BoxReader.readHandler(reader);
                    break;
                }
                case 1885959277: {
                    meta.pitm = BoxReader.readPITM(reader);
                    break;
                }
                case 1768714083: {
                    meta.iloc = BoxReader.readILOC(reader);
                    break;
                }
                case 1768977008: {
                    meta.iprp = BoxReader.readIPRP(reader, box.size);
                    break;
                }
                case 0x69696E66: {
                    meta.iinf = BoxReader.readIINF(reader);
                }
            }
            reader.moveTo(pos + box.size);
        }
        return meta;
    }

    private static HDLR readHandler(DataReader reader) throws IOException {
        HDLR hdlr = new HDLR();
        BoxReader.readFullBox(reader);
        reader.getU32();
        hdlr.handlerType = reader.getU32();
        reader.skip(12);
        System.out.println("\thdlr-type:" + BoxReader.getTypeString(hdlr.handlerType));
        return hdlr;
    }

    private static PITM readPITM(DataReader reader) throws IOException {
        PITM res = new PITM();
        FullBox fBox = BoxReader.readFullBox(reader);
        res.itemID = fBox.version == 0 ? reader.getU16() : reader.getU32();
        return res;
    }

    private static ILOC readILOC(DataReader reader) throws IOException {
        ILOC res = new ILOC();
        FullBox fBox = BoxReader.readFullBox(reader);
        int temp = reader.getU8();
        res.offsetSize = temp >> 4;
        res.lengthSize = temp & 0xF;
        temp = reader.getU8();
        res.baseOffsetSize = temp >> 4;
        if (fBox.version == 1 || fBox.version == 2) {
            res.indexSize = temp & 0xF;
        }
        if (fBox.version < 2) {
            res.itemCount = reader.getU16();
        } else if (fBox.version == 2) {
            res.itemCount = reader.getU32();
        }
        res.itemID = new int[res.itemCount];
        res.constructionMethod = new int[res.itemCount];
        res.dataReferenceIndex = new int[res.itemCount];
        res.baseOffset = new int[res.itemCount];
        res.extentCount = new int[res.itemCount];
        res.extend_index = new int[res.itemCount][];
        res.extend_offset = new int[res.itemCount][];
        res.extend_length = new int[res.itemCount][];
        for (int i = 0; i < res.itemCount; ++i) {
            if (fBox.version < 2) {
                res.itemID[i] = reader.getU16();
            } else if (fBox.version == 2) {
                res.itemID[i] = reader.getU32();
            }
            if (fBox.version == 1 || fBox.version == 2) {
                temp = reader.getU16();
                res.constructionMethod[i] = temp & 0xF;
            }
            res.dataReferenceIndex[i] = reader.getU16();
            for (int j = 0; j < res.baseOffsetSize; ++j) {
                res.baseOffset[i] = res.baseOffset[i] << 8 | reader.getU8();
            }
            res.extentCount[i] = reader.getU16();
            int jj = res.extentCount[i];
            res.extend_index[i] = new int[jj];
            res.extend_offset[i] = new int[jj];
            res.extend_length[i] = new int[jj];
            for (int j = 0; j < jj; ++j) {
                int k;
                if ((fBox.version == 1 || fBox.version == 2) && res.indexSize > 0) {
                    for (k = 0; k < res.indexSize; ++k) {
                        res.extend_index[i][j] = res.extend_index[i][j] << 8 | reader.getU8();
                    }
                }
                for (k = 0; k < res.offsetSize; ++k) {
                    res.extend_offset[i][j] = res.extend_offset[i][j] << 8 | reader.getU8();
                }
                for (k = 0; k < res.lengthSize; ++k) {
                    res.extend_length[i][j] = res.extend_length[i][j] << 8 | reader.getU8();
                }
                System.out.println("ILOC Baseoffset: " + res.baseOffset[i] + " Ext-off: " + res.extend_offset[i][j] + " Ext-len: " + res.extend_length[i][j]);
            }
        }
        return res;
    }

    private static IPRP readIPRP(DataReader reader, int size) throws IOException {
        int iprpEnd = reader.getPosition() + size - 8;
        IPRP res = new IPRP();
        while (reader.getPosition() < iprpEnd) {
            int pos = reader.getPosition();
            Box box = BoxReader.readBox(reader);
            System.out.println("\t\t" + box);
            switch (box.type) {
                case 1768973167: {
                    res.ipco = BoxReader.readIPCO(reader, box.size);
                    break;
                }
                case 1768975713: {
                    res.ipma = BoxReader.readIPMA(reader);
                }
            }
            reader.moveTo(pos + box.size);
        }
        return res;
    }

    private static IPCO readIPCO(DataReader reader, int size) throws IOException {
        int end = reader.getPosition() + size - 8;
        IPCO res = new IPCO();
        while (reader.getPosition() < end) {
            int pos = reader.getPosition();
            Box box = BoxReader.readBox(reader);
            System.out.println("\t\t\t" + box);
            switch (box.type) {
                case 1769173093: {
                    res.ispe = BoxReader.readISPE(reader);
                    break;
                }
                case 1752589123: {
                    System.out.println("before hvcc " + reader.getPosition() + ' ' + box.size);
                    res.hvcc = BoxReader.readHVCC(reader);
                    System.out.println("after" + reader.getPosition());
                }
            }
            reader.moveTo(pos + box.size);
        }
        return res;
    }

    private static IPMA readIPMA(DataReader reader) throws IOException {
        FullBox fBox = BoxReader.readFullBox(reader);
        IPMA ipma = new IPMA();
        ipma.entry_count = reader.getU32();
        ipma.item_ID = new int[ipma.entry_count];
        ipma.property_index = new int[ipma.entry_count][];
        ipma.essential = new byte[ipma.entry_count][];
        for (int i = 0; i < ipma.entry_count; ++i) {
            ipma.item_ID[i] = fBox.version < 1 ? reader.getU16() : reader.getU32();
            int association_count = reader.getU8();
            ipma.property_index[i] = new int[association_count];
            ipma.essential[i] = new byte[association_count];
            for (int j = 0; j < association_count; ++j) {
                int t = reader.getU8();
                ipma.essential[i][j] = (byte)(t >> 7);
                ipma.property_index[i][j] = (fBox.flags & 1) != 0 ? (t | reader.getU8()) & Short.MAX_VALUE : t & 0x7F;
            }
        }
        return ipma;
    }

    private static ISPE readISPE(DataReader reader) throws IOException {
        ISPE ispe = new ISPE();
        BoxReader.readFullBox(reader);
        ispe.imageWidth = reader.getU32();
        ispe.imageHeight = reader.getU32();
        System.out.println("\t\t\t\tiw: " + ispe.imageWidth + " ih: " + ispe.imageHeight);
        return ispe;
    }

    private static IINF readIINF(DataReader reader) throws IOException {
        IINF iinf = new IINF();
        FullBox fbox = BoxReader.readFullBox(reader);
        iinf.entry_count = fbox.version == 0 ? reader.getU16() : reader.getU32();
        iinf.infe = new INFE[iinf.entry_count];
        for (int i = 0; i < iinf.entry_count; ++i) {
            int pos = reader.getPosition();
            Box box = BoxReader.readBox(reader);
            iinf.infe[i] = BoxReader.readINFE(reader);
            reader.moveTo(pos + box.size);
        }
        return iinf;
    }

    private static INFE readINFE(DataReader reader) throws IOException {
        INFE infe = new INFE();
        FullBox fbox = BoxReader.readFullBox(reader);
        if (fbox.version == 0) {
            infe.item_ID = reader.getU16();
            infe.item_protection_index = reader.getU16();
            infe.item_name = BoxReader.readString(reader);
            infe.content_type = BoxReader.readString(reader);
            infe.content_encoding = BoxReader.readString(reader);
        } else if (fbox.version != 1 && fbox.version >= 2) {
            if (fbox.version == 2) {
                infe.item_ID = reader.getU16();
            } else if (fbox.version == 3) {
                infe.item_ID = reader.getU32();
            }
            infe.item_protection_index = reader.getU16();
            infe.item_type = reader.getU32();
            if (infe.item_type == 1835625829) {
                infe.content_type = BoxReader.readString(reader);
                infe.content_encoding = BoxReader.readString(reader);
            } else if (infe.item_type == 1970432288) {
                infe.item_uri_type = BoxReader.readString(reader);
            }
        }
        return infe;
    }

    private static String readString(DataReader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        int v = reader.getU8();
        while (v != 0) {
            sb.append((char)v);
            v = reader.getU8();
        }
        return sb.toString();
    }

    private static HVCC readHVCC(DataReader reader) throws IOException {
        HVCC hvcc = new HVCC();
        hvcc.configurationVersion = reader.getU8();
        int t = reader.getU8();
        hvcc.general_profile_space = t >> 6;
        hvcc.general_tier_flag = t >> 5 & 1;
        hvcc.general_profile_idc = t & 0x1F;
        hvcc.general_profile_compatibility_flags = reader.getU32();
        hvcc.general_constraint_indicator_flags = 1L * (long)reader.getU16() << 32 | (long)reader.getU32();
        hvcc.general_level_idc = reader.getU8();
        t = reader.getU16();
        hvcc.min_spatial_segmentation_idc = t & 0xFFF;
        t = reader.getU8();
        hvcc.parallelismType = t & 3;
        t = reader.getU8();
        hvcc.chroma_format_idc = t & 3;
        t = reader.getU8();
        hvcc.bit_depth_luma_minus8 = t & 7;
        t = reader.getU8();
        hvcc.bit_depth_chroma_minus8 = t & 7;
        hvcc.avgFrameRate = reader.getU16();
        t = reader.getU8();
        hvcc.constantFrameRate = t >> 6;
        hvcc.numTemporalLayers = t >> 3 & 7;
        hvcc.temporalIdNested = t >> 2 & 1;
        hvcc.lengthSizeMinusOne = t & 3;
        hvcc.numOfArrays = reader.getU8();
        hvcc.array_completeness = new int[hvcc.numOfArrays];
        hvcc.NAL_unit_type = new int[hvcc.numOfArrays];
        hvcc.numNalus = new int[hvcc.numOfArrays];
        hvcc.nalUnitLength = new int[hvcc.numOfArrays][];
        hvcc.nalUnit = new byte[hvcc.numOfArrays][][];
        for (int j = 0; j < hvcc.numOfArrays; ++j) {
            t = reader.getU8();
            hvcc.array_completeness[j] = t >> 7;
            hvcc.NAL_unit_type[j] = t & 0x3F;
            hvcc.numNalus[j] = reader.getU16();
            hvcc.nalUnitLength[j] = new int[hvcc.numNalus[j]];
            hvcc.nalUnit[j] = new byte[hvcc.numNalus[j]][];
            for (int i = 0; i < hvcc.numNalus[j]; ++i) {
                hvcc.nalUnitLength[j][i] = reader.getU16();
                byte[] nd = new byte[hvcc.nalUnitLength[j][i]];
                reader.read(nd);
                hvcc.nalUnit[j][i] = nd;
            }
        }
        return hvcc;
    }
}

