/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heif;

import com.idrsolutions.image.Decoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.JDeliImageSupport;
import com.idrsolutions.image.heif.box.BoxReader;
import com.idrsolutions.image.heif.box.HeifFile;
import com.idrsolutions.image.heif.box.ISPE;
import com.idrsolutions.image.utility.DataByteBig;
import com.idrsolutions.image.utility.DataFileBig;
import com.idrsolutions.image.utility.DataReader;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

public class HeifDecoder
extends JDeliImage
implements Decoder {
    @Override
    public BufferedImage read(byte[] data) throws Exception {
        DataByteBig reader = new DataByteBig(data);
        return JDeliImageSupport.optimiseImage(HeifDecoder.grabImage(reader));
    }

    @Override
    public BufferedImage read(File file) throws Exception {
        DataFileBig reader = new DataFileBig(file);
        BufferedImage image = HeifDecoder.grabImage(reader);
        reader.close();
        return JDeliImageSupport.optimiseImage(image);
    }

    private static BufferedImage grabImage(DataReader reader) throws IOException {
        HeifFile info = new HeifFile();
        BoxReader.readBoxes(reader, info);
        if (info.mdat != null) {
            ISPE ispe = info.meta.iprp.ipco.ispe;
            BufferedImage image = new BufferedImage(ispe.imageWidth, ispe.imageHeight, 4);
            System.out.println("image is found offset: " + info.mdat.offset + " 0x" + Integer.toHexString(info.mdat.offset) + " len: " + info.mdat.length);
            info.extract(reader);
            return image;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        File file = new File("C:\\Users\\suda\\OneDrive\\Pictures\\heif\\lena.heic");
        HeifDecoder dec = new HeifDecoder();
        dec.read(file);
    }
}

