/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sequelink.columns;

import java.io.IOException;
import java.sql.SQLException;
import macromedia.jdbc.sequelink.columns.SequeLinkColumn;
import macromedia.jdbc.slbase.BaseColumn;
import macromedia.jdbc.slbase.BaseColumns;
import macromedia.jdbc.slbase.BaseData;
import macromedia.sequelink.ssp.DiagnosticList;
import macromedia.sequelink.ssp.SspInputStream;
import macromedia.sequelink.util.UnSyncVector;
import macromedia.sequelink.variables.CursorVariables;
import macromedia.slutil.UtilException;

public class SequeLinkColumns
extends BaseColumns
implements CursorVariables {
    private boolean containsLongColumns;
    private boolean containsNormalColumns;
    private UnSyncVector normalColumns;

    public void add(BaseColumn baseColumn) {
        SequeLinkColumn sequeLinkColumn = (SequeLinkColumn)baseColumn;
        if (sequeLinkColumn.isLong()) {
            this.containsLongColumns = true;
        } else if (!sequeLinkColumn.isPseudo()) {
            this.containsNormalColumns = true;
        }
        super.add(baseColumn);
    }

    public boolean containsLongColumns() {
        return this.containsLongColumns;
    }

    public boolean containsNormalColumns() {
        return this.containsNormalColumns;
    }

    public UnSyncVector getNormalColumns() {
        if (this.normalColumns != null) {
            return this.normalColumns;
        }
        int n = this.count(0);
        this.normalColumns = new UnSyncVector();
        for (int i = 1; i <= n; ++i) {
            SequeLinkColumn sequeLinkColumn = (SequeLinkColumn)this.get(i);
            if (sequeLinkColumn.isLong() || sequeLinkColumn.isPseudo()) continue;
            this.normalColumns.addElement(sequeLinkColumn);
        }
        return this.normalColumns;
    }

    public void clearData() {
        int n = this.count(0);
        for (int i = 1; i <= n; ++i) {
            SequeLinkColumn sequeLinkColumn = (SequeLinkColumn)this.get(i);
            sequeLinkColumn.clearData();
        }
    }

    public void readNormalVariablesFromStream(SspInputStream sspInputStream) throws IOException, SQLException, UtilException {
        int n = this.count(0);
        for (int i = 1; i <= n; ++i) {
            SequeLinkColumn sequeLinkColumn = (SequeLinkColumn)this.get(i);
            if (sequeLinkColumn.isLong() || sequeLinkColumn.isPseudo()) continue;
            sequeLinkColumn.readObjectAndIndicatorFrom(sspInputStream);
        }
    }

    public BaseData getData(int n, int n2, int n3, DiagnosticList diagnosticList) throws SQLException {
        SequeLinkColumn sequeLinkColumn = (SequeLinkColumn)this.get(n);
        return sequeLinkColumn.getData(n2, n3, diagnosticList);
    }

    public void cacheData(int n, int n2, DiagnosticList diagnosticList) throws SQLException {
        SequeLinkColumn sequeLinkColumn = (SequeLinkColumn)this.get(n);
        sequeLinkColumn.cacheData(n2, diagnosticList);
    }

    public void clearCache() {
        int n = this.count(0);
        for (int i = 1; i <= n; ++i) {
            SequeLinkColumn sequeLinkColumn = (SequeLinkColumn)this.get(i);
            sequeLinkColumn.clearCache();
        }
    }

    public void cleanUp() {
        int n = this.count(0);
        for (int i = 1; i <= n; ++i) {
            SequeLinkColumn sequeLinkColumn = (SequeLinkColumn)this.get(i);
            sequeLinkColumn.cleanUp();
        }
    }
}

