/*
 * Decompiled with CFR 0.152.
 */
package com.ddtek.pool;

import com.ddtek.pool.ConnectionPool;
import com.ddtek.pool.ConnectionPoolMaintenance;
import com.ddtek.pool.ConnectionPoolShutdown;
import com.ddtek.pool.PooledConnectionDataSource;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.sql.ConnectionPoolDataSource;

class ConnectionPoolGroup {
    private static String footprint = "$Revision: #1 $";
    private Hashtable pools = new Hashtable();
    private String name;
    private ConnectionPoolMaintenance maintenance;
    private int initialPoolSize;
    private int minPoolSize;
    private int maxPoolSize;
    private long maxIdleTime;
    private long propertyCycle;
    private ConnectionPoolDataSource cpds;
    private boolean tracing;
    private boolean logTimestamp;
    private boolean logTName;
    private String reauthentication;
    private String maxPoolSizeBehavior;

    ConnectionPoolGroup(PooledConnectionDataSource pooledConnectionDataSource) throws SQLException {
        this.initialPoolSize = pooledConnectionDataSource.getInitialPoolSize();
        this.minPoolSize = pooledConnectionDataSource.getMinPoolSize();
        this.maxPoolSize = pooledConnectionDataSource.getMaxPoolSize();
        this.maxIdleTime = pooledConnectionDataSource.getMaxIdleTime() * 1000;
        this.propertyCycle = pooledConnectionDataSource.getPropertyCycle() * 1000;
        this.tracing = pooledConnectionDataSource.isTracing();
        this.logTimestamp = pooledConnectionDataSource.getLogTimestamp();
        this.logTName = pooledConnectionDataSource.getLogTName();
        this.name = pooledConnectionDataSource.getPoolName();
        this.reauthentication = pooledConnectionDataSource.getReauthentication();
        this.maxPoolSizeBehavior = pooledConnectionDataSource.getMaxPoolSizeBehavior();
        if (this.name == null) {
            this.name = pooledConnectionDataSource.getDataSourceName();
        }
        this.cpds = pooledConnectionDataSource.getCpds();
        try {
            ConnectionPoolShutdown connectionPoolShutdown = new ConnectionPoolShutdown(this);
            Runtime.getRuntime().addShutdownHook(connectionPoolShutdown);
        }
        catch (NoSuchMethodError noSuchMethodError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized ConnectionPool getConnectionPool(String string, String string2, String string3) throws SQLException {
        ConnectionPool connectionPool = (ConnectionPool)this.pools.get(string3);
        if (connectionPool == null) {
            connectionPool = "".equals(string) ? new ConnectionPool(this.name, this.cpds, this.initialPoolSize, this.minPoolSize, this.maxPoolSize, this.tracing, this.reauthentication, this.maxPoolSizeBehavior) : new ConnectionPool(this.name, this.cpds, this.initialPoolSize, this.minPoolSize, this.maxPoolSize, this.tracing, this.reauthentication, this.maxPoolSizeBehavior, string, string2);
            this.pools.put(string3, connectionPool);
            if (this.tracing) {
                connectionPool.setTracing(true);
            }
            connectionPool.setLogTimestamp(this.logTimestamp);
            connectionPool.setLogTName(this.logTName);
            if (this.maintenance == null) {
                this.maintenance = new ConnectionPoolMaintenance(this, this.propertyCycle);
                this.maintenance.start();
            }
        }
        return connectionPool;
    }

    synchronized void doMaintenance() {
        boolean bl = true;
        for (ConnectionPool connectionPool : this.pools.values()) {
            connectionPool.doMaintenance(this.maxIdleTime);
            if (connectionPool.isEmpty()) {
                this.pools.remove(connectionPool);
                continue;
            }
            bl = false;
        }
        if (bl) {
            this.maintenance.stopMaintenance();
            this.maintenance = null;
        }
    }

    synchronized void close() {
        if (this.maintenance != null) {
            this.maintenance.stopMaintenance();
            this.maintenance = null;
        }
        for (ConnectionPool connectionPool : this.pools.values()) {
            connectionPool.close();
        }
    }
}

