/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger;

import coldfusion.debugger.BreakPointHandler;
import coldfusion.debugger.CFDebuggerLogger;
import coldfusion.debugger.CFJVMDebugManager;
import coldfusion.debugger.ClassMethodLineTableCache;
import coldfusion.debugger.ExceptionBreakpointHandler;
import coldfusion.debugger.StepEventHandler;
import com.sun.jdi.ClassType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;

public class VMEventManager
extends Thread {
    EventQueue queue = null;
    boolean stop = false;
    CFJVMDebugManager debugManager = null;
    boolean methodExistFilterSet = false;
    boolean dummyBPSet = false;
    private ExceptionBreakpointHandler excpBPHandler;

    public VMEventManager(EventQueue queue, CFJVMDebugManager debugManager) {
        this.queue = queue;
        this.debugManager = debugManager;
        this.setDaemon(true);
        this.excpBPHandler = new ExceptionBreakpointHandler(debugManager);
    }

    public void stopEventManager() {
        this.stop = true;
    }

    @Override
    public void run() {
        EventSet eventSet = null;
        do {
            try {
                eventSet = this.queue.remove();
                this.processEvents(eventSet);
            }
            catch (VMDisconnectedException vmde) {
                break;
            }
            catch (Throwable e) {
                CFDebuggerLogger.log(e);
            }
        } while (!(eventSet instanceof VMDisconnectEvent) && !this.stop);
    }

    public void processEvents(final EventSet eventSet) {
        if (eventSet.size() > 0) {
            Thread eventProcessThread = new Thread(){

                @Override
                public void run() {
                    for (Event evt : eventSet) {
                        try {
                            VMEventManager.this.consumeEvent(evt);
                        }
                        catch (Throwable e) {
                            ThreadReference th;
                            if (evt instanceof LocatableEvent && ((th = ((LocatableEvent)evt).thread()).isAtBreakpoint() || th.isSuspended())) {
                                th.resume();
                            }
                            CFDebuggerLogger.log(e);
                        }
                    }
                }
            };
            eventProcessThread.start();
        }
    }

    public void consumeEvent(Event evt) throws Throwable {
        if (evt instanceof BreakpointEvent) {
            BreakpointEvent bpe = (BreakpointEvent)evt;
            BreakPointHandler bph = new BreakPointHandler(bpe, this.debugManager);
            bph.handleEvent(evt, null);
        } else if (evt instanceof StepEvent) {
            StepEvent se = (StepEvent)evt;
            StepEventHandler seh = new StepEventHandler(se, this.debugManager);
            seh.handleEvent(evt, null);
        } else if (evt instanceof ClassPrepareEvent) {
            ClassPrepareEvent cpe = (ClassPrepareEvent)evt;
            ReferenceType type = cpe.referenceType();
            if (type instanceof ClassType) {
                String superName;
                ClassType aClass = (ClassType)type;
                String className = aClass.name();
                if (!this.dummyBPSet && className.equals("coldfusion.debug.DummyDeubgRequestHandler")) {
                    this.debugManager.setDummpyRequestEndBP();
                    this.dummyBPSet = true;
                    return;
                }
                ClassType superClass = aClass.superclass();
                if (superClass != null && ((superName = superClass.name()).equals("coldfusion.runtime.CFPage") || superName.equals("coldfusion.runtime.UDFMethod"))) {
                    this.debugManager.setBreakpointsOnClassPrepare(className, aClass);
                    ClassMethodLineTableCache.removeClass(className);
                }
            }
            cpe.thread().resume();
        } else if (!(evt instanceof ClassUnloadEvent)) {
            if (evt instanceof VMDisconnectEvent || evt instanceof VMDeathEvent) {
                this.debugManager.onVMDisconnected(evt);
            } else if (evt instanceof ExceptionEvent) {
                if (!this.debugManager.isBreakOnException()) {
                    ((ExceptionEvent)evt).thread().resume();
                } else {
                    this.excpBPHandler.handleEvent(evt, null);
                }
            }
        }
    }
}

