/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sharepoint;

import coldfusion.runtime.Array;
import coldfusion.runtime.ArrayUtil;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.CFNumber;
import coldfusion.runtime.Cast;
import coldfusion.runtime.StringFunc;
import coldfusion.runtime.Struct;
import coldfusion.tagext.net.sharepoint.SharepointExceptions;
import coldfusion.xml.XmlNodeList;
import coldfusion.xml.rpc.ServiceProxy;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axis.encoding.MixedContentType;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.UnsignedInt;
import org.apache.axis.utils.bytecode.ParamReader;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SharepointUtils {
    private Struct rootStruct = null;
    private Node rootNode = null;
    private static Set<String> EXTRAKEYSSET = SharepointUtils.getExtraKeysSet();

    public SharepointUtils() {
    }

    public SharepointUtils(Node n) {
        this.rootNode = n;
        this.rootStruct = new Struct();
        this.populateNodeInfo(this.rootStruct, this.rootNode);
    }

    public Struct constructResultStruct() {
        Struct parentStruct = this.rootStruct;
        this.bfs(this.rootNode, parentStruct);
        return this.rootStruct;
    }

    private void bfs(Node rootNode, Struct parentStruct) {
        Struct curr;
        LinkedList<Node> BFSLinkedList = new LinkedList<Node>();
        LinkedList<Struct> structLinkedList = new LinkedList<Struct>();
        boolean hasChanged = false;
        while ((curr = this.createStructNode(rootNode)) == null) {
            hasChanged = true;
            if ((rootNode = rootNode.getFirstChild()) != null) continue;
            return;
        }
        if (hasChanged) {
            this.populateNodeInfo(parentStruct, rootNode);
        }
        this.addStructToParent(rootNode, curr, parentStruct, true);
        BFSLinkedList.addLast(rootNode);
        structLinkedList.addLast(parentStruct);
        while (BFSLinkedList.size() != 0 && structLinkedList.size() != 0) {
            Node node = (Node)BFSLinkedList.removeFirst();
            parentStruct = (Struct)structLinkedList.removeFirst();
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node n;
                boolean isTextNode = false;
                Node childNode = childNodes.item(i);
                String nodeValue = childNode.getNodeValue();
                nodeValue = nodeValue == null ? nodeValue : nodeValue.trim();
                curr = this.createStructNode(childNode);
                Node node2 = nodeValue == null ? childNode : (n = nodeValue.length() > 0 ? childNode.getParentNode() : null);
                if (n != null && curr != null) {
                    boolean isRoot = n.equals(rootNode) || this.isRoot(n);
                    this.addStructToParent(n, curr, parentStruct, isRoot);
                    BFSLinkedList.addLast(childNode);
                }
                NodeList grandChildNodes = childNode.getChildNodes();
                for (int j = 0; j < grandChildNodes.getLength() && (isTextNode = this.isTextNode(grandChildNodes.item(j))); ++j) {
                }
                if (isTextNode && parentStruct != null) {
                    structLinkedList.addLast(parentStruct);
                    continue;
                }
                if (curr == null) continue;
                structLinkedList.addLast(curr);
            }
        }
    }

    private boolean isTextNode(Node n) {
        return n != null && (n.getNodeType() == 3 || n.getNodeType() == 4);
    }

    private void populateNodeInfo(Struct struct, Node node) {
        struct.put((Object)"_CF_STRUCT_NAME", (Object)node.getLocalName());
        struct.put((Object)"NODE_HASHCODE", (Object)node.hashCode());
    }

    private void addStructToParent(Node n, Struct curr, Struct parentStruct, boolean isRoot) {
        if (isRoot) {
            this.rootStruct.putAll((Map)curr);
        } else if (this.isNodeStruct(n.getParentNode(), parentStruct)) {
            this.addChildStruct(n, curr, parentStruct);
        }
    }

    private boolean isRoot(Node n) {
        return n.getParentNode().getNodeName().equals("#document");
    }

    private void addChildStruct(Node n, Struct curr, Struct parentStruct) {
        String key = (String)parentStruct.get((Object)"_CF_STRUCT_NAME");
        Object obj = parentStruct.get((Object)key);
        if (obj != null) {
            Array newChildrenArray = new Array();
            if (obj instanceof Struct) {
                if (this.isNodeStruct(n, (Struct)obj)) {
                    this.copyNodeValue((Struct)obj, curr);
                } else {
                    ArrayUtil.ArrayAppend((List)newChildrenArray, (Object)obj);
                    ArrayUtil.ArrayAppend((List)newChildrenArray, (Object)curr);
                    parentStruct.put((Object)key, (Object)newChildrenArray);
                }
            } else if (obj instanceof Array) {
                Array arr = (Array)obj;
                boolean structNodeFound = false;
                for (Object o : arr) {
                    Struct s = (Struct)o;
                    if (!this.isNodeStruct(n, s)) continue;
                    structNodeFound = true;
                    this.copyNodeValue(s, curr);
                    break;
                }
                if (!structNodeFound) {
                    ArrayUtil.ArrayAppend((List)((Array)obj), (Object)curr);
                }
            } else if (obj.toString().equals(">")) {
                parentStruct.put((Object)key, (Object)curr);
            } else {
                SharepointExceptions.throwInvalidObjectInStructException();
            }
        } else {
            parentStruct.put((Object)key, (Object)curr);
        }
    }

    private void copyNodeValue(Struct orig, Struct curr) {
        Object nodeName = orig.get((Object)"_CF_STRUCT_NAME");
        if (nodeName != null && orig.get(nodeName) == null) {
            orig.put(nodeName, curr.get(nodeName));
        }
    }

    private Struct createStructNode(Node node) {
        String nodeValue = node.getNodeValue();
        Struct curr = null;
        if (nodeValue == null) {
            curr = this.populateNodesWithAttrs(node);
        } else if (nodeValue.trim().length() > 0) {
            curr = this.populateNodesWithValues(node);
        }
        return curr;
    }

    private boolean isNodeStruct(Node n, Struct rootStruct) {
        String structNodeName = (String)rootStruct.get((Object)"_CF_STRUCT_NAME");
        int structHashcode = (Integer)rootStruct.get((Object)"NODE_HASHCODE");
        int nodeHashcode = n.hashCode();
        String nodeName = n.getLocalName();
        boolean isNameEqual = nodeName.equals(structNodeName);
        boolean isHashcodeEqual = structHashcode == nodeHashcode;
        return isNameEqual && isHashcodeEqual;
    }

    private Struct populateNodesWithAttrs(Node n) {
        Struct curr = new Struct();
        String nodeName = n.getLocalName();
        curr.put((Object)"_CF_STRUCT_NAME", (Object)nodeName);
        curr.put((Object)"NODE_HASHCODE", (Object)n.hashCode());
        NamedNodeMap attributes = n.getAttributes();
        if (attributes != null) {
            Node attribute;
            if (attributes.getLength() == 1 && this.isNameSpaceAttribute(attribute = attributes.item(0), n) && n.getChildNodes().getLength() <= 1) {
                return null;
            }
            this.populateAttributes(curr, attributes, n);
        }
        return curr;
    }

    private boolean isNameSpaceAttribute(Node attributeNode, Node parentNode) {
        String attributeVal;
        return attributeNode != null && (attributeVal = attributeNode.getNodeValue()) != null && attributeVal.equals(parentNode.getNamespaceURI());
    }

    public void populateAttributes(Struct curr, NamedNodeMap attributes, Node n) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attributeValue;
            Node attrNode = attributes.item(i);
            String nodeName = attrNode.getNodeName();
            if (this.isNameSpaceAttribute(attrNode, n) || (attributeValue = attrNode.getNodeValue()) == null) continue;
            curr.put((Object)nodeName, (Object)StringFunc.REReplace((String)attributeValue, (String)"[1-99]+;#", (Object)"", (String)"ONE", (boolean)false));
        }
    }

    private Struct populateNodesWithValues(Node n) {
        Struct curr = new Struct();
        String nodeValue = n.getNodeValue();
        if (n.getNodeType() == 3 || n.getNodeType() == 4) {
            Node parentNode = n.getParentNode();
            int hashCode = parentNode.hashCode();
            String parentNodeName = parentNode.getLocalName();
            curr.put((Object)"_CF_STRUCT_NAME", (Object)parentNodeName);
            curr.put((Object)"NODE_HASHCODE", (Object)hashCode);
            curr.put((Object)parentNodeName, (Object)StringFunc.REReplace((String)nodeValue, (String)"[1-99]+;#", (Object)"", (String)"ONE", (boolean)false));
        }
        return curr;
    }

    public void cleanUpStruct(Struct curr) {
        LinkedList<Struct> list = new LinkedList<Struct>();
        list.addLast(curr);
        while (list.size() > 0) {
            Struct temp = (Struct)list.removeFirst();
            String childNodeName = (String)temp.get((Object)"_CF_STRUCT_NAME");
            if (childNodeName == null) {
                return;
            }
            Object childNode = temp.get((Object)childNodeName);
            if (childNode instanceof Struct) {
                Struct node = (Struct)childNode;
                if (this.isExtraNode(node)) {
                    temp.remove((Object)childNodeName);
                } else {
                    list.addLast(node);
                }
            } else if (childNode instanceof Array) {
                Array arr = (Array)childNode;
                Array extraNodesArr = new Array();
                for (Object ob : arr) {
                    if (!(ob instanceof Struct)) continue;
                    Struct node = (Struct)ob;
                    if (this.isExtraNode(node)) {
                        extraNodesArr.add((Object)node);
                        continue;
                    }
                    list.addLast((Struct)ob);
                }
                arr.removeAll((Collection)extraNodesArr);
            }
            this.removeExtraNodes(temp);
        }
    }

    private void removeExtraNodes(Struct curr) {
        Iterator itr = curr.keySet().iterator();
        while (itr.hasNext()) {
            String structKey = (String)itr.next();
            if (!EXTRAKEYSSET.contains(structKey)) continue;
            itr.remove();
        }
    }

    private static Set<String> getExtraKeysSet() {
        HashSet<String> extraKeysSet = new HashSet<String>();
        extraKeysSet.add("_CF_STRUCT_NAME");
        extraKeysSet.add("NODE_HASHCODE");
        return extraKeysSet;
    }

    private boolean isExtraNode(Struct curr) {
        Set keys = curr.keySet();
        return keys.size() == 2 && keys.containsAll(EXTRAKEYSSET);
    }

    public Map<String, Object> modifyParamValues(String action, ServiceProxy proxy, Map<String, Object> params) {
        Class[] classes = proxy.getOperationParamClasses(action, params.size());
        String[] paramNames = proxy.getOperationParamNames(action, params.size());
        if (classes == null || paramNames == null) {
            return params;
        }
        for (int i = 0; i < classes.length; ++i) {
            Object obj;
            Class clazz = classes[i];
            if (this.isBoolean(clazz)) {
                obj = params.get(paramNames[i]);
                if (!(obj instanceof CFBoolean)) continue;
                params.put(paramNames[i], ((CFBoolean)obj).value);
                continue;
            }
            if (this.isXmlInput(clazz)) {
                this.updateXmlInputValues(params, paramNames[i], clazz);
                continue;
            }
            if (this.isStringArray(clazz)) {
                this.updateStringArrayValues(params, paramNames[i], clazz);
                continue;
            }
            if (this.isUnsignedInt(clazz)) {
                this.updateUnsignedIntValues(params, paramNames[i], clazz);
                continue;
            }
            if (this.isUnsignedIntArray(clazz)) {
                this.updateUnsignedIntArrValues(params, paramNames[i], clazz);
                continue;
            }
            if (clazz != String.class || !((obj = params.get(paramNames[i])) instanceof CFBoolean) && !(obj instanceof CFNumber)) continue;
            params.put(paramNames[i], obj.toString());
        }
        return params;
    }

    private boolean isXmlInput(Class clazz) {
        Class<?>[] interfaces;
        for (Class<?> iface : interfaces = clazz.getInterfaces()) {
            if (!iface.getName().equals("org.apache.axis.encoding.MixedContentType") && !iface.getName().equals("org.apache.axis.encoding.AnyContentType")) continue;
            return true;
        }
        return false;
    }

    private boolean isStringArray(Class clazz) {
        return clazz.getSimpleName().equals("ArrayOfString");
    }

    private boolean isUnsignedIntArray(Class clazz) {
        return clazz.getSimpleName().equals("ArrayOfUnsignedInt");
    }

    private boolean isUnsignedInt(Class clazz) {
        return clazz.getName().equals("org.apache.axis.types.UnsignedInt");
    }

    private boolean isBoolean(Class clazz) {
        return clazz == Boolean.class || clazz == Boolean.TYPE;
    }

    private void updateXmlInputValues(Map<String, Object> params, String key, Class clazz) {
        Object obj = params.get(key);
        if (obj instanceof XmlNodeList || obj instanceof String && ((String)obj).length() == 0) {
            MessageElement[] elem = null;
            if (obj instanceof XmlNodeList) {
                obj = ((XmlNodeList)obj).getNode(0);
                elem = new MessageElement[]{new MessageElement(((Document)obj).getDocumentElement())};
            }
            try {
                Object o = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (o instanceof MixedContentType) {
                    ((MixedContentType)o).set_any(elem);
                } else {
                    Method method = clazz.getMethod("set_any", MessageElement[].class);
                    if (method != null) {
                        method.invoke(o, new Object[]{elem});
                    }
                }
                params.put(key, o);
            }
            catch (Exception e) {
                SharepointExceptions.throwGenericSharepointException(e);
            }
        } else {
            SharepointExceptions.throwInvalidInputTypeException(key, "XmlNodeList");
        }
    }

    private void updateStringArrayValues(Map<String, Object> params, String key, Class clazz) {
        String[] strArray = null;
        Object modifiedParam = null;
        Object value = params.get(key);
        if (value instanceof Array) {
            Array arr = (Array)value;
            strArray = new String[arr.size()];
            int i = 0;
            for (Object ob : arr) {
                if (ob instanceof String) {
                    strArray[i] = (String)ob;
                    ++i;
                    continue;
                }
                if (ob instanceof CFBoolean) {
                    strArray[i] = Cast._String((CFBoolean)((CFBoolean)ob));
                    continue;
                }
                if (ob instanceof Number) {
                    strArray[i] = Cast._String(ob);
                    continue;
                }
                SharepointExceptions.throwInvalidInputTypeException(key, "String Array");
            }
        } else {
            SharepointExceptions.throwInvalidInputTypeException(key, "String Array");
        }
        Object[] objArr = new Object[]{strArray};
        Class[] classArr = new Class[1];
        if (strArray != null) {
            classArr[0] = strArray.getClass();
        }
        try {
            modifiedParam = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method method = clazz.getMethod("setString", classArr);
            method.invoke(modifiedParam, objArr);
        }
        catch (Exception e) {
            SharepointExceptions.throwGenericSharepointException(e);
        }
        params.put(key, modifiedParam);
    }

    private void updateUnsignedIntArrValues(Map<String, Object> params, String key, Class clazz) {
        UnsignedInt[] intArray = null;
        Object modifiedParam = null;
        Object value = params.get(key);
        if (value instanceof Array) {
            Array arr = (Array)value;
            intArray = new UnsignedInt[arr.size()];
            int i = 0;
            for (Object ob : arr) {
                if (ob instanceof String || ob instanceof CFBoolean || ob instanceof Number || ob instanceof Boolean) {
                    try {
                        intArray[i] = (UnsignedInt)this.convertToUnsignedInt(UnsignedInt.class, ob);
                        ++i;
                    }
                    catch (Exception e) {
                        SharepointExceptions.throwInvalidInputTypeException(key, "UnsignedInt Array", e);
                    }
                    continue;
                }
                SharepointExceptions.throwInvalidInputTypeException(key, "UnsignedInt Array");
            }
        } else {
            SharepointExceptions.throwInvalidInputTypeException(key, "UnsignedInt Array");
        }
        Object[] objArr = new Object[]{intArray};
        Class[] classArr = new Class[1];
        if (intArray != null) {
            classArr[0] = intArray.getClass();
        }
        try {
            modifiedParam = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method method = clazz.getMethod("setUnsignedInt", classArr);
            method.invoke(modifiedParam, objArr);
        }
        catch (Exception e) {
            SharepointExceptions.throwGenericSharepointException(e);
        }
        params.put(key, modifiedParam);
    }

    private void updateUnsignedIntValues(Map<String, Object> params, String key, Class clazz) {
        Object val = params.get(key);
        try {
            Object modifiedParam = this.convertToUnsignedInt(clazz, val);
            params.put(key, modifiedParam);
        }
        catch (Exception e) {
            SharepointExceptions.throwGenericSharepointException(e);
        }
    }

    private Object convertToUnsignedInt(Class clazz, Object val) throws Exception {
        Object modifiedParam = null;
        if (val instanceof String || val instanceof CFBoolean || val instanceof Number || val instanceof Boolean) {
            long longVal = Cast._long((Object)val);
            Object[] objArr = new Object[]{longVal};
            Class[] classes = new Class[]{Long.TYPE};
            modifiedParam = clazz.newInstance();
            Method method = clazz.getMethod("setValue", classes);
            method.invoke(modifiedParam, objArr);
        }
        return modifiedParam;
    }

    public void verifyParams(Object service, String action, Map<String, Object> params) {
        Method[] methods;
        Class<?> serviceClass = service.getClass();
        for (Method method : methods = serviceClass.getMethods()) {
            if (!method.getName().equalsIgnoreCase(action) || !method.getDeclaringClass().getName().equals(serviceClass.getName())) continue;
            try {
                ParamReader preader = new ParamReader(serviceClass);
                String[] paramStrArray = preader.getParameterNames(method);
                if (paramStrArray == null) {
                    if (params.size() == 0) continue;
                    SharepointExceptions.throwExcessParamsException(action);
                    continue;
                }
                if (params.size() != paramStrArray.length) {
                    SharepointExceptions.throwInvalidParamsException(paramStrArray, action);
                    continue;
                }
                this.verifyParamNames(params, paramStrArray, action);
            }
            catch (IOException e) {
                SharepointExceptions.throwGenericSharepointException(e.getClass().getName(), e.getMessage());
            }
        }
    }

    private void verifyParamNames(Map<String, Object> params, String[] paramNamesArray, String action) {
        ArrayList<String> paramList = new ArrayList<String>();
        for (String paramName : paramNamesArray) {
            paramList.add(paramName.toUpperCase());
        }
        ArrayList<String> cfparamList = new ArrayList<String>();
        for (String cfParam : params.keySet()) {
            cfparamList.add(cfParam.toUpperCase());
        }
        if (!paramList.containsAll(cfparamList)) {
            SharepointExceptions.throwInvalidParamsException(paramNamesArray, action);
        }
    }
}

