/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.SpellCheckMergeData;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.spelling.SolrSpellChecker;
import org.apache.solr.spelling.SpellingOptions;
import org.apache.solr.spelling.SpellingResult;

public class ConjunctionSolrSpellChecker
extends SolrSpellChecker {
    private StringDistance stringDistance = null;
    private Float accuracy = null;
    private String dictionaryName = null;
    private Analyzer queryAnalyzer = null;
    private List<SolrSpellChecker> checkers = new ArrayList<SolrSpellChecker>();
    private boolean initialized = false;

    public void addChecker(SolrSpellChecker checker) {
        if (this.initialized) {
            throw new IllegalStateException("Need to add checkers before calling init()");
        }
        try {
            if (this.stringDistance == null) {
                this.stringDistance = checker.getStringDistance();
            } else if (this.stringDistance != checker.getStringDistance()) {
                throw new IllegalArgumentException("All checkers need to use the same StringDistance.");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            if (this.accuracy == null) {
                this.accuracy = Float.valueOf(checker.getAccuracy());
            } else if (this.accuracy.floatValue() != checker.getAccuracy()) {
                throw new IllegalArgumentException("All checkers need to use the same Accuracy.");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (this.queryAnalyzer == null) {
            this.queryAnalyzer = checker.getQueryAnalyzer();
        } else if (this.queryAnalyzer != checker.getQueryAnalyzer()) {
            throw new IllegalArgumentException("All checkers need to use the same Analyzer.");
        }
        this.checkers.add(checker);
    }

    @Override
    public String init(NamedList config, SolrCore core) {
        for (int i = 0; i < this.checkers.size(); ++i) {
            SolrSpellChecker c = this.checkers.get(i);
            String dn = c.init(config, core);
            if (this.dictionaryName != null && !this.dictionaryName.equals(dn)) {
                throw new IllegalArgumentException("Cannot have more than one dictionary. (" + dn + " , " + this.dictionaryName + ")");
            }
            this.dictionaryName = dn;
        }
        if (this.dictionaryName == null) {
            this.dictionaryName = "default";
        }
        this.initialized = true;
        return this.dictionaryName;
    }

    @Override
    public void build(SolrCore core, SolrIndexSearcher searcher) throws IOException {
        for (SolrSpellChecker c : this.checkers) {
            c.build(core, searcher);
        }
    }

    @Override
    public SpellingResult getSuggestions(SpellingOptions options) throws IOException {
        SpellingResult[] results = new SpellingResult[this.checkers.size()];
        for (int i = 0; i < this.checkers.size(); ++i) {
            results[i] = this.checkers.get(i).getSuggestions(options);
        }
        return this.mergeCheckers(results, options.count);
    }

    @Override
    public SpellingResult mergeSuggestions(SpellCheckMergeData mergeData, int numSug, int count, boolean extendedResults) {
        SpellingResult[] results = new SpellingResult[this.checkers.size()];
        for (int i = 0; i < this.checkers.size(); ++i) {
            results[i] = this.checkers.get(i).mergeSuggestions(mergeData, numSug, count, extendedResults);
        }
        return this.mergeCheckers(results, numSug);
    }

    private SpellingResult mergeCheckers(SpellingResult[] results, int numSug) {
        HashMap<Token, Integer> combinedTokenFrequency = new HashMap<Token, Integer>();
        LinkedHashMap<Token, ArrayList<LinkedHashMap<String, Integer>>> allSuggestions = new LinkedHashMap<Token, ArrayList<LinkedHashMap<String, Integer>>>();
        for (SpellingResult result : results) {
            if (result.getTokenFrequency() != null) {
                combinedTokenFrequency.putAll(result.getTokenFrequency());
            }
            for (Map.Entry<Token, LinkedHashMap<String, Integer>> entry : result.getSuggestions().entrySet()) {
                ArrayList<LinkedHashMap<String, Integer>> allForThisToken = (ArrayList<LinkedHashMap<String, Integer>>)allSuggestions.get(entry.getKey());
                if (allForThisToken == null) {
                    allForThisToken = new ArrayList<LinkedHashMap<String, Integer>>();
                    allSuggestions.put(entry.getKey(), allForThisToken);
                }
                allForThisToken.add(entry.getValue());
            }
        }
        SpellingResult combinedResult = new SpellingResult();
        block2: for (Map.Entry entry : allSuggestions.entrySet()) {
            Token original = (Token)entry.getKey();
            ArrayList corrIters = new ArrayList(((List)entry.getValue()).size());
            for (LinkedHashMap corrections : (List)entry.getValue()) {
                corrIters.add(corrections.entrySet().iterator());
            }
            int numberAdded = 0;
            while (numberAdded < numSug) {
                boolean anyData = false;
                for (Iterator iterator : corrIters) {
                    if (!iterator.hasNext()) continue;
                    anyData = true;
                    Map.Entry corr = (Map.Entry)iterator.next();
                    combinedResult.add(original, (String)corr.getKey(), (Integer)corr.getValue());
                    Integer tokenFrequency = (Integer)combinedTokenFrequency.get(original);
                    combinedResult.addFrequency(original, tokenFrequency == null ? 0 : tokenFrequency);
                    if (++numberAdded != numSug) continue;
                    break;
                }
                if (anyData) continue;
                if (numberAdded != 0) continue block2;
                combinedResult.add(original, Collections.emptyList());
                Integer tokenFrequency = (Integer)combinedTokenFrequency.get(original);
                combinedResult.addFrequency(original, tokenFrequency == null ? 0 : tokenFrequency);
                continue block2;
            }
        }
        return combinedResult;
    }

    @Override
    public void reload(SolrCore core, SolrIndexSearcher searcher) throws IOException {
        for (SolrSpellChecker c : this.checkers) {
            c.reload(core, searcher);
        }
    }

    @Override
    public Analyzer getQueryAnalyzer() {
        return this.queryAnalyzer;
    }

    @Override
    public String getDictionaryName() {
        return this.dictionaryName;
    }

    @Override
    protected float getAccuracy() {
        if (this.accuracy == null) {
            return super.getAccuracy();
        }
        return this.accuracy.floatValue();
    }

    @Override
    protected StringDistance getStringDistance() {
        if (this.stringDistance == null) {
            return super.getStringDistance();
        }
        return this.stringDistance;
    }

    @Override
    public boolean isSuggestionsMayOverlap() {
        return true;
    }
}

