/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.util.EntityUtils;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ContentStreamHandlerBase;
import org.apache.solr.logging.MDCUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.QueryResponseWriterUtil;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.AuthorizationResponse;
import org.apache.solr.servlet.ResponseUtils;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.apache.solr.servlet.SolrRequestParsers;
import org.apache.solr.servlet.cache.HttpCacheHeaderUtil;
import org.apache.solr.servlet.cache.Method;
import org.apache.solr.util.RTimer;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class HttpSolrCall {
    protected static Logger log = LoggerFactory.getLogger(HttpSolrCall.class);
    static final Random random;
    protected final SolrDispatchFilter solrDispatchFilter;
    protected final CoreContainer cores;
    protected final HttpServletRequest req;
    protected final HttpServletResponse response;
    protected final boolean retry;
    protected SolrCore core = null;
    protected SolrQueryRequest solrReq = null;
    protected SolrRequestHandler handler = null;
    protected final SolrParams queryParams;
    protected String path;
    protected SolrDispatchFilter.Action action;
    protected String coreUrl;
    protected SolrConfig config;
    protected Map<String, Integer> invalidStates;
    protected AuthorizationContext.RequestType requestType;
    protected List<String> collectionsList;
    static final String CONNECTION_HEADER = "Connection";
    static final String TRANSFER_ENCODING_HEADER = "Transfer-Encoding";
    static final String CONTENT_LENGTH_HEADER = "Content-Length";

    public AuthorizationContext.RequestType getRequestType() {
        return this.requestType;
    }

    public List<String> getCollectionsList() {
        return this.collectionsList;
    }

    public HttpSolrCall(SolrDispatchFilter solrDispatchFilter, CoreContainer cores, HttpServletRequest request, HttpServletResponse response, boolean retry) {
        this.solrDispatchFilter = solrDispatchFilter;
        this.cores = cores;
        this.req = request;
        this.response = response;
        this.retry = retry;
        this.requestType = AuthorizationContext.RequestType.UNKNOWN;
        this.queryParams = SolrRequestParsers.parseQueryString(this.req.getQueryString());
    }

    public String getPath() {
        return this.path;
    }

    public HttpServletRequest getReq() {
        return this.req;
    }

    public SolrCore getCore() {
        return this.core;
    }

    public SolrParams getQueryParams() {
        return this.queryParams;
    }

    private void init() throws Exception {
        int idx;
        String alternate;
        Aliases aliases = null;
        String corename = "";
        String origCorename = null;
        this.req.setAttribute("org.apache.solr.RequestTimer", (Object)new RTimer());
        this.req.setAttribute("org.apache.solr.CoreContainer", (Object)this.cores);
        this.path = this.req.getServletPath();
        if (this.req.getPathInfo() != null) {
            this.path = this.path + this.req.getPathInfo();
        }
        if ((alternate = this.cores.getManagementPath()) != null && this.path.startsWith(alternate)) {
            this.path = this.path.substring(0, alternate.length());
        }
        if ((idx = this.path.indexOf(58)) > 0) {
            this.path = this.path.substring(0, idx);
        }
        boolean usingAliases = false;
        this.handler = this.cores.getRequestHandler(this.path);
        if (this.handler != null) {
            this.solrReq = SolrRequestParsers.DEFAULT.parse(null, this.path, this.req);
            this.solrReq.getContext().put(CoreContainer.class.getName(), this.cores);
            this.requestType = AuthorizationContext.RequestType.ADMIN;
            this.action = SolrDispatchFilter.Action.ADMIN;
            return;
        }
        idx = this.path.indexOf("/", 1);
        if (idx > 1) {
            corename = this.path.substring(1, idx);
            if (this.cores.isZooKeeperAware()) {
                origCorename = corename;
                ZkStateReader reader = this.cores.getZkController().getZkStateReader();
                aliases = reader.getAliases();
                if (aliases != null && aliases.collectionAliasSize() > 0) {
                    usingAliases = true;
                    String alias = aliases.getCollectionAlias(corename);
                    if (alias != null) {
                        this.collectionsList = StrUtils.splitSmart((String)alias, (String)",", (boolean)true);
                        corename = this.collectionsList.get(0);
                    }
                }
            }
            this.core = this.cores.getCore(corename);
            if (this.core != null) {
                this.path = this.path.substring(idx);
            }
        }
        if (this.core == null && !this.cores.isZooKeeperAware()) {
            this.core = this.cores.getCore("");
        }
        if (this.core != null) {
            this.addMDCValues();
        }
        if (this.core == null && this.cores.isZooKeeperAware()) {
            this.core = this.getCoreByCollection(corename);
            if (this.core != null) {
                this.path = this.path.substring(idx);
                this.addMDCValues();
                if (this.collectionsList == null) {
                    this.collectionsList = new ArrayList<String>();
                }
                this.collectionsList.add(corename);
            }
            this.extractRemotePath(corename, origCorename, idx);
            if (this.action != null) {
                return;
            }
            if (this.core == null) {
                this.core = this.cores.getCore("");
                if (this.core != null) {
                    this.addMDCValues();
                }
            }
        }
        if (this.core != null) {
            this.config = this.core.getSolrConfig();
            SolrRequestParsers parser = this.config.getRequestParsers();
            this.extractHandlerFromURLPath(parser);
            if (this.action != null) {
                return;
            }
            if (this.handler != null) {
                if (this.solrReq == null) {
                    this.solrReq = parser.parse(this.core, this.path, this.req);
                }
                if (usingAliases) {
                    this.processAliases(aliases, this.collectionsList);
                }
                this.action = SolrDispatchFilter.Action.PROCESS;
                return;
            }
        }
        SolrDispatchFilter.log.debug("no handler or core retrieved for " + this.path + ", follow through...");
        this.action = SolrDispatchFilter.Action.PASSTHROUGH;
    }

    private void extractHandlerFromURLPath(SolrRequestParsers parser) throws Exception {
        if (this.handler == null && this.path.length() > 1) {
            this.handler = this.core.getRequestHandler(this.path);
            if (this.handler == null && (this.path.equals("/schema") || this.path.startsWith("/schema/"))) {
                this.solrReq = parser.parse(this.core, this.path, this.req);
                SolrRequestInfo.setRequestInfo(new SolrRequestInfo(this.solrReq, new SolrQueryResponse()));
                if (this.path.equals(this.req.getServletPath())) {
                    this.action = SolrDispatchFilter.Action.PASSTHROUGH;
                    return;
                }
                this.action = SolrDispatchFilter.Action.FORWARD;
                return;
            }
            if (this.handler == null && parser.isHandleSelect() && ("/select".equals(this.path) || "/select/".equals(this.path))) {
                this.solrReq = parser.parse(this.core, this.path, this.req);
                this.invalidStates = this.checkStateIsValid(this.solrReq.getParams().get("_stateVer_"));
                String qt = this.solrReq.getParams().get("qt");
                this.handler = this.core.getRequestHandler(qt);
                if (this.handler == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown handler: " + qt);
                }
                if (qt != null && qt.startsWith("/") && this.handler instanceof ContentStreamHandlerBase) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Request Handler ('qt').  Do not use /select to access: " + qt);
                }
            }
        }
    }

    private void extractRemotePath(String corename, String origCorename, int idx) throws UnsupportedEncodingException, KeeperException, InterruptedException {
        if (this.core == null && idx > 0) {
            this.coreUrl = this.getRemotCoreUrl(corename, origCorename);
            this.invalidStates = this.checkStateIsValid(this.queryParams.get("_stateVer_"));
            if (this.coreUrl != null && this.queryParams.get("update.distrib") == null) {
                this.path = this.path.substring(idx);
                if (this.invalidStates != null) {
                    throw new SolrException(SolrException.ErrorCode.INVALID_STATE, new String(ZkStateReader.toJSON(this.invalidStates), IOUtils.UTF_8));
                }
                this.action = SolrDispatchFilter.Action.REMOTEQUERY;
            } else if (!this.retry) {
                ZkStateReader reader = this.cores.getZkController().getZkStateReader();
                reader.updateAliases();
                this.action = SolrDispatchFilter.Action.RETRY;
            }
        }
    }

    public SolrDispatchFilter.Action call() throws IOException {
        MDCUtils.clearMDC();
        if (this.cores == null) {
            this.sendError(503, "Server is shutting down or failed to initialize");
            return SolrDispatchFilter.Action.RETURN;
        }
        if (this.cores.isZooKeeperAware()) {
            MDC.put((String)"node_name", (String)this.cores.getZkController().getNodeName());
        }
        if (this.solrDispatchFilter.abortErrorMessage != null) {
            this.sendError(500, this.solrDispatchFilter.abortErrorMessage);
            return SolrDispatchFilter.Action.RETURN;
        }
        try {
            this.init();
            if (this.cores.getAuthorizationPlugin() != null) {
                AuthorizationContext context = this.getAuthCtx();
                log.info(context.toString());
                AuthorizationResponse authResponse = this.cores.getAuthorizationPlugin().authorize(context);
                if (authResponse.statusCode != 202 && authResponse.statusCode != 200) {
                    this.sendError(authResponse.statusCode, "Unauthorized request, Response code: " + authResponse.statusCode);
                    return SolrDispatchFilter.Action.RETURN;
                }
            }
            HttpServletResponse resp = this.response;
            switch (this.action) {
                case ADMIN: {
                    this.handleAdminRequest();
                    return SolrDispatchFilter.Action.RETURN;
                }
                case REMOTEQUERY: {
                    this.remoteQuery(this.coreUrl + this.path, resp);
                    return SolrDispatchFilter.Action.RETURN;
                }
                case PROCESS: {
                    Method reqMethod = Method.getMethod(this.req.getMethod());
                    HttpCacheHeaderUtil.setCacheControlHeader(this.config, resp, reqMethod);
                    if (this.config.getHttpCachingConfig().isNever304() || !HttpCacheHeaderUtil.doCacheHeaderValidation(this.solrReq, this.req, reqMethod, resp)) {
                        SolrQueryResponse solrRsp = new SolrQueryResponse();
                        SolrRequestInfo.setRequestInfo(new SolrRequestInfo(this.solrReq, solrRsp));
                        this.execute(solrRsp);
                        HttpCacheHeaderUtil.checkHttpCachingVeto(solrRsp, resp, reqMethod);
                        Iterator<Map.Entry<String, String>> headers = solrRsp.httpHeaders();
                        while (headers.hasNext()) {
                            Map.Entry<String, String> entry = headers.next();
                            resp.addHeader(entry.getKey(), entry.getValue());
                        }
                        QueryResponseWriter responseWriter = this.core.getQueryResponseWriter(this.solrReq);
                        if (this.invalidStates != null) {
                            this.solrReq.getContext().put("_stateVer_", this.invalidStates);
                        }
                        this.writeResponse(solrRsp, responseWriter, reqMethod);
                    }
                    return SolrDispatchFilter.Action.RETURN;
                }
            }
            return this.action;
        }
        catch (Throwable ex) {
            this.sendError(ex);
            for (Throwable t = ex; t != null; t = t.getCause()) {
                if (!(t instanceof Error)) continue;
                if (t != ex) {
                    SolrDispatchFilter.log.error("An Error was wrapped in another exception - please report complete stacktrace on SOLR-6161", ex);
                }
                throw (Error)t;
            }
            return SolrDispatchFilter.Action.RETURN;
        }
    }

    void destroy() {
        try {
            if (this.solrReq != null) {
                SolrDispatchFilter.log.debug("Closing out SolrRequest: {}", (Object)this.solrReq);
                this.solrReq.close();
            }
        }
        finally {
            try {
                if (this.core != null) {
                    this.core.close();
                }
            }
            finally {
                SolrRequestInfo.clearRequestInfo();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void remoteQuery(String coreUrl, HttpServletResponse resp) throws IOException {
        HttpGet method = null;
        HttpEntity httpEntity = null;
        boolean success = false;
        try {
            boolean isPostOrPutRequest;
            String urlstr = coreUrl;
            String queryString = this.req.getQueryString();
            urlstr = urlstr + (queryString == null ? "" : "?" + queryString);
            boolean bl = isPostOrPutRequest = "POST".equals(this.req.getMethod()) || "PUT".equals(this.req.getMethod());
            if ("GET".equals(this.req.getMethod())) {
                method = new HttpGet(urlstr);
            } else if ("HEAD".equals(this.req.getMethod())) {
                method = new HttpHead(urlstr);
            } else if (isPostOrPutRequest) {
                HttpPost entityRequest = "POST".equals(this.req.getMethod()) ? new HttpPost(urlstr) : new HttpPut(urlstr);
                InputStreamEntity entity = new InputStreamEntity((InputStream)this.req.getInputStream(), (long)this.req.getContentLength());
                entityRequest.setEntity((HttpEntity)entity);
                method = entityRequest;
            } else {
                if (!"DELETE".equals(this.req.getMethod())) throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected method type: " + this.req.getMethod());
                method = new HttpDelete(urlstr);
            }
            Enumeration e = this.req.getHeaderNames();
            while (e.hasMoreElements()) {
                String headerName = (String)e.nextElement();
                if ("host".equalsIgnoreCase(headerName) || "authorization".equalsIgnoreCase(headerName) || "accept".equalsIgnoreCase(headerName)) continue;
                method.addHeader(headerName, this.req.getHeader(headerName));
            }
            if (method instanceof HttpEntityEnclosingRequest) {
                method.removeHeaders(TRANSFER_ENCODING_HEADER);
                method.removeHeaders(CONTENT_LENGTH_HEADER);
            }
            CloseableHttpResponse response = this.solrDispatchFilter.httpClient.execute((HttpUriRequest)method);
            int httpStatus = response.getStatusLine().getStatusCode();
            httpEntity = response.getEntity();
            resp.setStatus(httpStatus);
            HeaderIterator responseHeaders = response.headerIterator();
            while (responseHeaders.hasNext()) {
                Header header = responseHeaders.nextHeader();
                if (header == null || header.getName().equals(TRANSFER_ENCODING_HEADER) || header.getName().equals(CONNECTION_HEADER)) continue;
                resp.addHeader(header.getName(), header.getValue());
            }
            if (httpEntity != null) {
                if (httpEntity.getContentEncoding() != null) {
                    resp.setCharacterEncoding(httpEntity.getContentEncoding().getValue());
                }
                if (httpEntity.getContentType() != null) {
                    resp.setContentType(httpEntity.getContentType().getValue());
                }
                InputStream is = httpEntity.getContent();
                ServletOutputStream os = resp.getOutputStream();
                try {
                    org.apache.commons.io.IOUtils.copyLarge((InputStream)is, (OutputStream)os);
                    os.flush();
                }
                finally {
                    org.apache.commons.io.IOUtils.closeQuietly((OutputStream)os);
                    org.apache.commons.io.IOUtils.closeQuietly((InputStream)is);
                }
            }
            success = true;
            EntityUtils.consumeQuietly((HttpEntity)httpEntity);
            if (method == null || success) return;
        }
        catch (IOException e) {
            this.sendError(new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error trying to proxy request for url: " + coreUrl, (Throwable)e));
            return;
        }
        finally {
            EntityUtils.consumeQuietly(httpEntity);
            if (method != null && !success) {
                method.abort();
            }
        }
        method.abort();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendError(Throwable ex) throws IOException {
        Exception exp = null;
        SolrCore localCore = null;
        try {
            SolrQueryResponse solrResp = new SolrQueryResponse();
            if (ex instanceof Exception) {
                solrResp.setException((Exception)ex);
            } else {
                solrResp.setException(new RuntimeException(ex));
            }
            localCore = this.core == null ? this.cores.getCore("") : this.core;
            if (this.solrReq == null) {
                Object solrParams = this.req != null ? SolrRequestParsers.parseQueryString(this.req.getQueryString()) : new MapSolrParams(Collections.emptyMap());
                this.solrReq = new SolrQueryRequestBase(this.core, (SolrParams)solrParams){};
            }
            QueryResponseWriter writer = this.core.getQueryResponseWriter(this.solrReq);
            this.writeResponse(solrResp, writer, Method.GET);
        }
        catch (Exception e) {
            exp = e;
        }
        finally {
            try {
                if (exp != null) {
                    SimpleOrderedMap info = new SimpleOrderedMap();
                    int code = ResponseUtils.getErrorInfo(ex, (NamedList)info, SolrDispatchFilter.log);
                    this.sendError(code, info.toString());
                }
            }
            finally {
                if (this.core == null && localCore != null) {
                    localCore.close();
                }
            }
        }
    }

    protected void sendError(int code, String message) throws IOException {
        try {
            this.response.sendError(code, message);
        }
        catch (EOFException e) {
            SolrDispatchFilter.log.info("Unable to write error response, client closed connection or we are shutting down", (Throwable)e);
        }
    }

    private void addMDCValues() {
        MDCUtils.setCore(this.core.getName());
        if (this.cores.isZooKeeperAware()) {
            CloudDescriptor cloud = this.core.getCoreDescriptor().getCloudDescriptor();
            MDCUtils.setCollection(cloud.getCollectionName());
            MDCUtils.setShard(cloud.getShardId());
            MDCUtils.setReplica(cloud.getCoreNodeName());
        }
    }

    protected void execute(SolrQueryResponse rsp) {
        this.solrReq.getContext().put("webapp", this.req.getContextPath());
        this.solrReq.getCore().execute(this.handler, this.solrReq, rsp);
    }

    private void handleAdminRequest() throws IOException {
        QueryResponseWriter respWriter;
        SolrQueryResponse solrResp = new SolrQueryResponse();
        SolrCore.preDecorateResponse(this.solrReq, solrResp);
        this.handler.handleRequest(this.solrReq, solrResp);
        SolrCore.postDecorateResponse(this.handler, this.solrReq, solrResp);
        if (SolrDispatchFilter.log.isInfoEnabled() && solrResp.getToLog().size() > 0) {
            SolrDispatchFilter.log.info(solrResp.getToLogAsString("[admin] "));
        }
        if ((respWriter = SolrCore.DEFAULT_RESPONSE_WRITERS.get(this.solrReq.getParams().get("wt"))) == null) {
            respWriter = SolrCore.DEFAULT_RESPONSE_WRITERS.get("standard");
        }
        this.writeResponse(solrResp, respWriter, Method.getMethod(this.req.getMethod()));
    }

    private void processAliases(Aliases aliases, List<String> collectionsList) {
        String collection = this.solrReq.getParams().get("collection");
        if (collection != null) {
            collectionsList = StrUtils.splitSmart((String)collection, (String)",", (boolean)true);
        }
        if (collectionsList != null) {
            HashSet<String> newCollectionsList = new HashSet<String>(collectionsList.size());
            for (String col : collectionsList) {
                String al = aliases.getCollectionAlias(col);
                if (al != null) {
                    List aliasList = StrUtils.splitSmart((String)al, (String)",", (boolean)true);
                    newCollectionsList.addAll(aliasList);
                    continue;
                }
                newCollectionsList.add(col);
            }
            if (newCollectionsList.size() > 0) {
                StringBuilder collectionString = new StringBuilder();
                Iterator it = newCollectionsList.iterator();
                int sz = newCollectionsList.size();
                for (int i = 0; i < sz; ++i) {
                    collectionString.append((String)it.next());
                    if (i >= newCollectionsList.size() - 1) continue;
                    collectionString.append(",");
                }
                ModifiableSolrParams params = new ModifiableSolrParams(this.solrReq.getParams());
                params.set("collection", new String[]{collectionString.toString()});
                this.solrReq.setParams((SolrParams)params);
            }
        }
    }

    private void writeResponse(SolrQueryResponse solrRsp, QueryResponseWriter responseWriter, Method reqMethod) throws IOException {
        try {
            String ct;
            Object invalidStates = this.solrReq.getContext().get("_stateVer_");
            if (invalidStates != null) {
                solrRsp.add("_stateVer_", invalidStates);
            }
            if (null != (ct = responseWriter.getContentType(this.solrReq, solrRsp))) {
                this.response.setContentType(ct);
            }
            if (solrRsp.getException() != null) {
                SimpleOrderedMap info = new SimpleOrderedMap();
                int code = ResponseUtils.getErrorInfo(solrRsp.getException(), (NamedList)info, SolrDispatchFilter.log);
                solrRsp.add("error", info);
                this.response.setStatus(code);
            }
            if (Method.HEAD != reqMethod) {
                QueryResponseWriterUtil.writeQueryResponse((OutputStream)this.response.getOutputStream(), responseWriter, this.solrReq, solrRsp, ct);
            }
        }
        catch (EOFException e) {
            SolrDispatchFilter.log.info("Unable to write response, client closed connection or we are shutting down", (Throwable)e);
        }
    }

    private Map<String, Integer> checkStateIsValid(String stateVer) {
        HashMap<String, Integer> result = null;
        if (stateVer != null && !stateVer.isEmpty() && this.cores.isZooKeeperAware()) {
            String[] pairs;
            for (String pair : pairs = StringUtils.split((String)stateVer, (char)'|')) {
                Integer status;
                String[] pcs = StringUtils.split((String)pair, (char)':');
                if (pcs.length != 2 || pcs[0].isEmpty() || pcs[1].isEmpty() || (status = this.cores.getZkController().getZkStateReader().compareStateVersions(pcs[0], Integer.parseInt(pcs[1]))) == null) continue;
                if (result == null) {
                    result = new HashMap<String, Integer>();
                }
                result.put(pcs[0], status);
            }
        }
        return result;
    }

    private SolrCore getCoreByCollection(String corename) {
        ZkStateReader zkStateReader = this.cores.getZkController().getZkStateReader();
        ClusterState clusterState = zkStateReader.getClusterState();
        Map slices = clusterState.getActiveSlicesMap(corename);
        if (slices == null) {
            return null;
        }
        Set entries = slices.entrySet();
        SolrCore core = null;
        block0: for (Map.Entry entry : entries) {
            Replica leaderProps = clusterState.getLeader(corename, (String)entry.getKey());
            if (leaderProps != null) {
                core = this.checkProps((ZkNodeProps)leaderProps);
            }
            if (core != null) break;
            Map shards = ((Slice)entry.getValue()).getReplicasMap();
            Set shardEntries = shards.entrySet();
            for (Map.Entry shardEntry : shardEntries) {
                Replica zkProps = (Replica)shardEntry.getValue();
                core = this.checkProps((ZkNodeProps)zkProps);
                if (core == null) continue;
                break block0;
            }
        }
        return core;
    }

    private SolrCore checkProps(ZkNodeProps zkProps) {
        SolrCore core = null;
        if (this.cores.getZkController().getNodeName().equals(zkProps.getStr("node_name"))) {
            String corename = zkProps.getStr("core");
            core = this.cores.getCore(corename);
        }
        return core;
    }

    private void getSlicesForCollections(ClusterState clusterState, Collection<Slice> slices, boolean activeSlices) {
        if (activeSlices) {
            for (String collection : clusterState.getCollections()) {
                Collection activeCollectionSlices = clusterState.getActiveSlices(collection);
                if (activeCollectionSlices == null) continue;
                slices.addAll(activeCollectionSlices);
            }
        } else {
            for (String collection : clusterState.getCollections()) {
                Collection collectionSlices = clusterState.getSlices(collection);
                if (collectionSlices == null) continue;
                slices.addAll(collectionSlices);
            }
        }
    }

    private String getRemotCoreUrl(String collectionName, String origCorename) {
        ClusterState clusterState = this.cores.getZkController().getClusterState();
        ArrayList<Slice> slices = clusterState.getActiveSlices(collectionName);
        boolean byCoreName = false;
        if (slices == null) {
            slices = new ArrayList<Slice>();
            byCoreName = true;
            this.getSlicesForCollections(clusterState, slices, true);
            if (slices.isEmpty()) {
                this.getSlicesForCollections(clusterState, slices, false);
            }
        }
        if (slices.isEmpty()) {
            return null;
        }
        if (this.collectionsList == null) {
            this.collectionsList = new ArrayList<String>();
        }
        this.collectionsList.add(collectionName);
        String coreUrl = this.getCoreUrl(collectionName, origCorename, clusterState, slices, byCoreName, true);
        if (coreUrl == null) {
            coreUrl = this.getCoreUrl(collectionName, origCorename, clusterState, slices, byCoreName, false);
        }
        return coreUrl;
    }

    private String getCoreUrl(String collectionName, String origCorename, ClusterState clusterState, Collection<Slice> slices, boolean byCoreName, boolean activeReplicas) {
        Set liveNodes = clusterState.getLiveNodes();
        ArrayList<Slice> randomizedSlices = new ArrayList<Slice>(slices.size());
        randomizedSlices.addAll(slices);
        Collections.shuffle(randomizedSlices, random);
        for (Slice slice : randomizedSlices) {
            ArrayList randomizedReplicas = new ArrayList();
            randomizedReplicas.addAll(slice.getReplicas());
            Collections.shuffle(randomizedReplicas, random);
            for (Replica replica : randomizedReplicas) {
                String coreUrl;
                if (activeReplicas && (!liveNodes.contains(replica.getNodeName()) || replica.getState() != Replica.State.ACTIVE) || byCoreName && !collectionName.equals(replica.getStr("core")) || replica.getStr("base_url").equals(this.cores.getZkController().getBaseUrl())) continue;
                if (origCorename != null) {
                    coreUrl = replica.getStr("base_url") + "/" + origCorename;
                } else {
                    coreUrl = replica.getCoreUrl();
                    if (coreUrl.endsWith("/")) {
                        coreUrl = coreUrl.substring(0, coreUrl.length() - 1);
                    }
                }
                return coreUrl;
            }
        }
        return null;
    }

    private AuthorizationContext getAuthCtx() {
        final String resource = this.getPath();
        SolrParams params = this.getQueryParams();
        final ArrayList<AuthorizationContext.CollectionRequest> collectionRequests = new ArrayList<AuthorizationContext.CollectionRequest>();
        if (this.getCollectionsList() != null) {
            for (String collection : this.getCollectionsList()) {
                collectionRequests.add(new AuthorizationContext.CollectionRequest(collection));
            }
        }
        if (this.getPath().equals("/admin/collections")) {
            if (CollectionParams.CollectionAction.CREATE.isEqual(params.get("action")) || CollectionParams.CollectionAction.RELOAD.isEqual(params.get("action")) || CollectionParams.CollectionAction.DELETE.isEqual(params.get("action"))) {
                collectionRequests.add(new AuthorizationContext.CollectionRequest(params.get("name")));
            } else if (params.get("collection") != null) {
                collectionRequests.add(new AuthorizationContext.CollectionRequest(params.get("collection")));
            }
        }
        if (resource.equals("/select") && params.get("collection") != null) {
            collectionRequests.clear();
            for (String collection : params.get("collection").split(",")) {
                collectionRequests.add(new AuthorizationContext.CollectionRequest(collection));
            }
        }
        if (this.requestType == AuthorizationContext.RequestType.UNKNOWN) {
            if (resource.startsWith("/select") || resource.startsWith("/get")) {
                this.requestType = AuthorizationContext.RequestType.READ;
            }
            if (resource.startsWith("/update")) {
                this.requestType = AuthorizationContext.RequestType.WRITE;
            }
        }
        if (this.getCore() != null && (this.getCollectionsList() == null || this.getCollectionsList().size() == 0)) {
            collectionRequests.add(new AuthorizationContext.CollectionRequest(this.getCore().getCoreDescriptor().getCollectionName()));
        }
        if (this.getQueryParams().get("collection") != null) {
            collectionRequests.add(new AuthorizationContext.CollectionRequest(this.getQueryParams().get("collection")));
        }
        return new AuthorizationContext(){

            @Override
            public SolrParams getParams() {
                return HttpSolrCall.this.getQueryParams();
            }

            @Override
            public Principal getUserPrincipal() {
                return HttpSolrCall.this.getReq().getUserPrincipal();
            }

            @Override
            public String getHttpHeader(String s) {
                return HttpSolrCall.this.getReq().getHeader(s);
            }

            @Override
            public Enumeration getHeaderNames() {
                return HttpSolrCall.this.getReq().getHeaderNames();
            }

            @Override
            public List<AuthorizationContext.CollectionRequest> getCollectionRequests() {
                return collectionRequests;
            }

            @Override
            public AuthorizationContext.RequestType getRequestType() {
                return HttpSolrCall.this.requestType;
            }

            @Override
            public String getResource() {
                return HttpSolrCall.this.path;
            }

            public String toString() {
                StringBuilder response = new StringBuilder("userPrincipal: [").append(this.getUserPrincipal()).append("]").append(" type: [").append(HttpSolrCall.this.requestType.toString()).append("], collections: [");
                for (AuthorizationContext.CollectionRequest collectionRequest : collectionRequests) {
                    response.append(collectionRequest.collectionName).append(", ");
                }
                if (collectionRequests.size() > 0) {
                    response.delete(response.length() - 1, response.length());
                }
                response.append("], Path: [").append(resource).append("]");
                return response.toString();
            }

            @Override
            public String getRemoteAddr() {
                return HttpSolrCall.this.getReq().getRemoteAddr();
            }

            @Override
            public String getRemoteHost() {
                return HttpSolrCall.this.getReq().getRemoteHost();
            }
        };
    }

    static {
        String seed = System.getProperty("tests.seed");
        random = seed == null ? new Random() : new Random(seed.hashCode());
    }
}

