/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.IndexSchemaFactory;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.ZkIndexSchemaReader;
import org.apache.solr.util.SystemIdResolver;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class ManagedIndexSchemaFactory
extends IndexSchemaFactory
implements SolrCoreAware {
    private static final Logger log = LoggerFactory.getLogger(ManagedIndexSchemaFactory.class);
    private static final String UPGRADED_SCHEMA_EXTENSION = ".bak";
    private static final String SCHEMA_DOT_XML = "schema.xml";
    public static final String DEFAULT_MANAGED_SCHEMA_RESOURCE_NAME = "managed-schema";
    public static final String MANAGED_SCHEMA_RESOURCE_NAME = "managedSchemaResourceName";
    private boolean isMutable;
    private String managedSchemaResourceName;
    private SolrConfig config;
    private SolrResourceLoader loader;
    private String resourceName;
    private ManagedIndexSchema schema;
    private SolrCore core;
    private ZkIndexSchemaReader zkIndexSchemaReader;
    private String loadedResource;
    private boolean shouldUpgrade = false;
    private Object schemaUpdateLock = new Object();

    public String getManagedSchemaResourceName() {
        return this.managedSchemaResourceName;
    }

    public SolrResourceLoader getResourceLoader() {
        return this.loader;
    }

    @Override
    public void init(NamedList args) {
        SolrParams params = SolrParams.toSolrParams((NamedList)args);
        this.isMutable = params.getBool("mutable", false);
        args.remove("mutable");
        this.managedSchemaResourceName = params.get(MANAGED_SCHEMA_RESOURCE_NAME, DEFAULT_MANAGED_SCHEMA_RESOURCE_NAME);
        args.remove(MANAGED_SCHEMA_RESOURCE_NAME);
        if (SCHEMA_DOT_XML.equals(this.managedSchemaResourceName)) {
            String msg = "managedSchemaResourceName can't be 'schema.xml'";
            log.error(msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        if (args.size() > 0) {
            String msg = "Unexpected arg(s): " + args;
            log.error(msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
    }

    @Override
    public ManagedIndexSchema create(String resourceName, SolrConfig config) {
        this.resourceName = resourceName;
        this.config = config;
        this.loader = config.getResourceLoader();
        InputStream schemaInputStream = null;
        if (null == resourceName) {
            resourceName = SCHEMA_DOT_XML;
        }
        int schemaZkVersion = -1;
        if (!(this.loader instanceof ZkSolrResourceLoader)) {
            schemaInputStream = this.readSchemaLocally();
        } else {
            ZkSolrResourceLoader zkLoader = (ZkSolrResourceLoader)this.loader;
            SolrZkClient zkClient = zkLoader.getZkController().getZkClient();
            String managedSchemaPath = zkLoader.getConfigSetZkPath() + "/" + this.managedSchemaResourceName;
            Stat stat = new Stat();
            try {
                byte[] data = zkClient.getData(managedSchemaPath, null, stat, true);
                schemaZkVersion = stat.getVersion();
                schemaInputStream = new ByteArrayInputStream(data);
                this.loadedResource = this.managedSchemaResourceName;
                this.warnIfNonManagedSchemaExists();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("", (Throwable)e);
            }
            catch (KeeperException.NoNodeException e) {
                log.info("The schema is configured as managed, but managed schema resource " + this.managedSchemaResourceName + " not found - loading non-managed schema " + resourceName + " instead");
            }
            catch (KeeperException e) {
                String msg = "Error attempting to access " + managedSchemaPath;
                log.error(msg, (Throwable)e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)e);
            }
            if (null == schemaInputStream) {
                try {
                    schemaInputStream = this.loader.openSchema(resourceName);
                    this.loadedResource = resourceName;
                    this.shouldUpgrade = true;
                }
                catch (Exception e) {
                    try {
                        byte[] data = zkClient.getData(managedSchemaPath, null, stat, true);
                        schemaZkVersion = stat.getVersion();
                        schemaInputStream = new ByteArrayInputStream(data);
                        this.warnIfNonManagedSchemaExists();
                    }
                    catch (Exception e1) {
                        if (e1 instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        String msg = "Error loading both non-managed schema '" + resourceName + "' and managed schema '" + this.managedSchemaResourceName + "'";
                        log.error(msg, (Throwable)e);
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)e);
                    }
                }
            }
        }
        InputSource inputSource = new InputSource(schemaInputStream);
        inputSource.setSystemId(SystemIdResolver.createSystemIdFromResourceName(this.loadedResource));
        try {
            this.schema = new ManagedIndexSchema(config, this.loadedResource, inputSource, this.isMutable, this.managedSchemaResourceName, schemaZkVersion, this.getSchemaUpdateLock());
        }
        catch (KeeperException e) {
            String msg = "Error instantiating ManagedIndexSchema";
            log.error("Error instantiating ManagedIndexSchema", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error instantiating ManagedIndexSchema", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("", (Throwable)e);
        }
        if (this.shouldUpgrade) {
            this.upgradeToManagedSchema();
        }
        return this.schema;
    }

    private InputStream readSchemaLocally() {
        InputStream schemaInputStream = null;
        try {
            schemaInputStream = this.loader.openSchema(this.managedSchemaResourceName);
            this.loadedResource = this.managedSchemaResourceName;
            this.warnIfNonManagedSchemaExists();
        }
        catch (IOException e) {
            log.info("The schema is configured as managed, but managed schema resource " + this.managedSchemaResourceName + " not found - loading non-managed schema " + this.resourceName + " instead");
        }
        if (null == schemaInputStream) {
            try {
                schemaInputStream = this.loader.openSchema(this.resourceName);
                this.loadedResource = this.resourceName;
                this.shouldUpgrade = true;
            }
            catch (Exception e) {
                String msg = "Error loading both non-managed schema '" + this.resourceName + "' and managed schema '" + this.managedSchemaResourceName + "'";
                log.error(msg, (Throwable)e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)e);
            }
        }
        return schemaInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void warnIfNonManagedSchemaExists() {
        block11: {
            boolean exists;
            block12: {
                InputStream nonManagedSchemaInputStream;
                if (this.resourceName.equals(this.managedSchemaResourceName)) break block11;
                exists = false;
                SolrResourceLoader loader = this.config.getResourceLoader();
                if (loader instanceof ZkSolrResourceLoader) {
                    ZkSolrResourceLoader zkLoader = (ZkSolrResourceLoader)loader;
                    String nonManagedSchemaPath = zkLoader.getConfigSetZkPath() + "/" + this.resourceName;
                    try {
                        exists = zkLoader.getZkController().pathExists(nonManagedSchemaPath);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.warn("", (Throwable)e);
                    }
                    catch (KeeperException e) {
                        log.warn("Error checking for the existence of the non-managed schema " + this.resourceName, (Throwable)e);
                    }
                } else {
                    block10: {
                        nonManagedSchemaInputStream = null;
                        nonManagedSchemaInputStream = loader.openSchema(this.resourceName);
                        if (null == nonManagedSchemaInputStream) break block10;
                        exists = true;
                    }
                    IOUtils.closeQuietly((InputStream)nonManagedSchemaInputStream);
                }
                break block12;
                catch (IOException iOException) {
                    IOUtils.closeQuietly((InputStream)nonManagedSchemaInputStream);
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(nonManagedSchemaInputStream);
                        throw throwable;
                    }
                }
            }
            if (exists) {
                log.warn("The schema has been upgraded to managed, but the non-managed schema " + this.resourceName + " is still loadable.  PLEASE REMOVE THIS FILE.");
            }
        }
    }

    private void upgradeToManagedSchema() {
        SolrResourceLoader loader = this.config.getResourceLoader();
        if (loader instanceof ZkSolrResourceLoader) {
            this.zkUgradeToManagedSchema();
        } else {
            this.schema.persistManagedSchema(true);
            if (this.resourceName.equals(this.managedSchemaResourceName)) {
                log.info("On upgrading to managed schema, did not rename non-managed schema '" + this.resourceName + "' because it's the same as the managed schema's name.");
            } else {
                File nonManagedSchemaFile = this.locateConfigFile(this.resourceName);
                if (null == nonManagedSchemaFile) {
                    log.warn("On upgrading to managed schema, did not rename non-managed schema " + this.resourceName + " because it's neither an absolute file " + "nor under SolrConfig.getConfigDir() or the current directory." + "  PLEASE REMOVE THIS FILE.");
                } else {
                    File upgradedSchemaFile = new File(nonManagedSchemaFile.getPath() + UPGRADED_SCHEMA_EXTENSION);
                    if (nonManagedSchemaFile.renameTo(upgradedSchemaFile)) {
                        this.schema.setResourceName(this.managedSchemaResourceName);
                        log.info("After upgrading to managed schema, renamed the non-managed schema " + nonManagedSchemaFile + " to " + upgradedSchemaFile);
                    } else {
                        log.warn("Can't rename " + nonManagedSchemaFile.toString() + " to " + upgradedSchemaFile.toString() + " - PLEASE REMOVE THIS FILE.");
                    }
                }
            }
        }
    }

    private File locateConfigFile(String resource) {
        File located = null;
        File file = new File(resource);
        if (file.isAbsolute()) {
            if (file.isFile() && file.canRead()) {
                located = file;
            }
        } else {
            File fileUnderConfigDir = new File(this.config.getResourceLoader().getConfigDir() + resource);
            if (fileUnderConfigDir.isFile() && fileUnderConfigDir.canRead()) {
                located = fileUnderConfigDir;
            } else if (file.isFile() && file.canRead()) {
                located = file;
            }
        }
        return located;
    }

    private void zkUgradeToManagedSchema() {
        this.schema.persistManagedSchemaToZooKeeper(true);
        if (this.resourceName.equals(this.managedSchemaResourceName)) {
            log.info("On upgrading to managed schema, did not rename non-managed schema " + this.resourceName + " because it's the same as the managed schema's name.");
        } else {
            ZkSolrResourceLoader zkLoader = (ZkSolrResourceLoader)this.loader;
            String nonManagedSchemaPath = zkLoader.getConfigSetZkPath() + "/" + this.resourceName;
            try {
                ZkController zkController = zkLoader.getZkController();
                ZkCmdExecutor zkCmdExecutor = new ZkCmdExecutor(zkController.getClientTimeout());
                if (zkController.pathExists(nonManagedSchemaPath)) {
                    byte[] bytes = zkController.getZkClient().getData(nonManagedSchemaPath, null, null, true);
                    String upgradedSchemaPath = nonManagedSchemaPath + UPGRADED_SCHEMA_EXTENSION;
                    zkCmdExecutor.ensureExists(upgradedSchemaPath, zkController.getZkClient());
                    zkController.getZkClient().setData(upgradedSchemaPath, bytes, true);
                    zkController.getZkClient().delete(nonManagedSchemaPath, -1, true);
                    this.schema.setResourceName(this.managedSchemaResourceName);
                    log.info("After upgrading to managed schema in ZooKeeper, renamed the non-managed schema " + nonManagedSchemaPath + " to " + upgradedSchemaPath);
                } else {
                    log.info("After upgrading to managed schema in ZooKeeper, the non-managed schema " + nonManagedSchemaPath + " no longer exists.");
                }
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                String msg = "Error persisting managed schema resource " + this.managedSchemaResourceName;
                log.warn(msg, (Throwable)e);
            }
        }
    }

    public Object getSchemaUpdateLock() {
        return this.schemaUpdateLock;
    }

    @Override
    public void inform(SolrCore core) {
        this.core = core;
        if (this.loader instanceof ZkSolrResourceLoader) {
            this.zkIndexSchemaReader = new ZkIndexSchemaReader(this);
            ZkSolrResourceLoader zkLoader = (ZkSolrResourceLoader)this.loader;
            zkLoader.setZkIndexSchemaReader(this.zkIndexSchemaReader);
        } else {
            this.zkIndexSchemaReader = null;
        }
    }

    public ManagedIndexSchema getSchema() {
        return this.schema;
    }

    public void setSchema(ManagedIndexSchema schema) {
        this.schema = schema;
        this.core.setLatestSchema(schema);
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    public SolrConfig getConfig() {
        return this.config;
    }
}

