/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.rest.BaseSolrResource;
import org.apache.solr.rest.GETable;
import org.apache.solr.rest.POSTable;
import org.apache.solr.rest.schema.BaseFieldResource;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.SchemaField;
import org.noggit.ObjectBuilder;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicFieldCollectionResource
extends BaseFieldResource
implements GETable,
POSTable {
    private static final Logger log = LoggerFactory.getLogger(DynamicFieldCollectionResource.class);

    @Override
    public void doInit() throws ResourceException {
        super.doInit();
    }

    @Override
    public Representation get() {
        try {
            ArrayList<SimpleOrderedMap<Object>> props = new ArrayList<SimpleOrderedMap<Object>>();
            if (null == this.getRequestedFields()) {
                for (IndexSchema.DynamicField dynamicField : this.getSchema().getDynamicFields()) {
                    if (dynamicField.getRegex().startsWith("*___")) continue;
                    props.add(this.getFieldProperties(dynamicField.getPrototype()));
                }
            } else {
                if (0 == this.getRequestedFields().size()) {
                    String message = "Empty fl parameter value";
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
                }
                HashMap<String, SchemaField> dynamicFieldsByName = new HashMap<String, SchemaField>();
                for (IndexSchema.DynamicField dynamicField : this.getSchema().getDynamicFields()) {
                    dynamicFieldsByName.put(dynamicField.getRegex(), dynamicField.getPrototype());
                }
                for (String dynamicFieldName : this.getRequestedFields()) {
                    SchemaField dynamicSchemaField = (SchemaField)dynamicFieldsByName.get(dynamicFieldName);
                    if (null == dynamicSchemaField) {
                        log.info("Requested dynamic field '" + dynamicFieldName + "' not found.");
                        continue;
                    }
                    props.add(this.getFieldProperties(dynamicSchemaField));
                }
            }
            this.getSolrResponse().add("dynamicFields", props);
        }
        catch (Exception e) {
            this.getSolrResponse().setException(e);
        }
        this.handlePostExecution(log);
        return new BaseSolrResource.SolrOutputRepresentation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Representation post(Representation entity) {
        try {
            Object fieldType;
            if (!this.getSchema().isMutable()) {
                String message = "This IndexSchema is not mutable.";
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "This IndexSchema is not mutable.");
            }
            if (null == entity.getMediaType()) {
                entity.setMediaType(MediaType.APPLICATION_JSON);
            }
            if (!entity.getMediaType().equals((Object)MediaType.APPLICATION_JSON, true)) {
                String message = "Only media type " + MediaType.APPLICATION_JSON.toString() + " is accepted." + "  Request has media type " + entity.getMediaType().toString() + ".";
                log.error(message);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
            }
            Object object = ObjectBuilder.fromJSON((String)entity.getText());
            if (!(object instanceof List)) {
                String message = "Invalid JSON type " + object.getClass().getName() + ", expected List of the form" + " (ignore the backslashes): [{\"name\":\"*_foo\",\"type\":\"text_general\", ...}, {...}, ...]";
                log.error(message);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
            }
            List list = (List)object;
            ArrayList<SchemaField> newDynamicFields = new ArrayList<SchemaField>();
            ArrayList<BaseFieldResource.NewFieldArguments> newDynamicFieldArguments = new ArrayList<BaseFieldResource.NewFieldArguments>();
            ManagedIndexSchema oldSchema = (ManagedIndexSchema)this.getSchema();
            HashMap<String, List<String>> copyFields = new HashMap<String, List<String>>();
            for (Map map : list) {
                String fieldNamePattern = (String)map.remove("name");
                if (null == fieldNamePattern) {
                    String message = "Missing 'name' mapping.";
                    log.error(message);
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
                }
                fieldType = (String)map.remove("type");
                if (null == fieldType) {
                    String message = "Missing 'type' mapping.";
                    log.error(message);
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
                }
                Object copies = map.get("copyFields");
                List<String> copyTo = null;
                if (copies != null) {
                    if (copies instanceof List) {
                        copyTo = (List<String>)copies;
                    } else if (copies instanceof String) {
                        copyTo = Collections.singletonList(copies.toString());
                    } else {
                        String message = "Invalid 'copyFields' type.";
                        log.error(message);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
                    }
                }
                if (copyTo != null) {
                    map.remove("copyFields");
                    copyFields.put(fieldNamePattern, copyTo);
                }
                newDynamicFields.add(oldSchema.newDynamicField(fieldNamePattern, (String)fieldType, map));
                newDynamicFieldArguments.add(new BaseFieldResource.NewFieldArguments(fieldNamePattern, (String)fieldType, map));
            }
            IndexSchema newSchema = null;
            boolean firstAttempt = true;
            boolean success = false;
            while (!success) {
                try {
                    if (!firstAttempt) {
                        newDynamicFields.clear();
                        for (BaseFieldResource.NewFieldArguments args : newDynamicFieldArguments) {
                            newDynamicFields.add(oldSchema.newDynamicField(args.getName(), args.getType(), args.getMap()));
                        }
                    }
                    firstAttempt = false;
                    fieldType = oldSchema.getSchemaUpdateLock();
                    synchronized (fieldType) {
                        newSchema = oldSchema.addDynamicFields(newDynamicFields, copyFields, true);
                        if (null == newSchema) {
                            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to add dynamic fields.");
                        }
                        this.getSolrCore().setLatestSchema(newSchema);
                        success = true;
                    }
                }
                catch (ManagedIndexSchema.SchemaChangedInZkException e) {
                    log.debug("Schema changed while processing request, retrying");
                    oldSchema = (ManagedIndexSchema)this.getSolrCore().getLatestSchema();
                }
            }
            this.waitForSchemaUpdateToPropagate(newSchema);
        }
        catch (Exception e) {
            this.getSolrResponse().setException(e);
        }
        this.handlePostExecution(log);
        return new BaseSolrResource.SolrOutputRepresentation();
    }
}

