/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request.macro;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SyntaxError;

public class MacroExpander {
    public static final String MACRO_START = "${";
    private static final int MAX_LEVELS = 25;
    private Map<String, String[]> orig;
    private Map<String, String[]> expanded;
    private String macroStart = "${";
    private char escape = (char)92;
    private int level;

    public MacroExpander(Map<String, String[]> orig) {
        this.orig = orig;
    }

    public static Map<String, String[]> expand(Map<String, String[]> params) {
        MacroExpander mc = new MacroExpander(params);
        mc.expand();
        return mc.expanded;
    }

    public boolean expand() {
        this.expanded = new HashMap<String, String[]>(this.orig.size());
        boolean changed = false;
        for (Map.Entry<String, String[]> entry : this.orig.entrySet()) {
            String k = entry.getKey();
            String newK = this.expand(k);
            String[] values = entry.getValue();
            ArrayList<String> newValues = null;
            for (String v : values) {
                String newV = this.expand(v);
                if (newV == v) continue;
                if (newValues == null) {
                    newValues = new ArrayList<String>(values.length);
                    for (String vv : values) {
                        if (vv == v) break;
                        newValues.add(vv);
                    }
                }
                newValues.add(newV);
            }
            if (newValues != null) {
                values = newValues.toArray(new String[newValues.size()]);
                changed = true;
            }
            if (k != newK) {
                changed = true;
            }
            this.expanded.put(newK, values);
        }
        return changed;
    }

    public String expand(String val) {
        ++this.level;
        try {
            if (this.level >= 25) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Request template exceeded max nesting of 25 expanding '" + val + "'");
            }
            String string = this._expand(val);
            return string;
        }
        finally {
            --this.level;
        }
    }

    private String _expand(String val) {
        int idx = val.indexOf(this.macroStart.charAt(0));
        if (idx < 0) {
            return val;
        }
        int start = 0;
        boolean end = false;
        StringBuilder sb = null;
        while (true) {
            int rbrace;
            int matchedStart = idx = val.indexOf(this.macroStart, idx);
            if (idx > 0) {
                char ch = val.charAt(idx - 1);
                if (ch == this.escape) {
                    idx += this.macroStart.length();
                    continue;
                }
            } else if (idx < 0) {
                if (sb == null) {
                    return val;
                }
                sb.append(val.substring(start));
                return sb.toString();
            }
            if ((rbrace = val.indexOf(125, idx += this.macroStart.length())) == -1) continue;
            if (sb == null) {
                sb = new StringBuilder(val.length() * 2);
            }
            if (matchedStart > 0) {
                sb.append(val.substring(start, matchedStart));
            }
            start = rbrace + 1;
            QueryParsing.StrParser parser = new QueryParsing.StrParser(val, idx, rbrace);
            try {
                String[] replacementList;
                String replacement;
                String paramName = parser.getId();
                String defVal = null;
                boolean hasDefault = parser.opt(':');
                if (hasDefault) {
                    defVal = val.substring(parser.pos, rbrace);
                }
                if ((replacement = (replacementList = this.orig.get(paramName)) != null ? replacementList[0] : defVal) == null) continue;
                String expandedReplacement = this.expand(replacement);
                sb.append(expandedReplacement);
                continue;
            }
            catch (SyntaxError syntaxError) {
                sb.append(val.substring(matchedStart, start));
                continue;
            }
            break;
        }
    }
}

