/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import com.carrotsearch.hppc.IntObjectOpenHashMap;
import com.carrotsearch.hppc.IntOpenHashSet;
import com.carrotsearch.hppc.LongObjectMap;
import com.carrotsearch.hppc.LongObjectOpenHashMap;
import com.carrotsearch.hppc.LongOpenHashSet;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.cursors.LongObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.queries.TermsQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.uninverting.UninvertingReader;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.LongValues;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TrieDoubleField;
import org.apache.solr.schema.TrieFloatField;
import org.apache.solr.schema.TrieIntField;
import org.apache.solr.schema.TrieLongField;
import org.apache.solr.search.CollapsingQParserPlugin;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrConstantScoreQuery;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.apache.solr.util.plugin.SolrCoreAware;

public class ExpandComponent
extends SearchComponent
implements PluginInfoInitialized,
SolrCoreAware {
    public static final String COMPONENT_NAME = "expand";
    private static final int finishingStage = ResponseBuilder.STAGE_GET_FIELDS;
    private PluginInfo info = PluginInfo.EMPTY_INFO;

    @Override
    public void init(PluginInfo info) {
        this.info = info;
    }

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        if (rb.req.getParams().getBool(COMPONENT_NAME, false)) {
            rb.doExpand = true;
        }
    }

    @Override
    public void inform(SolrCore core) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void process(ResponseBuilder rb) throws IOException {
        Object collector;
        String[] filters2;
        Query query;
        List<Query> filters;
        if (!rb.doExpand) {
            return;
        }
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        String field = params.get("expand.field");
        String hint = null;
        if (field == null && (filters = rb.getFilters()) != null) {
            for (Query q : filters) {
                if (!(q instanceof CollapsingQParserPlugin.CollapsingPostFilter)) continue;
                CollapsingQParserPlugin.CollapsingPostFilter cp = (CollapsingQParserPlugin.CollapsingPostFilter)q;
                field = cp.getField();
                hint = cp.hint;
            }
        }
        if (field == null) {
            throw new IOException("Expand field is null.");
        }
        String sortParam = params.get("expand.sort");
        String[] fqs = params.getParams("expand.fq");
        String qs = params.get("expand.q");
        int limit = params.getInt("expand.rows", 5);
        Sort sort = null;
        if (sortParam != null) {
            sort = QueryParsing.parseSortSpec(sortParam, rb.req).getSort();
        }
        if (qs == null) {
            query = rb.getQuery();
        } else {
            try {
                QParser parser = QParser.getParser(qs, null, req);
                query = parser.getQuery();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        ArrayList<Query> newFilters = new ArrayList<Query>();
        if (fqs == null) {
            filters2 = rb.getFilters();
            if (filters2 != null) {
                for (Query query2 : filters2) {
                    if (query2 instanceof CollapsingQParserPlugin.CollapsingPostFilter) continue;
                    newFilters.add(query2);
                }
            }
        } else {
            try {
                void var15_21;
                filters2 = fqs;
                int n = filters2.length;
                boolean bl = false;
                while (var15_21 < n) {
                    String fq = filters2[var15_21];
                    if (fq != null && fq.trim().length() != 0 && !fq.equals("*:*")) {
                        QParser fqp = QParser.getParser(fq, null, req);
                        newFilters.add(fqp.getQuery());
                    }
                    ++var15_21;
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        SolrIndexSearcher searcher = req.getSearcher();
        LeafReader reader = searcher.getLeafReader();
        FieldType fieldType = searcher.getSchema().getField(field).getType();
        SortedDocValues values = null;
        long nullValue = 0L;
        if (fieldType instanceof StrField) {
            if ("top_fc".equals(hint)) {
                HashMap<String, UninvertingReader.Type> mapping = new HashMap<String, UninvertingReader.Type>();
                mapping.put(field, UninvertingReader.Type.SORTED);
                UninvertingReader uninvertingReader = new UninvertingReader((LeafReader)new ReaderWrapper(searcher.getLeafReader(), field), mapping);
                values = uninvertingReader.getSortedDocValues(field);
            } else {
                values = DocValues.getSorted((LeafReader)reader, (String)field);
            }
        } else {
            String defaultValue = searcher.getSchema().getField(field).getDefaultValue();
            if (defaultValue != null) {
                if (fieldType instanceof TrieIntField || fieldType instanceof TrieLongField) {
                    nullValue = Long.parseLong(defaultValue);
                } else if (fieldType instanceof TrieFloatField) {
                    nullValue = Float.floatToIntBits(Float.parseFloat(defaultValue));
                } else if (fieldType instanceof TrieDoubleField) {
                    nullValue = Double.doubleToLongBits(Double.parseDouble(defaultValue));
                }
            } else if (fieldType instanceof TrieFloatField) {
                nullValue = Float.floatToIntBits(0.0f);
            } else if (fieldType instanceof TrieDoubleField) {
                nullValue = Double.doubleToLongBits(0.0);
            }
        }
        FixedBitSet groupBits = null;
        LongOpenHashSet groupSet = null;
        DocList docList = rb.getResults().docList;
        IntOpenHashSet collapsedSet = new IntOpenHashSet(docList.size() * 2);
        DocIterator idit = docList.iterator();
        int[] globalDocs = new int[docList.size()];
        int docsIndex = -1;
        while (idit.hasNext()) {
            globalDocs[++docsIndex] = idit.nextDoc();
        }
        Arrays.sort(globalDocs);
        Query groupQuery = null;
        List contexts = searcher.getTopReaderContext().leaves();
        int currentContext = 0;
        int currentDocBase = ((LeafReaderContext)contexts.get((int)currentContext)).docBase;
        int nextDocBase = currentContext + 1 < contexts.size() ? ((LeafReaderContext)contexts.get((int)(currentContext + 1))).docBase : Integer.MAX_VALUE;
        IntObjectOpenHashMap ordBytes = null;
        if (values != null) {
            groupBits = new FixedBitSet(values.getValueCount());
            MultiDocValues.OrdinalMap ordinalMap = null;
            SortedDocValues[] sortedDocValues = null;
            LongValues segmentOrdinalMap = null;
            SortedDocValues currentValues = null;
            if (values instanceof MultiDocValues.MultiSortedDocValues) {
                ordinalMap = ((MultiDocValues.MultiSortedDocValues)values).mapping;
                sortedDocValues = ((MultiDocValues.MultiSortedDocValues)values).values;
                currentValues = sortedDocValues[currentContext];
                segmentOrdinalMap = ordinalMap.getGlobalOrds(currentContext);
            }
            int count = 0;
            ordBytes = new IntObjectOpenHashMap();
            for (int i = 0; i < globalDocs.length; ++i) {
                BytesRef ref;
                int ord;
                int globalDoc = globalDocs[i];
                while (globalDoc >= nextDocBase) {
                    currentDocBase = ((LeafReaderContext)contexts.get((int)(++currentContext))).docBase;
                    int n = nextDocBase = currentContext + 1 < contexts.size() ? ((LeafReaderContext)contexts.get((int)(currentContext + 1))).docBase : Integer.MAX_VALUE;
                    if (ordinalMap == null) continue;
                    currentValues = sortedDocValues[currentContext];
                    segmentOrdinalMap = ordinalMap.getGlobalOrds(currentContext);
                }
                int contextDoc = globalDoc - currentDocBase;
                if (ordinalMap != null) {
                    ord = currentValues.getOrd(contextDoc);
                    if (ord <= -1) continue;
                    ++count;
                    ref = currentValues.lookupOrd(ord);
                    ord = (int)segmentOrdinalMap.get(ord);
                    ordBytes.put(ord, (Object)BytesRef.deepCopyOf((BytesRef)ref));
                    groupBits.set(ord);
                    collapsedSet.add(globalDoc);
                    continue;
                }
                ord = values.getOrd(globalDoc);
                if (ord <= -1) continue;
                ++count;
                ref = values.lookupOrd(ord);
                ordBytes.put(ord, (Object)BytesRef.deepCopyOf((BytesRef)ref));
                groupBits.set(ord);
                collapsedSet.add(globalDoc);
            }
            if (count > 0 && count < 200) {
                try {
                    groupQuery = this.getGroupQuery(field, count, (IntObjectOpenHashMap<BytesRef>)ordBytes);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        } else {
            groupSet = new LongOpenHashSet((int)((double)docList.size() * 1.25));
            NumericDocValues collapseValues = ((LeafReaderContext)contexts.get(currentContext)).reader().getNumericDocValues(field);
            int count = 0;
            for (int i = 0; i < globalDocs.length; ++i) {
                int globalDoc = globalDocs[i];
                while (globalDoc >= nextDocBase) {
                    currentDocBase = ((LeafReaderContext)contexts.get((int)(++currentContext))).docBase;
                    nextDocBase = currentContext + 1 < contexts.size() ? ((LeafReaderContext)contexts.get((int)(currentContext + 1))).docBase : Integer.MAX_VALUE;
                    collapseValues = ((LeafReaderContext)contexts.get(currentContext)).reader().getNumericDocValues(field);
                }
                int contextDoc = globalDoc - currentDocBase;
                long value = collapseValues.get(contextDoc);
                if (value == nullValue) continue;
                ++count;
                groupSet.add(value);
                collapsedSet.add(globalDoc);
            }
            if (count > 0 && count < 200) {
                groupQuery = this.getGroupQuery(field, fieldType, count, groupSet);
            }
        }
        if (sort != null) {
            sort = sort.rewrite((IndexSearcher)searcher);
        }
        Collector groupExpandCollector = null;
        groupExpandCollector = values != null ? new GroupExpandCollector(values, groupBits, collapsedSet, limit, sort) : new NumericGroupExpandCollector(field, nullValue, groupSet, collapsedSet, limit, sort);
        if (groupQuery != null) {
            newFilters.add(groupQuery);
        }
        SolrIndexSearcher.ProcessedFilter pfilter = searcher.getProcessedFilter(null, newFilters);
        if (pfilter.postFilter != null) {
            pfilter.postFilter.setLastDelegate(groupExpandCollector);
            collector = pfilter.postFilter;
        } else {
            collector = groupExpandCollector;
        }
        if (pfilter.filter == null) {
            searcher.search(query, (Collector)collector);
        } else {
            searcher.search((Query)new FilteredQuery(query, pfilter.filter), (Collector)collector);
        }
        LongObjectMap groups = ((GroupCollector)groupExpandCollector).getGroups();
        SimpleOrderedMap outMap = new SimpleOrderedMap();
        CharsRefBuilder charsRef = new CharsRefBuilder();
        for (LongObjectCursor cursor : groups) {
            long groupValue = cursor.key;
            TopDocsCollector topDocsCollector = (TopDocsCollector)cursor.value;
            TopDocs topDocs = topDocsCollector.topDocs();
            ScoreDoc[] scoreDocs = topDocs.scoreDocs;
            if (scoreDocs.length <= 0) continue;
            int[] docs = new int[scoreDocs.length];
            float[] scores = new float[scoreDocs.length];
            for (int i = 0; i < docs.length; ++i) {
                ScoreDoc scoreDoc = scoreDocs[i];
                docs[i] = scoreDoc.doc;
                scores[i] = scoreDoc.score;
            }
            DocSlice slice = new DocSlice(0, docs.length, docs, scores, topDocs.totalHits, topDocs.getMaxScore());
            if (fieldType instanceof StrField) {
                BytesRef bytesRef = (BytesRef)ordBytes.get((int)groupValue);
                fieldType.indexedToReadable(bytesRef, charsRef);
                String group = charsRef.toString();
                outMap.add(group, (Object)slice);
                continue;
            }
            if (fieldType instanceof TrieIntField || fieldType instanceof TrieLongField) {
                outMap.add(Long.toString(groupValue), (Object)slice);
                continue;
            }
            if (fieldType instanceof TrieFloatField) {
                outMap.add(Float.toString(Float.intBitsToFloat((int)groupValue)), (Object)slice);
                continue;
            }
            if (!(fieldType instanceof TrieDoubleField)) continue;
            outMap.add(Double.toString(Double.longBitsToDouble(groupValue)), (Object)slice);
        }
        rb.rsp.add("expanded", outMap);
    }

    @Override
    public int distributedProcess(ResponseBuilder rb) throws IOException {
        if (rb.doExpand && rb.stage < finishingStage) {
            return finishingStage;
        }
        return ResponseBuilder.STAGE_DONE;
    }

    @Override
    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        if (!rb.onePassDistributedQuery && (sreq.purpose & 0x40) == 0) {
            sreq.params.set(COMPONENT_NAME, new String[]{"false"});
        } else {
            sreq.params.set(COMPONENT_NAME, new String[]{"true"});
        }
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        if (!rb.doExpand) {
            return;
        }
        if ((sreq.purpose & 0x40) != 0) {
            SolrQueryRequest req = rb.req;
            NamedList expanded = (NamedList)req.getContext().get("expanded");
            if (expanded == null) {
                expanded = new SimpleOrderedMap();
                req.getContext().put("expanded", expanded);
            }
            for (ShardResponse srsp : sreq.responses) {
                NamedList response = srsp.getSolrResponse().getResponse();
                NamedList ex = (NamedList)response.get("expanded");
                for (int i = 0; i < ex.size(); ++i) {
                    String name = ex.getName(i);
                    SolrDocumentList val = (SolrDocumentList)ex.getVal(i);
                    expanded.add(name, (Object)val);
                }
            }
        }
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (!rb.doExpand) {
            return;
        }
        if (rb.stage != finishingStage) {
            return;
        }
        NamedList expanded = (NamedList)rb.req.getContext().get("expanded");
        if (expanded == null) {
            expanded = new SimpleOrderedMap();
        }
        rb.rsp.add("expanded", expanded);
    }

    private Query getGroupQuery(String fname, FieldType ft, int size, LongOpenHashSet groupSet) {
        BytesRef[] bytesRefs = new BytesRef[size];
        BytesRefBuilder term = new BytesRefBuilder();
        Iterator it = groupSet.iterator();
        int index = -1;
        String stringVal = null;
        while (it.hasNext()) {
            LongCursor cursor = (LongCursor)it.next();
            stringVal = ft instanceof TrieIntField || ft instanceof TrieLongField ? Long.toString(cursor.value) : (ft instanceof TrieFloatField ? Float.toString(Float.intBitsToFloat((int)cursor.value)) : Double.toString(Double.longBitsToDouble(cursor.value)));
            ft.readableToIndexed(stringVal, term);
            bytesRefs[++index] = term.toBytesRef();
        }
        return new SolrConstantScoreQuery((Filter)new QueryWrapperFilter((Query)new TermsQuery(fname, bytesRefs)));
    }

    private Query getGroupQuery(String fname, int size, IntObjectOpenHashMap<BytesRef> ordBytes) throws Exception {
        BytesRef[] bytesRefs = new BytesRef[size];
        int index = -1;
        for (IntObjectCursor cursor : ordBytes) {
            bytesRefs[++index] = (BytesRef)cursor.value;
        }
        return new SolrConstantScoreQuery((Filter)new QueryWrapperFilter((Query)new TermsQuery(fname, bytesRefs)));
    }

    @Override
    public String getDescription() {
        return "Expand Component";
    }

    @Override
    public URL[] getDocs() {
        try {
            return new URL[]{new URL("http://wiki.apache.org/solr/ExpandComponent")};
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private class ReaderWrapper
    extends FilterLeafReader {
        private String field;

        public ReaderWrapper(LeafReader leafReader, String field) {
            super(leafReader);
            this.field = field;
        }

        public SortedDocValues getSortedDocValues(String field) {
            return null;
        }

        public Object getCoreCacheKey() {
            return this.in.getCoreCacheKey();
        }

        public FieldInfos getFieldInfos() {
            Iterator it = this.in.getFieldInfos().iterator();
            ArrayList<FieldInfo> newInfos = new ArrayList<FieldInfo>();
            while (it.hasNext()) {
                FieldInfo fieldInfo = (FieldInfo)it.next();
                if (fieldInfo.name.equals(this.field)) {
                    FieldInfo f = new FieldInfo(fieldInfo.name, fieldInfo.number, fieldInfo.hasVectors(), fieldInfo.hasNorms(), fieldInfo.hasPayloads(), fieldInfo.getIndexOptions(), DocValuesType.NONE, fieldInfo.getDocValuesGen(), fieldInfo.attributes());
                    newInfos.add(f);
                    continue;
                }
                newInfos.add(fieldInfo);
            }
            FieldInfos infos = new FieldInfos(newInfos.toArray(new FieldInfo[newInfos.size()]));
            return infos;
        }
    }

    private static interface GroupCollector {
        public LongObjectMap getGroups();
    }

    private class NumericGroupExpandCollector
    implements Collector,
    GroupCollector {
        private NumericDocValues docValues;
        private String field;
        private LongObjectOpenHashMap<Collector> groups;
        private IntOpenHashSet collapsedSet;
        private long nullValue;

        public NumericGroupExpandCollector(String field, long nullValue, LongOpenHashSet groupSet, IntOpenHashSet collapsedSet, int limit, Sort sort) throws IOException {
            int numGroups = collapsedSet.size();
            this.nullValue = nullValue;
            this.groups = new LongObjectOpenHashMap(numGroups * 2);
            for (LongCursor cursor : groupSet) {
                TopScoreDocCollector collector = sort == null ? TopScoreDocCollector.create((int)limit) : TopFieldCollector.create((Sort)sort, (int)limit, (boolean)false, (boolean)false, (boolean)false);
                this.groups.put(cursor.value, (Object)collector);
            }
            this.field = field;
            this.collapsedSet = collapsedSet;
        }

        public boolean needsScores() {
            return true;
        }

        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            final int docBase = context.docBase;
            this.docValues = context.reader().getNumericDocValues(this.field);
            final LongObjectOpenHashMap leafCollectors = new LongObjectOpenHashMap();
            for (LongObjectCursor entry : this.groups) {
                leafCollectors.put(entry.key, (Object)((Collector)entry.value).getLeafCollector(context));
            }
            return new LeafCollector(){

                public void setScorer(Scorer scorer) throws IOException {
                    for (ObjectCursor c : leafCollectors.values()) {
                        ((LeafCollector)c.value).setScorer(scorer);
                    }
                }

                public void collect(int docId) throws IOException {
                    long value = NumericGroupExpandCollector.this.docValues.get(docId);
                    if (value != NumericGroupExpandCollector.this.nullValue && leafCollectors.containsKey(value) && !NumericGroupExpandCollector.this.collapsedSet.contains(docId + docBase)) {
                        LeafCollector c = (LeafCollector)leafCollectors.lget();
                        c.collect(docId);
                    }
                }
            };
        }

        public LongObjectOpenHashMap<Collector> getGroups() {
            return this.groups;
        }
    }

    private class GroupExpandCollector
    implements Collector,
    GroupCollector {
        private SortedDocValues docValues;
        private MultiDocValues.OrdinalMap ordinalMap;
        private SortedDocValues segmentValues;
        private LongValues segmentOrdinalMap;
        private MultiDocValues.MultiSortedDocValues multiSortedDocValues;
        private LongObjectMap<Collector> groups;
        private FixedBitSet groupBits;
        private IntOpenHashSet collapsedSet;

        public GroupExpandCollector(SortedDocValues docValues, FixedBitSet groupBits, IntOpenHashSet collapsedSet, int limit, Sort sort) throws IOException {
            int group;
            int numGroups = collapsedSet.size();
            this.groups = new LongObjectOpenHashMap(numGroups * 2);
            BitSetIterator iterator = new BitSetIterator((BitSet)groupBits, 0L);
            while ((group = iterator.nextDoc()) != Integer.MAX_VALUE) {
                TopScoreDocCollector collector = sort == null ? TopScoreDocCollector.create((int)limit) : TopFieldCollector.create((Sort)sort, (int)limit, (boolean)false, (boolean)false, (boolean)false);
                this.groups.put((long)group, (Object)collector);
            }
            this.collapsedSet = collapsedSet;
            this.groupBits = groupBits;
            this.docValues = docValues;
            if (docValues instanceof MultiDocValues.MultiSortedDocValues) {
                this.multiSortedDocValues = (MultiDocValues.MultiSortedDocValues)docValues;
                this.ordinalMap = this.multiSortedDocValues.mapping;
            }
        }

        public boolean needsScores() {
            return true;
        }

        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            int docBase = context.docBase;
            if (this.ordinalMap != null) {
                this.segmentValues = this.multiSortedDocValues.values[context.ord];
                this.segmentOrdinalMap = this.ordinalMap.getGlobalOrds(context.ord);
            }
            LongObjectOpenHashMap leafCollectors = new LongObjectOpenHashMap();
            for (LongObjectCursor entry : this.groups) {
                leafCollectors.put(entry.key, (Object)((Collector)entry.value).getLeafCollector(context));
            }
            return new LeafCollector((LongObjectMap)leafCollectors, docBase){
                final /* synthetic */ LongObjectMap val$leafCollectors;
                final /* synthetic */ int val$docBase;
                {
                    this.val$leafCollectors = longObjectMap;
                    this.val$docBase = n;
                }

                public void setScorer(Scorer scorer) throws IOException {
                    for (ObjectCursor c : this.val$leafCollectors.values()) {
                        ((LeafCollector)c.value).setScorer(scorer);
                    }
                }

                public void collect(int docId) throws IOException {
                    int globalDoc = docId + this.val$docBase;
                    int ord = -1;
                    if (GroupExpandCollector.this.ordinalMap != null) {
                        ord = GroupExpandCollector.this.segmentValues.getOrd(docId);
                        if (ord > -1) {
                            ord = (int)GroupExpandCollector.this.segmentOrdinalMap.get(ord);
                        }
                    } else {
                        ord = GroupExpandCollector.this.docValues.getOrd(globalDoc);
                    }
                    if (ord > -1 && GroupExpandCollector.this.groupBits.get(ord) && !GroupExpandCollector.this.collapsedSet.contains(globalDoc)) {
                        LeafCollector c = (LeafCollector)this.val$leafCollectors.get((long)ord);
                        c.collect(docId);
                    }
                }
            };
        }

        public LongObjectMap<Collector> getGroups() {
            return this.groups;
        }
    }
}

