/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.util.Defs;
import ice.util.Settings;
import java.io.Serializable;

public class CookieManagerSettings
implements Serializable,
Settings {
    private static final boolean COOKIE_EXPIRATION_BUFFER_ENABLED_DEFAULT = false;
    private static final String COOKIE_EXPIRATION_BUFFER_ENABLED_KEY = "ice.net.cookieExpirationBufferEnabled";
    private static final boolean PERSIST_PRIVATE_COOKIES_DEFAULT = true;
    private static final String PERSIST_PRIVATE_COOKIES_KEY = "ice.net.persistPrivateCookies";
    private boolean cookieExpirationBufferEnabled;
    private boolean persistPrivateCookies;

    public CookieManagerSettings() {
        this.initialize();
    }

    public boolean equals(Object object) {
        return object instanceof CookieManagerSettings && ((CookieManagerSettings)object).cookieExpirationBufferEnabled == this.cookieExpirationBufferEnabled && ((CookieManagerSettings)object).persistPrivateCookies == this.persistPrivateCookies;
    }

    public boolean isCookieExpirationBufferEnabled() {
        return this.cookieExpirationBufferEnabled;
    }

    public static boolean isDefaultCookieExpirationBufferEnabled() {
        return Defs.sysPropertyBoolean((String)COOKIE_EXPIRATION_BUFFER_ENABLED_KEY, (boolean)false);
    }

    public void resetToDefault() {
        this.initialize();
    }

    public void setCookieExpirationBufferEnabled(boolean cookieExpirationBufferEnabled) {
        this.cookieExpirationBufferEnabled = cookieExpirationBufferEnabled;
    }

    public static void setDefaultCookieExpirationBufferEnabled(boolean cookieExpirationBufferEnabled) {
        Defs.setSystemProperty((String)COOKIE_EXPIRATION_BUFFER_ENABLED_KEY, (String)new Boolean(cookieExpirationBufferEnabled).toString());
    }

    public static void setDefaultPersistPrivateCookies(boolean persistPrivateCookies) {
        Defs.setSystemProperty((String)PERSIST_PRIVATE_COOKIES_KEY, (String)new Boolean(persistPrivateCookies).toString());
    }

    public void setPersistPrivateCookies(boolean persistPrivateCookies) {
        this.persistPrivateCookies = persistPrivateCookies;
    }

    public static boolean shouldDefaultPersistPrivateCookies() {
        return Defs.sysPropertyBoolean((String)PERSIST_PRIVATE_COOKIES_KEY, (boolean)true);
    }

    public boolean shouldPersistPrivateCookies() {
        return this.persistPrivateCookies;
    }

    public String toString() {
        return "CookieManagerSettings [cookieExpirationBufferEnabled: " + this.cookieExpirationBufferEnabled + ", " + "persistPrivateCookies: " + this.persistPrivateCookies + "]";
    }

    private void initialize() {
        this.cookieExpirationBufferEnabled = CookieManagerSettings.isDefaultCookieExpirationBufferEnabled();
        this.persistPrivateCookies = CookieManagerSettings.shouldDefaultPersistPrivateCookies();
    }
}

