/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document.webkit;

import coldfusion.document.webkit.Base64Encoder;
import coldfusion.document.webkit.HttpPDFRequestHandler;
import coldfusion.document.webkit.PDFgCryptoUtils;
import coldfusion.document.webkit.PDFgErrorHandler;
import coldfusion.document.webkit.PDFgServiceManager;
import coldfusion.document.webkit.PDFgServiceManagerSetupException;
import coldfusion.log.CFLogs;
import coldfusion.pdfg.jetty.PDFGServiceImpl;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Cast;
import coldfusion.security.SecurityUtils;
import coldfusion.server.ConfigMap;
import coldfusion.server.LicenseService;
import coldfusion.server.ServiceFactory;
import coldfusion.server.SystemInfo;
import coldfusion.tagext.io.FileUtils;
import coldfusion.util.RB;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public final class PDFgServiceManagerHelper {
    public static final String COLON = ":";
    public static final int DEFAULT_WEIGHT = 2;
    public static final int DEFAULT_PORT = 8993;
    public static final String SERVLET = "/PDFgServlet/";
    public static final String URL_PROTOCOL = "http://";
    public static final String URL_PROTOCOL_SSL = "https://";
    public static final String NAME = "name";
    public static final String HOSTNAME = "hostname";
    public static final String PORT = "port";
    public static final String WEIGHT = "weight";
    public static final String ISLOCAL = "islocal";
    public static final String ISHTTPS = "ishttps";
    public static final String ISENABLED = "isenabled";
    public static final String LOCALHOST = "localhost";
    private static String PRIVATE_KEY_NAME = ".prikey";
    public static final String LOOPBACK_ADDRESS = "127.0.0.1";
    public static boolean supportsLocalSM = (SystemInfo.isWindows() || SystemInfo.isLinux()) && !SystemInfo.isPPC();
    public static boolean localSMEnabled = false;
    private static volatile PDFgServiceManagerHelper instance = null;
    protected static List<PDFgServiceManager> pdfgServiceManagers = new ArrayList<PDFgServiceManager>();
    protected static AtomicInteger enabledStdCount = new AtomicInteger(0);
    private String seed;
    private String priKeyPath;
    private BigInteger pKeyMod;
    private BigInteger pKeyExp;
    private PrivateKey privateKey;
    public static String serverId;
    private int defaultPort = 8993;
    private LicenseService licenseService = ServiceFactory.getLicenseService();

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public void setDefaultPort(int defaultPort) {
        this.defaultPort = defaultPort;
    }

    protected PDFgServiceManagerHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PDFgServiceManagerHelper getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<PDFgServiceManagerHelper> clazz = PDFgServiceManagerHelper.class;
        synchronized (PDFgServiceManagerHelper.class) {
            if (instance == null) {
                instance = new PDFgServiceManagerHelper();
                if (serverId == null) {
                    serverId = instance.getServerId();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getServerId() {
        if (serverId != null && serverId.length() > 0) {
            return serverId;
        }
        serverId = Base64Encoder.encode(SecurityUtils.generateRandom((int)10));
        return serverId;
    }

    public PDFgServiceManager enableServiceManager(PDFgServiceManager serviceManager) {
        if (serviceManager.isEnabled()) {
            return null;
        }
        boolean verified = true;
        verified = this.verifyServiceManager(serviceManager);
        if (!verified) {
            throw new PDFgErrorHandler.ConnectionVerificationFailedException();
        }
        this.checkEnabledForStd();
        serviceManager.setEnabled(true);
        this.registerServiceManager(serviceManager);
        if (serviceManager.isLocal()) {
            localSMEnabled = true;
        }
        return serviceManager;
    }

    public PDFgServiceManager disableServiceManager(PDFgServiceManager serviceManager) {
        if (!serviceManager.isEnabled()) {
            return null;
        }
        if (serviceManager.isEnabled()) {
            this.checkDisabledForStd();
        }
        this.unRegisterServiceManager(serviceManager, false);
        if (serviceManager.isLocal()) {
            localSMEnabled = false;
        }
        serviceManager.setEnabled(false);
        return serviceManager;
    }

    public void checkDisabledForStd() {
        if (this.licenseService.isStandard()) {
            int count = enabledStdCount.get();
            if (count == 1) {
                enabledStdCount.compareAndSet(count, count - 1);
            } else {
                count = this.getEnabledSMCount();
                if (count == 1) {
                    enabledStdCount.compareAndSet(count, count - 1);
                } else {
                    this.disableNResetAllSMs();
                }
            }
        }
    }

    protected void checkEnabledForStd() {
        if (this.licenseService.isStandard()) {
            int count = enabledStdCount.get();
            if (count == 0) {
                enabledStdCount.compareAndSet(count, 1);
            } else {
                count = this.getEnabledSMCount();
                if (count == 0) {
                    enabledStdCount.compareAndSet(count, 1);
                } else {
                    if (count == 1) {
                        throw new UnsupportedServiceManagerexception();
                    }
                    this.disableNResetAllSMs();
                }
            }
        }
    }

    private void disableNResetAllSMs() {
        this.disableAllSMs();
        enabledStdCount.set(0);
        throw new InconsistentServiceManagerStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableAllSMs() {
        List<PDFgServiceManager> list = pdfgServiceManagers;
        synchronized (list) {
            for (PDFgServiceManager serviceManager : pdfgServiceManagers) {
                if (serviceManager == null || !serviceManager.isEnabled()) continue;
                this.unRegisterServiceManager(serviceManager, false);
                if (serviceManager.isLocal()) {
                    localSMEnabled = false;
                }
                serviceManager.setEnabled(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getEnabledSMCount() {
        int newCount = 0;
        List<PDFgServiceManager> list = pdfgServiceManagers;
        synchronized (list) {
            for (PDFgServiceManager serviceManager : pdfgServiceManagers) {
                if (serviceManager == null || !serviceManager.isEnabled()) continue;
                ++newCount;
            }
        }
        return newCount;
    }

    public boolean verifyServiceManager(PDFgServiceManager serviceManager) {
        boolean verified = false;
        try {
            verified = HttpPDFRequestHandler.verifyPDFgServiceManager(serviceManager);
        }
        catch (PDFgErrorHandler.ConnectionVerificationFailedException e) {
            throw e;
        }
        finally {
            if (!verified) {
                serviceManager.setEnabled(verified);
            }
        }
        return verified;
    }

    public ConfigMap serializeToMap(PDFgServiceManager serviceManager) {
        ConfigMap smObj = new ConfigMap();
        if (serviceManager.getName() != null) {
            smObj.put((Object)NAME, (Object)serviceManager.getName());
        } else {
            smObj.put((Object)NAME, (Object)LOCALHOST);
        }
        if (serviceManager.getHostname() != null) {
            smObj.put((Object)HOSTNAME, (Object)serviceManager.getHostname());
        } else {
            smObj.put((Object)HOSTNAME, (Object)LOCALHOST);
        }
        smObj.put((Object)PORT, (Object)serviceManager.getPort());
        smObj.put((Object)WEIGHT, (Object)serviceManager.getWeight());
        smObj.put((Object)ISLOCAL, (Object)serviceManager.isLocal());
        smObj.put((Object)ISHTTPS, (Object)serviceManager.isHttps());
        smObj.put((Object)ISENABLED, (Object)serviceManager.isEnabled());
        return smObj;
    }

    protected PDFgServiceManager loadFromConfigMapForView(ConfigMap settings) {
        PDFgServiceManager serviceManager = new PDFgServiceManager();
        if (settings.containsKey((Object)NAME)) {
            serviceManager.setName((String)settings.get((Object)NAME));
        }
        if (settings.containsKey((Object)HOSTNAME)) {
            serviceManager.setHostname((String)settings.get((Object)HOSTNAME));
        }
        if (settings.containsKey((Object)PORT)) {
            serviceManager.setPort(Cast._int((Object)settings.get((Object)PORT)));
        }
        if (settings.containsKey((Object)WEIGHT)) {
            serviceManager.setWeight(Cast._int((Object)settings.get((Object)WEIGHT)));
        }
        if (settings.containsKey((Object)ISLOCAL)) {
            serviceManager.setLocal(Cast._boolean((Object)settings.get((Object)ISLOCAL)));
        }
        if (settings.containsKey((Object)ISHTTPS)) {
            serviceManager.setHttps(Cast._boolean((Object)settings.get((Object)ISHTTPS)));
        }
        if (settings.containsKey((Object)ISENABLED)) {
            serviceManager.setEnabled(Cast._boolean((Object)settings.get((Object)ISENABLED)));
        }
        return serviceManager;
    }

    public PDFgServiceManager loadFromConfigMap(ConfigMap settings) {
        return this.loadFromConfigMapForView(settings);
    }

    public PDFgServiceManager createLocalPDFgServiceManager() {
        PDFgServiceManager serviceManager = new PDFgServiceManager();
        serviceManager.setName(LOCALHOST);
        serviceManager.setLocal(true);
        this.addServiceManager(serviceManager, false);
        return serviceManager;
    }

    public PDFgServiceManager createRegisterPDFgServiceManager(String name, String hostname, int port, int weight, boolean isHttps) {
        PDFgServiceManager serviceManager = new PDFgServiceManager(name, hostname, port, weight, isHttps);
        this.addServiceManager(serviceManager);
        return serviceManager;
    }

    public boolean addServiceManager(PDFgServiceManager serviceManager) {
        return this.addServiceManager(serviceManager, true);
    }

    public boolean addServiceManager(PDFgServiceManager serviceManager, boolean verify) {
        boolean olde;
        boolean updateConfig = false;
        if (serviceManager.isLocal() && serviceManager.isEnabled()) {
            localSMEnabled = true;
        }
        if (verify) {
            boolean oldEnableStatus = serviceManager.isEnabled();
            try {
                this.verifyServiceManager(serviceManager);
            }
            catch (PDFgErrorHandler.ConnectionVerificationFailedException e) {
                CFLogs.SERVER_LOG.error((Throwable)((Object)e));
            }
            if (serviceManager.isEnabled() != oldEnableStatus) {
                updateConfig = true;
            }
        }
        if (olde = serviceManager.isEnabled()) {
            serviceManager.setEnabled(false);
            try {
                this.checkEnabledForStd();
            }
            catch (UnsupportedServiceManagerexception e) {
                olde = false;
            }
            serviceManager.setEnabled(olde);
        }
        this.sortNAddSM(serviceManager);
        this.registerServiceManager(serviceManager);
        return updateConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortNAddSM(PDFgServiceManager serviceManager) {
        List<PDFgServiceManager> list = pdfgServiceManagers;
        synchronized (list) {
            int i = Collections.binarySearch(pdfgServiceManagers, serviceManager);
            int indexToAdd = 0;
            indexToAdd = i >= 0 ? i : -(i + 1);
            pdfgServiceManagers.add(indexToAdd, serviceManager);
        }
    }

    public PDFgServiceManager getServiceManager(String name) {
        if (name == null) {
            return null;
        }
        for (PDFgServiceManager serviceManager : pdfgServiceManagers) {
            if (!serviceManager.getName().equalsIgnoreCase(name)) continue;
            return serviceManager;
        }
        return null;
    }

    public List<PDFgServiceManager> getServiceManagers() {
        return new ArrayList<PDFgServiceManager>(pdfgServiceManagers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServiceManager(PDFgServiceManager serviceManager) {
        if (serviceManager.isEnabled() && !serviceManager.isRegistered() && !serviceManager.isRegisterInProgress()) {
            PDFgServiceManager pDFgServiceManager = serviceManager;
            synchronized (pDFgServiceManager) {
                if (!serviceManager.isRegistered() && !serviceManager.isRegisterInProgress()) {
                    byte[] encryptedSessionId = HttpPDFRequestHandler.registerPDFgServiceManager(serviceManager);
                    this.createSMAuthToken(encryptedSessionId, serviceManager);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reRegisterServiceManager(PDFgServiceManager serviceManager) {
        if (!serviceManager.isRegisterInProgress()) {
            PDFgServiceManager pDFgServiceManager = serviceManager;
            synchronized (pDFgServiceManager) {
                serviceManager.setRegisterInProgress(true);
                serviceManager.nullifyRegisterState();
                if (serviceManager.isEnabled()) {
                    byte[] encryptedSessionId = HttpPDFRequestHandler.registerPDFgServiceManager(serviceManager);
                    this.createSMAuthToken(encryptedSessionId, serviceManager);
                }
            }
        }
        try {
            Thread.currentThread().wait(5L);
        }
        catch (InterruptedException e) {
            CFLogs.SERVER_LOG.error((Throwable)e);
        }
        try {
            if (!serviceManager.isRegistered() && !serviceManager.isRegisterInProgress()) {
                this.reRegisterServiceManager(serviceManager);
            }
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterServiceManager(PDFgServiceManager serviceManager, boolean removeFromList) {
        if (removeFromList) {
            List<PDFgServiceManager> list = pdfgServiceManagers;
            synchronized (list) {
                pdfgServiceManagers.remove(serviceManager);
            }
        }
        HttpPDFRequestHandler.unregisterPDFgServiceManager(serviceManager);
    }

    public PDFgServiceManager getPDFgServiceManager(boolean needLocal) {
        PDFgServiceManager serviceManager = this.getAvailableSM(needLocal);
        if (!serviceManager.isRegistered() && !serviceManager.isRegisterInProgress()) {
            serviceManager = this.reRegisterServiceManager(needLocal, serviceManager);
        }
        if (serviceManager == null) {
            throw new NoServiceManagerFoundException();
        }
        return serviceManager;
    }

    public PDFgServiceManager reRegisterServiceManager(boolean needLocal, PDFgServiceManager serviceManager) {
        try {
            this.reRegisterServiceManager(serviceManager);
            if (!serviceManager.isRegistered() && !serviceManager.isRegisterInProgress()) {
                serviceManager = this.getAvailableSM(needLocal);
            }
        }
        catch (Exception e) {
            serviceManager = this.getAvailableSM(needLocal);
        }
        return serviceManager;
    }

    public PDFgServiceManager getAvailableSM(boolean needLocal) {
        if (pdfgServiceManagers.isEmpty()) {
            throw new NoServiceManagerFoundException();
        }
        if (needLocal && supportsLocalSM && localSMEnabled) {
            return this.getLocalSM();
        }
        ArrayList<PDFgServiceManager> currentSms = new ArrayList<PDFgServiceManager>();
        for (PDFgServiceManager pdFgServiceManager : pdfgServiceManagers) {
            if (!pdFgServiceManager.isEnabled()) continue;
            currentSms.add(pdFgServiceManager);
        }
        if (currentSms.isEmpty()) {
            throw new NoServiceManagerFoundException();
        }
        int length = currentSms.size();
        for (int j = 0; j < length; ++j) {
            PDFgServiceManager serviceManager = (PDFgServiceManager)currentSms.get(j);
            if (serviceManager.getCurrentWeight() > 0) {
                if (j < length - 1) {
                    boolean updated;
                    PDFgServiceManager nextServiceManager = (PDFgServiceManager)currentSms.get(j + 1);
                    if (nextServiceManager == null || serviceManager.getCurrentWeight() < nextServiceManager.getCurrentWeight() || !(updated = serviceManager.decrementCurrentWeight(serviceManager.getCurrentWeight()))) continue;
                    return serviceManager;
                }
                if (serviceManager.getCurrentWeight() > 0) {
                    boolean updated = serviceManager.decrementCurrentWeight(serviceManager.getCurrentWeight());
                    if (!updated) {
                        if (serviceManager.getCurrentWeight() > 0) {
                            updated = serviceManager.decrementCurrentWeight(serviceManager.getCurrentWeight());
                            if (!updated) {
                                if (serviceManager.getCurrentWeight() <= 0) {
                                    this.resetAllCurrentWeights();
                                    return this.getAvailableSM(needLocal);
                                }
                                return this.getAvailableSM(needLocal);
                            }
                            return serviceManager;
                        }
                        this.resetAllCurrentWeights();
                        return this.getAvailableSM(needLocal);
                    }
                    return serviceManager;
                }
                this.resetAllCurrentWeights();
                return this.getAvailableSM(needLocal);
            }
            if (j != length - 1) continue;
            this.resetAllCurrentWeights();
            return this.getAvailableSM(needLocal);
        }
        throw new NoServiceManagerFoundException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetAllCurrentWeights() {
        Iterator<PDFgServiceManager> iterator = pdfgServiceManagers.iterator();
        while (iterator.hasNext()) {
            PDFgServiceManager serviceManager;
            PDFgServiceManager pDFgServiceManager = serviceManager = iterator.next();
            synchronized (pDFgServiceManager) {
                serviceManager.resetCurrentWeight();
            }
        }
    }

    private PDFgServiceManager getLocalSM() {
        ArrayList<PDFgServiceManager> currentSms = new ArrayList<PDFgServiceManager>();
        currentSms.addAll(pdfgServiceManagers);
        for (PDFgServiceManager serviceManager : currentSms) {
            boolean updated;
            int currentWeight;
            if (!serviceManager.isLocal()) continue;
            while ((currentWeight = serviceManager.getCurrentWeight()) != 0 && !(updated = serviceManager.decrementCurrentWeight(currentWeight))) {
            }
            return serviceManager;
        }
        throw new ServiceManagerNotFoundException(LOCALHOST);
    }

    public void setPrivateKeyPath(String keyFilePath) {
        this.priKeyPath = keyFilePath + PRIVATE_KEY_NAME;
    }

    public void setSeed(String seed) {
        this.seed = seed;
    }

    protected void createSMAuthToken(byte[] encryptedSessionId, PDFgServiceManager serviceManager) {
        byte[] decryptedSessionId;
        if (encryptedSessionId != null && (decryptedSessionId = PDFgCryptoUtils.rsaDecrypt(encryptedSessionId, this.privateKey)) != null) {
            Long sessionId = PDFgCryptoUtils.byteToLong(decryptedSessionId);
            String sessionIdStr = String.valueOf(sessionId);
            long aToken = PDFgCryptoUtils.generateRandom();
            String authTokenStr = String.valueOf(aToken);
            String encryptedAuthToken = PDFgCryptoUtils.encrypt(authTokenStr, sessionIdStr);
            serviceManager.setRegisterState(encryptedAuthToken, sessionIdStr);
        }
    }

    protected void encryptSetStorePKey(BigInteger pKeyMod, BigInteger pKeyExp) {
        this.pKeyMod = pKeyMod;
        this.pKeyExp = pKeyExp;
        this.encryptNStorePKey();
    }

    private void encryptNStorePKey() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PDFgServiceManagerHelper.this.encryptNWriteToFile(PDFgServiceManagerHelper.this.priKeyPath);
                return null;
            }
        });
    }

    public void loadPrivateKey() {
        block6: {
            if (this.priKeyPath != null && this.seed != null) {
                boolean bcAdded = false;
                try {
                    bcAdded = PDFgCryptoUtils.addBCProvider();
                    this.readNDecryptFromFile(this.priKeyPath);
                    if (this.pKeyMod != null && this.pKeyExp != null) {
                        this.privateKey = PDFgCryptoUtils.createPrivateKeyObj(this.pKeyMod, this.pKeyExp);
                        break block6;
                    }
                    throw new PDFgServiceManagerSetupException(RB.getString(PDFgServiceManagerHelper.class, (String)"KEYS_LOAD_ERROR"));
                }
                finally {
                    if (bcAdded) {
                        PDFgCryptoUtils.removeBCProvider();
                    }
                }
            }
            throw new PDFgServiceManagerSetupException(RB.getString(PDFgServiceManagerHelper.class, (String)"KEYS_LOAD_ERROR"));
        }
    }

    public void reEncryptPKey() {
        try {
            this.encryptSetStorePKey(this.pKeyMod, this.pKeyExp);
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error((Throwable)e);
        }
    }

    protected void encryptNWriteToFile(String fileName) {
        ObjectOutputStream oout = null;
        try {
            oout = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));
            String encryptedMod = PDFgCryptoUtils.encrypt(this.pKeyMod.toString(), this.seed);
            String encryptedExp = PDFgCryptoUtils.encrypt(this.pKeyExp.toString(), this.seed);
            oout.writeObject(encryptedMod);
            oout.writeObject(encryptedExp);
        }
        catch (FileNotFoundException e) {
            throw new PDFgServiceManagerSetupException(RB.getString(PDFgServiceManagerHelper.class, (String)"KEYS_LOAD_ERROR"), e);
        }
        catch (IOException ioe) {
            throw new PDFgServiceManagerSetupException(RB.getString(PDFgServiceManagerHelper.class, (String)"KEYS_LOAD_ERROR"), ioe);
        }
        finally {
            try {
                if (oout != null) {
                    oout.close();
                }
            }
            catch (IOException ioe) {
                throw new PDFgServiceManagerSetupException(RB.getString(PDFgServiceManagerHelper.class, (String)"KEYS_LOAD_ERROR"), ioe);
            }
        }
        try {
            FileUtils.setUnixModes((String)this.priKeyPath, (int)600);
        }
        catch (IOException e) {
            throw new PDFgServiceManagerSetupException(RB.getString(PDFgServiceManagerHelper.class, (String)"KEYS_LOAD_ERROR"), e);
        }
    }

    private void readNDecryptFromFile(String fileName) {
        ObjectInputStream oin = null;
        try {
            String decryptedE;
            String decryptedM;
            oin = new ObjectInputStream(new BufferedInputStream(new FileInputStream(fileName)));
            String mRead = (String)oin.readObject();
            String eRead = (String)oin.readObject();
            boolean reEncrypt = false;
            try {
                decryptedM = PDFgCryptoUtils.decrypt(mRead, this.seed);
                decryptedE = PDFgCryptoUtils.decrypt(eRead, this.seed);
            }
            catch (Exception e) {
                decryptedM = PDFgCryptoUtils.decrypt(mRead, PDFGServiceImpl.oldSeed);
                decryptedE = PDFgCryptoUtils.decrypt(eRead, PDFGServiceImpl.oldSeed);
                reEncrypt = true;
            }
            this.pKeyMod = new BigInteger(decryptedM);
            this.pKeyExp = new BigInteger(decryptedE);
            if (reEncrypt) {
                this.reEncryptPKey();
            }
        }
        catch (IOException e) {
            throw new PDFgServiceManagerSetupException(RB.getString(PDFgServiceManagerHelper.class, (String)"KEYS_LOAD_ERROR"), e);
        }
        catch (ClassNotFoundException e) {
            throw new PDFgServiceManagerSetupException(RB.getString(PDFgServiceManagerHelper.class, (String)"KEYS_LOAD_ERROR"), e);
        }
        finally {
            try {
                if (oin != null) {
                    oin.close();
                }
            }
            catch (IOException ioe) {
                throw new PDFgServiceManagerSetupException(RB.getString(PDFgServiceManagerHelper.class, (String)"KEYS_LOAD_ERROR"), ioe);
            }
        }
    }

    public static class InconsistentServiceManagerStateException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class UnsupportedServiceManagerexception
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class ServiceManagerNotFoundException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String host = "";

        public ServiceManagerNotFoundException(String host) {
            this.host = host;
        }
    }

    public static class NoServiceManagerFoundException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }
}

