/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.eventgateway.flex.rmi;

import coldfusion.eventgateway.flex.FlexMessagingGateway;
import coldfusion.eventgateway.flex.rmi.FlexToCFProxy;
import flex.messaging.MessageException;
import flex.messaging.messages.AsyncMessage;
import java.rmi.RemoteException;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;

public class FlexToCFProxyServer
extends UnicastRemoteObject
implements FlexToCFProxy {
    private FlexMessagingGateway gw;

    public FlexToCFProxyServer(FlexMessagingGateway gateway) throws RemoteException {
        this.gw = gateway;
    }

    @Override
    public boolean sendToCFGateway(AsyncMessage msg) {
        this.checkPermissions();
        boolean ret = false;
        int status = this.gw.getStatus();
        if (status == 2) {
            ret = this.gw.incomingMessage(msg);
        }
        return ret;
    }

    private void checkPermissions() throws MessageException {
        try {
            String host = FlexToCFProxyServer.getClientHost();
            if (!this.gw.verifyHost(host)) {
                throw new MessageException("Permission denied");
            }
        }
        catch (ServerNotActiveException e) {
            throw new MessageException("Permission denied");
        }
    }
}

