/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.net;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import macromedia.sequelink.net.IIOP;
import macromedia.sequelink.net.IIOPFormat;
import macromedia.sequelink.net.IIOPOctetSequence;
import macromedia.sequelink.net.IIOPString;
import macromedia.sequelink.net.NetworkException;

public class IIOPDecoder {
    DataInputStream dis;
    IIOP iiop;
    IIOPFormat iiopFormat;

    public IIOPDecoder(InputStream inputStream) throws NetworkException {
        this.dis = new DataInputStream(inputStream);
        this.decodeProtocolIdentifier();
        this.decodeProtocolHeader();
    }

    public IIOPDecoder(InputStream inputStream, IIOP iIOP) throws NetworkException {
        this.dis = new DataInputStream(inputStream);
        this.iiop = iIOP;
        this.decodeProtocolMessage();
    }

    public IIOP getIIOP() {
        return this.iiop;
    }

    public IIOPFormat getIIOPFormat() {
        return this.iiopFormat;
    }

    private void decodeProtocolIdentifier() throws NetworkException {
        byte[] byArray = new byte[4];
        try {
            this.dis.readFully(byArray);
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
        IIOPFormat.validateProtoId(byArray);
    }

    private void decodeProtocolHeader() throws NetworkException {
        int n2;
        byte by2;
        byte by3;
        byte by4;
        byte by5;
        try {
            by5 = this.dis.readByte();
            by4 = this.dis.readByte();
            by3 = this.dis.readByte();
            by2 = this.dis.readByte();
            n2 = this.dis.readInt();
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
        this.iiopFormat = new IIOPFormat(by5, by4, by2, by3, n2);
        this.iiop = this.iiopFormat.getIIOP();
    }

    private void decodeProtocolMessage() throws NetworkException {
        switch (this.iiop.getMsgType()) {
            case 0: {
                this.decodeRequest();
                break;
            }
            case 1: {
                this.decodeReply();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw IIOP.getException(7524);
            }
        }
    }

    private void decodeRequest() throws NetworkException {
        byte by2;
        int n2;
        int n3;
        byte by3;
        int n4;
        int n5;
        try {
            n5 = this.dis.readInt();
            n4 = this.dis.readInt();
            by3 = this.dis.readByte();
            byte by4 = this.dis.readByte();
            by4 = this.dis.readByte();
            by4 = this.dis.readByte();
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
        IIOPOctetSequence iIOPOctetSequence = new IIOPOctetSequence(this.dis, this.iiop.isBigEndian());
        IIOPString iIOPString = new IIOPString(this.dis, this.iiop.isBigEndian());
        try {
            n3 = this.dis.readInt();
            n2 = this.dis.readInt();
            by2 = this.dis.readByte();
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
        this.iiopFormat = new IIOPFormat(this.iiop, n5, n4, by3, iIOPOctetSequence, iIOPString, n3, n2, by2);
        this.iiop = this.iiopFormat.getIIOP();
    }

    private void decodeReply() throws NetworkException {
        int n2;
        int n3;
        int n4;
        try {
            n4 = this.dis.readInt();
            n3 = this.dis.readInt();
            n2 = this.dis.readInt();
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
        this.iiopFormat = new IIOPFormat(this.iiop, n4, n3, n2);
        this.iiop = this.iiopFormat.getIIOP();
        if (this.iiop.getReplyStatus() == 0) {
            byte by2;
            int n5;
            try {
                n5 = this.dis.readInt();
            }
            catch (IOException iOException) {
                throw IIOP.getException(7531, iOException.getMessage());
            }
            try {
                by2 = this.dis.readByte();
            }
            catch (IOException iOException) {
                throw IIOP.getException(7531, iOException.getMessage());
            }
            if (by2 != 0) {
                throw IIOP.getException(7532);
            }
            this.iiop.setDataLen(n5);
        } else {
            try {
                this.iiop.setDataLen(this.dis.available());
            }
            catch (IOException iOException) {
                throw IIOP.getException(7531, iOException.getMessage());
            }
        }
    }
}

