/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import macromedia.jdbc.slbase.BaseConnection;

public class BaseTimestamp {
    int year;
    int month;
    int date;
    int hours;
    int minutes;
    int seconds;
    long millis = -1L;
    int nanos;

    BaseTimestamp(Timestamp timestamp, Calendar calendar) {
        calendar = calendar == null ? new GregorianCalendar() : (Calendar)calendar.clone();
        calendar.setTime(timestamp);
        this.year = calendar.get(1);
        this.month = calendar.get(2);
        this.date = calendar.get(5);
        this.hours = calendar.get(11);
        this.minutes = calendar.get(12);
        this.seconds = calendar.get(13);
        this.millis = calendar.getTime().getTime();
        this.nanos = timestamp.getNanos();
    }

    BaseTimestamp(Calendar calendar, int n2) {
        this.year = calendar.get(1);
        this.month = calendar.get(2);
        this.date = calendar.get(5);
        this.hours = calendar.get(11);
        this.minutes = calendar.get(12);
        this.seconds = calendar.get(13);
        this.millis = calendar.getTime().getTime();
        this.nanos = n2;
    }

    public BaseTimestamp(int n2, int n3, int n4, int n5, int n6, int n7, int n8, Calendar calendar) {
        if (calendar == null) {
            this.year = n2;
            this.month = n3;
            this.date = n4;
            this.hours = n5;
            this.minutes = n6;
            this.seconds = n7;
        } else {
            calendar = (Calendar)calendar.clone();
            calendar.clear();
            calendar.set(n2, n3, n4, n5, n6, n7);
            this.year = calendar.get(1);
            this.month = calendar.get(2);
            this.date = calendar.get(5);
            this.hours = calendar.get(11);
            this.minutes = calendar.get(12);
            this.seconds = calendar.get(13);
            this.millis = calendar.getTime().getTime();
        }
        this.nanos = n8;
    }

    public BaseTimestamp(int n2, int n3, int n4, long l2) {
        this.year = n2;
        this.month = n3;
        this.date = n4;
        this.hours = (int)(l2 / 1000L / 60L / 60L);
        this.minutes = (int)(l2 / 1000L / 60L % 60L);
        this.seconds = (int)(l2 / 1000L % 60L);
        this.nanos = (int)(l2 % 1000L * 1000000L);
    }

    Timestamp getTimestamp() {
        Timestamp timestamp = new Timestamp(this.getMillis());
        timestamp.setNanos(this.nanos);
        return timestamp;
    }

    public long getMillis() {
        if (this.millis == -1L) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.year, this.month, this.date, this.hours, this.minutes, this.seconds);
            this.millis = gregorianCalendar.getTime().getTime();
        }
        return this.millis;
    }

    public int getYear() {
        return this.year;
    }

    public int getDateClassCompatiableYear() {
        return this.year - 1900;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDate() {
        return this.date;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getNanos() {
        return this.nanos;
    }

    public String toString() {
        String string;
        String string2;
        if (this.millis == -1L) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.year, this.month, this.date, this.hours, this.minutes, this.seconds);
            this.year = gregorianCalendar.get(1);
            this.month = gregorianCalendar.get(2);
            this.date = gregorianCalendar.get(5);
            this.hours = gregorianCalendar.get(11);
            this.minutes = gregorianCalendar.get(12);
            this.seconds = gregorianCalendar.get(13);
            this.millis = gregorianCalendar.getTime().getTime();
        }
        int n2 = this.year;
        int n3 = this.month + 1;
        int n4 = this.date;
        int n5 = this.hours;
        int n6 = this.minutes;
        int n7 = this.seconds;
        String string3 = "000000000";
        String string4 = "0000";
        if (n2 < 1000) {
            string2 = "" + n2;
            string2 = string4.substring(0, 4 - string2.length()) + string2;
        } else {
            string2 = "" + n2;
        }
        String string5 = n3 < 10 ? "0" + n3 : Integer.toString(n3);
        String string6 = n4 < 10 ? "0" + n4 : Integer.toString(n4);
        String string7 = n5 < 10 ? "0" + n5 : Integer.toString(n5);
        String string8 = n6 < 10 ? "0" + n6 : Integer.toString(n6);
        String string9 = n7 < 10 ? "0" + n7 : Integer.toString(n7);
        int n8 = this.getNanos();
        if (n8 == 0) {
            string = "0";
        } else {
            string = Integer.toString(n8);
            string = string3.substring(0, 9 - string.length()) + string;
            char[] cArray = new char[string.length()];
            string.getChars(0, string.length(), cArray, 0);
            int n9 = 8;
            while (cArray[n9] == '0') {
                --n9;
            }
            string = new String(cArray, 0, n9 + 1);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append("-");
        stringBuffer.append(string5);
        stringBuffer.append("-");
        stringBuffer.append(string6);
        stringBuffer.append(" ");
        stringBuffer.append(string7);
        stringBuffer.append(":");
        stringBuffer.append(string8);
        stringBuffer.append(":");
        stringBuffer.append(string9);
        stringBuffer.append(".");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public String timeToString() {
        if (this.millis == -1L) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.year, this.month, this.date, this.hours, this.minutes, this.seconds);
            this.year = gregorianCalendar.get(1);
            this.month = gregorianCalendar.get(2);
            this.date = gregorianCalendar.get(5);
            this.hours = gregorianCalendar.get(11);
            this.minutes = gregorianCalendar.get(12);
            this.seconds = gregorianCalendar.get(13);
            this.millis = gregorianCalendar.getTime().getTime();
        }
        int n2 = this.year;
        int n3 = this.month + 1;
        int n4 = this.date;
        int n5 = this.hours;
        int n6 = this.minutes;
        int n7 = this.seconds;
        String string = "000000000";
        String string2 = "0000";
        String string3 = n5 < 10 ? "0" + n5 : Integer.toString(n5);
        String string4 = n6 < 10 ? "0" + n6 : Integer.toString(n6);
        String string5 = n7 < 10 ? "0" + n7 : Integer.toString(n7);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string3);
        stringBuffer.append(":");
        stringBuffer.append(string4);
        stringBuffer.append(":");
        stringBuffer.append(string5);
        return stringBuffer.toString();
    }

    public static BaseTimestamp valueOf(String string) {
        int n2 = string.indexOf(32);
        if (n2 > 0) {
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1);
            return BaseTimestamp.valueOf(string2, string3, 0);
        }
        String string4 = "Timestamp format must be yyyy-mm-dd hh:mm:ss.fffffffff";
        throw new IllegalArgumentException(string4);
    }

    public static BaseTimestamp valueOf(String string, BaseConnection baseConnection) {
        String string2;
        String string3;
        int n2 = (string = string.trim()).indexOf(32);
        if (n2 > 0) {
            string3 = string.substring(0, n2);
            string2 = string.substring(n2 + 1);
        } else if (string.indexOf(45) != -1) {
            string3 = string;
            string2 = null;
        } else if (string.indexOf(58) != -1) {
            string3 = null;
            string2 = string;
        } else {
            String string4 = "Timestamp format must be one of the following: yyyy-mm-dd hh:mm:ss.fffffffff, yyyy-mm-dd, or hh:mm:ss.fffffffff";
            throw new IllegalArgumentException(string4);
        }
        return BaseTimestamp.valueOf(string3, string2, baseConnection.getDateTimeBehavior());
    }

    public static BaseTimestamp valueOf(String string, String string2, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        String string3 = "Timestamp format must be one of the following: yyyy-mm-dd hh:mm:ss.fffffffff, yyyy-mm-dd, or hh:mm:ss.fffffffff";
        String string4 = "000000000";
        if (string == null) {
            if (n2 == 2) {
                Date date = new Date(System.currentTimeMillis());
                n6 = date.getYear() + 1900;
                n5 = date.getMonth();
                n4 = date.getDate();
            } else {
                n6 = 1970;
                n5 = 0;
                n4 = 1;
            }
        } else {
            int n11 = string.indexOf(45);
            if (n11 > 0 & (n3 = string.indexOf(45, n11 + 1)) > 0 & n3 < string.length() - 1) {
                n6 = Integer.parseInt(string.substring(0, n11));
                n5 = Integer.parseInt(string.substring(n11 + 1, n3)) - 1;
                n4 = Integer.parseInt(string.substring(n3 + 1));
            } else {
                throw new IllegalArgumentException(string3);
            }
        }
        if (string2 != null) {
            int n12 = string2.indexOf(58);
            n3 = string2.indexOf(58, n12 + 1);
            int n13 = string2.indexOf(46, n3 + 1);
            if (n12 > 0 & n3 > 0 & n3 < string2.length() - 1) {
                n7 = Integer.parseInt(string2.substring(0, n12));
                n8 = Integer.parseInt(string2.substring(n12 + 1, n3));
                if (n13 > 0 & n13 < string2.length() - 1) {
                    n9 = Integer.parseInt(string2.substring(n3 + 1, n13));
                    String string5 = string2.substring(n13 + 1);
                    if (string5.length() > 9) {
                        throw new IllegalArgumentException(string3);
                    }
                    if (!Character.isDigit(string5.charAt(0))) {
                        throw new IllegalArgumentException(string3);
                    }
                    string5 = string5 + string4.substring(0, 9 - string5.length());
                    n10 = Integer.parseInt(string5);
                } else {
                    if (n13 > 0) {
                        throw new IllegalArgumentException(string3);
                    }
                    n9 = Integer.parseInt(string2.substring(n3 + 1));
                }
            } else {
                throw new IllegalArgumentException();
            }
        }
        return new BaseTimestamp(n6, n5, n4, n7, n8, n9, n10, null);
    }

    static BaseTimestamp applyCalender(BaseTimestamp baseTimestamp, Calendar calendar) {
        calendar = (Calendar)calendar.clone();
        int n2 = baseTimestamp.getYear();
        int n3 = baseTimestamp.getMonth();
        int n4 = baseTimestamp.getDate();
        int n5 = baseTimestamp.getHours();
        int n6 = baseTimestamp.getMinutes();
        int n7 = baseTimestamp.getSeconds();
        int n8 = baseTimestamp.getNanos();
        calendar.clear();
        calendar.set(n2, n3, n4, n5, n6, n7);
        baseTimestamp = new BaseTimestamp(calendar, n8);
        return baseTimestamp;
    }
}

