/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.cmce;

import java.security.SecureRandom;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.EncapsulatedSecretGenerator;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.SecretWithEncapsulation;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.cmce.CMCEEngine;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.cmce.CMCEPublicKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;

public class CMCEKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public CMCEKEMGenerator(SecureRandom secureRandom) {
        this.sr = secureRandom;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter) {
        CMCEPublicKeyParameters cMCEPublicKeyParameters = (CMCEPublicKeyParameters)asymmetricKeyParameter;
        CMCEEngine cMCEEngine = cMCEPublicKeyParameters.getParameters().getEngine();
        return this.generateEncapsulated(asymmetricKeyParameter, cMCEEngine.getDefaultSessionKeySize());
    }

    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter, int n2) {
        CMCEPublicKeyParameters cMCEPublicKeyParameters = (CMCEPublicKeyParameters)asymmetricKeyParameter;
        CMCEEngine cMCEEngine = cMCEPublicKeyParameters.getParameters().getEngine();
        byte[] byArray = new byte[cMCEEngine.getCipherTextSize()];
        byte[] byArray2 = new byte[n2 / 8];
        cMCEEngine.kem_enc(byArray, byArray2, cMCEPublicKeyParameters.getPublicKey(), this.sr);
        return new SecretWithEncapsulationImpl(byArray2, byArray);
    }
}

