/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document.webkit;

import coldfusion.document.webkit.PDFgServiceManagerHelper;
import java.util.concurrent.atomic.AtomicInteger;

public final class PDFgServiceManager
implements Comparable<PDFgServiceManager> {
    private String name;
    private String hostname = "127.0.0.1";
    private int port;
    private int weight = 2;
    private AtomicInteger currentWeight = new AtomicInteger(2);
    private boolean isLocal = false;
    private boolean isHttps = false;
    private volatile PDFgServiceManagerState registerState;
    private volatile boolean registerInProgress = false;
    private String url;
    private boolean isEnabled = true;

    public PDFgServiceManager() {
        this.port = PDFgServiceManagerHelper.getInstance().getDefaultPort();
        this.name = this.hostname;
        this.constructURL();
    }

    public PDFgServiceManager(String name, String hostname, int port, int weight, boolean isHttps) {
        this.name = name;
        this.hostname = hostname;
        this.port = port;
        this.weight = weight;
        this.isHttps = isHttps;
        this.currentWeight.set(weight);
        this.constructURL();
    }

    public void update(String name, String hostname, int port, int weight, boolean isHttps) {
        this.name = name;
        this.hostname = hostname;
        this.port = port;
        this.isHttps = isHttps;
        this.weight = weight;
        this.currentWeight.set(weight);
        this.registerInProgress = false;
        this.nullifyRegisterState();
        this.constructURL();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
        this.constructURL();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.constructURL();
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
        this.currentWeight.set(weight);
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public void setLocal(boolean isLocal) {
        this.isLocal = isLocal;
    }

    public boolean isHttps() {
        return this.isHttps;
    }

    public void setHttps(boolean isHttps) {
        this.isHttps = isHttps;
        this.constructURL();
    }

    public int getCurrentWeight() {
        return this.currentWeight.get();
    }

    public boolean decrementCurrentWeight(int expect) {
        return this.currentWeight.compareAndSet(expect, expect - 1);
    }

    public void resetCurrentWeight() {
        if (this.isEnabled) {
            this.currentWeight.set(this.weight);
        } else {
            this.currentWeight.set(0);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PDFgServiceManager)) {
            return false;
        }
        PDFgServiceManager other = (PDFgServiceManager)obj;
        return !(this.name == null ? other.name != null : !this.name.equalsIgnoreCase(other.name));
    }

    public void setRegisterState(String authToken, String sessionId) {
        this.registerState = new PDFgServiceManagerState(authToken, sessionId);
        this.registerInProgress = false;
    }

    public void nullifyRegisterState() {
        this.registerState = null;
    }

    public String getSessionId() {
        if (this.registerState != null) {
            return this.registerState.getSessionId();
        }
        return null;
    }

    public String getAuthToken() {
        if (this.registerState != null) {
            return this.registerState.getAuthToken();
        }
        return null;
    }

    public boolean isRegistered() {
        if (this.registerState != null) {
            return this.registerState.isRegistered();
        }
        return false;
    }

    public boolean isRegisterInProgress() {
        return this.registerInProgress;
    }

    public void setRegisterInProgress(boolean registerInProgress) {
        this.registerInProgress = registerInProgress;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        if (isEnabled) {
            this.currentWeight.set(this.weight);
        } else {
            this.currentWeight.set(0);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String getURL() {
        return this.url;
    }

    @Override
    public int compareTo(PDFgServiceManager o) {
        return o.currentWeight.get() - this.currentWeight.get();
    }

    public PDFgServiceManager createViewCopy() {
        PDFgServiceManager newInstance = null;
        newInstance = new PDFgServiceManager(this.name, this.hostname, this.port, this.weight, this.isHttps);
        newInstance.setLocal(this.isLocal);
        newInstance.setEnabled(this.isEnabled);
        return newInstance;
    }

    private void constructURL() {
        this.url = (this.isHttps ? "https://" : "http://") + this.hostname + ":" + this.port + "/PDFgServlet/";
    }

    private final class PDFgServiceManagerState {
        private final String authToken;
        private final String sessionId;
        private final boolean isRegistered;

        public PDFgServiceManagerState(String authToken, String sessionId) {
            if (sessionId != null && sessionId.length() > 0 && authToken != null && authToken.length() > 0) {
                this.sessionId = sessionId;
                this.authToken = authToken;
                this.isRegistered = true;
            } else {
                this.sessionId = null;
                this.authToken = null;
                this.isRegistered = false;
            }
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public String getAuthToken() {
            return this.authToken;
        }

        public boolean isRegistered() {
            return this.isRegistered;
        }
    }
}

