/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDefaultFontProvider;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintAnchor;
import net.sf.jasperreports.engine.JRPrintAnchorIndex;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyle;

public class JasperPrint
implements Serializable {
    private static final long serialVersionUID = 10200L;
    private String name = null;
    private int pageWidth = 0;
    private int pageHeight = 0;
    private byte orientation = 1;
    private Map fontsMap = new HashMap();
    private List fontsList = new ArrayList();
    private Map stylesMap = new HashMap();
    private List stylesList = new ArrayList();
    private List pages = new ArrayList();
    private transient Map anchorIndexes = null;
    private DefaultStyleProvider defaultStyleProvider = new DefaultStyleProvider(null, null);
    private String localeCode;
    private String timeZoneId;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(int pageWidth) {
        this.pageWidth = pageWidth;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(int pageHeight) {
        this.pageHeight = pageHeight;
    }

    public byte getOrientation() {
        return this.orientation;
    }

    public void setOrientation(byte orientation) {
        this.orientation = orientation;
    }

    public JRReportFont getDefaultFont() {
        return this.defaultStyleProvider.getDefaultFont();
    }

    public void setDefaultFont(JRReportFont font) {
        this.defaultStyleProvider.setDefaultFont(font);
    }

    public JRDefaultFontProvider getDefaultFontProvider() {
        return this.defaultStyleProvider;
    }

    public JRReportFont[] getFonts() {
        JRReportFont[] fontsArray = new JRReportFont[this.fontsList.size()];
        this.fontsList.toArray(fontsArray);
        return fontsArray;
    }

    public List getFontsList() {
        return this.fontsList;
    }

    public Map getFontsMap() {
        return this.fontsMap;
    }

    public synchronized void addFont(JRReportFont reportFont) throws JRException {
        this.addFont(reportFont, false);
    }

    public synchronized void addFont(JRReportFont reportFont, boolean isIgnoreDuplicate) throws JRException {
        if (this.fontsMap.containsKey(reportFont.getName())) {
            if (!isIgnoreDuplicate) {
                throw new JRException("Duplicate declaration of report font : " + reportFont.getName());
            }
        } else {
            this.fontsList.add(reportFont);
            this.fontsMap.put(reportFont.getName(), reportFont);
            if (reportFont.isDefault()) {
                this.setDefaultFont(reportFont);
            }
        }
    }

    public synchronized JRReportFont removeFont(String fontName) {
        return this.removeFont((JRReportFont)this.fontsMap.get(fontName));
    }

    public synchronized JRReportFont removeFont(JRReportFont reportFont) {
        if (reportFont != null) {
            if (reportFont.isDefault()) {
                this.setDefaultFont(null);
            }
            this.fontsList.remove(reportFont);
            this.fontsMap.remove(reportFont.getName());
        }
        return reportFont;
    }

    public JRStyle getDefaultStyle() {
        return this.defaultStyleProvider.getDefaultStyle();
    }

    public synchronized void setDefaultStyle(JRStyle style) {
        this.defaultStyleProvider.setDefaultStyle(style);
    }

    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.defaultStyleProvider;
    }

    public JRStyle[] getStyles() {
        JRStyle[] stylesArray = new JRStyle[this.stylesList.size()];
        this.stylesList.toArray(stylesArray);
        return stylesArray;
    }

    public List getStylesList() {
        return this.stylesList;
    }

    public Map getStylesMap() {
        return this.stylesMap;
    }

    public synchronized void addStyle(JRStyle style) throws JRException {
        this.addStyle(style, false);
    }

    public synchronized void addStyle(JRStyle style, boolean isIgnoreDuplicate) throws JRException {
        if (this.stylesMap.containsKey(style.getName())) {
            if (!isIgnoreDuplicate) {
                throw new JRException("Duplicate declaration of report style : " + style.getName());
            }
        } else {
            this.stylesList.add(style);
            this.stylesMap.put(style.getName(), style);
        }
    }

    public synchronized JRStyle removeStyle(String styleName) {
        return this.removeStyle((JRStyle)this.stylesMap.get(styleName));
    }

    public synchronized JRStyle removeStyle(JRStyle style) {
        if (style != null) {
            if (style.isDefault()) {
                this.setDefaultStyle(null);
            }
            this.stylesList.remove(style);
            this.stylesMap.remove(style.getName());
        }
        return style;
    }

    public List getPages() {
        return this.pages;
    }

    public synchronized void addPage(JRPrintPage page) {
        this.anchorIndexes = null;
        this.pages.add(page);
    }

    public synchronized void addPage(int index, JRPrintPage page) {
        this.anchorIndexes = null;
        this.pages.add(index, page);
    }

    public synchronized JRPrintPage removePage(int index) {
        this.anchorIndexes = null;
        return (JRPrintPage)this.pages.remove(index);
    }

    public synchronized Map getAnchorIndexes() {
        if (this.anchorIndexes == null) {
            this.anchorIndexes = new HashMap();
            JRPrintPage page2 = null;
            int i = 0;
            for (JRPrintPage page2 : this.pages) {
                List elements = page2.getElements();
                if (elements != null && elements.size() > 0) {
                    JRPrintElement element2 = null;
                    for (JRPrintElement element2 : elements) {
                        if (!(element2 instanceof JRPrintAnchor)) continue;
                        this.anchorIndexes.put(((JRPrintAnchor)((Object)element2)).getAnchorName(), new JRPrintAnchorIndex(i, element2));
                    }
                }
                ++i;
            }
        }
        return this.anchorIndexes;
    }

    public String getLocaleCode() {
        return this.localeCode;
    }

    public void setLocaleCode(String localeCode) {
        this.localeCode = localeCode;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    private static class DefaultStyleProvider
    implements JRDefaultStyleProvider,
    Serializable {
        private static final long serialVersionUID = 10200L;
        private JRReportFont defaultFont;
        private JRStyle defaultStyle;

        DefaultStyleProvider(JRReportFont font, JRStyle style) {
            this.defaultFont = font;
            this.defaultStyle = style;
        }

        @Override
        public JRReportFont getDefaultFont() {
            return this.defaultFont;
        }

        void setDefaultFont(JRReportFont font) {
            this.defaultFont = font;
        }

        @Override
        public JRStyle getDefaultStyle() {
            return this.defaultStyle;
        }

        void setDefaultStyle(JRStyle style) {
            this.defaultStyle = style;
        }
    }
}

