/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.webdav;

import coldfusion.exchange.ExchangeAttachment;
import coldfusion.exchange.ExchangeTask;
import coldfusion.exchange.TaskFilterInfo;
import coldfusion.exchange.webdav.AttachmentManager;
import coldfusion.exchange.webdav.Utils;
import coldfusion.exchange.webdav.WebDAVConnection;
import coldfusion.exchange.webdav.WebDAVExceptions;
import coldfusion.exchange.webdav.WebDAVFolderManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.methods.PropPatchMethod;
import org.apache.webdav.lib.methods.SearchMethod;
import org.w3c.dom.NodeList;

public class TaskManager
extends WebDAVFolderManager {
    TaskManager(WebDAVConnection con) {
        super(con);
    }

    public ArrayList getTasks(TaskFilterInfo filter) throws Throwable {
        HttpClient client;
        int code;
        String selectSql = "select \"http://schemas.microsoft.com/mapi/id/{00062003-0000-0000-C000-000000000046}/0x8101\" as Status,\"http://schemas.microsoft.com/exchange/mileage\" as Milage,\"http://schemas.microsoft.com/mapi/companies\" as Companies, \"http://schemas.microsoft.com/mapi/billing\" as Billing, \"DAV:href\" as href,\"DAV:uid\" as uid,\"urn:schemas:httpmail:datereceived\" as receiptTime,\"http://schemas.microsoft.com/mapi/id/{00062003-0000-0000-C000-000000000046}/0x8102\" as PercentComplete, \"http://schemas.microsoft.com/mapi/id/{00062003-0000-0000-C000-000000000046}/0x8103\" as TeamTask, \"http://schemas.microsoft.com/mapi/id/{00062003-0000-0000-C000-000000000046}/0x8105\" as DueDate, \"http://schemas.microsoft.com/mapi/id/{00062003-0000-0000-C000-000000000046}/0x8110\" as ActualWork, \"http://schemas.microsoft.com/mapi/id/{00062003-0000-0000-C000-000000000046}/0x8111\" as TotalWork, \"http://schemas.microsoft.com/mapi/id/{00062003-0000-0000-C000-000000000046}/0x811c\" as TaskComplete, \"http://schemas.microsoft.com/mapi/id/{00062003-0000-0000-C000-000000000046}/0x811f\" as TaskOwner, \"http://schemas.microsoft.com/mapi/id/{00062003-0000-0000-C000-000000000046}/0x8126\" as IsRecurring, \"http://schemas.microsoft.com/mapi/id/{00062008-0000-0000-C000-000000000046}/0x8502\" as ReminderTime, \"http://schemas.microsoft.com/mapi/id/{00062008-0000-0000-C000-000000000046}/0x8503\" as ReminderSet, \"http://schemas.microsoft.com/mapi/id/{00062008-0000-0000-C000-000000000046}/0x851C\" as ReminderOverride, \"http://schemas.microsoft.com/mapi/id/{00062008-0000-0000-C000-000000000046}/0x851E\" as ReminderPlaySound, \"http://schemas.microsoft.com/mapi/id/{00062008-0000-0000-C000-000000000046}/0x851F\" as ReminderSoundFile, \"urn:schemas:mailheader:to\" as to, \"http://schemas.microsoft.com/exchange/x-priority-long\" as priority, \"urn:schemas:httpmail:subject\" as subject, \"urn:schemas:httpmail:textdescription\" as message, \"urn:schemas:httpmail:htmldescription\" as htmldescription, \"http://schemas.microsoft.com/mapi/id/{00062003-0000-0000-C000-000000000046}/0x8104\" as StartDate, \"http://schemas.microsoft.com/mapi/id/{00062003-0000-0000-C000-000000000046}/0x810f\" as DateCompleted, \"http://schemas.microsoft.com/exchange/keywords-utf8\" as categories,\"DAV:getlastmodified\" as lastModified,\"urn:schemas:httpmail:hasattachment\" as hasattachment ";
        String sql = selectSql + " from " + this.getTaskURL() + " ";
        ArrayList<String> conditions = new ArrayList<String>();
        String tmpStr = null;
        String[] filterUids = null;
        if (filter != null) {
            int i;
            if (filter.getFromDateCompleted() != null) {
                tmpStr = Utils.localToExchangeDate(filter.getFromDateCompleted());
                conditions.add("\"http://schemas.microsoft.com/mapi/id/{00062003-0000-0000-C000-000000000046}/0x810f\" &gt;= '" + tmpStr + "' ");
            }
            if (filter.getToDateCompleted() != null) {
                tmpStr = Utils.localToExchangeDate(filter.getToDateCompleted());
                conditions.add("\"http://schemas.microsoft.com/mapi/id/{00062003-0000-0000-C000-000000000046}/0x810f\" &lt;= '" + tmpStr + "' ");
            }
            if (filter.getFromDueDate() != null) {
                tmpStr = Utils.localToExchangeDate(filter.getFromDueDate());
                conditions.add("\"http://schemas.microsoft.com/mapi/id/{00062003-0000-0000-C000-000000000046}/0x8105\" &gt;= '" + tmpStr + "' ");
            }
            if (filter.getToDueDate() != null) {
                tmpStr = Utils.localToExchangeDate(filter.getToDueDate());
                conditions.add("\"http://schemas.microsoft.com/mapi/id/{00062003-0000-0000-C000-000000000046}/0x8105\" &lt;= '" + tmpStr + "' ");
            }
            boolean isReminderSet = false;
            if (filter.getFromReminderDate() != null) {
                tmpStr = Utils.localToExchangeDate(filter.getFromReminderDate());
                conditions.add("\"http://schemas.microsoft.com/mapi/id/{00062008-0000-0000-C000-000000000046}/0x8502\" &gt;= '" + tmpStr + "' ");
                isReminderSet = true;
            }
            if (filter.getToReminderDate() != null) {
                tmpStr = Utils.localToExchangeDate(filter.getToReminderDate());
                conditions.add("\"http://schemas.microsoft.com/mapi/id/{00062008-0000-0000-C000-000000000046}/0x8502\" &lt;= '" + tmpStr + "' ");
                isReminderSet = true;
            }
            if (isReminderSet) {
                conditions.add("\"http://schemas.microsoft.com/mapi/id/{00062008-0000-0000-C000-000000000046}/0x8503\" = CAST(\"true\" as 'boolean')");
            }
            if (filter.getFromStartDate() != null) {
                tmpStr = Utils.localToLongExchangeDate(filter.getFromStartDate());
                conditions.add("\"http://schemas.microsoft.com/mapi/id/{00062003-0000-0000-C000-000000000046}/0x8104\" &gt;= CAST(\"" + tmpStr + "\" as 'dateTime')");
            }
            if (filter.getToStartDate() != null) {
                tmpStr = Utils.localToLongExchangeDate(filter.getToStartDate());
                conditions.add("\"http://schemas.microsoft.com/mapi/id/{00062003-0000-0000-C000-000000000046}/0x8104\" &lt;= CAST(\"" + tmpStr + "\" as 'dateTime')");
            }
            if (filter.getActualWork() != null) {
                conditions.add("\"http://schemas.microsoft.com/mapi/id/{00062003-0000-0000-C000-000000000046}/0x8110\" = CAST(\"" + filter.getActualWork() + "\" as 'int')");
            }
            if (filter.getBillingInfo() != null) {
                conditions.add("\"http://schemas.microsoft.com/mapi/billing\" LIKE '%" + this.encodeXMLContent(filter.getBillingInfo()) + "%'");
            }
            if (filter.getCompanies() != null) {
                conditions.add("\"http://schemas.microsoft.com/mapi/companies\" LIKE '%" + this.encodeXMLContent(filter.getCompanies()) + "%'");
            }
            if (filter.getMileage() != null) {
                conditions.add("\"http://schemas.microsoft.com/exchange/mileage\" LIKE '%" + this.encodeXMLContent(filter.getMileage()) + "%'");
            }
            if (filter.getPercentComplete() != null) {
                conditions.add("\"http://schemas.microsoft.com/mapi/id/{00062003-0000-0000-C000-000000000046}/0x8102\" = CAST(\"" + filter.getPercentComplete().floatValue() / 100.0f + "\" as 'float')");
            }
            if (filter.getStatus() != null) {
                conditions.add("\"http://schemas.microsoft.com/mapi/id/{00062003-0000-0000-C000-000000000046}/0x8101\" = CAST(\"" + ExchangeTask.statusStringToInt(filter.getStatus()) + "\" as 'int')");
            }
            if (filter.getTotalWork() != null) {
                conditions.add("\"http://schemas.microsoft.com/mapi/id/{00062003-0000-0000-C000-000000000046}/0x8111\" = CAST(\"" + filter.getTotalWork() + "\" as 'int')");
            }
            if (filter.getTeamTask() != null) {
                conditions.add("\"http://schemas.microsoft.com/mapi/id/{00062003-0000-0000-C000-000000000046}/0x8103\" LIKE '%" + this.encodeXMLContent(filter.getTeamTask()) + "%'");
            }
            if ((tmpStr = filter.getId()) != null) {
                filterUids = Utils.splitString(tmpStr);
                String tmpCondition = "(";
                for (i = 0; i < filterUids.length; ++i) {
                    if (i != 0) {
                        tmpCondition = tmpCondition + " OR ";
                    }
                    tmpCondition = tmpCondition + "\"DAV:uid\" = '" + filterUids[i] + "'";
                }
                conditions.add(tmpCondition + ")");
            }
            if (filter.getSubject() != null) {
                conditions.add("\"urn:schemas:httpmail:subject\" LIKE '%" + this.encodeXMLContent(filter.getSubject()) + "%'");
            }
            if (filter.getMessage() != null) {
                conditions.add("\"urn:schemas:httpmail:textdescription\" LIKE '%" + this.encodeXMLContent(filter.getMessage()) + "%'");
            }
            if (filter.getPriority() != null) {
                conditions.add("\"http://schemas.microsoft.com/exchange/x-priority-long\" = " + filter.getPriority());
            }
            if (filter.getFromLastModifiedDate() != null) {
                String gmtFromLastModifiedDate = Utils.localToExchangeDate(filter.getFromLastModifiedDate());
                conditions.add("\"DAV:getlastmodified\" &gt;= '" + gmtFromLastModifiedDate + "' ");
            }
            if (filter.getToLastModifiedDate() != null) {
                String gmToLastModifiedDate = Utils.localToExchangeDate(filter.getToLastModifiedDate());
                conditions.add("\"DAV:getlastmodified\" &lt;= '" + gmToLastModifiedDate + "' ");
            }
            if ((tmpStr = filter.getCategories()) != null) {
                String[] filterCats = null;
                filterCats = Utils.splitString(tmpStr);
                String tmpCondition = "(";
                for (int i2 = 0; i2 < filterCats.length; ++i2) {
                    if (i2 != 0) {
                        tmpCondition = tmpCondition + " AND ";
                    }
                    tmpCondition = tmpCondition + "\"http://schemas.microsoft.com/exchange/keywords-utf8\" LIKE '%" + this.encodeXMLContent(filterCats[i2]) + "%'";
                }
                tmpCondition = tmpCondition + ")";
                conditions.add(tmpCondition);
            }
            if (conditions.size() > 0) {
                String whereSql = "";
                for (i = 0; i < conditions.size(); ++i) {
                    if (i != 0) {
                        whereSql = whereSql + " AND ";
                    }
                    whereSql = whereSql + conditions.get(i).toString() + " ";
                }
                sql = sql + " where " + whereSql;
            }
        }
        String xmlSql = "<?xml version=\"1.0\"?><d:searchrequest xmlns:d=\"DAV:\"><d:sql> " + sql + "</d:sql> </d:searchrequest> ";
        String searchPath = this.getTaskFolderUrl();
        SearchMethod method = new SearchMethod(searchPath, xmlSql);
        method.setRequestHeader(new Header("Depth", "1"));
        method.setRequestHeader(new Header("Translate", "f"));
        if (filter.getMaxRows() != -1) {
            method.setRequestHeader(new Header("Range", "rows=0-" + (filter.getMaxRows() - 1)));
        }
        if ((code = (client = this.getHttpClient()).executeMethod((HttpMethod)method)) < 200 || code > 300) {
            throw new WebDAVExceptions(2, code, null, "Error getting tasks");
        }
        Enumeration enm = method.getResponses();
        ArrayList<ExchangeTask> tasks = new ArrayList<ExchangeTask>();
        while (enm.hasMoreElements()) {
            Object obj = enm.nextElement();
            ResponseEntity entity = (ResponseEntity)obj;
            ExchangeTask task = this.createTaskObj(entity);
            if (task == null) continue;
            boolean uidFound = false;
            if (filterUids != null) {
                for (int i = 0; i < filterUids.length; ++i) {
                    if (!filterUids[i].equals(task.getId())) continue;
                    uidFound = true;
                    break;
                }
            } else {
                uidFound = true;
            }
            if (!uidFound) continue;
            tasks.add(task);
        }
        return tasks;
    }

    private ExchangeTask createTaskObj(ResponseEntity entity) {
        ExchangeTask task = new ExchangeTask();
        Enumeration enm1 = entity.getProperties();
        while (enm1.hasMoreElements()) {
            String categories;
            int i;
            NodeList nodeList;
            BaseProperty prop = (BaseProperty)enm1.nextElement();
            String propName = prop.getLocalName();
            String propValue = prop.getPropertyAsString();
            if (propValue == null || propValue.length() == 0) continue;
            if (propName.equals("Status")) {
                task.setStatus(ExchangeTask.statusIntToString(propValue));
                continue;
            }
            if (propName.equals("StartDate")) {
                task.setStartDate(Utils.exchangeToLocalDate(propValue));
                continue;
            }
            if (propName.equals("DueDate")) {
                task.setDueDate(Utils.exchangeToLocalDate(propValue));
                continue;
            }
            if (propName.equals("ReminderTime")) {
                task.setReminderDate(Utils.exchangeToLocalDate(propValue));
                continue;
            }
            if (propName.equals("DateCompleted")) {
                task.setDateCompleted(Utils.exchangeToLocalDate(propValue));
                continue;
            }
            if (propName.equals("Milage")) {
                task.setMileage(propValue);
                continue;
            }
            if (propName.equals("receiptTime")) {
                task.setTimeReceived(Utils.exchangeToLocalDate(propValue));
                continue;
            }
            if (propName.equals("Companies")) {
                nodeList = prop.getElement().getChildNodes();
                if (nodeList.getLength() == 0) continue;
                String companies = "";
                for (i = 0; i < nodeList.getLength(); ++i) {
                    if (nodeList.item(i).getFirstChild() == null) continue;
                    if (i != 0) {
                        companies = companies + ",";
                    }
                    companies = companies + nodeList.item(i).getFirstChild().getNodeValue();
                }
                task.setCompanies(companies);
                continue;
            }
            if (propName.equals("Billing")) {
                task.setBillingInfo(propValue);
                continue;
            }
            if (propName.equals("PercentComplete")) {
                float percentComplete = 0.0f;
                char deciSeparator = this.connection.getExchangeServerDecimalSeperator();
                if (deciSeparator != '.') {
                    propValue = propValue.replace(deciSeparator, '.');
                }
                percentComplete = Float.parseFloat(propValue) * 100.0f;
                task.setPercentComplete(percentComplete);
                continue;
            }
            if (propName.equals("categories")) {
                nodeList = prop.getElement().getChildNodes();
                if (nodeList.getLength() == 0) continue;
                categories = "";
                for (i = 0; i < nodeList.getLength(); ++i) {
                    if (nodeList.item(i).getFirstChild() == null) continue;
                    if (i != 0) {
                        categories = categories + ",";
                    }
                    categories = categories + nodeList.item(i).getFirstChild().getNodeValue();
                }
                task.setCategories(categories);
                continue;
            }
            if (propName.equals("TeamTask")) {
                task.setTeamTask(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("ActualWork")) {
                task.setActualWork(Integer.parseInt(propValue));
                continue;
            }
            if (propName.equalsIgnoreCase("TotalWork")) {
                task.setTotalWork(Integer.parseInt(propValue));
                continue;
            }
            if (propName.equalsIgnoreCase("TaskComplete")) {
                task.setTaskComplete(Boolean.valueOf(propValue));
                continue;
            }
            if (propName.equalsIgnoreCase("IsRecurring")) {
                task.setIsRecurring(Boolean.valueOf(propValue));
                continue;
            }
            if (propName.equalsIgnoreCase("ReminderSet")) {
                task.setIsReminderSet(Boolean.valueOf(propValue));
                continue;
            }
            if (propName.equalsIgnoreCase("uid")) {
                task.setId(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("href")) {
                task.setHref(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("subject")) {
                task.setSubject(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("message")) {
                task.setMessage(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("htmldescription")) {
                task.setHtmlMessage(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("priority")) {
                task.setPriority(Integer.parseInt(propValue));
                continue;
            }
            if (propName.equals("hasattachment")) {
                task.setHasAttachment(Integer.parseInt(propValue) == 1);
                continue;
            }
            if (propName.equals("categories")) {
                nodeList = prop.getElement().getChildNodes();
                if (nodeList.getLength() == 0) continue;
                categories = "";
                for (i = 0; i < nodeList.getLength(); ++i) {
                    if (nodeList.item(i).getFirstChild() == null) continue;
                    if (i != 0) {
                        categories = categories + ",";
                    }
                    categories = categories + nodeList.item(i).getFirstChild().getNodeValue();
                }
                task.setCategories(categories);
                continue;
            }
            if (!propName.equalsIgnoreCase("lastmodified")) continue;
            task.setLastModified(Utils.exchangeToLocalDate(propValue));
        }
        return task;
    }

    private String getTaskURL() {
        return "\"" + this.getTaskFolderUrl() + "\"";
    }

    private ArrayList setTaskCompleteStatus(ExchangeTask task) {
        int status = -1;
        float percentComplete = -1.0f;
        Date dateCompleted = task.getDateCompleted();
        ArrayList<String> propertiesToRemove = new ArrayList<String>();
        String tmpStr = null;
        tmpStr = task.getStatus();
        if (tmpStr != null) {
            status = ExchangeTask.statusStringToInt(tmpStr);
        }
        if (status == 2) {
            percentComplete = 100.0f;
            task.setPercentComplete(100.0f);
            if (dateCompleted == null) {
                dateCompleted = Calendar.getInstance().getTime();
            }
        } else if (status != -1 && status != 2) {
            propertiesToRemove.add("tk2:datecompleted");
            if (percentComplete == 100.0f) {
                percentComplete = 0.0f;
            }
            dateCompleted = null;
        } else if (task.getPercentComplete() != null) {
            percentComplete = task.getPercentComplete().floatValue();
            if (percentComplete >= 100.0f) {
                status = 2;
                if (dateCompleted == null) {
                    dateCompleted = Calendar.getInstance().getTime();
                }
                percentComplete = 100.0f;
            } else {
                propertiesToRemove.add("tk2:datecompleted");
                dateCompleted = null;
                if (status == 0 || status == 2 || percentComplete > 0.0f) {
                    status = 1;
                }
            }
        } else if (dateCompleted != null) {
            status = 2;
            percentComplete = 100.0f;
        }
        if (percentComplete != -1.0f) {
            task.setPercentComplete(percentComplete);
        }
        if (status != -1) {
            task.setStatus(ExchangeTask.statusIntToString(String.valueOf(status)));
        }
        task.setDateCompleted(dateCompleted);
        if (dateCompleted != null) {
            task.setReminderDate(null);
            propertiesToRemove.add("tk1:0x8502");
            propertiesToRemove.add("tk1:0x8503");
        }
        return propertiesToRemove;
    }

    void saveTask(ExchangeTask task, ArrayList propertiesToBeRemoved) throws Throwable {
        String strXMLNSInfo = "xmlns:g=\"DAV:\" xmlns:e=\"http://schemas.microsoft.com/exchange/\" xmlns:mapi=\"http://schemas.microsoft.com/mapi/\" xmlns:x=\"xml:\" xmlns:dt=\"urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/\" xmlns:mail=\"urn:schemas:httpmail:\" xmlns:tk2=\"http://schemas.microsoft.com/exchange/tasks/\" xmlns:tk1=\"http://schemas.microsoft.com/mapi/id/{00062008-0000-0000-C000-000000000046}/\" xmlns:tk=\"http://schemas.microsoft.com/mapi/id/{00062003-0000-0000-C000-000000000046}/\"> ";
        String strNameInfo = "";
        Integer tmpInt = null;
        int status = -1;
        float percentComplete = -1.0f;
        Date dateCompleted = task.getDateCompleted();
        String tmpStr = task.getStatus();
        status = tmpStr != null ? ExchangeTask.statusStringToInt(tmpStr) : 0;
        percentComplete = task.getPercentComplete() != null ? task.getPercentComplete().floatValue() : 0.0f;
        if (dateCompleted != null) {
            strNameInfo = strNameInfo + "<tk:0x810f dt:dt=\"dateTime.tz\">" + Utils.localToLongExchangeDate(dateCompleted) + "</tk:0x810f>";
            strNameInfo = strNameInfo + "<tk2:datecompleted dt:dt=\"dateTime.tz\">" + Utils.localToLongExchangeDate(dateCompleted) + "</tk2:datecompleted>";
        }
        if (status != -1) {
            strNameInfo = strNameInfo + "<tk:0x8101 dt:dt=\"int\">" + status + "</tk:0x8101>";
        }
        if (percentComplete != -1.0f) {
            String percentStr = String.valueOf(percentComplete / 100.0f);
            char deciSeparator = this.connection.getExchangeServerDecimalSeperator();
            if (deciSeparator != '.') {
                percentStr = percentStr.replace('.', deciSeparator);
            }
            strNameInfo = strNameInfo + "<tk:0x8102 dt:dt=\"float\">" + percentStr + "</tk:0x8102>";
        }
        strNameInfo = strNameInfo + "<tk:0x8110 dt:dt=\"int\">" + ((tmpInt = task.getActualWork()) == null ? 0 : tmpInt) + "</tk:0x8110>";
        tmpStr = task.getSubject();
        if (tmpStr != null) {
            strNameInfo = strNameInfo + "<mail:subject>" + this.encodeXMLContent(tmpStr) + "</mail:subject>";
        }
        if ((tmpStr = task.getMessage()) != null) {
            strNameInfo = strNameInfo + "<mail:htmldescription>" + this.encodeXMLContent(tmpStr) + "</mail:htmldescription>";
        }
        if ((tmpStr = task.getBillingInfo()) != null) {
            strNameInfo = strNameInfo + "<mapi:billing>" + this.encodeXMLContent(tmpStr) + "</mapi:billing>";
        }
        if ((tmpStr = task.getCompanies()) != null) {
            strNameInfo = strNameInfo + this.createCompaniesXML(this.encodeXMLContent(tmpStr));
        }
        if ((tmpStr = task.getMileage()) != null) {
            strNameInfo = strNameInfo + "<e:mileage>" + this.encodeXMLContent(tmpStr) + "</e:mileage>";
        }
        if ((tmpStr = task.getTeamTask()) != null) {
            strNameInfo = strNameInfo + "<tk:0x8103>" + this.encodeXMLContent(tmpStr) + "</tk:0x8103>";
        }
        if ((tmpStr = task.getCategories()) != null) {
            strNameInfo = strNameInfo + this.createCategoriesXML(this.encodeXMLContent(tmpStr));
        }
        strNameInfo = strNameInfo + "<tk:0x8111 dt:dt=\"int\">" + ((tmpInt = task.getTotalWork()) == null ? 0 : tmpInt) + "</tk:0x8111>";
        tmpStr = Utils.localToLongExchangeDate(task.getDueDate());
        if (tmpStr != null) {
            strNameInfo = strNameInfo + "<tk:0x8105 dt:dt=\"dateTime.tz\">" + this.encodeXMLContent(tmpStr) + "</tk:0x8105>";
            strNameInfo = strNameInfo + "<mapi:commonend dt:dt=\"dateTime.tz\">" + this.encodeXMLContent(tmpStr) + "</mapi:commonend>";
        }
        if ((tmpStr = Utils.localToLongExchangeDate(task.getReminderDate())) != null) {
            strNameInfo = strNameInfo + "<tk1:0x8502 dt:dt=\"dateTime.tz\">" + this.encodeXMLContent(tmpStr) + "</tk1:0x8502>";
            strNameInfo = strNameInfo + "<tk1:0x8503 dt:dt=\"boolean\">1</tk1:0x8503>";
        }
        if ((tmpStr = Utils.localToLongExchangeDate(task.getStartDate())) != null) {
            strNameInfo = strNameInfo + "<tk:0x8104 dt:dt=\"dateTime.tz\">" + this.encodeXMLContent(tmpStr) + "</tk:0x8104>";
            strNameInfo = strNameInfo + "<mapi:commonstart dt:dt=\"dateTime.tz\">" + this.encodeXMLContent(tmpStr) + "</mapi:commonstart>";
        }
        if (task.getIsRecurring() != null) {
            strNameInfo = strNameInfo + "<tk:0x8126 dt:dt=\"boolean\">" + (task.getIsRecurring() != false ? "1" : "0") + "</tk:0x8126>";
        }
        if (task.getTaskComplete() != null) {
            strNameInfo = strNameInfo + "<tk:0x811c dt:dt=\"boolean\">" + (task.getTaskComplete() != false ? "1" : "0") + "</tk:0x811c>";
        }
        strNameInfo = strNameInfo + "<e:x-priority-long dt:dt=\"int\">" + ((tmpInt = task.getPriority()) == null ? 1 : tmpInt) + "</e:x-priority-long>";
        String strSetProperties = "<g:set> <g:prop><g:contentclass>urn:content-classes:task</g:contentclass><e:outlookmessageclass>IPM.Task</e:outlookmessageclass>" + strNameInfo + "</g:prop></g:set>";
        String strRemoveProperties = "<g:remove>";
        Iterator it = propertiesToBeRemoved.iterator();
        while (it.hasNext()) {
            strRemoveProperties = strRemoveProperties + "<g:prop><" + it.next().toString() + "/></g:prop>";
        }
        strRemoveProperties = strRemoveProperties + "</g:remove>";
        String strBody = "<?xml version=\"1.0\"?><g:propertyupdate " + strXMLNSInfo + strSetProperties + strRemoveProperties + "</g:propertyupdate>";
        int code = this.executeWebDAVMethod(PropPatchMethod.class, this.getHttpClient(), task.getHref(), strBody, true);
        if (code < 200 || code > 300) {
            throw new WebDAVExceptions(2, code, null, "Error getting Tasks");
        }
        String uid = Utils.findProperty(task.getHref(), "uid", "DAV:", this.getHttpClient());
        if (uid == null) {
            throw new WebDAVExceptions(11, null, "Error getting UID of the new task");
        }
        task.setId(uid);
    }

    void modifyTask(ExchangeTask task, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
        if (task == null || task.getId() == null) {
            return;
        }
        TaskFilterInfo filter = new TaskFilterInfo();
        filter.setId(task.getId());
        ArrayList taskList = this.getTasks(filter);
        if (taskList == null || taskList.size() == 0) {
            throw new WebDAVExceptions(4, null, "UID not found");
        }
        ExchangeTask oldTask = (ExchangeTask)taskList.get(0);
        ArrayList propertiesToRemove = this.setTaskCompleteStatus(task);
        oldTask.setNonNullValues(task);
        String status = task.getStatus();
        String oldStatus = oldTask.getStatus();
        Float percent = task.getPercentComplete();
        Float oldPercent = oldTask.getPercentComplete();
        if (status != null && !status.equalsIgnoreCase("Completed") && oldPercent != null && oldPercent.floatValue() == 100.0f) {
            oldTask.setPercentComplete(0.0f);
        } else if (percent != null && percent.floatValue() < 100.0f && oldStatus != null && (oldStatus.equalsIgnoreCase("Completed") || oldStatus.equalsIgnoreCase("Not_Started") && percent.floatValue() > 0.0f)) {
            oldTask.setStatus("In_Progress");
        }
        if (task.getHref() == null) {
            task.setHref(oldTask.getHref());
        }
        this.saveTask(oldTask, propertiesToRemove);
        if (attachedFileNames != null && attachedFileContents != null) {
            AttachmentManager atchMgr = new AttachmentManager(this.connection);
            atchMgr.createAttachments(task.getHref(), attachedFileNames, attachedFileContents);
        }
    }

    void modifyTask(ExchangeTask task) throws Throwable {
        this.modifyTask(task, null, null);
    }

    void createTask(ExchangeTask task) throws Throwable {
        this.createTask(task, null, null);
    }

    void createTask(ExchangeTask task, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
        task.setHref(this.createURI());
        ArrayList propertiesToRemove = this.setTaskCompleteStatus(task);
        this.saveTask(task, propertiesToRemove);
        if (attachedFileNames != null && attachedFileContents != null) {
            AttachmentManager atchMgr = new AttachmentManager(this.connection);
            atchMgr.createAttachments(task.getHref(), attachedFileNames, attachedFileContents);
        }
    }

    private String createURI() {
        String strTaskItem = this.loginInfo.getMailBoxName() + "_task_" + Calendar.getInstance().getTimeInMillis() + ".eml";
        return this.getTaskFolderUrl() + "/" + strTaskItem;
    }

    void deleteTasks(String[] uids) throws Throwable {
        if (uids == null) {
            return;
        }
        TaskFilterInfo filterInfo = new TaskFilterInfo();
        String uidFilter = "";
        for (int i = 0; i < uids.length; ++i) {
            if (i != 0) {
                uidFilter = uidFilter + ",";
            }
            uidFilter = uidFilter + uids[i];
        }
        filterInfo.setId(uidFilter);
        ArrayList tks = this.getTasks(filterInfo);
        if (tks == null || tks.size() == 0) {
            throw new WebDAVExceptions(4, null, "UID not found");
        }
        for (ExchangeTask task : tks) {
            try {
                AttachmentManager atchMgr = new AttachmentManager(this.connection);
                atchMgr.deleteAttachmentsFor(task.getHref());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.deleteAtHref(task.getHref());
        }
    }

    ExchangeTask getTask(String uid) throws Throwable {
        TaskFilterInfo filterInfo = new TaskFilterInfo();
        filterInfo.setId(uid);
        ArrayList tasks = this.getTasks(filterInfo);
        if (tasks.size() == 0) {
            throw new WebDAVExceptions(4, "UID " + uid + " not found");
        }
        return (ExchangeTask)tasks.get(0);
    }

    void addAttachments(String href, String[] fileNames, Object[] contents) throws Throwable {
        if (href == null) {
            return;
        }
        AttachmentManager atchMgr = new AttachmentManager(this.connection);
        atchMgr.createAttachments(href, fileNames, contents);
    }

    ArrayList getAttachments(String uid, boolean getContent) throws Throwable {
        if (uid == null) {
            return null;
        }
        ExchangeTask ct = this.getTask(uid);
        AttachmentManager atchMgr = new AttachmentManager(this.connection);
        return atchMgr.getAttachments(ct, getContent, null);
    }

    void deleteAttachments(String uid, String[] fileNames) throws Throwable {
        ArrayList atchmts = this.getAttachments(uid, false);
        if (atchmts == null) {
            return;
        }
        block0: for (ExchangeAttachment atch : atchmts) {
            String fileName = atch.getFileName();
            if (fileNames != null) {
                for (int i = 0; i < fileNames.length; ++i) {
                    if (!fileName.equals(fileNames[i])) continue;
                    this.deleteAtHref(atch.getHref());
                    continue block0;
                }
                continue;
            }
            this.deleteAtHref(atch.getHref());
        }
    }

    private String createCompaniesXML(String companies) {
        if (companies == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(companies, ",");
        String compXml = "<mapi:companies dt:dt=\"mv.string\">";
        if (tokenizer.countTokens() > 0) {
            while (tokenizer.hasMoreTokens()) {
                compXml = compXml + "<x:v>" + tokenizer.nextToken() + "</x:v>";
            }
        } else {
            compXml = compXml + "<x:v></x:v>";
        }
        compXml = compXml + "</mapi:companies>";
        return compXml;
    }

    private String createCategoriesXML(String categories) {
        if (categories == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(categories, ",");
        String compXml = "<e:keywords-utf8>";
        if (tokenizer.countTokens() > 0) {
            while (tokenizer.hasMoreTokens()) {
                compXml = compXml + "<x:v>" + tokenizer.nextToken() + "</x:v>";
            }
        } else {
            compXml = compXml + "<x:v></x:v>";
        }
        compXml = compXml + "</e:keywords-utf8>";
        return compXml;
    }
}

