/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.webdav;

import coldfusion.exchange.ExchangeAttachment;
import coldfusion.exchange.ExchangeMailMeeting;
import coldfusion.exchange.ExchangeMessage;
import coldfusion.exchange.MessageFilterInfo;
import coldfusion.exchange.webdav.AttachmentManager;
import coldfusion.exchange.webdav.CalendarManager;
import coldfusion.exchange.webdav.Utils;
import coldfusion.exchange.webdav.WebDAVConnection;
import coldfusion.exchange.webdav.WebDAVExceptions;
import coldfusion.exchange.webdav.WebDAVFolderManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.methods.MoveMethod;
import org.apache.webdav.lib.methods.PropPatchMethod;
import org.apache.webdav.lib.methods.SearchMethod;

public class MessageManager
extends WebDAVFolderManager {
    MessageManager(WebDAVConnection con) {
        super(con);
    }

    public ArrayList getMessages(MessageFilterInfo filter) throws Throwable {
        HttpClient client;
        int code;
        String selectSql = "select \"urn:schemas:httpmail:datereceived\" as datereceived,\"urn:schemas:httpmail:from\" as from,\"DAV:contentclass\" as contentclass,\"urn:schemas:httpmail:to\" as to,\"urn:schemas:httpmail:importance\" as importance, \"urn:schemas:mailheader:sensitivity\" as sensitivity,\"urn:schemas:httpmail:hasattachment\" as hasattachment,\"urn:schemas:httpmail:subject\" as subject,\"urn:schemas:mailheader:message-id\" as uid,\"DAV:href\" as href,\"urn:schemas:httpmail:textdescription\" as textdescription,\"urn:schemas:httpmail:htmldescription\" as htmldescription,\"DAV:isfolder\" as isfolder,\"DAV:creationdate\",\"urn:schemas:httpmail:read\" as read,\"urn:schemas:httpmail:messageflag\" as messageflag,\"urn:schemas:httpmail:sender\" as sender, \"urn:schemas:httpmail:cc\" as cc,\"urn:schemas:httpmail:bcc\" as bcc,\"urn:schemas:httpmail:flagcompleted\" as flagcompleted,\"urn:schemas:httpmail:date\" as dateSent,\"urn:schemas:calendar:uid\" as meetingUID,\"DAV:getlastmodified\" as lastModified,\"http://schemas.microsoft.com/exchange/outlookmessageclass\" as messageClass";
        String tmpStr = null;
        Date tmpDate = null;
        Boolean tmpBool = null;
        String url = this.getMailboxURL();
        tmpStr = filter.getFolder();
        if (tmpStr != null) {
            url = "\"" + this.connection.webDavResource.getHttpURL().toString() + "/" + Utils.getEncodedHref(tmpStr.trim()) + "\"";
        }
        String fromSql = " from " + url + " ";
        String whereSql = null;
        ArrayList<String> conds = new ArrayList<String>();
        conds.add("\"http://schemas.microsoft.com/mapi/proptag/0x67aa000b\" = FALSE");
        conds.add("\"DAV:isfolder\" = FALSE");
        int messageType = filter.getMessageType();
        if (messageType == 2) {
            conds.add("\"DAV:contentclass\" = 'urn:content-classes:calendarmessage'");
        } else if (messageType == 1) {
            conds.add("\"DAV:contentclass\" = 'urn:content-classes:message'");
        } else if (messageType == 3) {
            conds.add("\"DAV:contentclass\" = 'urn:content-classes:calendarmessage'");
            conds.add("\"http://schemas.microsoft.com/exchange/outlookmessageclass\" = 'IPM.Schedule.Meeting.Request'");
        } else if (messageType == 4) {
            conds.add("\"DAV:contentclass\" = 'urn:content-classes:calendarmessage'");
            conds.add("(\"http://schemas.microsoft.com/exchange/outlookmessageclass\" = 'IPM.Schedule.Meeting.Resp.Pos' OR \"http://schemas.microsoft.com/exchange/outlookmessageclass\" = 'IPM.Schedule.Meeting.Resp.Neg' OR \"http://schemas.microsoft.com/exchange/outlookmessageclass\" = 'IPM.Schedule.Meeting.Resp.Tent')");
        } else if (messageType == 5) {
            conds.add("\"DAV:contentclass\" = 'urn:content-classes:calendarmessage'");
            conds.add("\"http://schemas.microsoft.com/exchange/outlookmessageclass\" = 'IPM.Schedule.Meeting.Canceled'");
        }
        tmpDate = filter.getFromTimeReceived();
        if (tmpDate != null) {
            conds.add("\"urn:schemas:httpmail:datereceived\" &gt;= '" + Utils.localToExchangeDate(tmpDate) + "' ");
        }
        if ((tmpDate = filter.getToTimeReceived()) != null) {
            conds.add("\"urn:schemas:httpmail:datereceived\" &lt;= '" + Utils.localToExchangeDate(tmpDate) + "' ");
        }
        if ((tmpDate = filter.getFromTimeSent()) != null) {
            conds.add("\"urn:schemas:httpmail:date\" &gt;= '" + Utils.localToExchangeDate(tmpDate) + "' ");
        }
        if ((tmpDate = filter.getToTimeSent()) != null) {
            conds.add("\"urn:schemas:httpmail:date\" &lt;= '" + Utils.localToExchangeDate(tmpDate) + "' ");
        }
        if ((tmpStr = filter.getBcc()) != null) {
            conds.add("\"urn:schemas:httpmail:bcc\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
        }
        if ((tmpStr = filter.getCc()) != null) {
            conds.add("\"urn:schemas:httpmail:cc\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
        }
        if ((tmpStr = filter.getFromId()) != null) {
            conds.add("\"urn:schemas:httpmail:from\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
        }
        if (filter.getFromLastModifiedDate() != null) {
            String gmtFromLastModifiedDate = Utils.localToExchangeDate(filter.getFromLastModifiedDate());
            conds.add("\"DAV:getlastmodified\" &gt;= '" + gmtFromLastModifiedDate + "' ");
        }
        if (filter.getToLastModifiedDate() != null) {
            String gmToLastModifiedDate = Utils.localToExchangeDate(filter.getToLastModifiedDate());
            conds.add("\"DAV:getlastmodified\" &lt;= '" + gmToLastModifiedDate + "' ");
        }
        String[] filterIds = null;
        tmpStr = filter.getId();
        if (tmpStr != null) {
            filterIds = Utils.splitString(tmpStr);
            String tmpCondition = "(";
            for (int i = 0; i < filterIds.length; ++i) {
                if (i != 0) {
                    tmpCondition = tmpCondition + " OR ";
                }
                tmpCondition = tmpCondition + "\"urn:schemas:mailheader:message-id\" = '" + this.encodeXMLContent(filterIds[i]) + "'";
            }
            conds.add(tmpCondition + ")");
        }
        if ((tmpStr = filter.getImportance()) != null) {
            conds.add("\"urn:schemas:httpmail:importance\" = " + this.ImportanceStringToInt(tmpStr));
        }
        if ((tmpStr = filter.getSensitivity()) != null) {
            conds.add("\"urn:schemas:mailheader:sensitivity\" LIKE '%" + tmpStr + "%'");
        }
        if ((tmpStr = filter.getMessage()) != null) {
            conds.add("\"urn:schemas:httpmail:textdescription\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
        }
        if ((tmpStr = filter.getSubject()) != null) {
            conds.add("\"urn:schemas:httpmail:subject\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
        }
        if ((tmpStr = filter.getToId()) != null) {
            String[] params = Utils.splitString(tmpStr);
            String tmpCondition = "";
            for (int i = 0; i < params.length; ++i) {
                if (i != 0) {
                    tmpCondition = tmpCondition + " AND ";
                }
                tmpCondition = tmpCondition + "\"urn:schemas:httpmail:to\" LIKE '%" + this.encodeXMLContent(params[i]).trim() + "%'";
            }
            conds.add(tmpCondition);
        }
        if ((tmpBool = filter.getHasAttachment()) != null) {
            conds.add("\"urn:schemas:httpmail:hasattachment\" = " + (tmpBool != false ? "TRUE" : "FALSE"));
        }
        if ((tmpBool = filter.isRead()) != null) {
            conds.add("\"urn:schemas:httpmail:read\" = " + (tmpBool != false ? "TRUE" : "FALSE"));
        }
        if (conds.size() > 0) {
            for (String cond : conds) {
                whereSql = whereSql != null ? whereSql + " and " : "";
                whereSql = whereSql + cond;
            }
            whereSql = " where " + whereSql;
        } else {
            whereSql = "";
        }
        String sql = selectSql + fromSql + whereSql;
        String xmlSql = "<?xml version=\"1.0\"?><d:searchrequest xmlns:d=\"DAV:\"><d:sql> " + sql + "</d:sql> </d:searchrequest> ";
        String searchPath = this.loginInfo.getExchangeUrl() + "/";
        tmpStr = filter.getFolder();
        if (tmpStr == null) {
            tmpStr = this.getInboxFolderName();
        }
        searchPath = searchPath + "/" + Utils.getEncodedHref(tmpStr);
        SearchMethod method = new SearchMethod(searchPath, xmlSql);
        method.setRequestHeader(new Header("Depth", "1"));
        method.setRequestHeader(new Header("Translate", "f"));
        if (filter.getMaxRows() != null && filter.getMaxRows() != -1) {
            method.setRequestHeader(new Header("Range", "rows=0-" + (filter.getMaxRows() - 1)));
        }
        if ((code = (client = this.getHttpClient()).executeMethod((HttpMethod)method)) < 200 || code > 300) {
            throw new WebDAVExceptions(2, code, null, "Error getting mail messages");
        }
        Enumeration enm = method.getResponses();
        ArrayList<ExchangeMessage> messages = new ArrayList<ExchangeMessage>();
        while (enm.hasMoreElements()) {
            Object obj = enm.nextElement();
            ResponseEntity entity = (ResponseEntity)obj;
            ExchangeMessage msg = this.createMessageObj(entity);
            if (msg == null) continue;
            if (filter.getFolder() != null) {
                msg.setFolder(filter.getFolder());
            }
            boolean uidFound = false;
            if (filterIds != null) {
                for (int i = 0; i < filterIds.length; ++i) {
                    String msgId;
                    String filterId = this.encodeXMLContent(filterIds[i]);
                    if (!filterId.equals(msgId = this.encodeXMLContent(msg.getId()))) continue;
                    uidFound = true;
                    break;
                }
            } else {
                uidFound = true;
            }
            if (!uidFound) continue;
            messages.add(msg);
        }
        return messages;
    }

    private int ImportanceStringToInt(String imp) {
        if (imp == null || imp.trim().length() == 0) {
            return 1;
        }
        if (imp.trim().equalsIgnoreCase("low")) {
            return 0;
        }
        if (imp.equalsIgnoreCase("high")) {
            return 2;
        }
        return 1;
    }

    private String ImportanceIntToString(String value) {
        if (value == null || value.trim().length() == 0) {
            return "Normal";
        }
        int imp = Integer.parseInt(value);
        if (imp == 0) {
            return "Low";
        }
        if (imp == 2) {
            return "High";
        }
        return "Normal";
    }

    private ExchangeMessage createMessageObj(ResponseEntity entity) {
        ExchangeMessage msg = new ExchangeMessage();
        String contentClass = null;
        String calendarMessageType = null;
        Enumeration enm1 = entity.getProperties();
        while (enm1.hasMoreElements()) {
            BaseProperty prop = (BaseProperty)enm1.nextElement();
            String propName = prop.getLocalName();
            String propValue = prop.getPropertyAsString();
            if (propValue == null || propValue.length() == 0) continue;
            if (propValue != null && propValue.length() != 0 && propName.equals("uid")) {
                msg.setId(propValue);
            }
            if (propName.equals("href")) {
                propValue = Utils.encodeForBracket(propValue);
                msg.setHref(propValue);
                continue;
            }
            if (propName.equals("from")) {
                msg.setFromId(propValue);
                continue;
            }
            if (propName.equals("datereceived")) {
                msg.setTimeReceived(Utils.exchangeToLocalDate(propValue));
                continue;
            }
            if (propName.equals("dateSent")) {
                msg.setTimeSent(Utils.exchangeToLocalDate(propValue));
                continue;
            }
            if (propName.equals("to")) {
                msg.setToId(propValue);
                continue;
            }
            if (propName.equals("cc")) {
                msg.setCc(propValue);
                continue;
            }
            if (propName.equals("bcc")) {
                msg.setBcc(propValue);
                continue;
            }
            if (propName.equals("subject")) {
                msg.setSubject(propValue);
                continue;
            }
            if (propName.equals("textdescription")) {
                msg.setMessage(propValue);
                continue;
            }
            if (propName.equals("htmldescription")) {
                msg.setHtmlMessage(propValue);
                continue;
            }
            if (propName.equals("importance")) {
                msg.setImportance(this.ImportanceIntToString(propValue));
                continue;
            }
            if (propName.equals("sensitivity")) {
                msg.setSensitivity(propValue);
                continue;
            }
            if (propName.equals("read")) {
                msg.setRead(Integer.parseInt(propValue) == 1);
                continue;
            }
            if (propName.equals("hasattachment")) {
                msg.setHasAttachment(Integer.parseInt(propValue) == 1);
                continue;
            }
            if (propName.equals("contentclass")) {
                contentClass = propValue;
                continue;
            }
            if (propName.equals("messageClass")) {
                calendarMessageType = propValue;
                continue;
            }
            if (propName.equals("meetingUID")) {
                msg.setMeetingUID(propValue);
                continue;
            }
            if (!propName.equalsIgnoreCase("lastmodified")) continue;
            msg.setLastModified(Utils.exchangeToLocalDate(propValue));
        }
        if ("urn:content-classes:message".equalsIgnoreCase(contentClass)) {
            msg.setMessageType(1);
        } else if ("urn:content-classes:calendarmessage".equalsIgnoreCase(contentClass)) {
            if (calendarMessageType != null) {
                if (calendarMessageType.equalsIgnoreCase("IPM.Schedule.Meeting.Request")) {
                    msg.setMessageType(3);
                } else if (calendarMessageType.equalsIgnoreCase("IPM.Schedule.Meeting.Resp.Pos")) {
                    msg.setMessageType(4);
                    msg.setMeetingResponseType("Accept");
                } else if (calendarMessageType.equalsIgnoreCase("IPM.Schedule.Meeting.Resp.Neg")) {
                    msg.setMessageType(4);
                    msg.setMeetingResponseType("Decline");
                } else if (calendarMessageType.equalsIgnoreCase("IPM.Schedule.Meeting.Resp.Tent")) {
                    msg.setMessageType(4);
                    msg.setMeetingResponseType("Tentative");
                } else if (calendarMessageType.equalsIgnoreCase("IPM.Schedule.Meeting.Canceled")) {
                    msg.setMessageType(5);
                    msg.setMeetingResponseType("Cancel");
                }
            }
        } else {
            msg.setMessageType(0);
        }
        return msg;
    }

    private String getMailboxURL() {
        return "\"" + this.getInboxFolderUrl() + "/\"";
    }

    void saveMessage(ExchangeMessage msg, boolean isNew) throws Throwable {
        String tmpStr;
        String strXMLNSInfo = "xmlns:g=\"DAV:\" xmlns:e=\"http://schemas.microsoft.com/exchange/\" xmlns:mapi=\"http://schemas.microsoft.com/mapi/\" xmlns:x=\"xml:\" xmlns:dt=\"urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/\" xmlns:header=\"urn:schemas:mailheader:\" xmlns:mail=\"urn:schemas:httpmail:\"> ";
        String strNameInfo = "";
        if (isNew) {
            tmpStr = msg.getFromId();
            if (tmpStr != null) {
                strNameInfo = strNameInfo + "<mail:from>" + this.encodeXMLContent(tmpStr) + "</mail:from>";
            }
            if ((tmpStr = msg.getBcc()) != null) {
                strNameInfo = strNameInfo + "<mail:cc>" + this.encodeXMLContent(tmpStr) + "</mail:cc>";
            }
            if ((tmpStr = msg.getToId()) != null) {
                strNameInfo = strNameInfo + "<mail:to>" + this.encodeXMLContent(tmpStr) + "</mail:to>";
            }
            if ((tmpStr = Utils.localToLongExchangeDate(msg.getTimeSent())) != null) {
                strNameInfo = strNameInfo + "<mail:date dt:dt=\"dateTime.tz\">" + this.encodeXMLContent(tmpStr) + "</mail:date>";
            }
            if ((tmpStr = msg.getMessage()) != null) {
                strNameInfo = strNameInfo + "<mail:htmldescription>" + this.encodeXMLContent(tmpStr) + "</mail:htmldescription>";
            }
            if ((tmpStr = msg.getSubject()) != null) {
                strNameInfo = strNameInfo + "<mail:subject>" + this.encodeXMLContent(tmpStr) + "</mail:subject>";
            }
            if ((tmpStr = msg.getSensitivity()) != null) {
                strNameInfo = strNameInfo + "<header:sensitivity>" + tmpStr + "</header:sensitivity>";
            }
        }
        if (msg.isRead() != null) {
            strNameInfo = strNameInfo + "<mail:read dt:dt=\"boolean\">" + (msg.isRead() != false ? "1" : "0") + "</mail:read>";
        }
        if ((tmpStr = msg.getImportance()) != null) {
            int imp = 1;
            if (tmpStr.trim().equalsIgnoreCase("low")) {
                imp = 0;
            } else if (tmpStr.equalsIgnoreCase("high")) {
                imp = 2;
            }
            strNameInfo = strNameInfo + "<mail:importance dt:dt=\"int\">" + imp + "</mail:importance>";
        }
        String strBody = "<?xml version=\"1.0\"?><g:propertyupdate " + strXMLNSInfo + "<g:set> <g:prop><g:contentclass>urn:content-classes:message</g:contentclass><e:outlookmessageclass>Ipm.Note</e:outlookmessageclass>" + strNameInfo + "</g:prop></g:set></g:propertyupdate>";
        int code = this.executeWebDAVMethod(PropPatchMethod.class, this.getHttpClient(), msg.getHref(), strBody, true);
        if (code < 200 || code > 300) {
            throw new WebDAVExceptions(2, code, null, "Error saving the message");
        }
        String uid = Utils.findProperty(msg.getHref(), "uid", "DAV:", this.getHttpClient());
        if (uid == null) {
            throw new WebDAVExceptions(11, null, "Error getting UID of the new mail");
        }
        msg.setId(uid);
    }

    ExchangeMessage getMessage(String uid, String folder) throws Throwable {
        MessageFilterInfo filterInfo = new MessageFilterInfo();
        filterInfo.setId(uid);
        if (folder == null) {
            folder = this.getInboxFolderName();
        }
        filterInfo.setFolder(folder);
        ArrayList msgs = this.getMessages(filterInfo);
        if (msgs.size() == 0) {
            throw new WebDAVExceptions(4, "UID " + uid + " not found");
        }
        return (ExchangeMessage)msgs.get(0);
    }

    void deleteMessages(String[] uids) throws Throwable {
        this.deleteMessages(uids, this.getInboxFolderName());
    }

    void deleteMessages(String[] uids, String folder) throws Throwable {
        ArrayList msgs;
        if (folder == null) {
            folder = this.getInboxFolderName();
        }
        if ((msgs = this.getMessages(uids, folder)) == null || msgs.size() == 0) {
            throw new WebDAVExceptions(4, null, "UID(s) not found");
        }
        for (ExchangeMessage msg : msgs) {
            try {
                AttachmentManager atchMgr = new AttachmentManager(this.connection);
                atchMgr.deleteAttachmentsFor(msg.getHref());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.deleteAtHref(msg.getHref());
        }
    }

    ArrayList getMessages(String[] uids, String folder) throws Throwable {
        if (folder == null) {
            folder = this.getInboxFolderName();
        }
        ArrayList<ExchangeMessage> verifiedMessages = new ArrayList<ExchangeMessage>();
        if (uids == null) {
            return verifiedMessages;
        }
        MessageFilterInfo filterInfo = new MessageFilterInfo();
        String uidFilter = "";
        for (int i = 0; i < uids.length; ++i) {
            if (i != 0) {
                uidFilter = uidFilter + ",";
            }
            uidFilter = uidFilter + uids[i];
        }
        filterInfo.setId(uidFilter);
        if (folder != null) {
            filterInfo.setFolder(folder);
        }
        ArrayList msgs = this.getMessages(filterInfo);
        Arrays.sort(uids);
        for (ExchangeMessage msg : msgs) {
            if (Arrays.binarySearch(uids, msg.getId()) < 0) continue;
            verifiedMessages.add(msg);
        }
        return verifiedMessages;
    }

    void addAttachments(String href, String[] fileNames, Object[] contents) throws Throwable {
        if (href == null) {
            return;
        }
        AttachmentManager atchMgr = new AttachmentManager(this.connection);
        atchMgr.createAttachments(href, fileNames, contents);
    }

    ArrayList getAttachments(String uid, boolean getContent) throws Throwable {
        return this.getAttachments(uid, getContent, this.getInboxFolderName());
    }

    ArrayList getAttachments(String uid, boolean getContent, String messageFolder) throws Throwable {
        if (uid == null) {
            return null;
        }
        ExchangeMessage msg = this.getMessage(uid, messageFolder);
        AttachmentManager atchMgr = new AttachmentManager(this.connection);
        return atchMgr.getAttachments(msg, getContent, messageFolder);
    }

    void deleteAttachments(String uid, String[] fileNames) throws Throwable {
        this.deleteAttachments(uid, fileNames, this.getInboxFolderName());
    }

    void deleteAttachments(String uid, String[] fileNames, String folder) throws Throwable {
        ArrayList atchmts = this.getAttachments(uid, false, folder);
        if (atchmts == null) {
            return;
        }
        block0: for (ExchangeAttachment atch : atchmts) {
            String fileName = atch.getFileName();
            if (fileNames != null) {
                for (int i = 0; i < fileNames.length; ++i) {
                    if (!fileName.equals(fileNames[i])) continue;
                    this.deleteAtHref(atch.getHref());
                    continue block0;
                }
                continue;
            }
            this.deleteAtHref(atch.getHref());
        }
    }

    void createMessage(ExchangeMessage msg) throws Throwable {
        this.createMessage(msg, null, null);
    }

    void createMessage(ExchangeMessage msg, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
        if (msg.getFolder() == null) {
            msg.setFolder(this.getInboxFolderName());
        }
        msg.setHref(this.createURI(msg.getFolder()));
        this.saveMessage(msg, true);
        if (attachedFileNames != null && attachedFileContents != null) {
            AttachmentManager atchMgr = new AttachmentManager(this.connection);
            atchMgr.createAttachments(msg.getHref(), attachedFileNames, attachedFileContents);
        }
    }

    private String createURI(String folder) {
        String strMessageItem = this.loginInfo.getMailBoxName() + "_msg_" + Calendar.getInstance().getTimeInMillis() + ".eml";
        String folderStr = null;
        folderStr = folder == null ? "/" + this.getInboxFolderName() + "/" : "/" + folder + "/";
        return this.loginInfo.getExchangeUrl() + folderStr + strMessageItem;
    }

    void modifyMessage(ExchangeMessage msg) throws Throwable {
        if (msg == null || msg.getId() == null) {
            return;
        }
        MessageFilterInfo filter = new MessageFilterInfo();
        filter.setId(msg.getId());
        filter.setFolder(msg.getFolder());
        ArrayList msgList = this.getMessages(filter);
        if (msgList == null || msgList.size() == 0) {
            throw new WebDAVExceptions(4, null, "UID not found");
        }
        ExchangeMessage oldMsg = (ExchangeMessage)msgList.get(0);
        oldMsg.setNonNullValues(msg);
        if (msg.getHref() == null) {
            msg.setHref(oldMsg.getHref());
        }
        this.saveMessage(oldMsg, false);
    }

    void modifyMessage(ExchangeMessage msg, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
        this.modifyMessage(msg);
        if (attachedFileNames != null && attachedFileContents != null) {
            AttachmentManager atchMgr = new AttachmentManager(this.connection);
            atchMgr.createAttachments(msg.getHref(), attachedFileNames, attachedFileContents);
        }
    }

    public ArrayList getMeetingInfo(String meetingUID, String mailUID) throws Throwable {
        String sql = CalendarManager.createSelectSQL();
        sql = sql + " ,\"urn:schemas:httpmail:datereceived\" as dateReceived ";
        sql = sql + ",\"urn:schemas:mailheader:message-id\" as mailUID ";
        sql = sql + " from \"" + this.connection.webDavResource.getHttpURL().toString() + "/" + this.getInboxFolderName() + "\" ";
        sql = sql + " where \"urn:schemas:calendar:uid\" =  '" + this.encodeXMLContent(meetingUID) + "'";
        sql = sql + " and \"http://schemas.microsoft.com/mapi/proptag/0x67aa000b\" = FALSE ";
        if (mailUID != null) {
            sql = sql + " and \"urn:schemas:mailheader:message-id\" LIKE '%" + Utils.getEncodedHref(mailUID) + "%'";
        }
        sql = sql + " ORDER By \"urn:schemas:httpmail:datereceived\" DESC ";
        String xmlSql = "<?xml version=\"1.0\"?><d:searchrequest xmlns:d=\"DAV:\"><d:sql> " + sql + "</d:sql> </d:searchrequest> ";
        String searchPath = this.loginInfo.getExchangeUrl() + "/" + this.getInboxFolderName();
        SearchMethod method = new SearchMethod(searchPath, xmlSql);
        method.setRequestHeader(new Header("Depth", "1"));
        method.setRequestHeader(new Header("Translate", "f"));
        HttpClient client = this.getHttpClient();
        int code = client.executeMethod((HttpMethod)method);
        if (code < 200 || code > 300) {
            throw new WebDAVExceptions(2, code, null, "Error getting meeting info");
        }
        Enumeration enm = method.getResponses();
        ArrayList<ExchangeMailMeeting> meetings = new ArrayList<ExchangeMailMeeting>();
        while (enm.hasMoreElements()) {
            Object obj = enm.nextElement();
            ResponseEntity entity = (ResponseEntity)obj;
            ExchangeMailMeeting mt = (ExchangeMailMeeting)CalendarManager.createAppointmentObj(entity, true);
            if (mailUID != null && !mt.getId().equalsIgnoreCase(mailUID)) continue;
            meetings.add(mt);
        }
        return meetings;
    }

    public void moveMessages(MessageFilterInfo filter, String destinationFolder) throws Throwable {
        ArrayList messages = this.getMessages(filter);
        String targetFolderURI = this.loginInfo.getExchangeUrl() + "/" + Utils.getEncodedHref(destinationFolder) + "/";
        for (int i = 0; i < messages.size(); ++i) {
            ExchangeMessage msg = (ExchangeMessage)messages.get(i);
            this.moveMessagesHelper(msg.getHref(), targetFolderURI);
        }
    }

    private void moveMessagesHelper(String sourceHref, String destFolderURI) throws Throwable {
        if (sourceHref == null) {
            return;
        }
        int index = sourceHref.lastIndexOf(47);
        if (index < 0) {
            return;
        }
        String newHref = destFolderURI + sourceHref.substring(index + 1);
        if (newHref.equals(sourceHref)) {
            return;
        }
        MoveMethod moveMethod = new MoveMethod(sourceHref);
        moveMethod.setDestination(newHref);
        moveMethod.setRequestHeader("Content-Type", "message/rfc822");
        int code = this.client.executeMethod((HttpMethod)moveMethod);
        if (code < 200 || code >= 300) {
            throw new WebDAVExceptions(2, code, null, "Error Moving Exchange resource");
        }
    }
}

