/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.mapping;

import coldfusion.orm.mapping.CFCPersistenceMetadata;
import coldfusion.orm.mapping.CFPropertyBinder;
import coldfusion.orm.mapping.OneToManyField;
import coldfusion.orm.mapping.PropertyField;
import coldfusion.orm.mapping.RelationField;
import coldfusion.sql.DBMetaData;
import coldfusion.sql.ForeignKeyMetaData;
import coldfusion.sql.TableMetaData;
import coldfusion.util.RB;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ManyToOneField
extends RelationField {
    private boolean insertable = true;
    private boolean updatable = true;
    private boolean unique;
    protected boolean notNull;
    private boolean optimisticLock = true;
    private boolean missingRowIgnored;
    private String indexName;
    private String uniqueKeyName;
    private String fkName;

    public boolean isInsertable() {
        return this.insertable;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public void setNotNull(boolean notNull) {
        this.notNull = notNull;
    }

    public boolean isOptimisticLock() {
        return this.optimisticLock;
    }

    public void setOptimisticLock(boolean optimisticLock) {
        this.optimisticLock = optimisticLock;
    }

    public boolean isMissingRowIgnored() {
        return this.missingRowIgnored;
    }

    public void setMissingRowIgnored(boolean missingRowIgnored) {
        this.missingRowIgnored = missingRowIgnored;
    }

    @Override
    public void resolve(CFCPersistenceMetadata cfcPmd, Map<String, CFCPersistenceMetadata> cfcMetaDataMap, DBMetaData dbMetaData) {
        CFCPersistenceMetadata targetCfcPmd = cfcMetaDataMap.get(this.targetComponent);
        if (targetCfcPmd == null) {
            return;
        }
        this.validateMappedByValue(cfcPmd, targetCfcPmd);
        if (this.fkColumns != null) {
            return;
        }
        OneToManyField targetOneToManyFied = (OneToManyField)targetCfcPmd.getRelationField(cfcPmd.getCfcName(), 2);
        if (this.linkTable == null && targetOneToManyFied != null && targetOneToManyFied.getFkColumns() != null) {
            this.fkColumns = targetOneToManyFied.getFkColumns();
            return;
        }
        try {
            TableMetaData thisTableMetadata = null;
            TableMetaData thatTableMetadata = null;
            if (dbMetaData != null) {
                thisTableMetadata = dbMetaData.getTableMetaData(cfcPmd.getTableName(), cfcPmd.getSchema(), cfcPmd.getCatalog());
                thatTableMetadata = dbMetaData.getTableMetaData(targetCfcPmd.getTableName(), targetCfcPmd.getSchema(), targetCfcPmd.getCatalog());
            }
            if (thisTableMetadata == null && thatTableMetadata == null && this.linkTable == null) {
                this.fkColumns = this.generateFKColumnNames(targetCfcPmd, this.name);
                if (this.fkColumns != null) {
                    if (targetOneToManyFied != null) {
                        targetOneToManyFied.setFkColumns(this.fkColumns);
                    }
                    return;
                }
            }
            if (dbMetaData == null || thisTableMetadata == null || thatTableMetadata == null) {
                return;
            }
            if (this.linkTable != null) {
                TableMetaData linkTableMetadata = dbMetaData.getTableMetaData(this.linkTable, this.linkTableSchema, this.linkTableCatalog);
                if (linkTableMetadata != null) {
                    Map fkMap = linkTableMetadata.getForeignKeys();
                    for (String fkCol : fkMap.keySet()) {
                        ForeignKeyMetaData fkMetadata = (ForeignKeyMetaData)fkMap.get(fkCol);
                        String pktableName = fkMetadata.getPktableName();
                        if (this.fkColumns == null && pktableName.equalsIgnoreCase(cfcPmd.getTableName())) {
                            this.fkColumns = new String[]{fkCol};
                            continue;
                        }
                        if (this.inverseJoinColumn != null || !pktableName.equalsIgnoreCase(targetCfcPmd.getTableName())) continue;
                        this.inverseJoinColumn = new String[]{fkCol};
                    }
                    if (targetOneToManyFied != null) {
                        if (targetOneToManyFied.getFkColumns() == null) {
                            targetOneToManyFied.setFkColumns(this.inverseJoinColumn);
                        }
                        if (targetOneToManyFied.getInverseJoinColumn() == null) {
                            targetOneToManyFied.setInverseJoinColumn(this.fkColumns);
                        }
                    }
                }
                return;
            }
            Map fkMap = thisTableMetadata.getForeignKeys();
            for (ForeignKeyMetaData fkMetaData : fkMap.values()) {
                if (!fkMetaData.getPktableName().equalsIgnoreCase(targetCfcPmd.getTableName())) continue;
                this.fkColumns = new String[]{fkMetaData.getFkColName()};
                String pkColName = fkMetaData.getPkColName();
                Set pkColumns = thatTableMetadata.getPkColumns();
                if (!pkColumns.contains(pkColName) && this.mappedBy == null) {
                    this.mappedBy = targetCfcPmd.getMappedPropertyField(pkColName);
                }
                if (targetOneToManyFied != null && targetOneToManyFied.getFkColumns() == null) {
                    targetOneToManyFied.setFkColumns(this.fkColumns);
                }
                return;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void validateMappedByValue(CFCPersistenceMetadata cfcPmd, CFCPersistenceMetadata targetCFCPmd) {
        if (this.mappedBy == null || this.linkTable != null) {
            return;
        }
        List<PropertyField> propertyFields = targetCFCPmd.getPropertyFields();
        boolean found = false;
        for (int i = 0; i < propertyFields.size(); ++i) {
            PropertyField field = propertyFields.get(i);
            if (!field.getName().equals(this.mappedBy)) continue;
            found = true;
            break;
        }
        if (!found) {
            List<RelationField> relFields = targetCFCPmd.getRelationFields();
            int relFieldSize = relFields != null ? relFields.size() : 0;
            for (int i = 0; i < relFieldSize; ++i) {
                RelationField relationField = relFields.get(i);
                if (relationField.getRelationType() != 1 || !relationField.getName().equals(this.mappedBy)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            throw new CFPropertyBinder.AttributeValidationException(RB.getString((Object)this, (String)"invalidMappedByValue", (Object)this.name, (Object)cfcPmd.getCfcName(), (Object)this.mappedBy, (Object)targetCFCPmd.getCfcName()));
        }
    }

    @Override
    public boolean isResolved() {
        return this.fkColumns != null;
    }

    @Override
    public int getRelationType() {
        return 3;
    }

    public void setIndexName(String index) {
        this.indexName = index;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setUniqueKeyName(String uniqueKey) {
        this.uniqueKeyName = uniqueKey;
    }

    public String getUniqueKeyName() {
        return this.uniqueKeyName;
    }

    public void setForeignKeyName(String fkName) {
        this.fkName = fkName;
    }

    public String getForeignKeyName() {
        return this.fkName;
    }
}

