/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.mapping;

import coldfusion.orm.mapping.CFPropertyBinder;
import coldfusion.orm.mapping.CollectionField;
import coldfusion.orm.mapping.CompositeID;
import coldfusion.orm.mapping.EmbeddedField;
import coldfusion.orm.mapping.Field;
import coldfusion.orm.mapping.IDField;
import coldfusion.orm.mapping.ManyToOneField;
import coldfusion.orm.mapping.OneToOneField;
import coldfusion.orm.mapping.PropertyField;
import coldfusion.orm.mapping.RelationField;
import coldfusion.orm.mapping.TimeStampField;
import coldfusion.orm.mapping.VersionField;
import coldfusion.sql.DBMetaData;
import coldfusion.sql.ForeignKeyMetaData;
import coldfusion.sql.TableMetaData;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.RB;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CFCPersistenceMetadata {
    private String entityName;
    private String cfcName;
    private String parentCfcName;
    private String tableName;
    private String schema;
    private String catalog;
    private boolean dynamicInsert;
    private boolean dynamicUpdate;
    private boolean readOnly;
    private boolean selectBeforeUpdate;
    private String discriminatorColumn;
    private String discriminatorValue;
    private String joinColumn;
    private int batchSize;
    private String optimisticLock;
    private boolean lazy = true;
    private String rowId;
    private Object id;
    private String cacheName;
    private String cacheStrategy;
    private VersionField version;
    private TimeStampField timestamp;
    private List<PropertyField> propertyFields = new ArrayList<PropertyField>();
    private List<EmbeddedField> embeddedFields;
    private List<RelationField> relationFields;
    private List<CollectionField> collectionFields;
    private CFCPersistenceMetadata parentCFCPmd;
    private Map<String, List<Field>> joinedFields;
    private String whereString;
    private String saveMapping;
    private String datasource;

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getCfcName() {
        return this.cfcName;
    }

    public void setCfcName(String cfcName) {
        this.cfcName = cfcName;
    }

    public String getParentCfcName() {
        return this.parentCfcName;
    }

    public void setParentCfcName(String parentCfcName) {
        this.parentCfcName = parentCfcName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public boolean isDynamicInsert() {
        return this.dynamicInsert;
    }

    public void setDynamicInsert(boolean dynamicInsert) {
        this.dynamicInsert = dynamicInsert;
    }

    public boolean isDynamicUpdate() {
        return this.dynamicUpdate;
    }

    public void setDynamicUpdate(boolean dynamicUpdate) {
        this.dynamicUpdate = dynamicUpdate;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isSelectBeforeUpdate() {
        return this.selectBeforeUpdate;
    }

    public void setSelectBeforeUpdate(boolean selectBeforeUpdate) {
        this.selectBeforeUpdate = selectBeforeUpdate;
    }

    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public void setDiscriminatorValue(String discriminatorValue) {
        this.discriminatorValue = discriminatorValue;
    }

    public String getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    public void setDiscriminatorColumn(String discriminatorColumn) {
        this.discriminatorColumn = discriminatorColumn;
    }

    public String getJoinColumn() {
        return this.joinColumn;
    }

    public void setJoinColumn(String joinColumn) {
        this.joinColumn = joinColumn;
    }

    public void addIdField(IDField idField) {
        if (this.id == null) {
            this.id = idField;
        } else if (this.id instanceof CompositeID) {
            CompositeID compositeId = (CompositeID)this.id;
            compositeId.addField(idField);
        } else {
            CompositeID compositeId = new CompositeID();
            compositeId.addField((IDField)this.id);
            compositeId.addField(idField);
            this.id = compositeId;
        }
    }

    public void addIdField(ManyToOneField manyToOne) {
        CompositeID compositeId;
        if (this.id instanceof CompositeID) {
            compositeId = (CompositeID)this.id;
            compositeId.addField(manyToOne);
        } else {
            compositeId = new CompositeID();
            compositeId.addField(manyToOne);
            if (this.id instanceof IDField) {
                compositeId.addField((IDField)this.id);
            }
        }
        this.id = compositeId;
    }

    public Object getIdField() {
        return this.id;
    }

    public void addPropertyField(PropertyField field) {
        if (field.getTable() != null) {
            List<Field> fieldList;
            if (this.joinedFields == null) {
                this.joinedFields = new CaseInsensitiveMap();
            }
            if ((fieldList = this.joinedFields.get(field.getTable())) == null) {
                fieldList = new ArrayList<Field>();
                this.joinedFields.put(field.getTable(), fieldList);
            }
            fieldList.add(field);
        } else {
            this.propertyFields.add(field);
        }
    }

    public List<PropertyField> getPropertyFields() {
        return this.propertyFields;
    }

    public Map<String, List<Field>> getJoinedFields() {
        return this.joinedFields;
    }

    public String getMappedPropertyField(String columnName) {
        for (PropertyField field : this.propertyFields) {
            if (!field.getColumn().equalsIgnoreCase(columnName)) continue;
            return field.getName();
        }
        return null;
    }

    public void addEmbeddedField(EmbeddedField field) {
        if (this.embeddedFields == null) {
            this.embeddedFields = new ArrayList<EmbeddedField>();
        }
        this.embeddedFields.add(field);
    }

    public List<EmbeddedField> getEmbeddedFields() {
        return this.embeddedFields;
    }

    public void addRelationField(RelationField field) {
        if (field.getLinkTable() != null && (field instanceof ManyToOneField || field instanceof OneToOneField)) {
            List<Field> fieldList;
            if (this.joinedFields == null) {
                this.joinedFields = new CaseInsensitiveMap();
            }
            if ((fieldList = this.joinedFields.get(field.getLinkTable())) == null) {
                fieldList = new ArrayList<Field>();
                this.joinedFields.put(field.getLinkTable(), fieldList);
            }
            fieldList.add(field);
        } else {
            if (this.relationFields == null) {
                this.relationFields = new ArrayList<RelationField>();
            }
            this.relationFields.add(field);
        }
    }

    public List<RelationField> getRelationFields() {
        return this.relationFields;
    }

    public RelationField getRelationField(String targetComponent, int relationType) {
        if (this.relationFields != null) {
            for (RelationField field : this.relationFields) {
                if (field.getRelationType() != relationType || !field.getTargetComponent().equalsIgnoreCase(targetComponent)) continue;
                return field;
            }
        }
        if (this.joinedFields != null) {
            for (String joinTable : this.joinedFields.keySet()) {
                List<Field> joinedProperties = this.joinedFields.get(joinTable);
                if (joinedProperties == null || joinedProperties.size() == 0) continue;
                for (Field field : joinedProperties) {
                    RelationField relField;
                    if (!(field instanceof RelationField) || (relField = (RelationField)field).getRelationType() != relationType || !relField.getTargetComponent().equalsIgnoreCase(targetComponent)) continue;
                    return relField;
                }
            }
        }
        return null;
    }

    public void addCollectionField(CollectionField col) {
        if (this.collectionFields == null) {
            this.collectionFields = new ArrayList<CollectionField>();
        }
        this.collectionFields.add(col);
    }

    public List<CollectionField> getCollectionFields() {
        return this.collectionFields;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public String getOptimisticLock() {
        return this.optimisticLock;
    }

    public void setOptimisticLock(String optimisticLock) {
        this.optimisticLock = optimisticLock;
    }

    public String getRowId() {
        return this.rowId;
    }

    public void setRowId(String rowId) {
        this.rowId = rowId;
    }

    public TimeStampField getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(TimeStampField timestamp) {
        this.timestamp = timestamp;
    }

    public VersionField getVersion() {
        return this.version;
    }

    public void setVersion(VersionField version) {
        this.version = version;
    }

    public void resolveRelationships(Map<String, CFCPersistenceMetadata> cfcMetaDataMap, DBMetaData dbMetaData) {
        if (this.relationFields != null) {
            for (RelationField relationField : this.relationFields) {
                relationField.resolve(this, cfcMetaDataMap, dbMetaData);
                if (relationField.isResolved()) continue;
                throw new CFPropertyBinder.AttributeValidationException(RB.getString((Object)this, (String)"unresolvedRelation", (Object)relationField.getName(), (Object)this.cfcName));
            }
        }
        if (this.joinedFields != null) {
            for (String joinedTable : this.joinedFields.keySet()) {
                List<Field> list = this.joinedFields.get(joinedTable);
                if (list.size() == 0) continue;
                for (Field joinField : list) {
                    RelationField relationField = joinField instanceof RelationField ? (RelationField)joinField : null;
                    if (relationField == null) continue;
                    relationField.resolve(this, cfcMetaDataMap, dbMetaData);
                    if (relationField.isResolved()) continue;
                    throw new CFPropertyBinder.AttributeValidationException(RB.getString((Object)this, (String)"unresolvedRelation", (Object)relationField.getName(), (Object)this.cfcName));
                }
            }
        }
        List<ManyToOneField> idManyToOneFields = null;
        if (this.id instanceof CompositeID) {
            idManyToOneFields = ((CompositeID)this.id).getManyToOneFields();
        }
        if (idManyToOneFields != null) {
            for (RelationField relationField : idManyToOneFields) {
                relationField.resolve(this, cfcMetaDataMap, dbMetaData);
                if (relationField.isResolved()) continue;
                throw new CFPropertyBinder.AttributeValidationException(RB.getString((Object)this, (String)"unresolvedRelation", (Object)relationField.getName(), (Object)this.cfcName));
            }
        }
    }

    public void setParentCFCPmd(CFCPersistenceMetadata parentCfc, DBMetaData dbMetaData) {
        String parentTable;
        if (parentCfc == null) {
            return;
        }
        this.parentCFCPmd = parentCfc;
        String tableName = this.getTableName();
        if (!tableName.equalsIgnoreCase(parentTable = parentCfc.getTableName())) {
            block10: {
                if (this.joinColumn == null && dbMetaData != null) {
                    try {
                        TableMetaData tableMetaData = dbMetaData.getTableMetaData(tableName, this.schema, this.catalog);
                        if (tableMetaData == null) break block10;
                        Map fks = tableMetaData.getForeignKeys();
                        for (ForeignKeyMetaData fkMetaData : fks.values()) {
                            if (!fkMetaData.getPktableName().equalsIgnoreCase(parentTable)) continue;
                            this.joinColumn = fkMetaData.getFkColName();
                            break;
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
            if (this.joinColumn == null) {
                throw new CFPropertyBinder.AttributeValidationException(RB.getString((Object)this, (String)"joinColumnMissing", (Object)this.cfcName));
            }
        } else {
            if (this.parentCFCPmd.getDiscriminatorColumn() == null) {
                this.parentCFCPmd.setDiscriminatorColumn(this.parentCFCPmd.getEntityName() + "Type");
            }
            if (this.discriminatorValue == null) {
                this.discriminatorValue = this.entityName;
            }
        }
    }

    public CFCPersistenceMetadata getParentCFCPmd() {
        return this.parentCFCPmd;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public String getCacheStrategy() {
        return this.cacheStrategy;
    }

    public void setCacheStrategy(String cacheStrategy) {
        this.cacheStrategy = cacheStrategy;
    }

    public void setWhereString(String whereString) {
        this.whereString = whereString;
    }

    public String getWhereString() {
        return this.whereString;
    }

    public String getSaveMapping() {
        return this.saveMapping;
    }

    public void setSaveMapping(String saveMapping) {
        this.saveMapping = saveMapping;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public String getDatasource() {
        return this.datasource;
    }
}

