/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.hibernate;

import coldfusion.orm.hibernate.HibernateConfiguration;
import coldfusion.orm.hibernate.HibernatePersistenceManager;
import coldfusion.orm.hibernate.HibernateSessionException;
import coldfusion.orm.hibernate.HibernateSessionManager;
import coldfusion.runtime.TemplateProxy;
import coldfusion.tagext.sql.TransactionTag;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.IdentifierLoadAccess;
import org.hibernate.LobHelper;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Metamodel;
import org.hibernate.MultiIdentifierLoadAccess;
import org.hibernate.NaturalIdLoadAccess;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionEventListener;
import org.hibernate.SessionFactory;
import org.hibernate.SharedSessionBuilder;
import org.hibernate.SimpleNaturalIdLoadAccess;
import org.hibernate.Transaction;
import org.hibernate.TypeHelper;
import org.hibernate.UnknownProfileException;
import org.hibernate.internal.SessionImpl;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.jdbc.Work;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.stat.SessionStatistics;

public class SessionWrapper
implements Session {
    private HibernateConfiguration config;
    private Session session;
    private String datasource;

    public SessionWrapper(HibernateConfiguration config, Session session, String datasource) {
        this.config = config;
        this.session = session;
        this.datasource = datasource;
    }

    public Session getActualSession() {
        return this.session;
    }

    public Transaction beginTransaction() throws HibernateException {
        return this.session.beginTransaction();
    }

    public void cancelQuery() throws HibernateException {
        this.session.cancelQuery();
    }

    public void clear() {
        this.session.clear();
    }

    public Connection connection() throws HibernateException {
        return ((SessionImpl)this.session).connection();
    }

    public boolean contains(String entityName, Object object) {
        return this.session.contains(entityName, object);
    }

    public Criteria createCriteria(String entityName) {
        return this.session.createCriteria(entityName);
    }

    public Criteria createCriteria(String entityName, String alias) {
        return this.session.createCriteria(entityName, alias);
    }

    public Criteria createCriteria(Class persistentClass) {
        return this.session.createCriteria(persistentClass);
    }

    public Criteria createCriteria(Class persistentClass, String alias) {
        return this.session.createCriteria(persistentClass, alias);
    }

    public Query createFilter(Object collection, String queryString) throws HibernateException {
        return this.session.createFilter(collection, queryString);
    }

    public Query createNamedQuery(String name, Class resultType) throws HibernateException {
        return this.session.createNamedQuery(name, resultType);
    }

    public Query createQuery(String queryString) throws HibernateException {
        this.attachTransactionToSession();
        return this.session.createQuery(queryString);
    }

    public Query createQuery(CriteriaDelete deleteQuery) throws HibernateException {
        return this.session.createQuery(deleteQuery);
    }

    public Query createQuery(CriteriaUpdate updateQuery) throws HibernateException {
        return this.session.createQuery(updateQuery);
    }

    public Query createQuery(CriteriaQuery criteriaQuery) throws HibernateException {
        return this.session.createQuery(criteriaQuery);
    }

    public Query createQuery(String queryString, Class resultType) throws HibernateException {
        return this.session.createQuery(queryString, resultType);
    }

    public NativeQuery createNativeQuery(String queryString) throws HibernateException {
        return this.session.createNativeQuery(queryString);
    }

    public void delete(String entityName, Object object) throws HibernateException {
        this.attachTransactionToSession();
        this.session.delete(entityName, object);
    }

    public void delete(Object object) throws HibernateException {
        this.attachTransactionToSession();
        String entityName = this.getEntityNameForCFC(object);
        if (entityName != null) {
            this.session.delete(entityName, object);
        } else {
            this.session.delete(object);
        }
    }

    public void disableFilter(String filterName) {
        this.session.disableFilter(filterName);
    }

    public Connection disconnect() throws HibernateException {
        return this.session.disconnect();
    }

    public Filter enableFilter(String filterName) {
        return this.session.enableFilter(filterName);
    }

    public void evict(Object object) throws HibernateException {
        if (object instanceof ArrayList) {
            for (Object obj : (ArrayList)object) {
                this.session.evict(obj);
            }
        } else {
            this.session.evict(object);
        }
    }

    public void flush() throws HibernateSessionException {
        this.attachTransactionToSession();
        try {
            this.session.flush();
        }
        catch (HibernateException t) {
            HibernateSessionManager.getInstance().discardSession(this);
            throw new HibernateSessionException(t);
        }
        catch (PersistenceException t) {
            HibernateSessionManager.getInstance().discardSession(this);
            throw new HibernateSessionException(t);
        }
    }

    public Object get(Class clazz, Serializable id) throws HibernateException {
        return this.session.get(clazz, id);
    }

    public Object get(Class clazz, Serializable id, LockMode lockMode) throws HibernateException {
        return this.session.get(clazz, id, lockMode);
    }

    public Object get(Class clazz, Serializable id, LockOptions lockOptions) throws HibernateException {
        return this.session.get(clazz, id, lockOptions);
    }

    public Object get(String entityName, Serializable id) throws HibernateException {
        return this.session.get(entityName, id);
    }

    public Object get(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        return this.session.get(entityName, id, lockMode);
    }

    public Object get(String entityName, Serializable id, LockOptions lockOptions) throws HibernateException {
        return this.session.get(entityName, id, lockOptions);
    }

    public CacheMode getCacheMode() {
        return this.session.getCacheMode();
    }

    public void setCacheMode(CacheMode cacheMode) {
        this.session.setCacheMode(cacheMode);
    }

    public LockMode getCurrentLockMode(Object object) throws HibernateException {
        return this.session.getCurrentLockMode(object);
    }

    public Filter getEnabledFilter(String filterName) {
        return this.session.getEnabledFilter(filterName);
    }

    public String getEntityName(Object object) throws HibernateException {
        return this.session.getEntityName(object);
    }

    public FlushModeType getFlushMode() {
        return this.session.getFlushMode();
    }

    public void setFlushMode(FlushModeType arg0) {
    }

    public FlushMode getHibernateFlushMode() {
        return this.session.getHibernateFlushMode();
    }

    public void setHibernateFlushMode(FlushMode flushMode) {
        this.session.setHibernateFlushMode(flushMode);
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        return this.session.getIdentifier(object);
    }

    public Query getNamedQuery(String queryName) throws HibernateException {
        return this.session.getNamedQuery(queryName);
    }

    public SessionFactory getSessionFactory() {
        return this.session.getSessionFactory();
    }

    public SessionStatistics getStatistics() {
        return this.session.getStatistics();
    }

    public Transaction getTransaction() {
        return this.session.getTransaction();
    }

    public boolean isConnected() {
        return this.session.isConnected();
    }

    public boolean isDirty() throws HibernateException {
        return this.session.isDirty();
    }

    public boolean isOpen() {
        return this.session.isOpen();
    }

    public Object load(String entityName, Serializable id) throws HibernateException {
        return this.session.load(entityName, id);
    }

    public Object load(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        return this.session.load(entityName, id, lockMode);
    }

    public void load(Object object, Serializable id) throws HibernateException {
        this.session.load(object, id);
    }

    public Object load(Class theClass, Serializable id) throws HibernateException {
        return this.session.load(theClass, id);
    }

    public Object load(Class theClass, Serializable id, LockMode lockMode) throws HibernateException {
        return this.session.load(theClass, id, lockMode);
    }

    public Object load(Class theClass, Serializable id, LockOptions lockOptions) throws HibernateException {
        return this.session.load(theClass, id, lockOptions);
    }

    public void lock(String entityName, Object object, LockMode lockMode) throws HibernateException {
        this.session.lock(entityName, object, lockMode);
    }

    public Object load(String entityName, Serializable id, LockOptions lockOptions) throws HibernateException {
        return this.session.load(entityName, id, lockOptions);
    }

    public void lock(Object object, LockMode lockMode) throws HibernateException {
        String entityName = this.getEntityNameForCFC(object);
        if (entityName != null) {
            this.session.lock(entityName, object, lockMode);
        } else {
            this.session.lock(object, lockMode);
        }
    }

    public Object merge(String entityName, Object object) throws HibernateException {
        return this.session.merge(entityName, object);
    }

    public Object merge(Object object) throws HibernateException {
        String entityName = this.getEntityNameForCFC(object);
        if (entityName != null) {
            return this.session.merge(entityName, object);
        }
        return this.session.merge(object);
    }

    public void persist(String entityName, Object object) throws HibernateException {
        this.attachTransactionToSession();
        this.session.persist(entityName, object);
    }

    public void persist(Object object) throws HibernateException {
        this.attachTransactionToSession();
        String entityName = this.getEntityNameForCFC(object);
        if (entityName != null) {
            this.session.persist(entityName, object);
        } else {
            this.session.persist(object);
        }
    }

    public void reconnect(Connection connection) throws HibernateException {
        this.session.reconnect(connection);
    }

    public void refresh(Object object) throws HibernateException {
        this.session.refresh(object);
    }

    public void refresh(Object object, LockMode lockMode) throws HibernateException {
        this.session.refresh(object, lockMode);
    }

    public void refresh(Object object, LockOptions lockOptions) throws HibernateException {
        this.session.refresh(object, lockOptions);
    }

    public void replicate(String entityName, Object object, ReplicationMode replicationMode) throws HibernateException {
        this.session.replicate(entityName, object, replicationMode);
    }

    public void replicate(Object object, ReplicationMode replicationMode) throws HibernateException {
        String entityName = this.getEntityNameForCFC(object);
        if (entityName != null) {
            this.session.replicate(entityName, object, replicationMode);
        } else {
            this.session.replicate(object, replicationMode);
        }
    }

    public Serializable save(String entityName, Object object) throws HibernateException {
        this.attachTransactionToSession();
        return this.session.save(entityName, object);
    }

    public Serializable save(Object object) throws HibernateException {
        this.attachTransactionToSession();
        String entityName = this.getEntityNameForCFC(object);
        if (entityName != null) {
            return this.session.save(entityName, object);
        }
        return this.session.save(object);
    }

    public void saveOrUpdate(String entityName, Object object) throws HibernateException {
        this.attachTransactionToSession();
        this.session.saveOrUpdate(entityName, object);
    }

    public void saveOrUpdate(Object object) throws HibernateException {
        this.attachTransactionToSession();
        String entityName = this.getEntityNameForCFC(object);
        if (entityName != null) {
            this.session.saveOrUpdate(entityName, object);
        } else {
            this.session.saveOrUpdate(object);
        }
    }

    public void setFlushMode(FlushMode flushMode) {
        this.setHibernateFlushMode(flushMode);
    }

    public void setReadOnly(Object entity, boolean readOnly) {
        this.session.setReadOnly(entity, readOnly);
    }

    public void update(String entityName, Object object) throws HibernateException {
        this.attachTransactionToSession();
        this.session.update(entityName, object);
    }

    public void update(Object object) throws HibernateException {
        this.attachTransactionToSession();
        String entityName = this.getEntityNameForCFC(object);
        if (entityName != null) {
            this.session.update(entityName, object);
        } else {
            this.session.update(object);
        }
    }

    public void doWork(Work work) throws HibernateException {
        this.session.doWork(work);
    }

    public boolean isDefaultReadOnly() {
        return this.session.isDefaultReadOnly();
    }

    public void setDefaultReadOnly(boolean readOnly) {
        this.session.setDefaultReadOnly(readOnly);
    }

    public Session.LockRequest buildLockRequest(LockOptions lockOptions) {
        return this.session.buildLockRequest(lockOptions);
    }

    public boolean isReadOnly(Object entityOrProxy) {
        return this.session.isReadOnly(entityOrProxy);
    }

    public boolean isFetchProfileEnabled(String name) throws UnknownProfileException {
        return this.session.isFetchProfileEnabled(name);
    }

    public void enableFetchProfile(String name) throws UnknownProfileException {
        this.session.enableFetchProfile(name);
    }

    public void disableFetchProfile(String name) throws UnknownProfileException {
        this.session.disableFetchProfile(name);
    }

    private String getEntityNameForCFC(Object obj) {
        String cfcName = null;
        if (obj instanceof TemplateProxy) {
            cfcName = ((TemplateProxy)obj).getName();
        }
        return cfcName != null ? this.config.getEntityName(cfcName) : null;
    }

    public void attachTransactionToSession() {
        TransactionTag txn = TransactionTag.getCurrent();
        if (txn == null) {
            return;
        }
        String txDataSource = txn.getDatasource();
        if (txDataSource == null) {
            try {
                txn.verifyDataSrc((Object)this.datasource, null, null);
            }
            catch (SQLException sQLException) {}
        } else if (!txDataSource.equalsIgnoreCase(this.datasource)) {
            throw new HibernatePersistenceManager.DistributedTransactionNotSupportedException();
        }
    }

    public String getTenantIdentifier() {
        return this.session.getTenantIdentifier();
    }

    public SharedSessionBuilder sessionWithOptions() {
        return this.session.sessionWithOptions();
    }

    public void refresh(String entityName, Object object) {
        this.session.refresh(entityName, object);
    }

    public void refresh(String entityName, Object object, LockOptions lockOptions) {
        this.session.refresh(entityName, object, lockOptions);
    }

    public IdentifierLoadAccess byId(String entityName) {
        return this.session.byId(entityName);
    }

    public IdentifierLoadAccess byId(Class entityClass) {
        return this.session.byId(entityClass);
    }

    public MultiIdentifierLoadAccess byMultipleIds(String entityName) {
        return this.session.byMultipleIds(entityName);
    }

    public MultiIdentifierLoadAccess byMultipleIds(Class entityClass) {
        return this.session.byMultipleIds(entityClass);
    }

    public NaturalIdLoadAccess byNaturalId(String entityName) {
        return this.session.byNaturalId(entityName);
    }

    public NaturalIdLoadAccess byNaturalId(Class entityClass) {
        return this.session.byNaturalId(entityClass);
    }

    public SimpleNaturalIdLoadAccess bySimpleNaturalId(String entityName) {
        return this.session.bySimpleNaturalId(entityName);
    }

    public SimpleNaturalIdLoadAccess bySimpleNaturalId(Class entityClass) {
        return this.session.bySimpleNaturalId(entityClass);
    }

    public <T> T doReturningWork(ReturningWork<T> work) throws HibernateException {
        return (T)this.session.doReturningWork(work);
    }

    public TypeHelper getTypeHelper() {
        return this.session.getTypeHelper();
    }

    public LobHelper getLobHelper() {
        return this.session.getLobHelper();
    }

    public Integer getJdbcBatchSize() {
        return this.session.getJdbcBatchSize();
    }

    public void setJdbcBatchSize(Integer jdbcBatchSize) {
        this.session.setJdbcBatchSize(jdbcBatchSize);
    }

    public void close() throws HibernateException {
        this.session.close();
    }

    public NativeQuery getNamedNativeQuery(String name) {
        return null;
    }

    public NativeQuery createNativeQuery(String sqlString, String resultSetMapping) {
        return this.session.createNativeQuery(sqlString, resultSetMapping);
    }

    public NativeQuery createNativeQuery(String sqlString, Class resultClass) {
        return null;
    }

    public Query createNamedQuery(String name) {
        return this.session.createNamedQuery(name);
    }

    public ProcedureCall createStoredProcedureCall(String procedureName) {
        return this.session.createStoredProcedureCall(procedureName);
    }

    public ProcedureCall createStoredProcedureCall(String procedureName, Class ... resultClasses) {
        return this.session.createStoredProcedureCall(procedureName, resultClasses);
    }

    public ProcedureCall createStoredProcedureCall(String procedureName, String ... resultSetMappings) {
        return this.session.createStoredProcedureCall(procedureName, resultSetMappings);
    }

    public ProcedureCall getNamedProcedureCall(String name) {
        return this.session.getNamedProcedureCall(name);
    }

    public void addEventListeners(SessionEventListener ... listeners) {
        this.session.addEventListeners(listeners);
    }

    public EntityGraph getEntityGraph(String graphName) {
        return this.session.getEntityGraph(graphName);
    }

    public List<EntityGraph> getEntityGraphs(Class entityClass) {
        return null;
    }

    public EntityGraph createEntityGraph(String graphName) {
        return this.session.createEntityGraph(graphName);
    }

    public EntityGraph createEntityGraph(Class rootType) {
        return this.session.createEntityGraph(rootType);
    }

    public Metamodel getMetamodel() {
        return null;
    }

    public boolean contains(Object object) {
        try {
            return this.session.contains(object);
        }
        catch (IllegalArgumentException illegalArgEx) {
            if (illegalArgEx.getMessage().equalsIgnoreCase("Not an entity [class coldfusion.orm.PersistentTemplateProxy]")) {
                return false;
            }
            throw illegalArgEx;
        }
    }

    public StoredProcedureQuery createNamedStoredProcedureQuery(String arg0) {
        return null;
    }

    public StoredProcedureQuery createStoredProcedureQuery(String arg0) {
        return null;
    }

    public StoredProcedureQuery createStoredProcedureQuery(String arg0, Class ... arg1) {
        return null;
    }

    public StoredProcedureQuery createStoredProcedureQuery(String arg0, String ... arg1) {
        return null;
    }

    public void detach(Object arg0) {
    }

    public <T> T find(Class<T> arg0, Object arg1) {
        return null;
    }

    public <T> T find(Class<T> arg0, Object arg1, Map<String, Object> arg2) {
        return null;
    }

    public <T> T find(Class<T> arg0, Object arg1, LockModeType arg2) {
        return null;
    }

    public <T> T find(Class<T> arg0, Object arg1, LockModeType arg2, Map<String, Object> arg3) {
        return null;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return null;
    }

    public Object getDelegate() {
        return null;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return null;
    }

    public LockModeType getLockMode(Object arg0) {
        return null;
    }

    public Map<String, Object> getProperties() {
        return null;
    }

    public <T> T getReference(Class<T> arg0, Object arg1) {
        return null;
    }

    public boolean isJoinedToTransaction() {
        return false;
    }

    public void joinTransaction() {
    }

    public void lock(Object arg0, LockModeType arg1) {
    }

    public void lock(Object arg0, LockModeType arg1, Map<String, Object> arg2) {
    }

    public void refresh(Object arg0, Map<String, Object> arg1) {
    }

    public void refresh(Object arg0, LockModeType arg1) {
    }

    public void refresh(Object arg0, LockModeType arg1, Map<String, Object> arg2) {
    }

    public void remove(Object arg0) {
    }

    public void setProperty(String arg0, Object arg1) {
    }

    public <T> T unwrap(Class<T> arg0) {
        return null;
    }

    public Session getSession() {
        return null;
    }
}

