/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.hibernate;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.orm.CFCMetadata;
import coldfusion.orm.ORMConfiguration;
import coldfusion.orm.ORMSettings;
import coldfusion.orm.ORMUtils;
import coldfusion.orm.hibernate.CFCMetadataImpl;
import coldfusion.orm.hibernate.CFConnectionProvider;
import coldfusion.orm.hibernate.HBMBuilder;
import coldfusion.orm.hibernate.HibernateEventHandler;
import coldfusion.orm.hibernate.MappingTransformer;
import coldfusion.orm.hibernate.MetadataExtractorIntegrator;
import coldfusion.orm.log.ORMLogWriter;
import coldfusion.orm.mapping.CFCPersistenceMetadata;
import coldfusion.orm.mapping.CFPropertyBinder;
import coldfusion.orm.mapping.CustomNamingStrategy;
import coldfusion.orm.mapping.DefaultNamingStrategy;
import coldfusion.orm.mapping.NamingStrategy;
import coldfusion.orm.mapping.SmartNamingStrategy;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.MetadataUtils;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.NeoPageContext;
import coldfusion.server.CFService;
import coldfusion.server.ORMSearchService;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.DBMetaData;
import coldfusion.sql.DataSrcImpl;
import coldfusion.util.CaseInsensitiveHashtable;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.RB;
import coldfusion.util.RuntimeWrapper;
import coldfusion.util.Utils;
import coldfusion.util.XmlUtils;
import coldfusion.vfs.VFSFileFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.EntityType;
import net.sf.ehcache.CacheManager;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.apache.xml.serialize.OutputFormat;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.JDBCException;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.internal.StandardDialectResolver;
import org.hibernate.engine.jdbc.dialect.spi.DatabaseMetaDataDialectResolutionInfoAdapter;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.util.xml.DTDEntityResolver;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.schema.TargetType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

public class HibernateConfiguration
implements ORMConfiguration {
    private static final Map<String, String> DIALECT_MAP = new CaseInsensitiveMap();
    private static final Map<String, String> CACHE_PROVIDERS = new CaseInsensitiveMap();
    private static String defFile = null;
    private Map<String, Configuration> datasourceVsConfigurationMap = new CaseInsensitiveMap();
    private Map<String, SessionFactory> datasourceVsSessionFactoryMap = new CaseInsensitiveMap();
    private Map<String, String> entityNameVsDatasource = new CaseInsensitiveMap();
    private Map<String, String> cfcNameVsEntityName = new CaseInsensitiveMap();
    private Map<String, String> entityNameVsCfcName = new CaseInsensitiveMap();
    private ORMSettings ormSettings;
    private String appLocation;
    private Map<String, CFCMetadataImpl> metaDataMap = new CaseInsensitiveHashtable();
    private Map<File, Long> annotatedCFCs;
    private Map<File, Long> hibernateMapFiles;
    private NamingStrategy namingStrategy;
    private String appName;
    private Map<Configuration, MetadataExtractorIntegrator> configurationMetadataExtractorIntegratorMap = new CaseInsensitiveMap();

    public HibernateConfiguration(ORMSettings ormSettings, String appLocation, String appName) {
        this.ormSettings = ormSettings;
        this.appLocation = appLocation;
        this.appName = appName;
        if (defFile == null) {
            try {
                defFile = CFService.getLibPath() + File.separator + "ehcache-default-config.xml";
            }
            catch (Exception ex) {
                CFLogs.APPLICATION_LOG.info((Object)"Could not get the ehcache-default-config.xml", (Throwable)ex);
            }
        }
        this.initHibernateConfiguration();
    }

    private void initHibernateConfiguration() {
        this.configurationMetadataExtractorIntegratorMap.clear();
        this.cfcNameVsEntityName.clear();
        this.entityNameVsCfcName.clear();
        String configFile = this.ormSettings.getConfigFile();
        this.validateDatasource();
        Document doc = this.createConfigDocument(configFile);
        this.namingStrategy = this.getNamingStrategy();
        boolean autogen = this.ormSettings.shouldGenerateMapping();
        String[] cfcLocation = this.ormSettings.getCFCLocation();
        if (cfcLocation == null || cfcLocation.length == 0) {
            cfcLocation = new String[]{this.appLocation};
        }
        this.buildConfiguration(doc, cfcLocation, autogen);
        this.validateAllDatasources();
    }

    private void validateAllDatasources() {
        for (String datasource : this.datasourceVsConfigurationMap.keySet()) {
            this.validateDatasource(datasource);
        }
    }

    private void validateDatasource(String datasource) {
        boolean dsOnServer = ServiceFactory.getDataSourceService().datasourceExists(datasource);
        if (!dsOnServer) {
            throw new DatasourceNotFoundException(datasource);
        }
    }

    private void validateDatasource() {
        String datasource = this.ormSettings.getDataSource();
        if (datasource == null) {
            throw new DatasourceUndefinedException();
        }
        this.validateDatasource(datasource);
    }

    private void addHibernateEventListeners(String datasource) {
        HibernateEventHandler listener = new HibernateEventHandler(this.ormSettings.getEventHandler());
        SessionFactory sessionFactory = this.datasourceVsSessionFactoryMap.get(datasource);
        EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)((SessionFactoryImpl)sessionFactory).getServiceRegistry().getService(EventListenerRegistry.class);
        eventListenerRegistry.getEventListenerGroup(EventType.POST_INSERT).appendListener((Object)listener);
        eventListenerRegistry.getEventListenerGroup(EventType.POST_UPDATE).appendListener((Object)listener);
        eventListenerRegistry.getEventListenerGroup(EventType.PRE_DELETE).appendListener((Object)listener);
        eventListenerRegistry.getEventListenerGroup(EventType.POST_DELETE).appendListener((Object)listener);
        eventListenerRegistry.getEventListenerGroup(EventType.PRE_LOAD).appendListener((Object)listener);
        eventListenerRegistry.getEventListenerGroup(EventType.POST_LOAD).appendListener((Object)listener);
    }

    private void addIndexEventListeners(String datasource) {
        SessionFactory sessionFactory = this.datasourceVsSessionFactoryMap.get(datasource);
        EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)((SessionFactoryImpl)sessionFactory).getServiceRegistry().getService(EventListenerRegistry.class);
        ORMSearchService ormSearchService = ServiceFactory.getOrmSearchService();
        if (ormSearchService != null) {
            ormSearchService.appendIndexEventListener((Object)eventListenerRegistry);
        }
    }

    private NamingStrategy getNamingStrategy() {
        String namingStrategy = this.ormSettings.getNamingStrategy();
        if (namingStrategy.equalsIgnoreCase("default")) {
            return DefaultNamingStrategy.INSTANCE;
        }
        if (namingStrategy.equalsIgnoreCase("smart")) {
            return SmartNamingStrategy.INSTANCE;
        }
        return new CustomNamingStrategy(namingStrategy);
    }

    private void addCacheConfiguration(Configuration configuration, String datasource) {
        String providerClass;
        String provider = this.ormSettings.getCacheProvider();
        if (provider == null) {
            provider = "EhCache";
        }
        if ((providerClass = CACHE_PROVIDERS.get(provider)) == null) {
            providerClass = provider;
        }
        configuration.setProperty("hibernate.cache.region.factory_class", providerClass);
        boolean ehCache = false;
        if ("EhCache".equalsIgnoreCase(provider)) {
            ehCache = true;
        } else if ("infinispan".equalsIgnoreCase(provider)) {
            configuration.setProperty("hibernate.transaction.jta.platform", "org.hibernate.service.jta.platform.internal.JBossStandAloneJtaPlatform");
        }
        String cacheConfig = this.ormSettings.getCacheConfigFile(datasource);
        if (cacheConfig == null) {
            if (ehCache) {
                this.createCacheConfigFile(configuration, datasource);
            }
        } else {
            File configFile = new File(cacheConfig);
            if (!configFile.isAbsolute()) {
                configFile = new File(this.appLocation, cacheConfig);
            }
            if (configFile.exists()) {
                configuration.setProperty("hibernate.cache.provider_configuration_file_resource_path", configFile.getAbsolutePath());
                if (ehCache) {
                    configuration.setProperty("net.sf.ehcache.configurationResourceName", configFile.toURI().toString());
                }
            } else if (ehCache) {
                this.createCacheConfigFile(configuration, datasource);
            }
        }
        configuration.setProperty("hibernate.cache.use_query_cache", "true");
    }

    private void createCacheConfigFile(Configuration configuration, String datasource) {
        Throwable throwable;
        File configFile = new File(this.appLocation, "ehcache-config_ORM_" + this.appName + "_" + datasource + ".xml");
        File defaultConfigFile = new File(defFile);
        String configXMLData = "";
        StringBuffer configXMLDataBuffer = new StringBuffer(550);
        try {
            throwable = null;
            try (BufferedReader configReader = new BufferedReader(new FileReader(defaultConfigFile));){
                String line;
                while ((line = configReader.readLine()) != null) {
                    configXMLDataBuffer.append(line);
                }
                configXMLData = configXMLDataBuffer.toString().replaceAll("<cache_manager_name>", "_ORM_" + this.appName + "_" + datasource);
                configFile.createNewFile();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException ex) {
            throw new MappingGenerationException(ex);
        }
        try {
            throwable = null;
            try (FileWriter configWriter = new FileWriter(configFile);){
                configWriter.write(configXMLData);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException ex) {
            throw new MappingGenerationException(ex);
        }
        configuration.setProperty("net.sf.ehcache.configurationResourceName", configFile.toURI().toString());
    }

    private String determineDialect(String datasource) {
        Dialect dialect;
        Connection connection = this.getDBConnection(datasource);
        try {
            dialect = new StandardDialectResolver().resolveDialect((DialectResolutionInfo)new DatabaseMetaDataDialectResolutionInfoAdapter(connection.getMetaData()));
        }
        catch (SQLException e) {
            throw new ConnectionException(e);
        }
        return dialect.getClass().getName();
    }

    private Connection getDBConnection(String datasource) {
        DataSrcImpl dimpl = DataSrcImpl.getSqlProxy();
        try {
            if (dimpl.getName() == null || !dimpl.getName().equals(datasource)) {
                dimpl.setDatasrc(datasource);
                dimpl.validate();
            }
            if (datasource.equalsIgnoreCase(this.ormSettings.getDataSource())) {
                String userName = this.ormSettings.getDatasourceUserName();
                String password = this.ormSettings.getDatasourcePassword();
                if (userName != null && password != null) {
                    return dimpl.getConnection(userName, password);
                }
            }
            return dimpl.getConnection();
        }
        catch (SQLException e) {
            throw new ConnectionException(e);
        }
    }

    public void exportSchema() {
        for (String datasource : this.datasourceVsConfigurationMap.keySet()) {
            this.exportSchema(datasource);
        }
    }

    private void exportSchema(String datasource) {
        Exception exc;
        String dialect;
        Configuration configuration = this.datasourceVsConfigurationMap.get(datasource);
        int dbCreateOption = this.ormSettings.getDBCreateOption(datasource);
        if (dbCreateOption == 0) {
            return;
        }
        List dropExceptions = null;
        List exceptions = null;
        if (configuration.getProperty("hibernate.dialect") == null && (dialect = this.determineDialect(datasource)) != null) {
            configuration.setProperty("hibernate.dialect", dialect);
        }
        Exception scriptException = null;
        MetadataExtractorIntegrator metadataExtractorIntegratorInstance = this.configurationMetadataExtractorIntegratorMap.get(configuration);
        Metadata metadata = metadataExtractorIntegratorInstance.getMetadata();
        if (dbCreateOption == 1 || dbCreateOption == 2) {
            SchemaExport export = new SchemaExport().setHaltOnError(false);
            if (dbCreateOption == 2) {
                export.execute(EnumSet.of(TargetType.DATABASE), SchemaExport.Action.DROP, metadata);
                dropExceptions = export.getExceptions();
            }
            export.setHaltOnError(true);
            export.execute(EnumSet.of(TargetType.DATABASE), SchemaExport.Action.CREATE, metadata);
            exceptions = export.getExceptions();
            try {
                this.exportSQLScript();
            }
            catch (Exception e) {
                scriptException = e;
            }
        } else if (dbCreateOption == 3) {
            SchemaUpdate updater = new SchemaUpdate().setHaltOnError(true);
            updater.execute(EnumSet.of(TargetType.DATABASE), metadata);
            exceptions = updater.getExceptions();
        }
        if (dropExceptions != null) {
            for (Object o : dropExceptions) {
                exc = (Exception)o;
                CFLogs.APPLICATION_LOG.error((Throwable)exc);
            }
        }
        if (exceptions != null) {
            for (Object o : exceptions) {
                exc = (Exception)o;
                CFLogs.APPLICATION_LOG.error((Throwable)exc);
                if (!(exc instanceof HibernateException) && !(exc instanceof SQLException)) continue;
                if (dropExceptions != null) {
                    exceptions.addAll(dropExceptions);
                }
                throw new SchemaExportException(exc, exceptions);
            }
        }
        if (scriptException != null) {
            if (scriptException instanceof ScriptImportException) {
                throw (ScriptImportException)((Object)scriptException);
            }
            throw new SchemaExportException(scriptException, exceptions);
        }
    }

    private void exportSQLScript() throws Exception {
        for (String datasource : this.datasourceVsConfigurationMap.keySet()) {
            this.exportSQLScript(datasource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportSQLScript(String datasource) throws Exception {
        String sqlScript = this.ormSettings.getSqlScriptFile(datasource);
        if (sqlScript != null) {
            File sqlScriptFile = new File(sqlScript);
            if (!sqlScriptFile.isAbsolute()) {
                sqlScriptFile = new File(this.appLocation, sqlScript);
            }
            if (!sqlScriptFile.exists()) {
                throw new SqlScriptFileNotFoundException(sqlScriptFile.getAbsolutePath());
            }
            Statement statement = null;
            BufferedReader reader = null;
            try {
                String sqlLine;
                Connection connection = this.getDBConnection(datasource);
                statement = connection.createStatement();
                reader = new BufferedReader(new FileReader(sqlScriptFile));
                StringBuilder sql = new StringBuilder();
                int lineNum = 0;
                while ((sqlLine = reader.readLine()) != null) {
                    sqlLine = sqlLine.trim();
                    ++lineNum;
                    if (sqlLine.length() == 0 || sqlLine.startsWith("--") || sqlLine.startsWith("//") || sqlLine.startsWith("/*")) continue;
                    if (sqlLine.endsWith(";")) {
                        sqlLine = sqlLine.substring(0, sqlLine.length() - 1);
                        sql.append(" ").append(sqlLine);
                        try {
                            statement.execute(sql.toString());
                        }
                        catch (SQLException e) {
                            throw new ScriptImportException(e, sqlScriptFile.getName(), lineNum, sql.toString());
                        }
                        sql.setLength(0);
                        continue;
                    }
                    sql.append(" ").append(sqlLine);
                }
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception exception) {}
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    public ORMSettings getORMSettings() {
        return this.ormSettings;
    }

    public void buildSessionFactory() {
        this.datasourceVsSessionFactoryMap.clear();
        this.configurationMetadataExtractorIntegratorMap.clear();
        for (String datasource : this.datasourceVsConfigurationMap.keySet()) {
            this.buildSessionFactory(datasource);
        }
    }

    private SessionFactory buildSessionFactory(String datasource) {
        ORMSearchService ormSearchService;
        HibernateEventHandler listener = new HibernateEventHandler(this.ormSettings.getEventHandler());
        Configuration configuration = this.datasourceVsConfigurationMap.get(datasource);
        if (configuration == null) {
            throw new ORMUtils.ORMNotConfiguredForDatasourceException(datasource);
        }
        if (this.ormSettings.isEventHandlingEnabled()) {
            configuration.setInterceptor((Interceptor)listener);
        }
        MetadataExtractorIntegrator metadataExtractorIntegratorInstance = new MetadataExtractorIntegrator();
        BootstrapServiceRegistry bootstrapServiceRegistry = new BootstrapServiceRegistryBuilder().enableAutoClose().applyIntegrator((Integrator)metadataExtractorIntegratorInstance).build();
        StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder(bootstrapServiceRegistry).applySettings((Map)configuration.getProperties()).applySetting("hibernate.allow_update_outside_transaction", (Object)true).build();
        SessionFactory sessionFactory = configuration.buildSessionFactory((ServiceRegistry)serviceRegistry);
        this.datasourceVsSessionFactoryMap.put(datasource, sessionFactory);
        this.configurationMetadataExtractorIntegratorMap.put(configuration, metadataExtractorIntegratorInstance);
        this.populateEntityNameDatasourceMap(configuration, datasource);
        if (this.ormSettings.isEventHandlingEnabled()) {
            this.addHibernateEventListeners(datasource);
        }
        if (this.ormSettings.isSearchEnabled() && (ormSearchService = ServiceFactory.getOrmSearchService()) != null) {
            ormSearchService.setSearchSettings(this.ormSettings.getSearchSetting());
            if (ormSearchService.isAutoIndex(this.ormSettings.getSearchSetting())) {
                this.addIndexEventListeners(datasource);
            }
        }
        return sessionFactory;
    }

    private Document createConfigDocument(String configFileStr) {
        if (configFileStr == null) {
            return null;
        }
        File configFile = new File(configFileStr);
        if (!configFile.isAbsolute()) {
            configFile = new File(this.appLocation, configFileStr);
        }
        if (!configFile.exists()) {
            throw new ConfigNotFoundException(configFileStr);
        }
        return this.createXmlDocument(configFile);
    }

    private void buildConfiguration(Document configDoc, String[] cfcLocations, boolean autogen) {
        CaseInsensitiveMap datasourceVsMapDocuments = new CaseInsensitiveMap();
        this.hibernateMapFiles = new HashMap<File, Long>();
        this.loadHBMFiles(configDoc, cfcLocations, (Map<String, List<Document>>)datasourceVsMapDocuments);
        if (autogen) {
            this.generateAndLoadHBMFilesFromCFCs(cfcLocations, (Map<String, List<Document>>)datasourceVsMapDocuments);
        }
        Set datasourceDocSet = datasourceVsMapDocuments.entrySet();
        for (Map.Entry datasourceDoc : datasourceDocSet) {
            Configuration hibernateConfig = new Configuration();
            if (configDoc != null && ((String)datasourceDoc.getKey()).equalsIgnoreCase(this.ormSettings.getDataSource())) {
                hibernateConfig.configure(configDoc);
            }
            for (Document mapDoc : (List)datasourceDoc.getValue()) {
                MappingTransformer transformer = new MappingTransformer(mapDoc, this.cfcNameVsEntityName);
                transformer.transform();
                hibernateConfig.addDocument(mapDoc);
            }
            this.setConfigurationProperties(hibernateConfig, (String)datasourceDoc.getKey());
            this.datasourceVsConfigurationMap.put((String)datasourceDoc.getKey(), hibernateConfig);
        }
    }

    private void populateEntityNameDatasourceMap(Configuration config, String datasource) {
        Set entitiesforDataSource = this.datasourceVsSessionFactoryMap.get(datasource).getMetamodel().getEntities();
        for (EntityType entityType : entitiesforDataSource) {
            this.entityNameVsDatasource.put(entityType.getName(), datasource);
        }
    }

    private void setConfigurationProperties(Configuration hibernateConfig, String datasource) {
        String defaultSchema;
        String defaultCatalog;
        hibernateConfig.setProperty("coldfusion.datasource", datasource);
        if (datasource.equalsIgnoreCase(this.ormSettings.getDataSource())) {
            String userName = this.ormSettings.getDatasourceUserName();
            String password = this.ormSettings.getDatasourcePassword();
            if (userName != null && password != null) {
                hibernateConfig.setProperty("coldfusion.datasource.user", userName);
                hibernateConfig.setProperty("coldfusion.datasource.password", password);
            }
        }
        hibernateConfig.setProperty("hibernate.connection.release_mode", "AFTER_TRANSACTION");
        hibernateConfig.setProperty("hibernate.connection.provider_class", CFConnectionProvider.class.getName());
        hibernateConfig.setProperty("hibernate.default_entity_mode", "dynamic-map");
        String dialectValue = this.ormSettings.getDialect(datasource);
        if (dialectValue != null) {
            String dialectProp = DIALECT_MAP.get(dialectValue);
            dialectValue = dialectProp != null ? dialectProp : dialectValue;
            hibernateConfig.setProperty("hibernate.dialect", dialectValue);
        }
        if ((defaultCatalog = this.ormSettings.getDefaultCatalog(datasource)) != null && defaultCatalog.trim().length() > 0) {
            hibernateConfig.setProperty("hibernate.default_catalog", defaultCatalog.trim());
        }
        if ((defaultSchema = this.ormSettings.getDefaultSchema(datasource)) != null && defaultSchema.trim().length() > 0) {
            hibernateConfig.setProperty("hibernate.default_schema", defaultSchema.trim());
        }
        hibernateConfig.addProperties(this.ormSettings.getCustomSettings("hibernate."));
        if (this.ormSettings.isSecondaryCacheEnabled()) {
            hibernateConfig.setProperty("hibernate.cache.use_second_level_cache", "true");
            this.addCacheConfiguration(hibernateConfig, datasource);
        } else {
            hibernateConfig.setProperty("hibernate.cache.use_second_level_cache", "false");
        }
        if (this.ormSettings.isSqlLogEnabled()) {
            hibernateConfig.setProperty("hibernate.show_sql", "true");
            hibernateConfig.setProperty("hibernate.format_sql", "true");
        }
    }

    private void generateAndLoadHBMFilesFromCFCs(String[] cfcLocations, Map<String, List<Document>> datasourceVsMapDocuments) {
        Map<String, List<Document>> cfcHbmDocumentMap = this.generateHbmDocFromCFCs(cfcLocations);
        Set<Map.Entry<String, List<Document>>> cfcHbmDocumentMapEntries = cfcHbmDocumentMap.entrySet();
        for (Map.Entry<String, List<Document>> cfcHbmDocumentMapEntry : cfcHbmDocumentMapEntries) {
            for (Document cfcHbmDoc : cfcHbmDocumentMapEntry.getValue()) {
                this.buildEntityNameCFCNameMap(cfcHbmDoc);
            }
            List<Document> hbmDocs = datasourceVsMapDocuments.get(cfcHbmDocumentMapEntry.getKey());
            if (hbmDocs != null) {
                hbmDocs.addAll((Collection<Document>)cfcHbmDocumentMapEntry.getValue());
                continue;
            }
            datasourceVsMapDocuments.put(cfcHbmDocumentMapEntry.getKey(), cfcHbmDocumentMapEntry.getValue());
        }
    }

    private void loadHBMFiles(Document doc, String[] cfcLocations, Map<String, List<Document>> datasourceVsMapDocuments) {
        NeoPageContext pageContext = FusionContext.getCurrent().pageContext;
        Set<File> mapFiles = this.getHbmFiles(doc, cfcLocations);
        for (File mapFile : mapFiles) {
            Document mappedFileDoc = this.createXmlDocument(mapFile);
            this.buildEntityNameCFCNameMap(mappedFileDoc);
            String cfcName = this.getCFCNameFromTheDoc(mappedFileDoc);
            String datasource = null;
            if (cfcName != null) {
                try {
                    AttributeCollection metadata = (AttributeCollection)MetadataUtils.getComponentMetadata((String)cfcName, (NeoPageContext)pageContext, null);
                    datasource = (String)metadata.get((Object)"datasource");
                }
                catch (Throwable th) {
                    throw new RuntimeWrapper(th);
                }
            }
            this.populateDatasourceVsMapFileDoc(datasource, mappedFileDoc, datasourceVsMapDocuments);
            this.hibernateMapFiles.put(mapFile, mapFile.lastModified());
        }
    }

    private void populateDatasourceVsMapFileDoc(String datasource, Document mappedFileDoc, Map<String, List<Document>> datasourceVsmapDocuments) {
        List<Document> documents;
        if (datasource == null) {
            datasource = this.ormSettings.getDataSource();
        }
        if ((documents = datasourceVsmapDocuments.get(datasource)) == null) {
            documents = new ArrayList<Document>();
        }
        documents.add(mappedFileDoc);
        datasourceVsmapDocuments.put(datasource, documents);
    }

    public SessionFactory getSessionFactory() {
        return this.getSessionFactory(this.ormSettings.getDataSource());
    }

    public SessionFactory getSessionFactory(String datasource) {
        SessionFactory sessionFactory;
        if ((!this.ormSettings.shouldAutoRebuild() || ServiceFactory.getRuntimeService().isTrustedCache()) && (sessionFactory = this.datasourceVsSessionFactoryMap.get(datasource)) != null) {
            return sessionFactory;
        }
        return this._getSessionFactory(datasource);
    }

    private synchronized SessionFactory _getSessionFactory(String datasource) {
        SessionFactory sessionFactory = this.datasourceVsSessionFactoryMap.get(datasource);
        if (sessionFactory == null) {
            if (this.datasourceVsConfigurationMap.size() == 0) {
                this.initHibernateConfiguration();
            }
            sessionFactory = this.buildSessionFactory(datasource);
        }
        return sessionFactory;
    }

    private boolean isMappingsReloadNeeded() {
        if (!this.ormSettings.shouldAutoRebuild()) {
            return false;
        }
        if (this.hibernateMapFiles != null) {
            Set<Map.Entry<File, Long>> fileEntries = this.hibernateMapFiles.entrySet();
            for (Map.Entry<File, Long> fileEntry : fileEntries) {
                if (fileEntry.getKey().lastModified() <= fileEntry.getValue()) continue;
                return true;
            }
        }
        if (this.annotatedCFCs != null) {
            Set<Map.Entry<File, Long>> annotatedCFCEntries = this.annotatedCFCs.entrySet();
            for (Map.Entry<File, Long> annotatedCFCEntry : annotatedCFCEntries) {
                if (annotatedCFCEntry.getKey().lastModified() <= annotatedCFCEntry.getValue()) continue;
                return true;
            }
        }
        return false;
    }

    public Map<String, String> getCFCEntityNameMap() {
        return this.cfcNameVsEntityName;
    }

    public Map<String, String> getEntityNameVsCFCName() {
        return this.entityNameVsCfcName;
    }

    public String getEntityName(String cfcName) {
        return this.cfcNameVsEntityName.get(cfcName);
    }

    public String getExactEntityName(String entityName) {
        String cfcName = this.entityNameVsCfcName.get(entityName);
        if (cfcName == null) {
            return null;
        }
        return this.cfcNameVsEntityName.get(cfcName);
    }

    @Override
    public String getCFCName(String entityName) {
        return this.entityNameVsCfcName.get(entityName);
    }

    public CFCMetadata getCFCMetadataForEntity(String entityName) {
        CFCMetadataImpl cfcMetadata = this.metaDataMap.get(entityName);
        if (cfcMetadata == null) {
            String datasource = this.entityNameVsDatasource.get(entityName);
            if (datasource == null) {
                return null;
            }
            SessionFactory sessionFactory = this.datasourceVsSessionFactoryMap.get(datasource);
            if (sessionFactory == null) {
                return null;
            }
            ClassMetadata classMetadata = sessionFactory.getClassMetadata(entityName);
            if (classMetadata == null) {
                return null;
            }
            Configuration configuration = this.datasourceVsConfigurationMap.get(datasource);
            MetadataExtractorIntegrator metadataExtractorIntegratorInstance = this.configurationMetadataExtractorIntegratorMap.get(configuration);
            Metadata metadata = metadataExtractorIntegratorInstance.getMetadata();
            PersistentClass persistentClass = metadata.getEntityBinding(entityName);
            cfcMetadata = new CFCMetadataImpl(classMetadata, persistentClass);
            this.metaDataMap.put(entityName, cfcMetadata);
        }
        return cfcMetadata;
    }

    @Override
    public CFCMetadata getCFCMetadata(String cfcName) {
        String entityName = this.cfcNameVsEntityName.get(cfcName);
        if (entityName == null) {
            return null;
        }
        return this.getCFCMetadataForEntity(entityName);
    }

    public String getDataSource() {
        return this.ormSettings.getDataSource();
    }

    public String getDataSource(String entityName) {
        return this.entityNameVsDatasource.get(entityName);
    }

    public PersistentClass getHibernatePersistenceClass(String entityName) {
        Configuration hibernateConf;
        if (entityName == null) {
            return null;
        }
        String dataSource = this.getDataSource(entityName);
        if (dataSource == null) {
            dataSource = this.getDataSource();
        }
        if ((hibernateConf = this.datasourceVsConfigurationMap.get(dataSource)) != null) {
            MetadataExtractorIntegrator metadataExtractorIntegratorInstance = this.configurationMetadataExtractorIntegratorMap.get(hibernateConf);
            Metadata metadata = metadataExtractorIntegratorInstance.getMetadata();
            return metadata.getEntityBinding(entityName);
        }
        return null;
    }

    private String getCFCNameFromTheDoc(Document mappedFileDoc) {
        String pakkage = mappedFileDoc.getDocumentElement().getAttribute("package");
        String cfcName = this.getCFCNameFromTheDoc(mappedFileDoc, "class", pakkage);
        if (cfcName == null) {
            cfcName = this.getCFCNameFromTheDoc(mappedFileDoc, "subclass", pakkage);
        }
        if (cfcName == null) {
            cfcName = this.getCFCNameFromTheDoc(mappedFileDoc, "joined-subclass", pakkage);
        }
        if (cfcName == null) {
            cfcName = this.getCFCNameFromTheDoc(mappedFileDoc, "union-subclass", pakkage);
        }
        return cfcName;
    }

    private String getCFCNameFromTheDoc(Document mappedFileDoc, String nodeName, String pakkage) {
        NodeList childNodes = mappedFileDoc.getElementsByTagName(nodeName);
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node classNode = childNodes.item(i);
            String className = ((Element)classNode).getAttribute("name");
            if (!className.startsWith("cfc.")) continue;
            String cfcName = className.substring(4);
            if (pakkage != null && pakkage.length() > 0 && cfcName.indexOf(46) < 0) {
                cfcName = pakkage + '.' + cfcName;
            }
            return cfcName;
        }
        return null;
    }

    private void buildEntityNameCFCNameMap(Document mappedFileDoc) {
        String pakkage = mappedFileDoc.getDocumentElement().getAttribute("package");
        this.buildEntityNameCFCNameMap(mappedFileDoc, "class", pakkage);
        this.buildEntityNameCFCNameMap(mappedFileDoc, "subclass", pakkage);
        this.buildEntityNameCFCNameMap(mappedFileDoc, "joined-subclass", pakkage);
        this.buildEntityNameCFCNameMap(mappedFileDoc, "union-subclass", pakkage);
    }

    private void buildEntityNameCFCNameMap(Document mappedFileDoc, String nodeName, String pakkage) {
        NodeList childNodes = mappedFileDoc.getElementsByTagName(nodeName);
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            this.buildEntityNameCFCNameMap(childNodes.item(i), pakkage);
        }
    }

    private void buildEntityNameCFCNameMap(Node classNode, String pakkage) {
        String className = ((Element)classNode).getAttribute("name");
        if (className.startsWith("cfc.")) {
            String entityName;
            String cfcName = className.substring(4);
            if (pakkage != null && pakkage.length() > 0 && cfcName.indexOf(46) < 0) {
                cfcName = pakkage + '.' + cfcName;
            }
            String string = entityName = (entityName = ((Element)classNode).getAttribute("entity-name")).length() == 0 ? this.getEntityNameForCfcName(cfcName) : entityName;
            if (this.entityNameVsCfcName.containsKey(entityName)) {
                throw new DuplicateEntityNameException(entityName, cfcName, this.entityNameVsCfcName.get(entityName));
            }
            this.entityNameVsCfcName.put(entityName, cfcName);
            this.cfcNameVsEntityName.put(cfcName, entityName);
        }
    }

    private String getEntityNameForCfcName(String cfcName) {
        int indexOfDot = cfcName.lastIndexOf(46);
        return indexOfDot != -1 ? cfcName.substring(indexOfDot + 1) : cfcName;
    }

    private Map<String, List<Document>> generateHbmDocFromCFCs(String[] cfcLocation) {
        Set<File> cfcFiles = this.loadFilesFromPaths(cfcLocation, new MyFileFilter(".cfc"));
        boolean appSaveMapping = this.ormSettings.shouldSaveMapping();
        CaseInsensitiveMap hbmDocs = new CaseInsensitiveMap();
        CaseInsensitiveMap dbMetaDataMap = null;
        try {
            if (this.ormSettings.shouldUseDBForMapping()) {
                dbMetaDataMap = new CaseInsensitiveMap();
                String dataSource = this.getDataSource();
                dbMetaDataMap.put(dataSource, new DBMetaData(dataSource, this.ormSettings.getDatasourceUserName(), this.ormSettings.getDatasourcePassword()));
            }
        }
        catch (SQLException dataSource) {
            // empty catch block
        }
        try {
            DBMetaData dbMetaData;
            String cfcDatasource;
            HashMap cfcMetaDataMap = new HashMap();
            HashMap<String, File> cfcFileMap = new HashMap<String, File>();
            this.annotatedCFCs = new HashMap<File, Long>();
            for (File cfcFile : cfcFiles) {
                CFCPersistenceMetadata cfcPersistenceMetadata;
                CFPropertyBinder cfc;
                if (cfcFile.getName().equalsIgnoreCase("application.cfc")) continue;
                try {
                    cfc = new CFPropertyBinder(cfcFile.getAbsolutePath(), (Map<String, DBMetaData>)dbMetaDataMap, this.ormSettings, this.namingStrategy);
                }
                catch (Exception e) {
                    RuntimeWrapper rte;
                    if (e instanceof RuntimeWrapper && (rte = (RuntimeWrapper)e).getRootCause() instanceof SQLException) {
                        throw rte.getRootCause();
                    }
                    if (this.ormSettings.shouldSkipCFCWithError()) {
                        CFLogs.APPLICATION_LOG.error((Object)("Skipping file " + cfcFile.getAbsolutePath() + " as it has errors"), (Throwable)e);
                        continue;
                    }
                    throw e;
                }
                if (this.cfcNameVsEntityName.containsKey(cfc.getCFCName()) || !cfc.isPersistent() || (cfcPersistenceMetadata = cfc.getCFCPersistenceMetadata()) == null) continue;
                cfcMetaDataMap.put(cfc.getCFCName(), cfcPersistenceMetadata);
                cfcFileMap.put(cfc.getCFCName(), cfcFile);
                this.annotatedCFCs.put(cfcFile, cfcFile.lastModified());
            }
            Set cfcMetadataEntries = cfcMetaDataMap.entrySet();
            for (Map.Entry cfcMetadataEntry : cfcMetadataEntries) {
                cfcDatasource = ((CFCPersistenceMetadata)cfcMetadataEntry.getValue()).getDatasource();
                dbMetaData = dbMetaDataMap == null ? null : (DBMetaData)dbMetaDataMap.get(cfcDatasource);
                ((CFCPersistenceMetadata)cfcMetadataEntry.getValue()).resolveRelationships(cfcMetaDataMap, dbMetaData);
                String parentCfcName = ((CFCPersistenceMetadata)cfcMetadataEntry.getValue()).getParentCfcName();
                if (parentCfcName == null) continue;
                ((CFCPersistenceMetadata)cfcMetadataEntry.getValue()).setParentCFCPmd((CFCPersistenceMetadata)cfcMetaDataMap.get(parentCfcName), dbMetaData);
            }
            for (Map.Entry cfcMetadataEntry : cfcMetadataEntries) {
                cfcDatasource = ((CFCPersistenceMetadata)cfcMetadataEntry.getValue()).getDatasource();
                dbMetaData = dbMetaDataMap == null ? null : (DBMetaData)dbMetaDataMap.get(cfcDatasource);
                HBMBuilder builder = new HBMBuilder((CFCPersistenceMetadata)cfcMetadataEntry.getValue(), dbMetaData);
                Document document = builder.build();
                this.populateDatasourceVsMapFileDoc(cfcDatasource, document, (Map<String, List<Document>>)hbmDocs);
                boolean saveMapping = appSaveMapping;
                if (((CFCPersistenceMetadata)cfcMetadataEntry.getValue()).getSaveMapping() != null) {
                    boolean bl = saveMapping = ((CFCPersistenceMetadata)cfcMetadataEntry.getValue()).getSaveMapping().equalsIgnoreCase("true") || ((CFCPersistenceMetadata)cfcMetadataEntry.getValue()).getSaveMapping().equalsIgnoreCase("yes");
                }
                if (!saveMapping) continue;
                this.saveDocument(document, (File)cfcFileMap.get(cfcMetadataEntry.getKey()));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable th) {
            throw new MappingGenerationException(th);
        }
        finally {
            if (dbMetaDataMap != null) {
                for (DBMetaData dbMetaData : dbMetaDataMap.values()) {
                    dbMetaData.close();
                }
            }
        }
        return hbmDocs;
    }

    public void buildSearchMetadata() {
        for (String datasource : this.datasourceVsConfigurationMap.keySet()) {
            this.getSessionFactory(datasource);
        }
        String[] cfcLocation = this.ormSettings.getCFCLocation();
        if (cfcLocation == null || cfcLocation.length == 0) {
            cfcLocation = new String[]{this.appLocation};
        }
        Set<File> cfcFiles = this.loadFilesFromPaths(cfcLocation, new MyFileFilter(".cfc"));
        for (File cfcFile : cfcFiles) {
            ORMSearchService ormSearchService;
            if (cfcFile.getName().equalsIgnoreCase("application.cfc") || (ormSearchService = ServiceFactory.getOrmSearchService()) == null) continue;
            ormSearchService.addCFCSearchMetadata(cfcFile.getAbsolutePath(), (Object)this.ormSettings, (Object)this);
        }
        ORMSearchService ormSearchService = ServiceFactory.getOrmSearchService();
        if (ormSearchService != null) {
            ormSearchService.buildIndexHierarchyGraph();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDocument(Document document, File cfcfile) {
        String cfcname = cfcfile.getName();
        cfcname = cfcname.substring(0, cfcname.indexOf(46));
        File hbmFile = VFSFileFactory.getFileObject((File)cfcfile.getParentFile(), (String)(cfcname + ".hbmxml"));
        OutputFormat of = XmlUtils.createDefaultFormat();
        of.setDoctype("-//Hibernate/Hibernate Mapping DTD 3.0//EN", "http://www.hibernate.org/dtd/hibernate-mapping-3.0.dtd");
        OutputStream fos = null;
        try {
            fos = VFSFileFactory.getOutputStream((File)hbmFile);
            XmlUtils.saveDocument((Document)document, (OutputFormat)of, (OutputStream)fos);
        }
        catch (IOException e) {
            CFLogs.APPLICATION_LOG.error((Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Set<File> getHbmFiles(Document doc, String[] cfcLocations) {
        Set<Object> mapFiles;
        Set<Object> set = mapFiles = doc == null ? new HashSet() : this.getHbmFilesFromConfig(doc);
        if (mapFiles.size() == 0) {
            mapFiles.addAll(this.loadFilesFromPaths(cfcLocations, new MyFileFilter(".hbmxml")));
        }
        return mapFiles;
    }

    private Set<File> loadFilesFromPaths(String[] cfcLocations, FileFilter filter) {
        if (cfcLocations.length == 1 && cfcLocations[0].equals(this.appLocation)) {
            return this.loadFilesFromApplication(this.appLocation, filter);
        }
        HashSet<File> files = new HashSet<File>();
        FusionContext context = FusionContext.getCurrent();
        for (int i = 0; i < cfcLocations.length; ++i) {
            File f;
            String path = cfcLocations[i];
            if (cfcLocations[i].charAt(0) == '/' && !(f = VFSFileFactory.getFileObject((String)(path = context.getRealPath(cfcLocations[i])))).exists()) {
                path = cfcLocations[i];
            }
            if (!(f = VFSFileFactory.getFileObject((String)path)).isAbsolute()) {
                f = new File(this.appLocation, cfcLocations[i]);
            }
            if (!f.exists()) {
                throw new CFCLocationNotFoundException(f.getAbsolutePath());
            }
            this.searchAndAddMapping(f, files, filter);
        }
        return files;
    }

    private Set<File> loadFilesFromApplication(String appLocation, FileFilter filter) {
        HashSet<File> files = new HashSet<File>();
        this.searchAndAddMapping(new File(appLocation), files, filter);
        Map appMappings = FusionContext.getCurrent().getApplicationCustomMappings();
        if (appMappings != null) {
            Collection collection = appMappings.values();
            for (String mapping : collection) {
                File mappedDir = VFSFileFactory.getFileObject((String)mapping);
                if (!mappedDir.isDirectory()) continue;
                this.searchAndAddMapping(mappedDir, files, filter);
            }
        }
        return files;
    }

    private void searchAndAddMapping(File directory, Set<File> list, FileFilter filter) {
        File[] files = directory.listFiles(filter);
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                this.searchAndAddMapping(f, list, filter);
                continue;
            }
            list.add(Utils.getCanonicalFile((File)f));
        }
    }

    private Set<File> getHbmFilesFromConfig(Document doc) {
        HashSet<File> mappingFileList = new HashSet<File>();
        Element rootElement = doc.getDocumentElement();
        Element sessionFactoryNode = (Element)rootElement.getElementsByTagName("session-factory").item(0);
        NodeList mappings = sessionFactoryNode.getElementsByTagName("mapping");
        int length = mappings.getLength();
        for (int i = length - 1; i >= 0; --i) {
            Element mappingNode = (Element)mappings.item(i);
            String mappingFileStr = mappingNode.getAttribute("file");
            if (mappingFileStr.length() == 0) continue;
            if (new File(mappingFileStr).isAbsolute()) {
                mappingFileList.add(new File(mappingFileStr));
            } else {
                File mappingFile = new File(this.appLocation, mappingFileStr);
                if (mappingFile.exists()) {
                    mappingFileList.add(mappingFile);
                } else {
                    File mappedFile;
                    String mappedPath;
                    Map appMappings = FusionContext.getCurrent().getApplicationCustomMappings();
                    if (appMappings != null && (mappedPath = this.getMappedPath(mappingFileStr, appMappings)) != null && (mappedFile = VFSFileFactory.getFileObject((String)mappedPath)).exists()) {
                        mappingFileList.add(mappedFile);
                    }
                }
            }
            mappingNode.getParentNode().removeChild(mappingNode);
        }
        return mappingFileList;
    }

    private String getMappedPath(String relPath, Map mappings) {
        String v = relPath;
        String real = (String)mappings.get(relPath);
        while (real == null) {
            int slash = v.lastIndexOf(47);
            if (slash == -1) {
                return null;
            }
            if (slash != 0) {
                v = v.substring(0, slash);
                real = (String)mappings.get(v);
            } else {
                real = (String)mappings.get("/");
                v = "";
            }
            if (real == null) continue;
            real = real + relPath.substring(slash);
        }
        real = Utils.getCanonicalPath((String)real);
        return real;
    }

    private Document createXmlDocument(File configFile) {
        DTDEntityResolver entityResolver = new DTDEntityResolver();
        try {
            return XmlUtils.getDocument((File)configFile, (EntityResolver)entityResolver, (boolean)true);
        }
        catch (Exception e) {
            throw new ConfigParseException(e);
        }
    }

    public void close() {
        SessionFactory sessionFactory = null;
        for (String datasource : this.datasourceVsSessionFactoryMap.keySet()) {
            sessionFactory = this.datasourceVsSessionFactoryMap.get(datasource);
            try {
                sessionFactory.close();
                CacheManager cacheManager = CacheManager.getCacheManager((String)("_ORM_" + this.appName + "_" + datasource));
                if (cacheManager == null) continue;
                cacheManager.shutdown();
            }
            catch (HibernateException hibernateException) {}
        }
        this.datasourceVsSessionFactoryMap.clear();
        this.datasourceVsConfigurationMap.clear();
        this.entityNameVsDatasource.clear();
        this.configurationMetadataExtractorIntegratorMap.clear();
    }

    static {
        DIALECT_MAP.put("DB2", "org.hibernate.dialect.DB2Dialect");
        DIALECT_MAP.put("DB2AS400", "org.hibernate.dialect.DB2400Dialect");
        DIALECT_MAP.put("DB2OS390", "org.hibernate.dialect.DB2390Dialect");
        DIALECT_MAP.put("PostgreSQL", "org.hibernate.dialect.PostgreSQLDialect");
        DIALECT_MAP.put("MySQL", "org.hibernate.dialect.MySQLDialect");
        DIALECT_MAP.put("MySQLwithInnoDB", "org.hibernate.dialect.MySQLInnoDBDialect");
        DIALECT_MAP.put("MySQLwithMyISAM", "org.hibernate.dialect.MySQLMyISAMDialect");
        DIALECT_MAP.put("Oracle8i", "org.hibernate.dialect.Oracle8iDialect");
        DIALECT_MAP.put("Oracle9i", "org.hibernate.dialect.Oracle9iDialect");
        DIALECT_MAP.put("Oracle10g", "org.hibernate.dialect.Oracle10gDialect");
        DIALECT_MAP.put("Oracle11g", "org.hibernate.dialect.Oracle10gDialect");
        DIALECT_MAP.put("Oracle12c", "org.hibernate.dialect.Oracle12cDialect");
        DIALECT_MAP.put("Oracle18c", "org.hibernate.dialect.Oracle12cDialect");
        DIALECT_MAP.put("Sybase", "org.hibernate.dialect.SybaseDialect");
        DIALECT_MAP.put("SybaseAnywhere", "org.hibernate.dialect.SybaseAnywhereDialect");
        DIALECT_MAP.put("MicrosoftSQLServer", "org.hibernate.dialect.SQLServerDialect");
        DIALECT_MAP.put("MicrosoftSQLServer2005", "org.hibernate.dialect.SQLServer2005Dialect");
        DIALECT_MAP.put("MicrosoftSQLServer2008", "org.hibernate.dialect.SQLServer2008Dialect");
        DIALECT_MAP.put("MicrosoftSQLServer2012", "org.hibernate.dialect.SQLServer2012Dialect");
        DIALECT_MAP.put("Informix", "org.hibernate.dialect.InformixDialect");
        DIALECT_MAP.put("Derby", "org.hibernate.dialect.DerbyDialect");
        CACHE_PROVIDERS.put("EhCache", "org.hibernate.cache.ehcache.EhCacheRegionFactory");
        CACHE_PROVIDERS.put("ConcurrentHashMap", "org.hibernate.testing.cache.CachingRegionFactory");
        CACHE_PROVIDERS.put("Infinispan", "org.hibernate.cache.infinispan.InfinispanRegionFactory");
        Logger hibernateLogger = Logger.getLogger((String)"org.hibernate.SQL");
        PatternLayout layout = new PatternLayout("%d [%t] Hibernate %-5p %c - %m%n");
        WriterAppender appender = new WriterAppender((Layout)layout, (Writer)new ORMLogWriter());
        hibernateLogger.addAppender((Appender)appender);
    }

    public static class InvalidCacheProviderException
    extends NeoException {
        public String cacheProvider;

        public InvalidCacheProviderException(String cacheProvider) {
            this.cacheProvider = cacheProvider;
        }
    }

    public static class ConnectionException
    extends NeoException {
        public ConnectionException(Throwable ex) {
            super(ex);
        }
    }

    public static class SqlScriptFileNotFoundException
    extends NeoException {
        public String sqlscriptFile;

        public SqlScriptFileNotFoundException(String sqlscriptFile) {
            this.sqlscriptFile = sqlscriptFile;
        }
    }

    public static class CFCLocationNotFoundException
    extends NeoException {
        public String path;

        public CFCLocationNotFoundException(String path) {
            this.path = path;
        }
    }

    public static class SchemaExportException
    extends ApplicationException {
        private List exceptions;

        public SchemaExportException(Throwable ex, List exceptions) {
            super(ex);
            this.exceptions = exceptions;
        }

        public String getDetail() {
            StringBuilder buff = new StringBuilder();
            if (this.rootCause instanceof HibernateException) {
                HibernateException hibernateException = (HibernateException)this.rootCause;
                Throwable cause = hibernateException.getCause();
                if (cause != null && cause instanceof SQLException) {
                    buff.append(cause.getMessage());
                }
                if (this.rootCause instanceof JDBCException && ((JDBCException)this.rootCause).getSQL() != null) {
                    buff.append(" SQL : ").append(((JDBCException)this.rootCause).getSQL());
                }
            } else {
                buff.append(this.rootCause.getMessage());
            }
            if (this.exceptions != null && this.exceptions.size() > 1) {
                buff.append(RB.getString((Object)((Object)this), (String)"otherErrors"));
                buff.append("<ul>");
                for (int i = 0; i < this.exceptions.size(); ++i) {
                    Throwable th = (Throwable)this.exceptions.get(i);
                    if (th == this.rootCause) continue;
                    buff.append("<li>").append(th.getMessage()).append("</li>");
                }
                buff.append("</ul>");
            }
            return buff.toString();
        }
    }

    public static class ScriptImportException
    extends ApplicationException {
        public String file;
        public int lineNo;
        public String sqlExMsg;
        public String sql;

        public ScriptImportException(SQLException sqlEx, String file, int lineNo, String sql) {
            super((Throwable)sqlEx);
            this.sql = sql;
            this.sqlExMsg = sqlEx.getMessage();
            this.file = file;
            this.lineNo = lineNo;
        }
    }

    public static class MappingGenerationException
    extends NeoException {
        public MappingGenerationException(Throwable ex) {
            super(ex);
        }
    }

    private static class MyFileFilter
    implements FileFilter {
        private String extension;

        MyFileFilter(String extension) {
            this.extension = extension;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().toLowerCase().endsWith(this.extension);
        }
    }

    public static class DuplicateEntityNameException
    extends NeoException {
        public String entityName;
        public String cfc1;
        public String cfc2;

        public DuplicateEntityNameException(String entityName, String cfc1, String cfc2) {
            this.entityName = entityName;
            this.cfc1 = cfc1;
            this.cfc2 = cfc2;
        }
    }

    public static class DatasourceNotFoundException
    extends NeoException {
        public String datasource;

        public DatasourceNotFoundException(String datasource) {
            this.datasource = datasource;
        }
    }

    public static class DatasourceUndefinedException
    extends NeoException {
    }

    public static class ConfigNotFoundException
    extends NeoException {
        public String file;

        public ConfigNotFoundException(String file) {
            this.file = file;
        }
    }

    public static class ConfigParseException
    extends NeoException {
        public ConfigParseException(Throwable e) {
            super(e);
        }
    }
}

