/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.hibernate;

import coldfusion.filter.FusionContext;
import coldfusion.orm.ConfigManager;
import coldfusion.orm.ORMConfiguration;
import coldfusion.orm.ORMProvider;
import coldfusion.orm.PersistenceManager;
import coldfusion.orm.hibernate.ConfigurationManager;
import coldfusion.orm.hibernate.HibernateConfiguration;
import coldfusion.orm.hibernate.HibernatePersistenceManager;
import coldfusion.runtime.ApplicationEventListener;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.Cast;
import coldfusion.runtime.EventListeners;
import coldfusion.runtime.RequestEventListener;
import coldfusion.server.ORMSearchService;
import coldfusion.server.ServiceFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;

public class HibernateProvider
extends ORMProvider
implements ApplicationEventListener,
RequestEventListener {
    private Map<ORMConfiguration, HibernatePersistenceManager> persistenceMgrMap = new HashMap<ORMConfiguration, HibernatePersistenceManager>();

    public HibernateProvider() {
        EventListeners.addApplicationEventListener((ApplicationEventListener)this);
        EventListeners.addRequestEventListener((RequestEventListener)this);
    }

    public void removeRequestEventListener() {
        EventListeners.removeRequestEventListener((RequestEventListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistenceManager getPersistenceManager(ORMConfiguration config) {
        HibernatePersistenceManager persistenceManager = this.persistenceMgrMap.get(config);
        if (persistenceManager == null) {
            HibernateProvider hibernateProvider = this;
            synchronized (hibernateProvider) {
                persistenceManager = this.persistenceMgrMap.get(config);
                if (persistenceManager == null) {
                    persistenceManager = new HibernatePersistenceManager((HibernateConfiguration)config);
                    this.persistenceMgrMap.put(config, persistenceManager);
                }
            }
        }
        return persistenceManager;
    }

    @Override
    public ConfigManager getConfigManager() {
        return ConfigurationManager.getInstance();
    }

    public void beforeApplicationStart(ApplicationScope app) {
        this.initializeORMForApplication(app);
    }

    public void onApplicationChange(ApplicationScope appScope) {
    }

    private boolean isORMEnabledForApplication(ApplicationScope appScope) {
        if (appScope != null) {
            Map appSetting = appScope.getApplicationSettingsMap();
            Object ormStr = appSetting.get("ormenabled");
            return ormStr != null && Cast._boolean(ormStr);
        }
        return false;
    }

    public void onApplicationStart(ApplicationScope app) {
    }

    public void beforeApplicationStop(ApplicationScope app) {
    }

    public void onApplicationStop(final ApplicationScope app) {
        if (System.getSecurityManager() == null) {
            this.closeORMForApplication(app);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    HibernateProvider.this.closeORMForApplication(app);
                    return null;
                }
            });
        }
    }

    public void onRequestStart() {
    }

    public void onPageRequestStart() {
        ApplicationScope appScope;
        String appName = FusionContext.getCurrent().getApplicationName();
        ConfigurationManager configMgr = ConfigurationManager.getInstance();
        if (configMgr.getConfiguration(appName) == null && this.isORMEnabledForApplication(appScope = ApplicationScopeTracker.getApplicationScope((String)appName))) {
            this.initializeORMForApplication(appScope);
        }
    }

    public void onPageRequestEnd(Throwable t) {
    }

    public void onRequestEnd() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeORMForApplication(ApplicationScope app) {
        ORMSearchService ormSearchService = ServiceFactory.getOrmSearchService();
        if (ormSearchService != null) {
            ormSearchService.removeSearchFactory(app);
        }
        ConfigurationManager configManager = ConfigurationManager.getInstance();
        ApplicationScope applicationScope = app;
        synchronized (applicationScope) {
            HibernateConfiguration config = configManager.removeConfiguration(app.getName());
            if (config == null) {
                return;
            }
            HibernatePersistenceManager persistenceManager = this.persistenceMgrMap.remove(config);
            if (persistenceManager != null) {
                persistenceManager.cleanup();
            }
            config.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeORMForApplication(ApplicationScope app) {
        if (this.isORMEnabledForApplication(app)) {
            FusionContext context = FusionContext.getCurrent();
            ConfigurationManager configMgr = ConfigurationManager.getInstance();
            ApplicationScope applicationScope = app;
            synchronized (applicationScope) {
                if (configMgr.getConfiguration(app.getName()) == null) {
                    configMgr.initConfiguration(app.getName(), context.getApplicationPath());
                    HibernateConfiguration config = configMgr.getConfiguration(app.getName());
                    if (config != null) {
                        try {
                            config.buildSessionFactory();
                            config.exportSchema();
                            configMgr.buildSearchMetadata(app.getName());
                        }
                        catch (RuntimeException e) {
                            config.close();
                            configMgr.removeConfiguration(app.getName());
                            ORMSearchService ormSearchService = ServiceFactory.getOrmSearchService();
                            if (ormSearchService != null) {
                                ormSearchService.removeSearchFactory(app);
                            }
                            throw e;
                        }
                    }
                }
            }
        }
    }

    @Override
    public synchronized void reloadORMForApplication(final String applicationName) {
        if (System.getSecurityManager() == null) {
            this._reloadORMForApp(applicationName);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    HibernateProvider.this._reloadORMForApp(applicationName);
                    return null;
                }
            });
        }
    }

    private void _reloadORMForApp(String applicationName) {
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope((String)applicationName);
        if (appScope == null) {
            return;
        }
        this.closeORMForApplication(appScope);
        this.initializeORMForApplication(appScope);
    }
}

