/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.vfs.s3;

import coldfusion.vfs.s3.S3FileName;
import coldfusion.vfs.s3.S3FileNameParser;
import coldfusion.vfs.s3.S3FileSystem;
import coldfusion.vfs.s3.S3FileSystemConfigBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.jets3t.service.S3Service;
import org.jets3t.service.ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;

public class S3FileProvider
extends AbstractOriginatingFileProvider {
    static final Collection capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.GET_LAST_MODIFIED, Capability.SET_LAST_MODIFIED_FILE, Capability.SET_LAST_MODIFIED_FOLDER, Capability.URI, Capability.WRITE_CONTENT, Capability.APPEND_CONTENT));

    public S3FileProvider() {
        this.setFileNameParser((FileNameParser)S3FileNameParser.getInstance());
    }

    protected FileSystem doCreateFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        S3FileName rootFileName = (S3FileName)rootName;
        try {
            AWSCredentials awsCredentials;
            RestS3Service service;
            S3Bucket bucket;
            String secretAccessKey;
            S3FileSystemConfigBuilder s3ConfigBuilder = S3FileSystemConfigBuilder.getInstance();
            String accessKeyId = rootFileName.getAccessKeyId();
            if (accessKeyId == null) {
                accessKeyId = s3ConfigBuilder.getAccessKeyID(fileSystemOptions);
            }
            if ((secretAccessKey = rootFileName.getSecretAccessKey()) == null) {
                secretAccessKey = s3ConfigBuilder.getSecretAccessKey(fileSystemOptions);
            }
            if ((bucket = (service = new RestS3Service((ProviderCredentials)(awsCredentials = new AWSCredentials(accessKeyId, secretAccessKey)))).getBucket(rootFileName.getBucket())) != null && !bucket.isLocationKnown()) {
                bucket.setLocation(service.getBucketLocation(rootFileName.getBucket()));
            }
            if (bucket == null && service.isBucketAccessible(rootFileName.getBucket())) {
                bucket = new S3Bucket(rootFileName.getBucket());
            }
            return new S3FileSystem((S3Service)service, rootFileName, bucket, fileSystemOptions);
        }
        catch (ServiceException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public Collection getCapabilities() {
        return capabilities;
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return S3FileSystemConfigBuilder.getInstance();
    }
}

