/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql.mongo;

import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.monitor.util.CloudMonitoringUtil;
import coldfusion.nosql.mongo.CFMongoClientSession;
import coldfusion.nosql.mongo.MongoUtils;
import coldfusion.nosql.mongo.bson.BsonUtils;
import coldfusion.nosql.mongo.bson.types.CFMongoObjectID;
import coldfusion.nosql.mongo.cursor.CFMongoGridFsFindIterator;
import coldfusion.nosql.mongo.cursor.CFMongoGridFsFindIteratorImpl;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.GenerateCFInvoke;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.InvokeNamedMethodInvocationMap;
import coldfusion.runtime.NamedInvokable;
import coldfusion.runtime.NamedMethodInvoker;
import coldfusion.util.CFDumpable;
import coldfusion.util.IOUtils;
import coldfusion.vfs.VFSFileFactory;
import com.mongodb.ReadConcern;
import com.mongodb.ReadConcernLevel;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.GridFSFindIterable;
import com.mongodb.client.gridfs.model.GridFSDownloadOptions;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import org.bson.BsonDocument;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

@GenerateCFInvoke
@GenerateCFNamedInvoke
public class CFMongoGridFSBucket
implements CFDumpable,
NamedInvokable {
    private GridFSBucket bucket;
    private CFMongoClientSession csDelegate;
    private TagAttributeList tagAttributeList = new TagAttributeList("service", (Object)"MONGO_DB").addTagAttribute("gridfs", (Object)"y");
    private static InvokeNamedMethodInvocationMap<CFMongoGridFSBucket> __InvokeNamedMethodInvocationMap = new InvokeNamedMethodInvocationMap();

    public CFMongoGridFSBucket(GridFSBucket bucket) {
        this.bucket = bucket;
        this.tagAttributeList.addTagAttribute("bucket", (Object)bucket.getBucketName());
    }

    public CFMongoGridFSBucket(GridFSBucket bucket, CFMongoClientSession cs) {
        this.bucket = bucket;
        this.csDelegate = cs;
        this.tagAttributeList.addTagAttribute("bucket", (Object)bucket.getBucketName());
    }

    public String getName() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getName", (boolean)true);
        String res = this.bucket.getBucketName();
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getName", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoObjectID upload(Object stream) throws FileNotFoundException {
        RequestMonitorEventProcessor.onFunctionStart((String)"upload", (boolean)true);
        CFMongoObjectID res = this.upload(stream, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"upload", (String)"write", null, (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoObjectID upload(Object stream, Map configMap) throws FileNotFoundException {
        RequestMonitorEventProcessor.onFunctionStart((String)"upload", (boolean)true);
        InputStream iStream = null;
        String fileName = null;
        BsonObjectId id = null;
        if (stream instanceof String) {
            stream = VFSFileFactory.getFileObject((String)((String)stream));
        }
        if (stream instanceof File) {
            fileName = ((File)stream).getName();
            iStream = VFSFileFactory.getInputStream((File)((File)stream));
        }
        GridFSUploadOptions gridFSUploadOptions = MongoUtils.getGridFSUploadOptions(configMap);
        if (configMap != null && configMap.containsKey("filename")) {
            fileName = (String)configMap.get("filename");
        }
        if (configMap != null && configMap.containsKey("id")) {
            id = new BsonObjectId(MongoUtils.getObjectId(configMap.get("id")));
        }
        ObjectId returnId = null;
        if (this.csDelegate != null) {
            if (gridFSUploadOptions == null) {
                if (id == null) {
                    returnId = this.bucket.uploadFromStream(this.csDelegate.getClientSession(), fileName, iStream);
                } else {
                    this.bucket.uploadFromStream(this.csDelegate.getClientSession(), (BsonValue)id, fileName, iStream);
                }
            } else if (id == null) {
                returnId = this.bucket.uploadFromStream(this.csDelegate.getClientSession(), fileName, iStream, gridFSUploadOptions);
            } else {
                this.bucket.uploadFromStream(this.csDelegate.getClientSession(), (BsonValue)id, fileName, iStream, gridFSUploadOptions);
            }
        } else if (gridFSUploadOptions == null) {
            if (id == null) {
                returnId = this.bucket.uploadFromStream(fileName, iStream);
            } else {
                this.bucket.uploadFromStream((BsonValue)id, fileName, iStream);
            }
        } else if (id == null) {
            returnId = this.bucket.uploadFromStream(fileName, iStream, gridFSUploadOptions);
        } else {
            this.bucket.uploadFromStream((BsonValue)id, fileName, iStream, gridFSUploadOptions);
        }
        CFMongoObjectID res = new CFMongoObjectID(returnId);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"upload", (String)"write", null, (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map download(Object destination, Object fileNameorId) throws IOException {
        RequestMonitorEventProcessor.onFunctionStart((String)"download", (boolean)true);
        Map res = this.download(destination, fileNameorId, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"download", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map download(Object destination, Object fileNameorId, Map configMap) throws IOException {
        RequestMonitorEventProcessor.onFunctionStart((String)"download", (boolean)true);
        String fileName = null;
        BsonObjectId id = null;
        if (fileNameorId instanceof String) {
            fileName = (String)fileNameorId;
        } else {
            id = new BsonObjectId(MongoUtils.getObjectId(fileNameorId));
        }
        GridFSDownloadOptions gridFSDownloadOptions = MongoUtils.getGridFSDownloadOptions(configMap);
        GridFSDownloadStream downloadStream = null;
        downloadStream = this.csDelegate != null ? (gridFSDownloadOptions == null ? (id == null ? this.bucket.openDownloadStream(this.csDelegate.getClientSession(), fileName) : this.bucket.openDownloadStream(this.csDelegate.getClientSession(), (BsonValue)id)) : (id == null ? this.bucket.openDownloadStream(this.csDelegate.getClientSession(), fileName, gridFSDownloadOptions) : this.bucket.openDownloadStream(this.csDelegate.getClientSession(), (BsonValue)id))) : (gridFSDownloadOptions == null ? (id == null ? this.bucket.openDownloadStream(fileName) : this.bucket.openDownloadStream((BsonValue)id)) : (id == null ? this.bucket.openDownloadStream(fileName, gridFSDownloadOptions) : this.bucket.openDownloadStream((BsonValue)id)));
        GridFSFile gridFSFile = downloadStream.getGridFSFile();
        OutputStream oStream = null;
        if (destination instanceof String) {
            destination = VFSFileFactory.getFileObject((String)((String)destination));
        }
        if (destination instanceof File) {
            if (((File)destination).isDirectory()) {
                destination = VFSFileFactory.getFileObject((File)((File)destination), (String)gridFSFile.getFilename());
            }
            oStream = VFSFileFactory.getOutputStream((File)((File)destination));
        }
        IOUtils.write((InputStream)downloadStream, oStream);
        Map res = MongoUtils.to(gridFSFile);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"download", (String)"read", null, (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoGridFsFindIterator find() {
        RequestMonitorEventProcessor.onFunctionStart((String)"find", (boolean)true);
        GridFSFindIterable findIterator = this.csDelegate != null ? this.bucket.find(this.csDelegate.getClientSession()) : this.bucket.find();
        CFMongoGridFsFindIteratorImpl res = new CFMongoGridFsFindIteratorImpl(findIterator);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"find", (String)"read", null, (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoGridFsFindIterator find(Map<?, ?> query) {
        RequestMonitorEventProcessor.onFunctionStart((String)"find", (boolean)true);
        BsonDocument filter = BsonUtils.to(query);
        GridFSFindIterable findIterator = this.csDelegate != null ? this.bucket.find(this.csDelegate.getClientSession(), (Bson)filter) : this.bucket.find((Bson)filter);
        CFMongoGridFsFindIteratorImpl res = new CFMongoGridFsFindIteratorImpl(findIterator);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"find", (String)"read", null, (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoGridFSBucket rename(Object objectId, String newFileName) {
        RequestMonitorEventProcessor.onFunctionStart((String)"rename", (boolean)true);
        ObjectId id = MongoUtils.getObjectId(objectId);
        if (this.csDelegate != null) {
            this.bucket.rename(this.csDelegate.getClientSession(), id, newFileName);
        } else {
            this.bucket.rename(id, newFileName);
        }
        CloudMonitoringUtil.onCloudFunctionEnd((String)"rename", (String)"write", null, (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public CFMongoGridFSBucket delete(Object objectId) {
        RequestMonitorEventProcessor.onFunctionStart((String)"delete", (boolean)true);
        ObjectId id = MongoUtils.getObjectId(objectId);
        if (this.csDelegate != null) {
            this.bucket.delete(this.csDelegate.getClientSession(), id);
        } else {
            this.bucket.delete(id);
        }
        CloudMonitoringUtil.onCloudFunctionEnd((String)"delete", (String)"delete", null, (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public CFMongoGridFSBucket drop() {
        RequestMonitorEventProcessor.onFunctionStart((String)"drop", (boolean)true);
        if (this.csDelegate != null) {
            this.bucket.drop(this.csDelegate.getClientSession());
        } else {
            this.bucket.drop();
        }
        CloudMonitoringUtil.onCloudFunctionEnd((String)"drop", (String)"delete", null, (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public CFMongoGridFSBucket withReadConcern(String readConcern) {
        RequestMonitorEventProcessor.onFunctionStart((String)"withReadConcern", (boolean)true);
        this.bucket = this.bucket.withReadConcern(new ReadConcern(ReadConcernLevel.fromString((String)readConcern)));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"withReadConcern", (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public CFMongoGridFSBucket withWriteConcern(Map wConcernMap) {
        RequestMonitorEventProcessor.onFunctionStart((String)"withWriteConcern", (boolean)true);
        WriteConcern wConcern = MongoUtils.getWriteConcern(wConcernMap, this.bucket.getWriteConcern());
        this.bucket = this.bucket.withWriteConcern(wConcern);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"withWriteConcern", (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public CFMongoGridFSBucket withReadPreference(Map prefMap) {
        RequestMonitorEventProcessor.onFunctionStart((String)"withReadPreference", (boolean)true);
        ReadPreference readPreference = MongoUtils.getReadPreference(prefMap, this.bucket.getReadPreference());
        this.bucket = this.bucket.withReadPreference(readPreference);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"withReadPreference", (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public Map getWriteConcern() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getWriteConcern", (boolean)true);
        Map res = MongoUtils.toMap(this.bucket.getWriteConcern());
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getWriteConcern", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public String getReadConcern() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getReadConcern", (boolean)true);
        String res = this.bucket.getReadConcern().toString();
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getReadConcern", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map getReadPreference() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getReadPreference", (boolean)true);
        Map res = MongoUtils.toMap(this.bucket.getReadPreference());
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getReadPreference", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoGridFSBucket withSession(CFMongoClientSession session) {
        RequestMonitorEventProcessor.onFunctionStart((String)"withSession", (boolean)true);
        this.csDelegate = session;
        CloudMonitoringUtil.onCloudFunctionEnd((String)"withSession", (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public CFMongoGridFSBucket clearSession() {
        RequestMonitorEventProcessor.onFunctionStart((String)"clearSession", (boolean)true);
        this.csDelegate = null;
        CloudMonitoringUtil.onCloudFunctionEnd((String)"clearSession", (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public CFMongoClientSession getSession() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getSession", (boolean)true);
        CFMongoClientSession res = this.csDelegate;
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getSession", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public boolean isMD5Disabled() {
        RequestMonitorEventProcessor.onFunctionStart((String)"isMD5Disabled", (boolean)true);
        boolean res = this.bucket.getDisableMD5();
        CloudMonitoringUtil.onCloudFunctionEnd((String)"isMD5Disabled", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoGridFSBucket disableMD5(boolean disable) {
        RequestMonitorEventProcessor.onFunctionStart((String)"disableMD5", (boolean)true);
        this.bucket = this.bucket.withDisableMD5(disable);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"disableMD5", (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public int getChunkSizeInBytes() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getChunkSizeInBytes", (boolean)true);
        int res = this.bucket.getChunkSizeBytes();
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getChunkSizeInBytes", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoGridFSBucket withChunkSizeInBytes(int chunkSize) {
        RequestMonitorEventProcessor.onFunctionStart((String)"withChunkSizeInBytes", (boolean)true);
        this.bucket = this.bucket.withChunkSizeBytes(chunkSize);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"withChunkSizeInBytes", (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public Object getMetadata() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getMetadata", (boolean)true);
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("name", this.getName());
        ReadConcern readConcern = this.bucket.getReadConcern();
        String readConcernLevel = "DEFAULT";
        if (readConcern != null && readConcern.getLevel() != null) {
            readConcernLevel = readConcern.getLevel().toString();
        }
        metadata.put("readConcern", readConcernLevel);
        metadata.put("writeConcern", MongoUtils.toMap(this.bucket.getWriteConcern()));
        metadata.put("readPreference", MongoUtils.toMap(this.bucket.getReadPreference()));
        if (this.csDelegate != null) {
            metadata.put("session", this.csDelegate.getMetadata());
        }
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getMetadata", (TagAttributeList)this.tagAttributeList);
        return metadata;
    }

    public String getLabel() {
        return "MongoDB GridFS Bucket";
    }

    public Object invoke(String methodName, Map args, PageContext pageContext) throws Throwable {
        NamedMethodInvoker NamedMethodInvoker2 = __InvokeNamedMethodInvocationMap.get((Object)methodName);
        if (NamedMethodInvoker2 == null) {
            throw new CfJspPage.UnsupportedBaseTypeException(methodName, (Object)this);
        }
        return NamedMethodInvoker2.invoke((Object)this, args);
    }

    static {
        __InvokeNamedMethodInvocationMap.put((Object)"getName", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getName();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getName", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"upload", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"stream"}, args);
                    return obj.upload(argColl.get((Object)"stream"));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"stream", "configMap"}, args);
                    return obj.upload(argColl.get((Object)"stream"), Cast._Map((Object)argColl.get((Object)"configMap")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("upload", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"download", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"destination", "fileNameorId"}, args);
                    return obj.download(argColl.get((Object)"destination"), argColl.get((Object)"fileNameorId"));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"destination", "fileNameorId", "configMap"}, args);
                    return obj.download(argColl.get((Object)"destination"), argColl.get((Object)"fileNameorId"), Cast._Map((Object)argColl.get((Object)"configMap")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("download", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"find", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.find();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"query"}, args);
                    return obj.find(Cast._Map((Object)argColl.get((Object)"query")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("find", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"rename", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"objectId", "newFileName"}, args);
                    return obj.rename(argColl.get((Object)"objectId"), Cast._String((Object)argColl.get((Object)"newFileName")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("rename", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"delete", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"objectId"}, args);
                    return obj.delete(argColl.get((Object)"objectId"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("delete", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"drop", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.drop();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("drop", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"withReadConcern", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"readConcern"}, args);
                    return obj.withReadConcern(Cast._String((Object)argColl.get((Object)"readConcern")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("withReadConcern", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"withWriteConcern", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"wConcernMap"}, args);
                    return obj.withWriteConcern(Cast._Map((Object)argColl.get((Object)"wConcernMap")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("withWriteConcern", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"withReadPreference", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"prefMap"}, args);
                    return obj.withReadPreference(Cast._Map((Object)argColl.get((Object)"prefMap")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("withReadPreference", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getWriteConcern", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getWriteConcern();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getWriteConcern", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getReadConcern", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getReadConcern();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getReadConcern", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getReadPreference", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getReadPreference();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getReadPreference", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"withSession", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"session"}, args);
                    return obj.withSession((CFMongoClientSession)((Object)((Object)Cast._castForInvokeGen((Object)argColl.get((Object)"session"), CFMongoClientSession.class))));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("withSession", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"clearSession", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.clearSession();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("clearSession", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getSession", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getSession();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getSession", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"isMD5Disabled", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.isMD5Disabled();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("isMD5Disabled", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"disableMD5", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"disable"}, args);
                    return obj.disableMD5(Cast._boolean((Object)argColl.get((Object)"disable")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("disableMD5", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getChunkSizeInBytes", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getChunkSizeInBytes();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getChunkSizeInBytes", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"withChunkSizeInBytes", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"chunkSize"}, args);
                    return obj.withChunkSizeInBytes(Cast._int((Object)argColl.get((Object)"chunkSize"), (boolean)false));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("withChunkSizeInBytes", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getMetadata", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getMetadata();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getMetadata", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getLabel", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getLabel();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getLabel", obj);
        });
    }
}

