/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.pdf;

import coldfusion.server.ServiceFactory;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenAction;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGState;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceICCBased;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFICCProfile;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCProperties;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternTiling;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectPostScript;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmark;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFOutputIntent;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetAnnotation;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetBookmark;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetCatalog;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetColorSpace;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetContent;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetExtGState;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetField;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetFileStructure;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetFont;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetMetadata;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetOutputIntent;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetPage;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetPattern;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetXObject;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAInvalidNamespaceUsage;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFASaveTypes;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAXMPSchema;
import com.adobe.internal.pdftoolkit.xml.XMLElement;
import com.adobe.internal.xmp.options.PropertyOptions;
import java.awt.color.ICC_Profile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PDFABasicConversionHandler
implements PDFAConversionHandler {
    boolean errorsFound;
    public PDFASaveTypes saveTypes;
    private PDFField field;
    private boolean fieldDisplayed;
    private PDFPage page;
    private boolean pageDisplayed;
    private int pageIndex;
    private PDFAnnotation annot;
    private boolean annotDisplayed;
    private ArrayList resourceChain = new ArrayList();
    private int lastResourceDisplayed = -1;
    private StringBuilder archiveSummary = new StringBuilder();
    private ArrayList<String> aissues = new ArrayList();
    private final int ARCHIVEERRORSCONST = 1;
    private final int ARCHIVEMODANDISSUESCONST = 2;
    private final int ARCHIVESUMMARYCONST = 3;
    private final String kUnfixableIssueLabel = "UNFIXABLE ISSUE(S): ";
    private final String kFixAppliedLabel = "FIX APPLIED: ";
    private final String CATALOGERROR = "CATALOG ERROR";
    private final String DOCMETADATAERROR = "DOC METADATA ERROR";
    private final String FILESTRUCTURERROR = "FILE STRUCTURE ERROR";
    private final String BOOKMARKERROR = "BOOKMARK ERROR";
    private final String OUTPUTINTENTERROR = "OUTPUT INTENT ERROR";
    private final String ANNOTATIONERROR = "ANNOTATION ERROR";
    private final String COLORSPACEERROR = "COLOR SPACE ERROR";
    private final String CONTENTERROR = "CONTENT ERROR";
    private final String EXTJSSTATEERROR = "EXTJS STATE ERROR";
    private final String FONTERROR = "FONT ERROR";
    private final String FORMFIELDERROR = "FORM FIELD ERROR";
    private final String PAGEERROR = "PAGE ERROR";
    private final String PATTERNERROR = "PATTERN ERROR";
    private final String XOBJECTERROR = "XOBJECT ERROR";
    private Map<String, ArrayList<String>> globalErrorMap = new HashMap<String, ArrayList<String>>();

    private void reportResourceError(PDFAErrorSet errorSet, String source) {
        if (errorSet == null || !errorSet.hasErrors()) {
            return;
        }
        this.errorsFound = true;
        this.reportResourceIssue("UNFIXABLE ISSUE(S): " + errorSet.toString(), source);
    }

    private void reportResourceModification(String modification) {
        this.reportResourceIssue("FIX APPLIED: " + modification, "");
    }

    private void reportResourceIssue(String issue, String source) {
        StringBuilder res = new StringBuilder();
        try {
            int indentLevel = 0;
            if (this.field != null && !this.fieldDisplayed) {
                res.append("FIELD: " + this.field.getQualifiedName() + "\n");
                this.fieldDisplayed = true;
            }
            if (this.page != null && !this.pageDisplayed) {
                res.append("PAGE: " + this.pageIndex + "\n");
                this.pageDisplayed = true;
            }
            if (this.annot != null) {
                ++indentLevel;
                if (!this.annotDisplayed) {
                    String subtype = this.annot.getSubtype().asString();
                    String id = this.annot.getID();
                    if (id == null) {
                        if (this.annot instanceof PDFAnnotationWidget) {
                            PDFAnnotationWidget widget = (PDFAnnotationWidget)this.annot;
                            if (widget.isField()) {
                                id = widget.getField().getQualifiedName();
                                res.append("FIELD/ANNOT (" + subtype + "): " + (id != null ? id : "") + "\n");
                            } else {
                                res.append("ANNOT (" + subtype + "): \n");
                            }
                        } else {
                            res.append("ANNOT (" + subtype + "): \n");
                        }
                    } else {
                        res.append("ANNOT (" + subtype + "): " + (id != null ? id : "") + "\n");
                    }
                    this.annotDisplayed = true;
                }
            }
            if (this.resourceChain != null) {
                for (ResourceInfo info : this.resourceChain) {
                    String label;
                    Object subtype;
                    if (++indentLevel <= this.lastResourceDisplayed) continue;
                    ASName name = info.resourceName;
                    PDFObject resource = info.resource;
                    if (resource instanceof PDFColorSpace) {
                        subtype = ((PDFColorSpace)resource).getName();
                        label = "COLOR SPACE (" + subtype + "): ";
                    } else if (resource instanceof PDFFont) {
                        subtype = ((PDFFont)resource).getSubtype();
                        label = "FONT (" + subtype + "): ";
                    } else if (resource instanceof PDFXObject) {
                        subtype = ((PDFXObject)resource).getSubtype();
                        label = "XOBJECT (" + subtype + "): ";
                    } else if (resource instanceof PDFPatternTiling) {
                        subtype = String.valueOf(((PDFPatternTiling)resource).getPatternType());
                        label = "PATTERN (Type " + (String)subtype + "): ";
                    } else {
                        throw new RuntimeException("Test code is missing support for a resource type.");
                    }
                    res.append(label + (name != null ? name.asString() : "") + "\n");
                    ++this.lastResourceDisplayed;
                }
            }
            res.append(issue + "\n");
            this.report(0, res.toString(), 0, source);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void report(PDFOutputIntent intent, PDFAErrorSet errors) {
        try {
            this.reportError(0, "OUTPUT INTENT: " + intent.getSubType().asString(), "OUTPUT INTENT ERROR");
        }
        catch (PDFException e) {
            throw new RuntimeException("Could not get output intent subtype", e);
        }
        this.reportError(1, errors.toString(), "OUTPUT INTENT ERROR");
    }

    private void report(PDFBookmark bookmark, PDFAErrorSet errors) {
        try {
            this.reportError(0, "BOOKMARK: " + bookmark.getTitle(), "BOOKMARK ERROR");
        }
        catch (PDFException e) {
            throw new RuntimeException("Could not get output intent subtype", e);
        }
        this.reportError(1, errors.toString(), "BOOKMARK ERROR");
    }

    private void reportError(int indentLevel, String string, String source) {
        this.errorsFound = true;
        this.report(indentLevel, "UNFIXABLE ISSUE(S): " + string, 1, source);
    }

    private void reportModification(String modification) {
        this.report(0, "FIX APPLIED: " + modification, 2, "");
    }

    private void report(int indentLevel, String string, int errortype, String source) {
        String indent = "";
        for (int i = 0; i < indentLevel; ++i) {
            indent = indent + "  ";
        }
        if (errortype == 3) {
            this.archiveSummary.append(indent + string + "\n");
        }
        if (source.equals("") && errortype != 3) {
            this.aissues.add(string);
        }
        if (!source.equals("")) {
            if (this.globalErrorMap.containsKey(source)) {
                this.globalErrorMap.get(source).add(string);
            } else {
                ArrayList<String> a = new ArrayList<String>();
                a.add(string);
                this.globalErrorMap.put(source, a);
            }
        }
    }

    private void pushResourceInfo(ASName resourceName, PDFObject resource) {
        this.resourceChain.add(new ResourceInfo(resourceName, resource));
    }

    private void popResourceInfo() {
        this.resourceChain.remove(this.resourceChain.size() - 1);
        if (this.lastResourceDisplayed >= this.resourceChain.size()) {
            this.lastResourceDisplayed = this.resourceChain.size() - 1;
        }
    }

    public boolean annotationError(PDFAErrorSetAnnotation errors) {
        this.reportResourceError((PDFAErrorSet)errors, "ANNOTATION ERROR");
        return true;
    }

    public boolean beginAnnotationScan(PDFAnnotation annot) {
        this.annot = annot;
        return true;
    }

    public boolean beginAnnotationsScan() {
        return true;
    }

    public boolean beginColorSpaceScan(ASName name, PDFColorSpace colorSpace) {
        this.pushResourceInfo(name, (PDFObject)colorSpace);
        return true;
    }

    public boolean beginContentScan(PDFContents contents, PDFResources resources) {
        return true;
    }

    public boolean beginDocMetadataScan() {
        return true;
    }

    public boolean beginDocumentScan() {
        return true;
    }

    public boolean beginFontScan(ASName name, PDFFont font) {
        this.pushResourceInfo(name, (PDFObject)font);
        return true;
    }

    public boolean beginFileStructureScan() {
        return true;
    }

    public boolean beginFormFieldScan(PDFField field) {
        this.field = field;
        return true;
    }

    public boolean beginFormFieldTreeScan() {
        return true;
    }

    public boolean beginOutputIntentScan() {
        return true;
    }

    public boolean beginPageScan(PDFPage page, int index) {
        this.page = page;
        this.pageIndex = index;
        return true;
    }

    public boolean beginPageTreeScan() {
        return true;
    }

    public boolean beginPatternScan(ASName name, PDFPatternTiling pattern) {
        this.pushResourceInfo(name, (PDFObject)pattern);
        return true;
    }

    public boolean beginXObjectScan(ASName name, PDFXObject xObject) {
        this.pushResourceInfo(name, (PDFObject)xObject);
        return true;
    }

    public boolean bookmarkError(PDFBookmark bookmark, PDFAErrorSetBookmark errors) {
        this.report(bookmark, (PDFAErrorSet)errors);
        return true;
    }

    public boolean catalogError(PDFAErrorSetCatalog errors) {
        this.reportError(0, errors.toString(), "CATALOG ERROR");
        return true;
    }

    public boolean colorSpaceError(PDFAErrorSetColorSpace errors) {
        this.reportResourceError((PDFAErrorSet)errors, "COLOR SPACE ERROR");
        return true;
    }

    public boolean contentError(ASName operatorName, PDFAErrorSetContent errors) {
        this.reportResourceError((PDFAErrorSet)errors, "CONTENT ERROR");
        return true;
    }

    public boolean docMetadataError(PDFAErrorSetMetadata errors) {
        this.reportError(0, errors.toString(), "DOC METADATA ERROR");
        return true;
    }

    public boolean endAnnotationScan() {
        this.annot = null;
        this.annotDisplayed = false;
        return true;
    }

    public boolean endAnnotationsScan() {
        return true;
    }

    public boolean endColorSpaceScan() {
        this.popResourceInfo();
        return true;
    }

    public boolean endContentScan() {
        return true;
    }

    public boolean endDocMetadataScan() {
        return true;
    }

    public boolean endDocumentScan(boolean errorsFound) {
        if (errorsFound) {
            this.report(0, "VALIDATION SUMMARY: PDFAService reports that un-fixed PDF/A errors were found.", 3, "");
        } else {
            this.report(0, "VALIDATION SUMMARY: PDFAService reports that no un-fixed PDF/A errors were found.", 3, "");
        }
        return true;
    }

    public boolean endFontScan() {
        this.popResourceInfo();
        return true;
    }

    public boolean endFileStructureScan(PDFASaveTypes saveTypes) {
        this.saveTypes = saveTypes;
        return true;
    }

    public PDFASaveTypes getSaveType() {
        return this.saveTypes;
    }

    public boolean endFormFieldScan() {
        this.field = null;
        this.fieldDisplayed = false;
        return true;
    }

    public boolean endFormFieldTreeScan() {
        return true;
    }

    public boolean endOutputIntentScan() {
        return true;
    }

    public boolean endPageScan() {
        this.page = null;
        this.pageIndex = 0;
        this.pageDisplayed = false;
        return true;
    }

    public boolean endPageTreeScan() {
        return true;
    }

    public boolean endPatternScan() {
        this.popResourceInfo();
        return true;
    }

    public boolean endXObjectScan() {
        this.popResourceInfo();
        return true;
    }

    public boolean extGStateError(PDFExtGState extGState, PDFAErrorSetExtGState errors) {
        this.reportResourceError((PDFAErrorSet)errors, "EXTJS STATE ERROR");
        return true;
    }

    public boolean fileStructureError(PDFAErrorSetFileStructure errors) {
        if (errors.hasErrors()) {
            this.reportError(0, errors.toString(), "FILE STRUCTURE ERROR");
        }
        return true;
    }

    public boolean fileStructureErrorsFixed(PDFAErrorSetFileStructure errorsFound, PDFAErrorSetFileStructure errorsFixed) {
        if (errorsFound.hasErrors()) {
            this.report(0, "FileStructureErrorsFound: " + errorsFound.toString(), 1, "");
        }
        if (errorsFixed.hasErrors()) {
            this.report(0, "FileStructureErrorsFixed: " + errorsFixed.toString(), 1, "");
        }
        return true;
    }

    public boolean fontError(PDFAErrorSetFont errors) {
        this.reportResourceError((PDFAErrorSet)errors, "FONT ERROR");
        return true;
    }

    public boolean formFieldError(PDFAErrorSetField errors) {
        this.reportResourceError((PDFAErrorSet)errors, "FORM FIELD ERROR");
        return true;
    }

    public boolean outputIntentsError(PDFOutputIntent intent, PDFAErrorSetOutputIntent errors) {
        this.report(intent, (PDFAErrorSet)errors);
        return true;
    }

    public boolean pageError(PDFAErrorSetPage errors) {
        this.reportResourceError((PDFAErrorSet)errors, "PAGE ERROR");
        return true;
    }

    public boolean patternError(PDFAErrorSetPattern errors) {
        this.reportResourceError((PDFAErrorSet)errors, "PATTERN ERROR");
        return true;
    }

    public boolean xObjectError(PDFAErrorSetXObject errors) {
        this.reportResourceError((PDFAErrorSet)errors, "XOBJECT ERROR");
        return true;
    }

    public boolean openActionRemovedFromCatalog(PDFOpenAction openAction) {
        this.reportModification("Illegal OpenAction entry removed from catalog");
        return true;
    }

    public boolean ocPropertiesRemovedFromCatalog(PDFOCProperties ocp) {
        this.reportModification("OCProperties entry removed from catalog");
        return true;
    }

    public boolean xfaRemoved() {
        this.reportModification("XFA removed");
        return true;
    }

    public boolean annotWithOffOCRemoved(PDFAnnotation annot) {
        this.reportResourceModification("Annot with optional content \"Off\" removed.");
        return true;
    }

    public boolean annotOnOCEntryRemoved(PDFAnnotation annot, PDFOCObject oc) {
        this.reportResourceModification("Annot with optional content \"On\" made permanently visible.");
        return true;
    }

    public boolean javaScriptNameTreeRemoved() {
        this.reportModification("JavaScript name tree removed");
        return true;
    }

    public boolean embeddedFilesNameTreeRemoved() {
        this.reportModification("EmbeddedFiles name tree removed");
        return true;
    }

    public boolean pdfaInfoSetInMetadata(PDFAConformanceLevel conformance) {
        this.reportModification("PDF/A metadata set to " + conformance);
        return true;
    }

    public boolean opiRemovedFromXObject(PDFXObject xObject) {
        this.reportResourceModification("OPI removed from XObject");
        return true;
    }

    public boolean psRemovedFromXObject(PDFXObjectForm form, ASName entryName) {
        this.reportResourceModification("PS or Subtype2 removed from form XObject (" + entryName + ")");
        return true;
    }

    public boolean xObjectWithOffOCRemoved(ASName name, PDFXObject xObject) {
        this.reportModification("XObject (" + name + ") with optional content \"Off\" removed.");
        return true;
    }

    public boolean xObjectOnOCEntryRemoved(PDFXObject xObject, PDFOCObject oc) {
        this.reportResourceModification("XObject with optional content \"On\" made permanently visible.");
        return true;
    }

    public boolean alternatesRemovedFromImage(PDFXObjectImage image) {
        this.reportResourceModification("Alternates removed from image XOject");
        return true;
    }

    public boolean illegalInterpolationRemoved() {
        this.reportResourceModification("Illegal interpolation removed");
        return true;
    }

    public boolean transferFunctionRemovedOrReset(PDFExtGState extGState, ASName trEntryName) {
        this.reportResourceModification("Transfer function removed or reset (" + trEntryName + ")");
        return true;
    }

    public boolean renderingIntentOverridden(ASName oldIntent, ASName newIntent) {
        this.reportResourceModification("Rendering intent overridden (Old: " + oldIntent.asString() + ", " + newIntent.asString() + ")");
        return true;
    }

    public boolean inlineImageLZWFilterReplaced(ASName newFilter) {
        if (newFilter == null) {
            this.reportResourceModification("Inline image LZW filter removed");
        } else {
            this.reportResourceModification("Inline image LZW filter replaced with \"" + newFilter.asString() + "\"");
        }
        return true;
    }

    public boolean illegalAnnotationRemoved(PDFAnnotation annot) {
        this.reportResourceModification("Illegal annotation removed");
        return true;
    }

    public boolean invisibleHiddenOrNoViewAnnotRemoved(PDFAnnotation annot) {
        this.reportResourceModification("Invisible, hidden, or no-view annotation removed");
        return true;
    }

    public boolean annotationFlagsSet(PDFAnnotation annot, int oldFlags, int newFlags) {
        this.reportResourceModification("Annotation flags repaired (Old: " + oldFlags + ", New: " + newFlags + ")");
        return true;
    }

    public boolean normalAPDictConvertedToStream(PDFAnnotation annot) {
        this.reportResourceModification("Normal appearance dictionary converted to stream");
        return true;
    }

    public boolean nonNormalAnnotAppearanceRemoved(PDFAnnotation annot, ASName apType) {
        this.reportResourceModification("Non-normal appearance removed (" + apType.toString() + ")");
        return true;
    }

    public boolean illegalActionRemoved(PDFAction action) {
        this.reportResourceModification("Action removed");
        return true;
    }

    public boolean illegalAdditionalActionsRemoved(PDFAdditionalActions aa) {
        this.reportResourceModification("Additional actions removed");
        return true;
    }

    public boolean pdfaOutputIntentSet(PDFOutputIntent outputIntent) {
        this.reportModification("PDF/A output intent set");
        return true;
    }

    public boolean defaultColorSpaceSet(ASName colorSpaceName, PDFColorSpace colorSpace) {
        this.reportResourceModification(colorSpaceName.asString() + " color space set");
        return true;
    }

    public boolean optionalMarkedContentRemoved(ASName ocName) {
        this.reportResourceModification("Optional marked content region (" + ocName + ") removed from content stream");
        return true;
    }

    public boolean referenceXObjectRemoved(ASName name, PDFXObjectForm formXObject) {
        this.reportResourceModification("Reference XObject (" + name + ") removed from content stream");
        return true;
    }

    public boolean postScriptXObjectRemoved(ASName name, PDFXObjectPostScript psXObject) {
        this.reportResourceModification("PostScript XObject (" + name + ") removed from content stream");
        return true;
    }

    public boolean illegalInstructionRemoved(ASName op) {
        this.reportResourceModification("Illegal instruction removed: " + op);
        return true;
    }

    public boolean fontEmbedded(PDFFont font) {
        this.reportResourceModification("Font embedded");
        return true;
    }

    public boolean openTypeFontReEmbedded(PDFFont font) {
        this.reportResourceModification("Open Type font re-embedded in CFF format");
        return true;
    }

    public boolean trueTypeFontReEmbedded(PDFFont font) {
        this.reportResourceModification("True Type font re-embedded");
        return true;
    }

    public boolean cMapEmbeddedInType0Font(PDFFont font) {
        this.reportResourceModification("CMap embedded");
        return true;
    }

    public boolean CIDToGIDMapUpdatedInType0Font(PDFFont font) {
        this.reportResourceModification("CIDToGIDMap updated");
        return true;
    }

    public boolean CIDSetUpdatedInType0Font(PDFFont font) {
        this.reportResourceModification("CIDSet updated");
        return true;
    }

    public boolean wModeUpdatedInType0Font(PDFFont font) {
        this.reportResourceModification("CIDToGIDMap updated");
        return true;
    }

    public boolean widthsMetricsUpdated(PDFFont font) {
        this.reportResourceModification("Widths metrics updated");
        return true;
    }

    public boolean charSetUpdatedInType1Font(PDFFont font) {
        this.reportResourceModification("CharSet updated");
        return true;
    }

    public boolean fontXMPRemoved(PDFFont font) {
        this.reportResourceModification("Invalid XMP in font removed");
        return true;
    }

    public boolean conversionSummary(boolean fixesApplied, boolean unfixableFound) {
        if (fixesApplied) {
            this.report(0, "CONVERSION SUMMARY: PDFAService reports that PDF/A fixes were applied.", 3, "");
        } else {
            this.report(0, "CONVERSION SUMMARY: PDFAService reports that no PDF/A fixes were applied.", 3, "");
        }
        return true;
    }

    public boolean schemasForInsertion(Collection<PDFAInvalidNamespaceUsage> invalidUsage, Collection<PDFAXMPSchema> schemas) {
        this.report(0, "METADATA: Invalid Usage Remaining.", 2, "");
        this.report(1, invalidUsage.toString(), 2, "");
        this.report(0, "METADATA: Schemas to be inserted into the XMP.", 2, "");
        this.report(1, schemas.toString(), 2, "");
        return true;
    }

    public boolean invalidNamespaceUsage(Collection<PDFAInvalidNamespaceUsage> invalidUsage) {
        this.report(0, "METADATA: Invalid Namespace Usage Found.", 2, "");
        this.report(1, invalidUsage.toString(), 2, "");
        return true;
    }

    public boolean invalidTypeUsage(Map<XMLElement, PropertyOptions> invalidTypes) {
        this.report(0, "METADATA: Invalid Type Usage Found.", 2, "");
        this.report(1, invalidTypes.toString(), 2, "");
        return true;
    }

    public boolean alternateColorSpaceUsedAsInvalidICCProfileFound(PDFColorSpaceICCBased pIccCS) {
        this.report(0, "ICCProfile based color space found with invalid ICC profile. Falling back to alternate color space.", 2, "");
        this.report(1, pIccCS.getName().toString(), 2, "");
        return true;
    }

    public PDFICCProfile getValidICCProfile(PDFICCProfile pdficcProfile) {
        PDFICCProfile fixedProfile = null;
        String rootDir = ServiceFactory.getRuntimeService().getRootDir();
        ICC_Profile iccRGBProfile = null;
        try {
            iccRGBProfile = ICC_Profile.getInstance(rootDir + File.separator + "color_profiles" + File.separator + "sRGB Color Space Profile.icm");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        ICC_Profile iccCMYKProfile = null;
        try {
            iccCMYKProfile = ICC_Profile.getInstance(rootDir + File.separator + "color_profiles" + File.separator + "USWebCoatedSWOP.icc");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        ICC_Profile iccGrayProfile = null;
        try {
            iccGrayProfile = ICC_Profile.getInstance(rootDir + File.separator + "color_profiles" + File.separator + "BlackWhite.icc");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            if (pdficcProfile.getNumberOfComponents() == 1) {
                fixedProfile = PDFICCProfile.newInstance((PDFDocument)pdficcProfile.getPDFDocument(), iccGrayProfile);
            }
            if (pdficcProfile.getNumberOfComponents() == 2) {
                fixedProfile = PDFICCProfile.newInstance((PDFDocument)pdficcProfile.getPDFDocument(), (ICC_Profile)iccRGBProfile);
            }
            if (pdficcProfile.getNumberOfComponents() == 4) {
                fixedProfile = PDFICCProfile.newInstance((PDFDocument)pdficcProfile.getPDFDocument(), (ICC_Profile)iccCMYKProfile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fixedProfile != null) {
            this.report(0, "ICCProfile: Replacing invalid ICC profile.", 2, "");
            return fixedProfile;
        }
        return null;
    }

    public boolean hasErrors() {
        return this.errorsFound;
    }

    public Map<String, ArrayList<String>> getArchiveErrorReport() {
        return this.globalErrorMap;
    }

    public ArrayList<String> getArchiveIssuesReport() {
        return this.aissues;
    }

    public String getArchiveSummaryReport() {
        return this.archiveSummary.toString();
    }

    public boolean contentError(Instruction arg0, PDFAErrorSetContent arg1) {
        return false;
    }

    public boolean illegalInstructionRemoved(Instruction arg0) {
        return false;
    }

    public boolean rasterGeneratedforPage(PDFPage page) {
        return false;
    }

    class ResourceInfo {
        ASName resourceName;
        PDFObject resource;

        ResourceInfo(ASName resourceName, PDFObject resource) {
            this.resourceName = resourceName;
            this.resource = resource;
        }
    }
}

