/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.scheduling;

import coldfusion.scheduling.ThreadPoolInterface;
import coldfusion.util.FastHashtable;
import coldfusion.util.IntStack;
import java.util.Enumeration;
import java.util.Stack;

public class WorkerThread
extends Thread {
    private boolean methodTimingEnabled = true;
    private long startTime;
    private Object request;
    private boolean shutdown = false;
    private IntStack filterIndexStack = new IntStack();
    private Stack filterTargetStack = new Stack();
    boolean isNew = true;
    boolean hasRemovableAttributes;
    private FastHashtable attrTable = new FastHashtable();
    private FastHashtable removeTable = new FastHashtable();
    String[] messages = new String[]{"creating", "running", "swapping"};

    public WorkerThread(ThreadGroup threadGroup, String threadName) {
        super(threadGroup, threadName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block15: {
            ThreadPoolInterface pool = (ThreadPoolInterface)((Object)this.getThreadGroup());
            while (true) {
                Runnable r = null;
                int messageIndex = 0;
                try {
                    r = pool.createRunnable();
                    while (r != null) {
                        messageIndex = 1;
                        pool.run(r);
                        messageIndex = 2;
                        r = pool.swapRunnable(r);
                    }
                    if (r == null) continue;
                    pool.destroyRunnable(r, 3);
                    continue;
                }
                catch (InterruptedException ex) {
                    if (r != null) {
                        pool.destroyRunnable(r, 3);
                    }
                    pool.cleanupHandler(this);
                    return;
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                    continue;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    finally {
                        if (r != null) {
                            pool.destroyRunnable(r, 3);
                        }
                    }
                    if (!this.isInterrupted() && !this.isShutdown()) continue;
                    break block15;
                }
                break;
            }
            finally {
                pool.cleanupHandler(this);
            }
        }
    }

    public boolean isMethodTimingEnabled() {
        return this.methodTimingEnabled;
    }

    @Override
    public void interrupt() {
        this.shutdown = true;
        super.interrupt();
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public void setMethodTimingEnabled(boolean b) {
        this.methodTimingEnabled = b;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void markStart() {
        this.markStart(System.currentTimeMillis());
    }

    public void markStart(long time) {
        this.startTime = time;
        this.removeAttributes();
    }

    public Object getAttribute(String name) {
        return this.attrTable.get((Object)name);
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(name, value, false);
    }

    public void setAttribute(String name, Object value, boolean remove) {
        if (value != null) {
            this.attrTable.put((Object)name, value);
            if (remove && this.removeTable.get((Object)name) == null) {
                this.removeTable.put((Object)name, (Object)name);
                this.hasRemovableAttributes = true;
            }
        } else {
            this.removeAttribute(name);
        }
    }

    public Enumeration getAttributeNames() {
        return this.attrTable.keys();
    }

    public void removeAttribute(String name) {
        this.attrTable.remove((Object)name);
        this.removeTable.remove((Object)name);
    }

    public static final long currentTimeMillis() {
        Thread t = Thread.currentThread();
        if (t instanceof WorkerThread) {
            return ((WorkerThread)t).getStartTime();
        }
        return System.currentTimeMillis();
    }

    protected void removeAttributes() {
        if (this.hasRemovableAttributes) {
            boolean removed = false;
            Enumeration keysEnum = this.removeTable.keys();
            while (keysEnum.hasMoreElements()) {
                this.removeAttribute((String)keysEnum.nextElement());
                removed = true;
            }
            if (removed) {
                this.removeTable.clear();
            }
            this.hasRemovableAttributes = false;
        }
    }

    public Object getServletRequest() {
        return this.request;
    }

    public void setServletRequest(Object r) {
        this.request = r;
    }

    public void pushFilterTarget(Object target) {
        this.filterIndexStack.push(0);
        this.filterTargetStack.push(target);
    }

    public Object popFilterTarget() {
        this.filterIndexStack.pop();
        return this.filterTargetStack.pop();
    }

    public int getFilterIndex() {
        int n = this.filterIndexStack.pop();
        this.filterIndexStack.push(n + 1);
        return n;
    }

    public void clearFilterStack() {
        this.filterIndexStack.clear();
        this.filterTargetStack.clear();
    }
}

